/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.aliases.ItemData;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.registrations.Classes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

public class EvtMoveOn
extends SelfRegisteringSkriptEvent {
    static final HashMap<Integer, List<Trigger>> itemTypeTriggers;
    ItemType[] types = null;
    private static boolean registeredExecutor;
    private static final EventExecutor executor;

    static {
        Skript.registerEvent("Move On", EvtMoveOn.class, PlayerMoveEvent.class, "(step|walk)[ing] (on|over) %*itemtypes%").description("Called when a player moves onto a certain type of block. Please note that using this event can cause lag if there are many players online.").examples("on walking on dirt or grass", "on stepping on stone").since("2.0");
        itemTypeTriggers = new HashMap();
        registeredExecutor = false;
        executor = new EventExecutor(){

            public void execute(@Nullable Listener l, @Nullable Event event) throws EventException {
                if (event == null) {
                    return;
                }
                PlayerMoveEvent e = (PlayerMoveEvent)event;
                Location from = e.getFrom();
                Location to = e.getTo();
                if (!itemTypeTriggers.isEmpty()) {
                    int id = EvtMoveOn.getOnBlock(to);
                    if (id == 0) {
                        return;
                    }
                    List<Trigger> ts = itemTypeTriggers.get(id);
                    if (ts == null) {
                        return;
                    }
                    int y = EvtMoveOn.getBlockY(to.getY(), id);
                    if (to.getWorld().equals(from.getWorld()) && to.getBlockX() == from.getBlockX() && to.getBlockZ() == from.getBlockZ() && y == EvtMoveOn.getBlockY(from.getY(), EvtMoveOn.getOnBlock(from)) && EvtMoveOn.getOnBlock(from) == id) {
                        return;
                    }
                    SkriptEventHandler.logEventStart((Event)e);
                    byte data = to.getWorld().getBlockAt(to.getBlockX(), y, to.getBlockZ()).getData();
                    block0: for (Trigger t : ts) {
                        EvtMoveOn se = (EvtMoveOn)t.getEvent();
                        ItemType[] itemTypeArray = se.types;
                        int n = se.types.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ItemType i = itemTypeArray[n2];
                            if (i.isOfType(id, data)) {
                                SkriptEventHandler.logTriggerStart(t);
                                t.execute((Event)e);
                                SkriptEventHandler.logTriggerEnd(t);
                                continue block0;
                            }
                            ++n2;
                        }
                    }
                    SkriptEventHandler.logEventEnd();
                }
            }
        };
    }

    static final int getOnBlock(Location l) {
        int id = l.getWorld().getBlockTypeIdAt(l.getBlockX(), (int)Math.ceil(l.getY()) - 1, l.getBlockZ());
        if (id == 0 && Math.abs(l.getY() - (double)l.getBlockY() - 0.5) < 1.0E-10 && (id = l.getWorld().getBlockTypeIdAt(l.getBlockX(), l.getBlockY() - 1, l.getBlockZ())) != Material.FENCE.getId() && id != 107 && id != 113) {
            return 0;
        }
        return id;
    }

    static final int getBlockY(double y, int id) {
        if ((id == Material.FENCE.getId() || id == 107 || id == 113) && Math.abs(y - Math.floor(y) - 0.5) < 1.0E-10) {
            return (int)Math.floor(y) - 1;
        }
        return (int)Math.ceil(y) - 1;
    }

    public static final Block getBlock(PlayerMoveEvent e) {
        return e.getTo().clone().subtract(0.0, 0.5, 0.0).getBlock();
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        Literal<?> l = args[0];
        if (l == null) {
            return false;
        }
        ItemType[] itemTypeArray = this.types = (ItemType[])l.getAll();
        int n = this.types.length;
        int n2 = 0;
        while (n2 < n) {
            ItemType t = itemTypeArray[n2];
            boolean hasBlock = false;
            for (ItemData d : t) {
                if (d.getId() == -1) {
                    Skript.error("Can't use an 'on walk' event with an alias that matches all blocks");
                    return false;
                }
                if (d.getId() > 255 || d.getId() == 0) continue;
                hasBlock = true;
            }
            if (!hasBlock) {
                Skript.error(t + " is not a block and can thus not be walked on");
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "walk on " + Classes.toString(this.types, false);
    }

    @Override
    public void register(Trigger trigger) {
        ItemType[] itemTypeArray = this.types;
        int n = this.types.length;
        int n2 = 0;
        while (n2 < n) {
            ItemType t = itemTypeArray[n2];
            for (ItemData d : t) {
                if (d.getId() > 255) continue;
                List<Trigger> ts = itemTypeTriggers.get(d.getId());
                if (ts == null) {
                    ts = new ArrayList<Trigger>();
                    itemTypeTriggers.put(d.getId(), ts);
                }
                ts.add(trigger);
            }
            ++n2;
        }
        if (!registeredExecutor) {
            Bukkit.getPluginManager().registerEvent(PlayerMoveEvent.class, new Listener(){}, SkriptConfig.defaultEventPriority.value(), executor, (Plugin)Skript.getInstance(), true);
            registeredExecutor = true;
        }
    }

    @Override
    public void unregister(Trigger t) {
        Iterator<Map.Entry<Integer, List<Trigger>>> i2 = itemTypeTriggers.entrySet().iterator();
        while (i2.hasNext()) {
            List<Trigger> ts = i2.next().getValue();
            ts.remove(t);
            if (!ts.isEmpty()) continue;
            i2.remove();
        }
    }

    @Override
    public void unregisterAll() {
        itemTypeTriggers.clear();
    }
}

