/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.command.CommandEvent;
import ch.njol.skript.command.Commands;
import ch.njol.skript.command.ScriptCommand;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.EntryNode;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.SimpleNode;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Conditional;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Loop;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Statement;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.lang.While;
import ch.njol.skript.lang.function.Function;
import ch.njol.skript.lang.function.FunctionEvent;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.Signature;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Message;
import ch.njol.skript.localization.PluralizingArgsMessage;
import ch.njol.skript.log.CountingLogHandler;
import ch.njol.skript.log.ErrorDescLogHandler;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.Date;
import ch.njol.skript.util.ExceptionUtils;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Callback;
import ch.njol.util.Kleenean;
import ch.njol.util.NonNullPair;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public final class ScriptLoader {
    private static final Message m_no_errors = new Message("skript.no errors");
    private static final Message m_no_scripts = new Message("skript.no scripts");
    private static final PluralizingArgsMessage m_scripts_loaded = new PluralizingArgsMessage("skript.scripts loaded");
    @Nullable
    public static Config currentScript = null;
    @Nullable
    private static String currentEventName = null;
    @Nullable
    private static Class<? extends Event>[] currentEvents = null;
    public static List<TriggerSection> currentSections = new ArrayList<TriggerSection>();
    public static List<Loop> currentLoops = new ArrayList<Loop>();
    private static final Map<String, ItemType> currentAliases = new HashMap<String, ItemType>();
    static final HashMap<String, String> currentOptions = new HashMap();
    private static final ScriptInfo loadedScripts = new ScriptInfo();
    public static Kleenean hasDelayBefore = Kleenean.FALSE;
    private static String indentation = "";
    private static final FileFilter scriptFilter = new FileFilter(){

        @Override
        public boolean accept(@Nullable File f) {
            return f != null && (f.isDirectory() || StringUtils.endsWithIgnoreCase(f.getName(), ".sk")) && !f.getName().startsWith("-");
        }
    };

    private ScriptLoader() {
    }

    @Nullable
    public static String getCurrentEventName() {
        return currentEventName;
    }

    public static void setCurrentEvent(String name, Class<? extends Event> ... events) {
        currentEventName = name;
        currentEvents = events;
        hasDelayBefore = Kleenean.FALSE;
    }

    public static void deleteCurrentEvent() {
        currentEventName = null;
        currentEvents = null;
        hasDelayBefore = Kleenean.FALSE;
    }

    public static Map<String, ItemType> getScriptAliases() {
        return currentAliases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ScriptInfo loadScripts() {
        ScriptInfo i;
        File scriptsFolder = new File(Skript.getInstance().getDataFolder(), "scripts" + File.separator);
        if (!scriptsFolder.isDirectory()) {
            scriptsFolder.mkdirs();
        }
        Date start = new Date();
        ErrorDescLogHandler h = SkriptLogger.startLogHandler(new ErrorDescLogHandler(null, null, m_no_errors.toString()));
        try {
            Language.setUseLocal(false);
            ScriptLoader.loadStructures(scriptsFolder);
            i = ScriptLoader.loadScripts(scriptsFolder);
            ScriptInfo scriptInfo = loadedScripts;
            synchronized (scriptInfo) {
                loadedScripts.add(i);
            }
        }
        finally {
            Language.setUseLocal(true);
            h.stop();
        }
        if (i.files == 0) {
            Skript.warning(m_no_scripts.toString());
        }
        if (Skript.logNormal() && i.files > 0) {
            Skript.info(m_scripts_loaded.toString(i.files, i.triggers, i.commands, start.difference(new Date())));
        }
        SkriptEventHandler.registerBukkitEvents();
        return i;
    }

    public static final ScriptInfo loadScripts(File directory) {
        ScriptInfo i = new ScriptInfo();
        boolean wasLocal = Language.setUseLocal(false);
        try {
            Object[] files = directory.listFiles(scriptFilter);
            Arrays.sort(files);
            Object[] objectArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                Object f = objectArray[n2];
                if (((File)f).isDirectory()) {
                    i.add(ScriptLoader.loadScripts((File)f));
                } else {
                    i.add(ScriptLoader.loadScript((File)f));
                }
                ++n2;
            }
        }
        finally {
            if (wasLocal) {
                Language.setUseLocal(true);
            }
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ScriptInfo loadScripts(File[] files) {
        Arrays.sort(files);
        ScriptInfo i = new ScriptInfo();
        boolean wasLocal = Language.setUseLocal(false);
        try {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                assert (f != null) : Arrays.toString(files);
                i.add(ScriptLoader.loadScript(f));
                ++n2;
            }
        }
        finally {
            if (wasLocal) {
                Language.setUseLocal(true);
            }
        }
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            loadedScripts.add(i);
        }
        SkriptEventHandler.registerBukkitEvents();
        return i;
    }

    private static final ScriptInfo loadScript(File f) {
        try {
            Config config = new Config(f, true, false, ":");
            if (SkriptConfig.keepConfigsLoaded.value().booleanValue()) {
                SkriptConfig.configs.add(config);
            }
            int numTriggers = 0;
            int numCommands = 0;
            int numFunctions = 0;
            currentAliases.clear();
            currentOptions.clear();
            currentScript = config;
            CountingLogHandler numErrors = SkriptLogger.startLogHandler(new CountingLogHandler(SkriptLogger.SEVERE));
            try {
                for (Node cnode : config.getMainNode()) {
                    Trigger trigger;
                    NonNullPair<SkriptEventInfo<?>, SkriptEvent> parsedEvent;
                    if (!(cnode instanceof SectionNode)) {
                        Skript.error("invalid line - all code has to be put into triggers");
                        continue;
                    }
                    SectionNode node = (SectionNode)cnode;
                    String event = node.getKey();
                    if (event == null) continue;
                    if (event.equalsIgnoreCase("aliases")) {
                        node.convertToEntries(0, "=");
                        for (Node n : node) {
                            if (!(n instanceof EntryNode)) {
                                Skript.error("invalid line in aliases section");
                                continue;
                            }
                            ItemType t = Aliases.parseAlias(((EntryNode)n).getValue());
                            if (t == null) continue;
                            currentAliases.put(((EntryNode)n).getKey().toLowerCase(), t);
                        }
                        continue;
                    }
                    if (event.equalsIgnoreCase("options")) {
                        node.convertToEntries(0);
                        for (Node n : node) {
                            if (!(n instanceof EntryNode)) {
                                Skript.error("invalid line in options");
                                continue;
                            }
                            currentOptions.put(((EntryNode)n).getKey(), ((EntryNode)n).getValue());
                        }
                        continue;
                    }
                    if (event.equalsIgnoreCase("variables")) {
                        node.convertToEntries(0, "=");
                        for (Node n : node) {
                            Object o;
                            String var;
                            if (!(n instanceof EntryNode)) {
                                Skript.error("Invalid line in variables section");
                                continue;
                            }
                            String name = ((EntryNode)n).getKey().toLowerCase(Locale.ENGLISH);
                            if (name.startsWith("{") && name.endsWith("}")) {
                                name = name.substring(1, name.length() - 1);
                            }
                            if ((name = StringUtils.replaceAll((CharSequence)name, "%(.+)?%", new Callback<String, Matcher>(var = name){
                                private final /* synthetic */ String val$var;
                                {
                                    this.val$var = string;
                                }

                                @Override
                                @Nullable
                                public String run(Matcher m) {
                                    if (m.group(1).contains("{") || m.group(1).contains("}") || m.group(1).contains("%")) {
                                        Skript.error("'" + this.val$var + "' is not a valid name for a default variable");
                                        return null;
                                    }
                                    ClassInfo<?> ci = Classes.getClassInfoFromUserInput(m.group(1));
                                    if (ci == null) {
                                        Skript.error("Can't understand the type '" + m.group(1) + "'");
                                        return null;
                                    }
                                    return "<" + ci.getCodeName() + ">";
                                }
                            })) == null) continue;
                            if (name.contains("%")) {
                                Skript.error("Invalid use of percent signs in variable name");
                                continue;
                            }
                            if (Variables.getVariable(name, null, false) != null) continue;
                            ParseLogHandler log = SkriptLogger.startParseLogHandler();
                            try {
                                o = Classes.parseSimple(((EntryNode)n).getValue(), Object.class, ParseContext.SCRIPT);
                                if (o == null) {
                                    log.printError("Can't understand the value '" + ((EntryNode)n).getValue() + "'");
                                    continue;
                                }
                                log.printLog();
                            }
                            finally {
                                log.stop();
                            }
                            ClassInfo<?> ci = Classes.getSuperClassInfo(o.getClass());
                            if (ci.getSerializer() == null) {
                                Skript.error("Can't save '" + ((EntryNode)n).getValue() + "' in a variable");
                                continue;
                            }
                            if (ci.getSerializeAs() != null) {
                                ClassInfo<?> as = Classes.getExactClassInfo(ci.getSerializeAs());
                                if (as == null) {
                                    assert (false) : ci;
                                    continue;
                                }
                                if ((o = Converters.convert(o, as.getC())) == null) {
                                    Skript.error("Can't save '" + ((EntryNode)n).getValue() + "' in a variable");
                                    continue;
                                }
                            }
                            Variables.setVariable(name, o, null, false);
                        }
                        continue;
                    }
                    if (!SkriptParser.validateLine(event)) continue;
                    if (event.toLowerCase().startsWith("command ")) {
                        ScriptLoader.setCurrentEvent("command", CommandEvent.class);
                        ScriptCommand c = Commands.loadCommand(node);
                        if (c != null) {
                            ++numCommands;
                        }
                        ScriptLoader.deleteCurrentEvent();
                        continue;
                    }
                    if (event.toLowerCase().startsWith("function ")) {
                        ScriptLoader.setCurrentEvent("function", FunctionEvent.class);
                        Function<?> func = Functions.loadFunction(node);
                        if (func != null) {
                            ++numFunctions;
                        }
                        ScriptLoader.deleteCurrentEvent();
                        continue;
                    }
                    if (Skript.logVeryHigh() && !Skript.debug()) {
                        Skript.info("loading trigger '" + event + "'");
                    }
                    if (StringUtils.startsWithIgnoreCase(event, "on ")) {
                        event = event.substring("on ".length());
                    }
                    if ((parsedEvent = SkriptParser.parseEvent(event = ScriptLoader.replaceOptions(event), "can't understand this event: '" + node.getKey() + "'")) == null) continue;
                    if (Skript.debug() || node.debug()) {
                        Skript.debug(String.valueOf(event) + " (" + parsedEvent.getSecond().toString(null, true) + "):");
                    }
                    ScriptLoader.setCurrentEvent(parsedEvent.getFirst().getName().toLowerCase(Locale.ENGLISH), parsedEvent.getFirst().events);
                    try {
                        trigger = new Trigger(config.getFile(), event, parsedEvent.getSecond(), ScriptLoader.loadItems(node));
                    }
                    finally {
                        ScriptLoader.deleteCurrentEvent();
                    }
                    if (parsedEvent.getSecond() instanceof SelfRegisteringSkriptEvent) {
                        ((SelfRegisteringSkriptEvent)parsedEvent.getSecond()).register(trigger);
                        SkriptEventHandler.addSelfRegisteringTrigger(trigger);
                    } else {
                        SkriptEventHandler.addTrigger(parsedEvent.getFirst().events, trigger);
                    }
                    ++numTriggers;
                }
                if (Skript.logHigh()) {
                    Skript.info("loaded " + numTriggers + " trigger" + (numTriggers == 1 ? "" : "s") + " and " + numCommands + " command" + (numCommands == 1 ? "" : "s") + " from '" + config.getFileName() + "'");
                }
                currentScript = null;
            }
            finally {
                numErrors.stop();
            }
            ScriptInfo scriptInfo = new ScriptInfo(1, numTriggers, numCommands, numFunctions);
            return scriptInfo;
        }
        catch (IOException e) {
            Skript.error("Could not load " + f.getName() + ": " + ExceptionUtils.toString(e));
        }
        catch (Exception e) {
            Skript.exception((Throwable)e, "Could not load " + f.getName());
        }
        finally {
            SkriptLogger.setNode(null);
        }
        return new ScriptInfo();
    }

    public static final void loadStructures(File[] files) {
        Arrays.sort(files);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            assert (f != null) : Arrays.toString(files);
            ScriptLoader.loadStructure(f);
            ++n2;
        }
        SkriptEventHandler.registerBukkitEvents();
    }

    public static final void loadStructures(File directory) {
        Object[] files = directory.listFiles(scriptFilter);
        Arrays.sort(files);
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object f = objectArray[n2];
            if (((File)f).isDirectory()) {
                ScriptLoader.loadStructures((File)f);
            } else {
                ScriptLoader.loadStructure((File)f);
            }
            ++n2;
        }
    }

    private static final void loadStructure(File f) {
        try {
            try {
                Config config = new Config(f, true, false, ":");
                if (SkriptConfig.keepConfigsLoaded.value().booleanValue()) {
                    SkriptConfig.configs.add(config);
                }
                boolean numTriggers = false;
                boolean numCommands = false;
                int numFunctions = 0;
                currentAliases.clear();
                currentOptions.clear();
                currentScript = config;
                CountingLogHandler numErrors = SkriptLogger.startLogHandler(new CountingLogHandler(SkriptLogger.SEVERE));
                try {
                    for (Node cnode : config.getMainNode()) {
                        if (!(cnode instanceof SectionNode)) {
                            Skript.error("invalid line - all code has to be put into triggers");
                            continue;
                        }
                        SectionNode node = (SectionNode)cnode;
                        String event = node.getKey();
                        if (event == null || !SkriptParser.validateLine(event) || !event.toLowerCase().startsWith("function ")) continue;
                        ScriptLoader.setCurrentEvent("function", FunctionEvent.class);
                        Signature<?> func = Functions.loadSignature(config.getFileName(), node);
                        if (func != null) {
                            ++numFunctions;
                        }
                        ScriptLoader.deleteCurrentEvent();
                    }
                    currentScript = null;
                }
                finally {
                    numErrors.stop();
                }
            }
            catch (IOException e) {
                Skript.error("Could not load " + f.getName() + ": " + ExceptionUtils.toString(e));
                SkriptLogger.setNode(null);
            }
            catch (Exception e) {
                Skript.exception((Throwable)e, "Could not load " + f.getName());
                SkriptLogger.setNode(null);
            }
        }
        finally {
            SkriptLogger.setNode(null);
        }
    }

    static final ScriptInfo unloadScripts(File folder) {
        ScriptInfo r = ScriptLoader.unloadScripts_(folder);
        Functions.validateFunctions();
        return r;
    }

    private static final ScriptInfo unloadScripts_(File folder) {
        File[] files;
        ScriptInfo info = new ScriptInfo();
        File[] fileArray = files = folder.listFiles(scriptFilter);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                info.add(ScriptLoader.unloadScripts_(f));
            } else if (f.getName().endsWith(".sk")) {
                info.add(ScriptLoader.unloadScript_(f));
            }
            ++n2;
        }
        return info;
    }

    static final ScriptInfo unloadScript(File script) {
        ScriptInfo r = ScriptLoader.unloadScript_(script);
        Functions.clearFunctions(script);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ScriptInfo unloadScript_(File script) {
        ScriptInfo info = SkriptEventHandler.removeTriggers(script);
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            loadedScripts.subtract(info);
        }
        return info;
    }

    public static final String replaceOptions(String s) {
        String r = StringUtils.replaceAll((CharSequence)s, "\\{@(.+?)\\}", new Callback<String, Matcher>(){

            @Override
            @Nullable
            public String run(Matcher m) {
                String option = currentOptions.get(m.group(1));
                if (option == null) {
                    Skript.error("undefined option " + m.group());
                    return m.group();
                }
                return option;
            }
        });
        assert (r != null);
        return r;
    }

    public static ArrayList<TriggerItem> loadItems(SectionNode node) {
        if (Skript.debug()) {
            indentation = String.valueOf(indentation) + "    ";
        }
        ArrayList<TriggerItem> items = new ArrayList<TriggerItem>();
        Kleenean hadDelayBeforeLastIf = Kleenean.FALSE;
        for (Node n : node) {
            Kleenean hadDelayBefore;
            Condition cond;
            String l;
            String name;
            SkriptLogger.setNode(n);
            if (n instanceof SimpleNode) {
                Statement stmt;
                SimpleNode e = (SimpleNode)n;
                String s = ScriptLoader.replaceOptions(e.getKey());
                if (!SkriptParser.validateLine(s) || (stmt = Statement.parse(s, "Can't understand this condition/effect: " + s)) == null) continue;
                if (Skript.debug() || n.debug()) {
                    Skript.debug(String.valueOf(indentation) + stmt.toString(null, true));
                }
                items.add(stmt);
                if (!(stmt instanceof Delay)) continue;
                hasDelayBefore = Kleenean.TRUE;
                continue;
            }
            if (!(n instanceof SectionNode) || !SkriptParser.validateLine(name = ScriptLoader.replaceOptions(n.getKey()))) continue;
            if (StringUtils.startsWithIgnoreCase(name, "loop ")) {
                Expression<Object> loopedExpr;
                l = name.substring("loop ".length());
                RetainingLogHandler h = SkriptLogger.startRetainingLog();
                try {
                    loopedExpr = new SkriptParser(l).parseExpression(Object.class);
                    if (loopedExpr != null) {
                        loopedExpr = loopedExpr.getConvertedExpression(Object.class);
                    }
                    if (loopedExpr == null) {
                        h.printErrors("Can't understand this loop: '" + name + "'");
                        continue;
                    }
                    h.printLog();
                }
                finally {
                    h.stop();
                }
                if (loopedExpr.isSingle()) {
                    Skript.error("Can't loop " + loopedExpr + " because it's only a single value");
                    continue;
                }
                if (Skript.debug() || n.debug()) {
                    Skript.debug(String.valueOf(indentation) + "loop " + loopedExpr.toString(null, true) + ":");
                }
                Kleenean hadDelayBefore2 = hasDelayBefore;
                items.add(new Loop(loopedExpr, (SectionNode)n));
                if (hadDelayBefore2 == Kleenean.TRUE || hasDelayBefore == Kleenean.FALSE) continue;
                hasDelayBefore = Kleenean.UNKNOWN;
                continue;
            }
            if (StringUtils.startsWithIgnoreCase(name, "while ")) {
                l = name.substring("while ".length());
                Condition c = Condition.parse(l, "Can't understand this condition: " + l);
                if (c == null) continue;
                if (Skript.debug() || n.debug()) {
                    Skript.debug(String.valueOf(indentation) + "while " + c.toString(null, true) + ":");
                }
                Kleenean hadDelayBefore3 = hasDelayBefore;
                items.add(new While(c, (SectionNode)n));
                if (hadDelayBefore3 == Kleenean.TRUE || hasDelayBefore == Kleenean.FALSE) continue;
                hasDelayBefore = Kleenean.UNKNOWN;
                continue;
            }
            if (name.equalsIgnoreCase("else")) {
                if (items.size() == 0 || !(items.get(items.size() - 1) instanceof Conditional) || ((Conditional)items.get(items.size() - 1)).hasElseClause()) {
                    Skript.error("'else' has to be placed just after an 'if' or 'else if' section");
                    continue;
                }
                if (Skript.debug() || n.debug()) {
                    Skript.debug(String.valueOf(indentation) + "else:");
                }
                Kleenean hadDelayAfterLastIf = hasDelayBefore;
                hasDelayBefore = hadDelayBeforeLastIf;
                ((Conditional)items.get(items.size() - 1)).loadElseClause((SectionNode)n);
                hasDelayBefore = hadDelayBeforeLastIf.or(hadDelayAfterLastIf.and(hasDelayBefore));
                continue;
            }
            if (StringUtils.startsWithIgnoreCase(name, "else if ")) {
                if (items.size() == 0 || !(items.get(items.size() - 1) instanceof Conditional) || ((Conditional)items.get(items.size() - 1)).hasElseClause()) {
                    Skript.error("'else if' has to be placed just after another 'if' or 'else if' section");
                    continue;
                }
                cond = Condition.parse(name = name.substring("else if ".length()), "can't understand this condition: '" + name + "'");
                if (cond == null) continue;
                if (Skript.debug() || n.debug()) {
                    Skript.debug(String.valueOf(indentation) + "else if " + cond.toString(null, true));
                }
                Kleenean hadDelayAfterLastIf = hasDelayBefore;
                hasDelayBefore = hadDelayBeforeLastIf;
                ((Conditional)items.get(items.size() - 1)).loadElseIf(cond, (SectionNode)n);
                hasDelayBefore = hadDelayBeforeLastIf.or(hadDelayAfterLastIf.and(hasDelayBefore.and(Kleenean.UNKNOWN)));
                continue;
            }
            if (StringUtils.startsWithIgnoreCase(name, "if ")) {
                name = name.substring(3);
            }
            if ((cond = Condition.parse(name, "can't understand this condition: '" + name + "'")) == null) continue;
            if (Skript.debug() || n.debug()) {
                Skript.debug(String.valueOf(indentation) + cond.toString(null, true) + ":");
            }
            hadDelayBeforeLastIf = hadDelayBefore = hasDelayBefore;
            items.add(new Conditional(cond, (SectionNode)n));
            hasDelayBefore = hadDelayBefore.or(hasDelayBefore.and(Kleenean.UNKNOWN));
        }
        int i = 0;
        while (i < items.size() - 1) {
            ((TriggerItem)items.get(i)).setNext(items.get(i + 1));
            ++i;
        }
        SkriptLogger.setNode(node);
        if (Skript.debug()) {
            indentation = indentation.substring(0, indentation.length() - 4);
        }
        return items;
    }

    @Nullable
    static Trigger loadTrigger(SectionNode node) {
        NonNullPair<SkriptEventInfo<?>, SkriptEvent> parsedEvent;
        String event = node.getKey();
        if (event == null) {
            assert (false) : node;
            return null;
        }
        if (event.toLowerCase().startsWith("on ")) {
            event = event.substring("on ".length());
        }
        if ((parsedEvent = SkriptParser.parseEvent(event, "can't understand this event: '" + node.getKey() + "'")) == null) {
            assert (false);
            return null;
        }
        ScriptLoader.setCurrentEvent("unit test", parsedEvent.getFirst().events);
        try {
            Trigger trigger = new Trigger(null, event, parsedEvent.getSecond(), ScriptLoader.loadItems(node));
            return trigger;
        }
        finally {
            ScriptLoader.deleteCurrentEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int loadedScripts() {
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            return ScriptLoader.loadedScripts.files;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int loadedCommands() {
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            return ScriptLoader.loadedScripts.commands;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int loadedFunctions() {
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            return ScriptLoader.loadedScripts.functions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int loadedTriggers() {
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            return ScriptLoader.loadedScripts.triggers;
        }
    }

    public static final boolean isCurrentEvent(@Nullable Class<? extends Event> event) {
        return CollectionUtils.containsSuperclass(currentEvents, event);
    }

    @SafeVarargs
    public static final boolean isCurrentEvent(Class<? extends Event> ... events) {
        return CollectionUtils.containsAnySuperclass(currentEvents, events);
    }

    @Nullable
    public static Class<? extends Event>[] getCurrentEvents() {
        return currentEvents;
    }

    public static class ScriptInfo {
        public int files;
        public int triggers;
        public int commands;
        public int functions;

        public ScriptInfo() {
        }

        public ScriptInfo(int numFiles, int numTriggers, int numCommands, int numFunctions) {
            this.files = numFiles;
            this.triggers = numTriggers;
            this.commands = numCommands;
            this.functions = numFunctions;
        }

        public void add(ScriptInfo other) {
            this.files += other.files;
            this.triggers += other.triggers;
            this.commands += other.commands;
            this.functions += other.functions;
        }

        public void subtract(ScriptInfo other) {
            this.files -= other.files;
            this.triggers -= other.triggers;
            this.commands -= other.commands;
            this.functions -= other.functions;
        }
    }
}

