/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Potion Effects")
@Description(value={"Apply or remove potion effects to/from entities."})
@Examples(value={"apply swiftness 2 to the player", "remove haste from the victim", "on join:", "\tapply potion of strength of tier {strength.%player%} to the player for 999 days"})
@Since(value="2.0")
public class EffPotion
extends Effect {
    private static final int DEFAULT_DURATION = 300;
    private Expression<PotionEffectType> potions;
    @Nullable
    private Expression<Number> tier;
    private Expression<LivingEntity> entities;
    @Nullable
    private Expression<Timespan> duration;
    private boolean apply;

    static {
        Skript.registerEffect(EffPotion.class, "apply [potion of] %potioneffecttypes% [potion] [[[of] tier] %-number%] to %livingentities% [for %-timespan%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        boolean bl = this.apply = matchedPattern == 0;
        if (this.apply) {
            this.potions = exprs[0];
            this.tier = exprs[1];
            this.entities = exprs[2];
            this.duration = exprs[3];
        } else {
            this.potions = exprs[0];
            this.entities = exprs[1];
        }
        return true;
    }

    @Override
    protected void execute(Event e) {
        PotionEffectType[] ts = this.potions.getArray(e);
        if (ts.length == 0) {
            return;
        }
        if (!this.apply) {
            LivingEntity[] livingEntityArray = this.entities.getArray(e);
            int n = livingEntityArray.length;
            int n2 = 0;
            while (n2 < n) {
                LivingEntity en = livingEntityArray[n2];
                PotionEffectType[] potionEffectTypeArray = ts;
                int n3 = ts.length;
                int n4 = 0;
                while (n4 < n3) {
                    PotionEffectType t = potionEffectTypeArray[n4];
                    en.removePotionEffect(t);
                    ++n4;
                }
                ++n2;
            }
            return;
        }
        int a = 0;
        if (this.tier != null) {
            Number amp = this.tier.getSingle(e);
            if (amp == null) {
                return;
            }
            a = amp.intValue() - 1;
        }
        int d = 300;
        if (this.duration != null) {
            Timespan dur = this.duration.getSingle(e);
            if (dur == null) {
                return;
            }
            d = (int)(dur.getTicks_i() >= Integer.MAX_VALUE ? Integer.MAX_VALUE : dur.getTicks_i());
        }
        LivingEntity[] livingEntityArray = this.entities.getArray(e);
        int n = livingEntityArray.length;
        int n5 = 0;
        while (n5 < n) {
            LivingEntity en = livingEntityArray[n5];
            PotionEffectType[] potionEffectTypeArray = ts;
            int n6 = ts.length;
            int n7 = 0;
            while (n7 < n6) {
                PotionEffectType t = potionEffectTypeArray[n7];
                int duration = d;
                if (en.hasPotionEffect(t)) {
                    for (PotionEffect eff : en.getActivePotionEffects()) {
                        if (eff.getType() != t) continue;
                        duration += eff.getDuration();
                        break;
                    }
                }
                en.addPotionEffect(new PotionEffect(t, duration, a), true);
                ++n7;
            }
            ++n5;
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (this.apply) {
            return "apply " + this.potions.toString(e, debug) + (this.tier != null ? " of tier " + this.tier.toString(e, debug) : "") + " to " + this.entities.toString(e, debug) + (this.duration != null ? " for " + this.duration.toString(e, debug) : "");
        }
        return "remove " + this.potions.toString(e, debug) + " from " + this.entities.toString(e, debug);
    }
}

