/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier;

import com.vexsoftware.votifier.LogFilter;
import com.vexsoftware.votifier.crypto.RSAIO;
import com.vexsoftware.votifier.crypto.RSAKeygen;
import com.vexsoftware.votifier.model.ListenerLoader;
import com.vexsoftware.votifier.model.VoteListener;
import com.vexsoftware.votifier.net.VoteReceiver;
import java.io.File;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class Votifier
extends JavaPlugin {
    private static final Logger LOG = Logger.getLogger("Votifier");
    private static final String logPrefix = "[Votifier] ";
    private static Votifier instance;
    private String version;
    private final List<VoteListener> listeners = new ArrayList<VoteListener>();
    private VoteReceiver voteReceiver;
    private KeyPair keyPair;
    private boolean debug;

    static {
        LOG.setFilter(new LogFilter(logPrefix));
    }

    public void onEnable() {
        instance = this;
        this.version = this.getDescription().getVersion();
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        File config = new File(this.getDataFolder() + "/config.yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)config);
        File rsaDirectory = new File(this.getDataFolder() + "/rsa");
        String listenerDirectory = String.valueOf(this.getDataFolder().toString().replace("\\", "/")) + "/listeners";
        String hostAddr = Bukkit.getServer().getIp();
        if (hostAddr == null || hostAddr.length() == 0) {
            hostAddr = "0.0.0.0";
        }
        if (!config.exists()) {
            try {
                LOG.info("Configuring Votifier for the first time...");
                config.createNewFile();
                cfg.set("host", (Object)hostAddr);
                cfg.set("port", (Object)8192);
                cfg.set("debug", (Object)false);
                LOG.info("------------------------------------------------------------------------------");
                LOG.info("Assigning Votifier to listen on port 8192. If you are hosting Craftbukkit on a");
                LOG.info("shared server please check with your hosting provider to verify that this port");
                LOG.info("is available for your use. Chances are that your hosting provider will assign");
                LOG.info("a different port, which you need to specify in config.yml");
                LOG.info("------------------------------------------------------------------------------");
                cfg.set("listener_folder", (Object)listenerDirectory);
                cfg.save(config);
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Error creating configuration file", ex);
                this.gracefulExit();
                return;
            }
        } else {
            cfg = YamlConfiguration.loadConfiguration((File)config);
        }
        try {
            if (!rsaDirectory.exists()) {
                rsaDirectory.mkdir();
                new File(listenerDirectory).mkdir();
                this.keyPair = RSAKeygen.generate(2048);
                RSAIO.save(rsaDirectory, this.keyPair);
            } else {
                this.keyPair = RSAIO.load(rsaDirectory);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Error reading configuration file or RSA keys", ex);
            this.gracefulExit();
            return;
        }
        listenerDirectory = cfg.getString("listener_folder");
        this.listeners.addAll(ListenerLoader.load(listenerDirectory));
        String host = cfg.getString("host", hostAddr);
        int port = cfg.getInt("port", 8192);
        this.debug = cfg.getBoolean("debug", false);
        if (this.debug) {
            LOG.info("DEBUG mode enabled!");
        }
        try {
            this.voteReceiver = new VoteReceiver(this, host, port);
            this.voteReceiver.start();
            LOG.info("Votifier enabled.");
        }
        catch (Exception ex) {
            this.gracefulExit();
            return;
        }
    }

    public void onDisable() {
        if (this.voteReceiver != null) {
            this.voteReceiver.shutdown();
        }
        LOG.info("Votifier disabled.");
    }

    private void gracefulExit() {
        LOG.log(Level.SEVERE, "Votifier did not initialize properly!");
    }

    public static Votifier getInstance() {
        return instance;
    }

    public String getVersion() {
        return this.version;
    }

    public List<VoteListener> getListeners() {
        return this.listeners;
    }

    public VoteReceiver getVoteReceiver() {
        return this.voteReceiver;
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public boolean isDebug() {
        return this.debug;
    }
}

