/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.placeholderapi.internal.utils.bukkit;

import be.maximvdw.placeholderapi.internal.ui.SendConsole;
import be.maximvdw.placeholderapi.internal.utils.NumberUtils;
import be.maximvdw.placeholderapi.internal.utils.ReflectionUtil;
import com.google.common.base.Charsets;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BukkitUtils {
    private static String version = "";
    private static boolean uuidSupport = true;
    private static boolean legacyOnlinePlayers = false;
    private static Method getOnlinePlayers = null;
    private static Class<?> bukkitClass = null;
    private static Class<?> minecraftServerClass;
    private static Method getServerMethod;
    private static Class<?> gameProfileClass;
    private static Constructor gameProfileClassConstructor;
    private static int versionMajor;
    private static int versionMinor;
    private static int versionBuild;

    public static String getVersion() {
        if (Bukkit.getServer() == null) {
            return "";
        }
        if (version.equals("")) {
            version = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
            String[] data = BukkitUtils.getVersion().substring(1).split("_");
            if (NumberUtils.isInteger(data[1]) && NumberUtils.isInteger(data[0])) {
                versionMinor = Integer.parseInt(data[1]);
                versionMajor = Integer.parseInt(data[0]);
                if (data[2].startsWith("R")) {
                    versionBuild = Integer.parseInt(data[2].replace("R", "")) + 1;
                }
            }
            boolean latest = false;
            if (BukkitUtils.getVersionMajor() >= 1 && BukkitUtils.getVersionMinor() >= 8) {
                latest = true;
            }
            uuidSupport = latest || BukkitUtils.getVersion().contains("v1_7_R3") || BukkitUtils.getVersion().contains("v1_7_R4");
            if (BukkitUtils.getVersion().contains("v1_6") || BukkitUtils.getVersion().contains("v1_7")) {
                legacyOnlinePlayers = true;
            }
        }
        return version;
    }

    public static String getServerName() {
        return Bukkit.getServerName();
    }

    public static boolean disablePlugin(Plugin plugin) {
        Bukkit.getPluginManager().disablePlugin(plugin);
        return Bukkit.getPluginManager().isPluginEnabled(plugin);
    }

    public static String getMotd() {
        return Bukkit.getMotd();
    }

    public static int getMaxPlayers() {
        return Bukkit.getMaxPlayers();
    }

    public static Plugin[] getPlugins() {
        return Bukkit.getPluginManager().getPlugins();
    }

    public static int getPort() {
        return Bukkit.getPort();
    }

    public static int getPluginCount() {
        return Bukkit.getPluginManager().getPlugins().length;
    }

    public static int getTotalPlayerCount() {
        return Bukkit.getOfflinePlayers().length;
    }

    public static int getOPCount() {
        return Bukkit.getOperators().size();
    }

    public static Player[] getOperators() {
        return (Player[])Bukkit.getOperators().toArray();
    }

    public static String getIp() {
        String bukkitIP = Bukkit.getServer().getIp();
        return bukkitIP == null || bukkitIP == "" ? "127.0.0.1" : bukkitIP;
    }

    public static int getPlayerCount(GameMode mode) {
        int size = 0;
        for (Player player : BukkitUtils.getOnlinePlayers()) {
            if (player.getGameMode() != mode) continue;
            ++size;
        }
        return size;
    }

    public static Collection<? extends Player> getOnlinePlayers() {
        if (legacyOnlinePlayers) {
            Player[] players = new Player[]{};
            try {
                Object pObj = getOnlinePlayers.invoke(null, new Object[0]);
                if (!(pObj instanceof Player[])) {
                    legacyOnlinePlayers = true;
                    return Bukkit.getOnlinePlayers();
                }
                players = (Player[])getOnlinePlayers.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
            return Arrays.asList(players);
        }
        return Bukkit.getOnlinePlayers();
    }

    public static boolean hasWhitelist() {
        return Bukkit.hasWhitelist();
    }

    public static int getBuild() {
        if (BukkitUtils.isSpigot()) {
            return BukkitUtils.getSpigotBuild();
        }
        return BukkitUtils.getBukkitBuild();
    }

    public static void setVersion(String version) {
        BukkitUtils.version = version;
    }

    public static boolean hasUUIDSupport() {
        boolean latest = false;
        if (BukkitUtils.getVersionMajor() >= 1 && BukkitUtils.getVersionMinor() >= 8) {
            latest = true;
        }
        if (!version.equals("")) {
            return uuidSupport;
        }
        if (latest || BukkitUtils.getVersion().contains("v1_7_R3") || BukkitUtils.getVersion().contains("v1_7_R4")) {
            uuidSupport = true;
            return true;
        }
        uuidSupport = false;
        return false;
    }

    public static int getBukkitBuild() {
        String version = Bukkit.getVersion();
        Pattern pattern = Pattern.compile("(b)([0-9]+)(jnks)");
        Matcher matcher = pattern.matcher(version);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(2));
        }
        return 0;
    }

    public static int getSpigotBuild() {
        String version = Bukkit.getVersion();
        Pattern pattern = Pattern.compile("(git-Spigot-)([0-9]+)");
        Matcher matcher = pattern.matcher(version);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(2));
        }
        return 0;
    }

    public static int getPaperSpigotBuild() {
        String version = Bukkit.getVersion();
        Pattern pattern = Pattern.compile("(git-Paper-)([0-9]+)");
        Matcher matcher = pattern.matcher(version);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(2));
        }
        return 0;
    }

    public static boolean isSpigot() {
        return Bukkit.getVersion().toLowerCase().contains("spigot") || Bukkit.getVersion().toLowerCase().contains("paper");
    }

    public static String getServerVersion() {
        return version;
    }

    public static String getServerModName() {
        String mod = "";
        try {
            Class<?> minecraftServerClass = ReflectionUtil.getClass("MinecraftServer", ReflectionUtil.DynamicPackage.MINECRAFT_SERVER);
            Object serverInstance = ReflectionUtil.getMethod(minecraftServerClass, "getServer", new Class[0]).invoke(minecraftServerClass, new Object[0]);
            mod = (String)ReflectionUtil.getMethod("getServerModName", minecraftServerClass, new Class[0]).invoke(serverInstance, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mod;
    }

    public static void changeVersion(String version) {
        block4: {
            try {
                SendConsole.info("Preparing version change ...");
                Class<?> serverPing = ReflectionUtil.getClass("ServerPing", ReflectionUtil.DynamicPackage.MINECRAFT_SERVER);
                Class<?> serverPingData = ReflectionUtil.getClass("ServerPingServerData", ReflectionUtil.DynamicPackage.MINECRAFT_SERVER);
                Class<?> minecraftServerClass = ReflectionUtil.getClass("MinecraftServer", ReflectionUtil.DynamicPackage.MINECRAFT_SERVER);
                Object serverInstance = ReflectionUtil.getMethod(minecraftServerClass, "getServer", new Class[0]).invoke(minecraftServerClass, new Object[0]);
                Field[] fields = minecraftServerClass.getDeclaredFields();
                SendConsole.info("Searching for ping packet ...");
                for (Field field : fields) {
                    Field[] fields_value;
                    if (!field.getType().equals(serverPing)) continue;
                    SendConsole.info("Ping information found! Searching for current version ...");
                    Object value = ReflectionUtil.getValueFromClass(field.getName(), serverInstance, minecraftServerClass);
                    for (Field field_value : fields_value = value.getClass().getDeclaredFields()) {
                        if (!field_value.getType().equals(serverPingData)) continue;
                        SendConsole.info("Server version information found!");
                        Object serverData = ReflectionUtil.getValueFromClass(field_value.getName(), value, value.getClass());
                        String curVersion = (String)ReflectionUtil.getValue("a", serverData);
                        SendConsole.info("Current server version: " + curVersion);
                        SendConsole.info("Performing change ...");
                        ReflectionUtil.setValue("a", version, serverData);
                        ReflectionUtil.setValue("b", 4, serverData);
                        break block4;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static int getVersionMajor() {
        if (versionMajor == -1) {
            BukkitUtils.getVersion();
        }
        return versionMajor;
    }

    public static void setVersionMajor(int versionMajor) {
        BukkitUtils.versionMajor = versionMajor;
    }

    public static int getVersionMinor() {
        if (versionMinor == -1) {
            BukkitUtils.getVersion();
        }
        return versionMinor;
    }

    public static void setVersionMinor(int versionMinor) {
        BukkitUtils.versionMinor = versionMinor;
    }

    public static int getVersionBuild() {
        return versionBuild;
    }

    public static void setVersionBuild(int versionBuild) {
        BukkitUtils.versionBuild = versionBuild;
    }

    public OfflinePlayer getOfflinePlayer(String name) {
        UUID uuid = UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(Charsets.UTF_8));
        try {
            if (!version.contains("v1_7") && !version.contains("v1_8")) {
                return Bukkit.getOfflinePlayer((String)name);
            }
            Object gameProfile = gameProfileClassConstructor.newInstance(uuid, name);
            Object serverInstance = getServerMethod.invoke(minecraftServerClass, new Object[0]);
            OfflinePlayer player = (OfflinePlayer)ReflectionUtil.invokeMethod("getOfflinePlayer", minecraftServerClass, serverInstance, gameProfile);
            return player;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return Bukkit.getOfflinePlayer((UUID)uuid);
        }
    }

    static {
        getServerMethod = null;
        gameProfileClass = null;
        gameProfileClassConstructor = null;
        versionMajor = -1;
        versionMinor = -1;
        versionBuild = 0;
        try {
            BukkitUtils.getVersion();
        }
        catch (Throwable ex) {
            SendConsole.severe("Something happened while trying to get the version of the server!");
            SendConsole.severe("Please create a ticket with the following information:");
            SendConsole.severe(Bukkit.getServer().getClass().getPackage().getName());
            ex.printStackTrace();
            throw ex;
        }
        try {
            bukkitClass = ReflectionUtil.getClass("Bukkit", "org.bukkit");
            getOnlinePlayers = ReflectionUtil.getMethod(bukkitClass, "getOnlinePlayers", new Class[0]);
            minecraftServerClass = ReflectionUtil.getClass("MinecraftServer", ReflectionUtil.DynamicPackage.MINECRAFT_SERVER);
            getServerMethod = ReflectionUtil.getMethod(minecraftServerClass, "getServer", new Class[0]);
            if (version.contains("v1_7")) {
                gameProfileClass = ReflectionUtil.getClass("GameProfile", "net.minecraft.util.com.mojang.authlib");
            } else if (version.contains("v1_8")) {
                gameProfileClass = ReflectionUtil.getClass("GameProfile", "com.mojang.authlib");
            }
            if (gameProfileClass != null) {
                gameProfileClassConstructor = ReflectionUtil.getConstructor(gameProfileClass, UUID.class, String.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

