/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.placeholderapi.internal.storage;

import be.maximvdw.placeholderapi.internal.storage.YamlBuilder;
import be.maximvdw.placeholderapi.internal.ui.SendConsole;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class YamlStorage {
    private Plugin plugin = null;
    private String configName = "";
    private String pluginFolder = "";
    private String folder = "";
    private String resourceFolder = "";
    private boolean resources = false;
    private int configVersion = -1;
    private YamlBuilder template = null;
    private YamlConfiguration pluginConfig;
    private File configFile;
    private boolean loaded = false;

    public YamlStorage(Plugin plugin, String configName) {
        this(plugin, "", configName);
    }

    public YamlStorage(Plugin plugin, String folder, String configName) {
        this(plugin, folder, configName, false);
    }

    public YamlStorage(Plugin plugin, String folder, String configName, boolean resources) {
        this(plugin, folder, configName, resources, 0);
    }

    public YamlStorage(Plugin plugin, String folder, String configName, boolean resources, int version, int errorLevel) {
        this.plugin = plugin;
        this.folder = folder;
        this.configName = configName;
        this.resources = resources;
        this.setConfigVersion(version);
        this.loadConfig(errorLevel);
        if (version != -1 && this.getConfig().getInt("config") < version) {
            this.updateConfig();
        }
    }

    public YamlStorage(Plugin plugin, String folder, String configName, boolean resources, int version) {
        this(plugin, folder, configName, resources, version, 0);
    }

    public YamlStorage(Plugin plugin, String folder, String configName, int version, YamlBuilder builder) {
        this(plugin, folder, configName, version, builder, 0);
    }

    public YamlStorage(Plugin plugin, String folder, String configName, int version, YamlBuilder builder, int errorLevel) {
        this.plugin = plugin;
        this.folder = folder;
        this.configName = configName;
        this.setTemplate(builder);
        this.loadConfig(errorLevel);
        if (this.getConfig().getInt("config") < version) {
            this.updateConfig();
        }
    }

    public YamlStorage(Plugin plugin, String folder, String configName, String resourceFolder, boolean resources) {
        this.plugin = plugin;
        this.folder = folder;
        this.configName = configName;
        this.resourceFolder = resourceFolder;
        this.resources = resources;
        this.loadConfig();
    }

    public YamlStorage(Plugin plugin, String folder, String configName, String resourceFolder, boolean resources, int version) {
        this(plugin, folder, configName, resourceFolder, resources, version, 0);
    }

    public YamlStorage(Plugin plugin, String folder, String configName, String resourceFolder, boolean resources, int version, int errorLevel) {
        this.plugin = plugin;
        this.folder = folder;
        this.configName = configName;
        this.resourceFolder = resourceFolder;
        this.resources = resources;
        this.setConfigVersion(version);
        this.loadConfig(errorLevel);
        if (this.getConfig().getInt("config") < version) {
            this.updateConfig();
        }
    }

    public YamlStorage(String pluginFolder, String folder, String configName) {
        this.folder = folder;
        this.pluginFolder = pluginFolder;
        this.configName = configName;
        this.loadConfig();
    }

    public YamlConfiguration getConfig() {
        if (!this.loaded) {
            this.loadConfig();
        }
        return this.pluginConfig;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public String getContents() {
        try {
            FileInputStream fis = new FileInputStream(this.configFile);
            byte[] data = new byte[(int)this.configFile.length()];
            fis.read(data);
            fis.close();
            String s = new String(data, "UTF-8");
            return s;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void loadConfig() {
        this.loadConfig(0);
    }

    public void loadConfig(int errorLevel) {
        block19: {
            this.configFile = this.plugin != null ? new File(this.plugin.getDataFolder() + "/" + this.folder, this.configName + ".yml") : new File("plugins/" + this.pluginFolder + "/" + this.folder, this.configName + ".yml");
            if (this.configFile.exists()) {
                this.pluginConfig = new YamlConfiguration();
                try {
                    this.pluginConfig.load(this.configFile);
                }
                catch (FileNotFoundException ex) {
                    if (errorLevel < 1) {
                        SendConsole.severe("Error in [" + this.configName + "] - File not found!");
                    }
                }
                catch (IOException ex) {
                    if (errorLevel < 2) {
                        SendConsole.severe("Error in [" + this.configName + "] - Error while reading!");
                    }
                }
                catch (InvalidConfigurationException ex) {
                    if (errorLevel < 3) {
                        SendConsole.severe("Error in [" + this.configName + "] - Corrupted YML!");
                    }
                    ex.printStackTrace();
                }
                this.loaded = true;
            } else {
                try {
                    InputStream jarURL = null;
                    if (this.plugin != null) {
                        this.plugin.getDataFolder().mkdir();
                        new File(this.plugin.getDataFolder() + "/" + this.folder).mkdirs();
                        jarURL = this.plugin.getClass().getResourceAsStream("/" + this.resourceFolder + (this.resourceFolder == "" ? "" : "/") + this.configName + ".yml");
                    } else {
                        new File("plugins/" + this.pluginFolder + "/" + this.folder).mkdirs();
                    }
                    if (jarURL != null) {
                        SendConsole.info("Copying '" + this.configFile + "' from the resources!");
                        YamlStorage.copyFile(jarURL, this.configFile);
                    } else if (!this.resources) {
                        SendConsole.info("Creating new file '" + this.configFile + "'!");
                        this.configFile.createNewFile();
                        if (this.getTemplate() != null) {
                            SendConsole.info("Using template for file '" + this.configFile + "' ...");
                            this.getTemplate().writeToFile(this.getConfigFile());
                        }
                    } else {
                        return;
                    }
                    this.pluginConfig = new YamlConfiguration();
                    this.pluginConfig.load(this.configFile);
                    this.loaded = true;
                    if (jarURL != null) {
                        jarURL.close();
                    }
                }
                catch (Exception e) {
                    if (errorLevel >= 1) break block19;
                    SendConsole.severe("Error while loading " + this.configFile + "!");
                    e.printStackTrace();
                }
            }
        }
    }

    public void updateConfig() {
        SendConsole.warning("Updating " + this.getConfigFile().getName() + "!");
        this.configFile.renameTo(new File((this.plugin == null ? "plugins/ " : this.plugin.getDataFolder()) + "/" + this.folder, this.configFile.getName().replace(".yml", "") + new Date().getTime() + ".yml"));
        this.configFile = null;
        this.loadConfig();
    }

    private static void copyFile(InputStream in, File out) throws Exception {
        InputStream fis = in;
        FileOutputStream fos = new FileOutputStream(out);
        try {
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    public int getConfigVersion() {
        return this.configVersion;
    }

    public void setConfigVersion(int configVersion) {
        this.configVersion = configVersion;
    }

    public YamlBuilder getTemplate() {
        return this.template;
    }

    public void setTemplate(YamlBuilder template) {
        this.template = template;
    }
}

