/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.placeholderapi.internal.utils.chat;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;

public class ColorUtils {
    public static String toColors(String input) {
        if (input == null) {
            return null;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)input);
    }

    public static String getLastColors(String input) {
        String result = "";
        int length = input.length();
        boolean foundColor = false;
        for (int index = length - 1; index > -1; --index) {
            char c;
            ChatColor color;
            char section = input.charAt(index);
            if (section != '\u00a7' || index >= length - 1 || (color = ChatColor.getByChar((char)(c = input.charAt(index + 1)))) == null) continue;
            result = color.toString() + result;
            if (!color.isColor() && !color.equals((Object)ChatColor.RESET)) continue;
            foundColor = true;
            break;
        }
        if (!foundColor) {
            result = ChatColor.WHITE + result;
        }
        return result;
    }

    public static ChatColor getLastColor(String input) {
        if (input == null) {
            return ChatColor.RESET;
        }
        int length = input.length();
        for (int index = length - 1; index > -1; --index) {
            char c;
            ChatColor color;
            char section = input.charAt(index);
            if (section != '\u00a7' || index >= length - 1 || !(color = ChatColor.getByChar((char)(c = input.charAt(index + 1)))).isColor() || color == null) continue;
            return color;
        }
        return ChatColor.RESET;
    }

    public static ChatColor getLastEffect(String input) {
        if (input == null) {
            return ChatColor.RESET;
        }
        int length = input.length();
        for (int index = length - 1; index > -1; --index) {
            char c;
            ChatColor color;
            char section = input.charAt(index);
            if (section != '\u00a7' || index >= length - 1 || (color = ChatColor.getByChar((char)(c = input.charAt(index + 1)))) == null) continue;
            if (color.isColor()) {
                return ChatColor.RESET;
            }
            if (!color.isFormat()) continue;
            return color;
        }
        return ChatColor.RESET;
    }

    public static List<ChatColor> getLastEffects(String input) {
        ArrayList<ChatColor> effects = new ArrayList<ChatColor>();
        if (input == null) {
            return effects;
        }
        int length = input.length();
        for (int index = length - 1; index > -1; --index) {
            char c;
            ChatColor color;
            char section = input.charAt(index);
            if (section != '\u00a7' || index >= length - 1 || (color = ChatColor.getByChar((char)(c = input.charAt(index + 1)))) == null) continue;
            if (color.isColor()) {
                return effects;
            }
            if (!color.isFormat()) continue;
            effects.add(color);
        }
        return effects;
    }

    public static String removeColors(String input) {
        if (input == null) {
            return null;
        }
        return ChatColor.stripColor((String)input.replaceAll("(&([A-FK-Oa-fk-or0-9]))", ""));
    }
}

