/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.placeholderapi.internal.eventhooks;

import be.maximvdw.placeholderapi.internal.eventhooks.TriggerEvent;
import be.maximvdw.placeholderapi.internal.storage.YamlBuilder;
import be.maximvdw.placeholderapi.internal.storage.YamlStorage;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public abstract class BaseEventHook
implements Listener {
    private static Map<Object, TriggerEvent> hooks = new HashMap<Object, TriggerEvent>();
    private Map<EventCondition, String> eventConditions = new HashMap<EventCondition, String>();
    private String name = "";
    private String url = "";
    private String description = "";
    private String shortName = "";
    private String when = "";
    private String who = "";
    private boolean enabled = true;
    private Map<Player, EventPlaceholderContainer> placeholders = new HashMap<Player, EventPlaceholderContainer>();
    private YamlBuilder configTemplate = null;
    private int configVersion = 1;
    private Plugin plugin = null;
    private YamlStorage storage = null;
    private Object legacyPlugin = null;

    public BaseEventHook(Plugin plugin, String shortName, int version) {
        this.setPlugin(plugin);
        this.legacyPlugin = plugin.getClass().getProtectionDomain().getCodeSource().getLocation();
        this.setShortName(shortName);
        this.configVersion = version;
    }

    public int getConfigVersion() {
        return this.configVersion;
    }

    public Map<EventCondition, String> getEventConditions() {
        return this.eventConditions;
    }

    public void loadConfig() {
        if (this.storage.getConfig().getBoolean("enabled")) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    public abstract void start();

    public void generateConfig() {
        if (this.getConfigTemplate() == null) {
            YamlBuilder builder = new YamlBuilder();
            builder.addPart("----------------------------------------");
            builder.addPart(" " + this.getName());
            builder.addPart(" " + this.getDescription());
            builder.addPart(" " + this.getUrl());
            builder.addPart("----------------------------------------");
            builder.addPart(new YamlBuilder.YamlEmptyPart());
            builder.addPart(" DO NOT EDIT THIS CONFIG VERSION!");
            builder.addPart("config", this.configVersion);
            builder.addPart(new YamlBuilder.YamlEmptyPart());
            builder.addPart(new YamlBuilder.YamlEmptyPart());
            builder.addPart(" Do you want to enable this event hook?");
            builder.addPart(" Enabling this hook will trigger");
            builder.addPart(" when " + this.getWhen());
            builder.addPart(" for " + this.getWho());
            builder.addPart("enabled", false);
            builder.addPart(new YamlBuilder.YamlEmptyPart());
            builder.addPart(" What do you want to trigger?");
            builder.addPart("trigger", "default");
            builder.addPart(new YamlBuilder.YamlEmptyPart());
            builder.addPart(new YamlBuilder.YamlEmptyPart());
            this.setConfigTemplate(builder);
        }
    }

    public void enableEvent(Player player) {
        TriggerEvent event = BaseEventHook.getHook(this.legacyPlugin);
        if (event != null) {
            event.enableEvent(player, this.getConfig().getString("trigger"));
        }
    }

    public void disableEvent(Player player) {
        TriggerEvent event = BaseEventHook.getHook(this.legacyPlugin);
        if (event != null) {
            event.disableEvent(player, this.getConfig().getString("trigger"));
        }
    }

    @Deprecated
    public static void registerTriggerEvent(TriggerEvent event) {
        URL plugin = event.getClass().getProtectionDomain().getCodeSource().getLocation();
        hooks.put(plugin, event);
    }

    public static TriggerEvent getHook(Object plugin) {
        return hooks.get(plugin);
    }

    public YamlConfiguration getConfig() {
        return this.storage.getConfig();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public YamlStorage getStorage() {
        return this.storage;
    }

    public void setStorage(YamlStorage storage) {
        this.storage = storage;
    }

    public String getWhen() {
        return this.when;
    }

    public void setWhen(String action) {
        this.when = action;
    }

    public String getWho() {
        return this.who;
    }

    public void setWho(String playersAction) {
        this.who = playersAction;
    }

    public YamlBuilder getConfigTemplate() {
        return this.configTemplate;
    }

    public void setConfigTemplate(YamlBuilder configTemplate) {
        this.configTemplate = configTemplate;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public BaseEventHook addCondition(EventCondition condition, String value) {
        this.eventConditions.put(condition, value);
        return this;
    }

    public Map<Player, EventPlaceholderContainer> getPlaceholders() {
        return this.placeholders;
    }

    public void setPlaceholders(Map<Player, EventPlaceholderContainer> placeholders) {
        this.placeholders = placeholders;
    }

    public class EventPlaceholderContainer {
        private Map<String, Object> placeholders = new HashMap<String, Object>();

        public Map<String, Object> getPlaceholders() {
            return this.placeholders;
        }

        public void setPlaceholders(Map<String, Object> placeholders) {
            this.placeholders = placeholders;
        }

        public EventPlaceholderContainer addStaticPlaceholder(String key, Object value) {
            this.placeholders.put(key, value);
            return this;
        }
    }

    public static enum EventCondition {
        PLUGIN,
        VERSION,
        AUTHOR,
        OFFLINEPLAYER,
        PLAYER,
        MAIN,
        VERSION_IS_LOWER,
        VERSION_IS_HIGHER;

    }
}

