package io.github.nanodankster.skriptnpc.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import io.github.nanodankster.skriptnpc.util.SkriptCitizen;
import org.bukkit.event.Event;

@Name("Citizen Vulnerability")
@Description("Returns the vulnerability of a citizen.")
@Examples("set {_x} to npc vulnerability of the last citizen")
@Since("0.1")
public class ExprCitizenVulnerability extends SimpleExpression<Boolean> {
    static {
        Skript.registerExpression(ExprCitizenVulnerability.class, Boolean.class, ExpressionType.SIMPLE,
                "[the] (citizen|npc) vulnerability of %citizen%",
                "[the] %citizen%'s (citizen|npc) vulnerability");
    }

    private Expression<SkriptCitizen> citizen;

    @Override
    protected Boolean[] get(Event event) {
        if (citizen != null) {
            return new Boolean[]{citizen.getSingle(event).getNpc().isProtected()};
        }
        return null;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    @Override
    public String toString(Event event, boolean b) {
        return "vulnerability of a citizen";
    }

    @Override
    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        citizen = (Expression<SkriptCitizen>) expressions[0];
        return true;
    }

    @Override
    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        switch (mode) {
            case SET:
                citizen.getSingle(e).getNpc().setProtected((Boolean) delta[0]);
                break;
            case DELETE: ;
            case RESET:
                citizen.getSingle(e).getNpc().setProtected(false);
                break;
        }
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return CollectionUtils.array(Boolean.class);
        }
        return null;
    }
}
