package io.github.nanodankster.skriptnpc.skript;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import io.github.nanodankster.skriptnpc.SkriptNPC;
import io.github.nanodankster.skriptnpc.util.SkriptCitizen;
import org.bukkit.event.Event;

@Name("Citizen Vulnerability")
@Description("Returns the vulnerability of a citizen. Can be set and reset to true.")
@Examples("set vulnerability of the last npc to false")
@Since("0.1.1")
public class ExprPropCitizenVulnerability extends SimplePropertyExpression<SkriptCitizen, Boolean> {
    static {
        SkriptNPC.registerPropExpr(ExprPropCitizenVulnerability.class, Boolean.class, "[npc] vulnerability", "citizen");
    }
    @Override
    protected String getPropertyName() {
        return "vulnerability of citizen";
    }

    @Override
    public Boolean convert(SkriptCitizen skriptCitizen) {
        if (skriptCitizen != null) {
            return skriptCitizen.getNpc().isProtected();
        }
        return null;
    }

    @Override
    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return CollectionUtils.array(Boolean.class);
        }
        if (mode == Changer.ChangeMode.RESET) {
            return CollectionUtils.array();
        }
        return null;
    }

    @Override
    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        switch (mode) {
            case SET:
                Boolean changeTo = (Boolean) delta[0];
                getExpr().getSingle(e).getNpc().setProtected(changeTo);
                break;
            case RESET:
                getExpr().getSingle(e).getNpc().setProtected(true);
                break;
        }
    }
}
