/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptdoclet.doc;

import com.btk5h.skriptdoclet.Util;
import com.btk5h.skriptdoclet.doc.BaseType;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.Tag;
import java.util.Arrays;
import java.util.stream.Stream;

public class SkriptDoc
implements Comparable<SkriptDoc> {
    private transient int index;
    private String sourcePath;
    private String docName;
    private String docType;
    private String returnType;
    private String author;
    private String since;
    private String minecraftVersion;
    private String skriptVersion;
    private String description;
    private String[] patterns;
    private String[] examples;

    public int getIndex() {
        return this.index;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public String getDocName() {
        return this.docName;
    }

    public String getDocType() {
        return this.docType;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getSince() {
        return this.since;
    }

    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public String getSkriptVersion() {
        return this.skriptVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    public String[] getExamples() {
        return this.examples;
    }

    public static SkriptDoc fromClassDoc(ClassDoc classDoc) {
        String[] examples;
        SkriptDoc doc = new SkriptDoc();
        doc.index = Util.singleTagText((Doc)classDoc, "index").map(Integer::parseInt).orElse(0);
        doc.sourcePath = classDoc.qualifiedName();
        doc.docName = Util.singleTagText((Doc)classDoc, "name").orElse(classDoc.name());
        doc.docType = Util.singleTagText((Doc)classDoc, "type").orElseGet(() -> BaseType.fromClassDoc(classDoc).map(Enum::name).orElse("STANDALONE"));
        doc.returnType = Util.singleTagText((Doc)classDoc, "return").orElse(null);
        doc.author = Util.singleTagText((Doc)classDoc, "author").orElse(null);
        doc.since = Util.singleTagText((Doc)classDoc, "since").orElse(null);
        doc.minecraftVersion = Util.singleTagText((Doc)classDoc, "minecraftVersion").orElse(null);
        doc.skriptVersion = Util.singleTagText((Doc)classDoc, "skriptVersion").orElse(null);
        doc.description = classDoc.commentText();
        String fromType = Util.singleTagText((Doc)classDoc, "propertyType").orElse("object");
        String[] patterns = (String[])Stream.concat(Stream.concat(Arrays.stream(classDoc.tags("propertyExpression")).flatMap(tag -> Stream.of("[the] " + tag.text() + " of %" + fromType + "%", "%" + fromType + "%'[s] " + tag.text())), Arrays.stream(classDoc.tags("propertyCondition")).flatMap(tag -> Stream.of("%" + fromType + "% (is|are) " + tag.text(), "%" + fromType + "% (isn't|is not|aren't|are not) " + tag.text()))), Arrays.stream(classDoc.tags("pattern")).map(Tag::text)).map(s -> s.replaceAll("\n", "")).toArray(String[]::new);
        if (patterns.length > 0) {
            doc.patterns = patterns;
        }
        if ((examples = (String[])Arrays.stream(classDoc.tags("example")).map(Tag::text).toArray(String[]::new)).length > 0) {
            doc.examples = examples;
        }
        return doc;
    }

    @Override
    public int compareTo(SkriptDoc o) {
        int comp = o.index - this.index;
        if (comp == 0) {
            BaseType myType = null;
            BaseType oType = null;
            try {
                myType = BaseType.valueOf(this.docType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                oType = BaseType.valueOf(o.docType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (myType != oType) {
                if (myType == null) {
                    return -1;
                }
                if (oType == null) {
                    return 1;
                }
                comp = myType.compareTo(oType);
            } else if (myType != null) {
                comp = this.docType.compareTo(o.docType);
            }
        }
        if (comp == 0) {
            comp = this.docName.compareTo(o.docName);
        }
        return comp;
    }
}

