/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.util.ArrayList;
import me.ryanhamshire.GriefPrevention.BlockSnapshot;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.Visualization;
import me.ryanhamshire.GriefPrevention.VisualizationType;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Player;

class RestoreNatureExecutionTask
implements Runnable {
    private BlockSnapshot[][][] snapshots;
    private int miny;
    private Location lesserCorner;
    private Location greaterCorner;
    private Player player;

    public RestoreNatureExecutionTask(BlockSnapshot[][][] snapshots, int miny, Location lesserCorner, Location greaterCorner, Player player) {
        this.snapshots = snapshots;
        this.miny = miny;
        this.lesserCorner = lesserCorner;
        this.greaterCorner = greaterCorner;
        this.player = player;
    }

    @Override
    public void run() {
        Claim cachedClaim = null;
        int x = 1;
        while (x < this.snapshots.length - 1) {
            int z = 1;
            while (z < this.snapshots[0][0].length - 1) {
                int y = this.miny;
                while (y < this.snapshots[0].length) {
                    BlockSnapshot blockUpdate = this.snapshots[x][y][z];
                    Block currentBlock = blockUpdate.location.getBlock();
                    if (blockUpdate.typeId != currentBlock.getTypeId() || blockUpdate.data != currentBlock.getData()) {
                        Claim claim = GriefPrevention.instance.dataStore.getClaimAt(blockUpdate.location, false, cachedClaim);
                        if (claim != null) {
                            cachedClaim = claim;
                            break;
                        }
                        try {
                            currentBlock.setTypeIdAndData(blockUpdate.typeId, blockUpdate.data, false);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        Chunk chunk = this.lesserCorner.getChunk();
        Entity[] entities = chunk.getEntities();
        int i = 0;
        while (i < entities.length) {
            Entity entity = entities[i];
            if (!(entity instanceof Player) && !(entity instanceof Animals)) {
                if (!(entity instanceof Hanging) || GriefPrevention.instance.dataStore.getClaimAt(entity.getLocation(), false, null) == null) {
                    entity.remove();
                }
            } else {
                Block feetBlock = entity.getLocation().getBlock();
                feetBlock.setType(Material.AIR);
                feetBlock.getRelative(BlockFace.UP).setType(Material.AIR);
            }
            ++i;
        }
        if (this.player != null) {
            Claim claim = new Claim(this.lesserCorner, this.greaterCorner, null, new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), null);
            Visualization visualization = Visualization.FromClaim(claim, this.player.getLocation().getBlockY(), VisualizationType.RestoreNature, this.player.getLocation());
            Visualization.Apply(this.player, visualization);
        }
    }
}

