/*
 * Decompiled with CFR 0.152.
 */
package lib.PatPeter.SQLibrary;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Logger;
import lib.PatPeter.SQLibrary.DBMS;
import lib.PatPeter.SQLibrary.HostnameDatabase;
import lib.PatPeter.SQLibrary.StatementEnum;

public class PostgreSQL
extends HostnameDatabase {
    public PostgreSQL(Logger log, String prefix, String hostname, int port, String database, String username, String password) {
        super(log, prefix, DBMS.PostgreSQL, hostname, port, database, username, password);
    }

    public PostgreSQL(Logger log, String prefix, String database, String username, String password) {
        super(log, prefix, DBMS.PostgreSQL, "localhost", 1433, database, username, password);
    }

    public PostgreSQL(Logger log, String prefix, String database, String username) {
        super(log, prefix, DBMS.PostgreSQL, "localhost", 1433, database, username, "");
    }

    public PostgreSQL(Logger log, String prefix, String database) {
        super(log, prefix, DBMS.PostgreSQL, "localhost", 1433, database, "", "");
    }

    @Override
    public boolean initialize() {
        try {
            Class.forName("org.postgresql.Driver");
            return true;
        }
        catch (ClassNotFoundException e) {
            this.error("PostgreSQL driver class missing: " + e.getMessage() + ".");
            return false;
        }
    }

    @Override
    public boolean open() {
        if (this.initialize()) {
            String url = "";
            url = "jdbc:postgresql://" + this.getHostname() + ":" + this.getPort() + "/" + this.getDatabase();
            try {
                this.connection = DriverManager.getConnection(url, this.getUsername(), this.getPassword());
                return true;
            }
            catch (SQLException e) {
                this.error("Could not establish a PostgreSQL connection, SQLException: " + e.getMessage());
                return false;
            }
        }
        return false;
    }

    @Override
    protected void queryValidation(StatementEnum statement) throws SQLException {
        switch ((Statements)statement) {
            case PREPARE: 
            case EXECUTE: 
            case DEALLOCATE: {
                this.error("Please use the prepare() method to prepare a query.");
                throw new SQLException("Please use the prepare() method to prepare a query.");
            }
        }
    }

    @Override
    public Statements getStatement(String query) throws SQLException {
        String[] statement = query.trim().split(" ", 2);
        try {
            Statements converted = Statements.valueOf(statement[0].toUpperCase());
            return converted;
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Unknown statement: \"" + statement[0] + "\".");
        }
    }

    @Override
    public boolean isTable(String table) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean truncate(String table) {
        throw new UnsupportedOperationException();
    }

    protected static enum Statements implements StatementEnum
    {
        ABORT("ABORT"),
        ALERT("ALERT"),
        ANALYZE("ANALYZE"),
        BEGIN("BEGIN"),
        CHECKPOINT("CHECKPOINT"),
        CLOSE("CLOSE"),
        CLUSTER("CLUSTER"),
        COMMENT("COMMENT"),
        COMMIT("COMMIT"),
        COPY("COPY"),
        CREATE("CREATE"),
        DEALLOCATE("DEALLOCATE"),
        DECLARE("DECLARE"),
        DELETE("DELETE"),
        DROP("DROP"),
        END("END"),
        EXECUTE("EXECUTE"),
        EXPLAIN("EXPLAIN"),
        FETCH("FETCH"),
        GRANT("GRANT"),
        INSERT("INSERT"),
        LISTEN("LISTEN"),
        LOAD("LOAD"),
        LOCK("LOCK"),
        MOVE("MOVE"),
        NOTIFY("NOTIFY"),
        PREPARE("PREPARE"),
        REINDEX("REINDEX"),
        RESET("RESET"),
        REVOKE("REVOKE"),
        ROLLBACK("ROLLBACK"),
        SELECT("SELECT"),
        SET("SET"),
        SHOW("SHOW"),
        START("START"),
        TRUNCATE("TRUNCATE"),
        UNLISTEN("UNLISTEN"),
        UPDATE("UPDATE"),
        VACUUM("VACUUM");

        private String string;

        private Statements(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }
    }
}

