/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence;

import com.bekvon.bukkit.residence.CommandFiller;
import com.bekvon.bukkit.residence.ConfigManager;
import com.bekvon.bukkit.residence.LocaleManager;
import com.bekvon.bukkit.residence.allNms.v1_10Events;
import com.bekvon.bukkit.residence.allNms.v1_8Events;
import com.bekvon.bukkit.residence.allNms.v1_9Events;
import com.bekvon.bukkit.residence.api.ChatInterface;
import com.bekvon.bukkit.residence.api.MarketBuyInterface;
import com.bekvon.bukkit.residence.api.MarketRentInterface;
import com.bekvon.bukkit.residence.api.ResidenceApi;
import com.bekvon.bukkit.residence.api.ResidenceInterface;
import com.bekvon.bukkit.residence.api.ResidencePlayerInterface;
import com.bekvon.bukkit.residence.chat.ChatManager;
import com.bekvon.bukkit.residence.containers.ABInterface;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.NMS;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.dynmap.DynMapListeners;
import com.bekvon.bukkit.residence.dynmap.DynMapManager;
import com.bekvon.bukkit.residence.economy.BOSEAdapter;
import com.bekvon.bukkit.residence.economy.EconomyInterface;
import com.bekvon.bukkit.residence.economy.EssentialsEcoAdapter;
import com.bekvon.bukkit.residence.economy.IConomy5Adapter;
import com.bekvon.bukkit.residence.economy.IConomy6Adapter;
import com.bekvon.bukkit.residence.economy.RealShopEconomy;
import com.bekvon.bukkit.residence.economy.TransactionManager;
import com.bekvon.bukkit.residence.economy.rent.RentManager;
import com.bekvon.bukkit.residence.gui.FlagUtil;
import com.bekvon.bukkit.residence.itemlist.WorldItemManager;
import com.bekvon.bukkit.residence.listeners.ResidenceBlockListener;
import com.bekvon.bukkit.residence.listeners.ResidenceEntityListener;
import com.bekvon.bukkit.residence.listeners.ResidenceFixesListener;
import com.bekvon.bukkit.residence.listeners.ResidencePlayerListener;
import com.bekvon.bukkit.residence.listeners.SpigotListener;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.persistance.YMLSaveHelper;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.protection.LeaseManager;
import com.bekvon.bukkit.residence.protection.PermissionListManager;
import com.bekvon.bukkit.residence.protection.PlayerManager;
import com.bekvon.bukkit.residence.protection.ResidenceManager;
import com.bekvon.bukkit.residence.protection.ResidencePermissions;
import com.bekvon.bukkit.residence.protection.WorldFlagManager;
import com.bekvon.bukkit.residence.selection.AutoSelection;
import com.bekvon.bukkit.residence.selection.SchematicsManager;
import com.bekvon.bukkit.residence.selection.SelectionManager;
import com.bekvon.bukkit.residence.selection.WorldEditSelectionManager;
import com.bekvon.bukkit.residence.selection.WorldGuardUtil;
import com.bekvon.bukkit.residence.shopStuff.ShopListener;
import com.bekvon.bukkit.residence.shopStuff.ShopSignUtil;
import com.bekvon.bukkit.residence.signsStuff.SignUtil;
import com.bekvon.bukkit.residence.spout.ResidenceSpout;
import com.bekvon.bukkit.residence.spout.ResidenceSpoutListener;
import com.bekvon.bukkit.residence.text.Language;
import com.bekvon.bukkit.residence.text.help.HelpEntry;
import com.bekvon.bukkit.residence.text.help.InformationPager;
import com.bekvon.bukkit.residence.utils.ActionBar;
import com.bekvon.bukkit.residence.utils.CrackShot;
import com.bekvon.bukkit.residence.utils.FileCleanUp;
import com.bekvon.bukkit.residence.utils.RandomTp;
import com.bekvon.bukkit.residence.utils.Sorting;
import com.bekvon.bukkit.residence.utils.TabComplete;
import com.bekvon.bukkit.residence.utils.VersionChecker;
import com.bekvon.bukkit.residence.utils.YmlMaker;
import com.bekvon.bukkit.residence.vaultinterface.ResidenceVaultAdapter;
import com.earth2me.essentials.Essentials;
import com.griefcraft.lwc.LWC;
import com.griefcraft.lwc.LWCPlugin;
import com.iCo6.iConomy;
import com.residence.mcstats.Metrics;
import com.residence.zip.ZipLibrary;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import cosine.boseconomy.BOSEconomy;
import fr.crafter.tickleman.realeconomy.RealEconomy;
import fr.crafter.tickleman.realplugin.RealPlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.dynmap.DynmapAPI;

public class Residence
extends JavaPlugin {
    private static Residence instance;
    protected String ResidenceVersion;
    protected List<String> authlist;
    protected ResidenceManager rmanager;
    protected SelectionManager smanager;
    public PermissionManager gmanager;
    protected ConfigManager cmanager;
    protected boolean spigotPlatform = false;
    protected SignUtil signmanager;
    protected ResidenceBlockListener blistener;
    protected ResidencePlayerListener plistener;
    protected ResidenceEntityListener elistener;
    protected ResidenceSpoutListener slistener;
    protected ResidenceSpout spout;
    protected ResidenceFixesListener flistener;
    protected SpigotListener spigotlistener;
    protected ShopListener shlistener;
    protected TransactionManager tmanager;
    protected PermissionListManager pmanager;
    protected LeaseManager leasemanager;
    public WorldItemManager imanager;
    public WorldFlagManager wmanager;
    protected RentManager rentmanager;
    protected ChatManager chatmanager;
    protected Server server;
    public HelpEntry helppages;
    protected LocaleManager LocaleManager;
    protected Language NewLanguageManager;
    protected PlayerManager PlayerManager;
    protected FlagUtil FlagUtilManager;
    protected ShopSignUtil ShopSignUtilManager;
    protected RandomTp RandomTpManager;
    protected DynMapManager DynManager;
    protected Sorting SortingManager;
    protected ActionBar ABManager;
    protected AutoSelection AutoSelectionManager;
    protected SchematicsManager SchematicManager;
    private InformationPager InformationPagerManager;
    private WorldGuardUtil worldGuardUtil;
    protected CommandFiller cmdFiller;
    protected ZipLibrary zip;
    protected boolean firstenable = true;
    protected EconomyInterface economy;
    private int saveVersion = 1;
    public File dataFolder;
    protected int leaseBukkitId = -1;
    protected int rentBukkitId = -1;
    protected int healBukkitId = -1;
    protected int feedBukkitId = -1;
    protected int DespawnMobsBukkitId = -1;
    protected int autosaveBukkitId = -1;
    protected VersionChecker versionChecker;
    protected boolean initsuccess = false;
    public Map<String, String> deleteConfirm;
    public Map<String, String> UnrentConfirm = new HashMap<String, String>();
    public List<String> resadminToggle;
    private static final String[] validLanguages;
    private ConcurrentHashMap<String, OfflinePlayer> OfflinePlayerList = new ConcurrentHashMap();
    private Map<UUID, String> cachedPlayerNameUUIDs = new HashMap<UUID, String>();
    private WorldEditPlugin wep = null;
    private WorldGuardPlugin wg = null;
    private int wepid;
    private String ServerLandname = "Server_Land";
    private String ServerLandUUID = "00000000-0000-0000-0000-000000000000";
    private String TempUserUUID = "ffffffff-ffff-ffff-ffff-ffffffffffff";
    private ABInterface ab;
    private NMS nms;
    private LWC lwc;
    public HashMap<String, Long> rtMap = new HashMap();
    public List<String> teleportDelayMap = new ArrayList<String>();
    public HashMap<String, ClaimedResidence> teleportMap = new HashMap();
    private String prefix = ChatColor.GREEN + "[" + ChatColor.GOLD + "Residence" + ChatColor.GREEN + "]" + ChatColor.GRAY;
    private ResidenceApi API = new ResidenceApi();
    private MarketBuyInterface MarketBuyAPI = null;
    private MarketRentInterface MarketRentAPI = null;
    private ResidencePlayerInterface PlayerAPI = null;
    private ResidenceInterface ResidenceAPI = null;
    private ChatInterface ChatAPI = null;
    private Runnable doHeals = new Runnable(){

        @Override
        public void run() {
            Residence.this.plistener.doHeals();
        }
    };
    private Runnable doFeed = new Runnable(){

        @Override
        public void run() {
            Residence.this.plistener.feed();
        }
    };
    private Runnable DespawnMobs = new Runnable(){

        @Override
        public void run() {
            Residence.this.plistener.DespawnMobs();
        }
    };
    private Runnable rentExpire = new Runnable(){

        @Override
        public void run() {
            Residence.this.rentmanager.checkCurrentRents();
            if (Residence.this.cmanager.showIntervalMessages()) {
                Bukkit.getConsoleSender().sendMessage(String.valueOf(Residence.this.getPrefix()) + " - Rent Expirations checked!");
            }
        }
    };
    private Runnable leaseExpire = new Runnable(){

        @Override
        public void run() {
            Residence.this.leasemanager.doExpirations();
            if (Residence.this.cmanager.showIntervalMessages()) {
                Bukkit.getConsoleSender().sendMessage(String.valueOf(Residence.this.getPrefix()) + " - Lease Expirations checked!");
            }
        }
    };
    private Runnable autoSave = new Runnable(){

        @Override
        public void run() {
            try {
                if (Residence.this.initsuccess) {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)Residence.this, new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Residence.this.saveYml();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }
            catch (Exception ex) {
                Logger.getLogger("Minecraft").log(Level.SEVERE, String.valueOf(Residence.this.getPrefix()) + " SEVERE SAVE ERROR", ex);
            }
        }
    };

    static {
        validLanguages = new String[]{"English", "Czech", "Chinese", "ChineseTW"};
    }

    public boolean isSpigot() {
        return this.spigotPlatform;
    }

    public HashMap<String, ClaimedResidence> getTeleportMap() {
        return this.teleportMap;
    }

    public List<String> getTeleportDelayMap() {
        return this.teleportDelayMap;
    }

    public HashMap<String, Long> getRandomTeleportMap() {
        return this.rtMap;
    }

    public ResidencePlayerInterface getPlayerManagerAPI() {
        if (this.PlayerAPI == null) {
            this.PlayerAPI = this.PlayerManager;
        }
        return this.PlayerAPI;
    }

    public ResidenceInterface getResidenceManagerAPI() {
        if (this.ResidenceAPI == null) {
            this.ResidenceAPI = this.rmanager;
        }
        return this.ResidenceAPI;
    }

    public MarketRentInterface getMarketRentManagerAPI() {
        if (this.MarketRentAPI == null) {
            this.MarketRentAPI = this.rentmanager;
        }
        return this.MarketRentAPI;
    }

    public MarketBuyInterface getMarketBuyManagerAPI() {
        if (this.MarketBuyAPI == null) {
            this.MarketBuyAPI = this.tmanager;
        }
        return this.MarketBuyAPI;
    }

    public ChatInterface getResidenceChatAPI() {
        if (this.ChatAPI == null) {
            this.ChatAPI = this.chatmanager;
        }
        return this.ChatAPI;
    }

    public ResidenceApi getAPI() {
        return this.API;
    }

    public NMS getNms() {
        return this.nms;
    }

    public ABInterface getAB() {
        return this.ab;
    }

    public void reloadPlugin() {
        this.onDisable();
        this.reloadConfig();
        this.onEnable();
    }

    public void onDisable() {
        this.server.getScheduler().cancelTask(this.autosaveBukkitId);
        this.server.getScheduler().cancelTask(this.healBukkitId);
        this.server.getScheduler().cancelTask(this.feedBukkitId);
        this.server.getScheduler().cancelTask(this.DespawnMobsBukkitId);
        if (this.cmanager.useLeases()) {
            this.server.getScheduler().cancelTask(this.leaseBukkitId);
        }
        if (this.cmanager.enabledRentSystem()) {
            this.server.getScheduler().cancelTask(this.rentBukkitId);
        }
        if (this.getDynManager() != null && this.getDynManager().getMarkerSet() != null) {
            this.getDynManager().getMarkerSet().deleteMarkerSet();
        }
        if (this.initsuccess) {
            try {
                this.saveYml();
                if (this.zip != null) {
                    this.zip.backup();
                }
            }
            catch (Exception ex) {
                Logger.getLogger("Minecraft").log(Level.SEVERE, "[Residence] SEVERE SAVE ERROR", ex);
            }
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " Disabled!");
        }
    }

    public void onEnable() {
        try {
            int autosaveInt;
            Plugin dynmap;
            Object object;
            block78: {
                String lang;
                Class<?> nmsClass;
                Plugin plugin;
                instance = this;
                this.initsuccess = false;
                this.deleteConfirm = new HashMap<String, String>();
                this.resadminToggle = new ArrayList<String>();
                this.server = this.getServer();
                this.dataFolder = this.getDataFolder();
                this.ResidenceVersion = this.getDescription().getVersion();
                this.authlist = this.getDescription().getAuthors();
                this.cmdFiller = new CommandFiller();
                this.cmdFiller.fillCommands();
                this.SortingManager = new Sorting();
                if (!this.dataFolder.isDirectory()) {
                    this.dataFolder.mkdirs();
                }
                if (!new File(this.dataFolder, "groups.yml").isFile() && !new File(this.dataFolder, "flags.yml").isFile() && new File(this.dataFolder, "config.yml").isFile()) {
                    this.ConvertFile();
                }
                if (!new File(this.dataFolder, "config.yml").isFile()) {
                    this.writeDefaultConfigFromJar();
                }
                if (!new File(this.dataFolder, "uuids.yml").isFile()) {
                    File file = new File(this.getDataFolder(), "uuids.yml");
                    file.createNewFile();
                }
                if (!new File(this.dataFolder, "flags.yml").isFile()) {
                    this.writeDefaultFlagsFromJar();
                }
                if (!new File(this.dataFolder, "groups.yml").isFile()) {
                    this.writeDefaultGroupsFromJar();
                }
                this.getCommand("res").setTabCompleter((TabCompleter)new TabComplete());
                this.getCommand("resadmin").setTabCompleter((TabCompleter)new TabComplete());
                this.getCommand("residence").setTabCompleter((TabCompleter)new TabComplete());
                this.cmanager = new ConfigManager(this);
                String multiworld = this.cmanager.getMultiworldPlugin();
                if (multiworld != null && (plugin = this.server.getPluginManager().getPlugin(multiworld)) != null && !plugin.isEnabled()) {
                    Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " - Enabling multiworld plugin: " + multiworld);
                    this.server.getPluginManager().enablePlugin(plugin);
                }
                this.FlagUtilManager = new FlagUtil(this);
                this.getFlagUtilManager().load();
                try {
                    Class<?> c = Class.forName("org.bukkit.entity.Player");
                    Method[] methodArray = c.getDeclaredMethods();
                    int n = methodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Method one = methodArray[n2];
                        if (one.getName().equalsIgnoreCase("Spigot")) {
                            this.spigotPlatform = true;
                        }
                        ++n2;
                    }
                }
                catch (Exception c) {
                    // empty catch block
                }
                String packageName = this.getServer().getClass().getPackage().getName();
                String[] packageSplit = packageName.split("\\.");
                String version2 = packageSplit[packageSplit.length - 1].substring(0, packageSplit[packageSplit.length - 1].length() - 3);
                try {
                    nmsClass = this.getConfigManager().CouldronCompatability() ? Class.forName("com.bekvon.bukkit.residence.allNms.v1_7_Couldron") : Class.forName("com.bekvon.bukkit.residence.allNms." + version2);
                    if (NMS.class.isAssignableFrom(nmsClass)) {
                        this.nms = (NMS)nmsClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    } else {
                        System.out.println("Something went wrong, please note down version and contact author v:" + version2);
                        this.setEnabled(false);
                        Bukkit.shutdown();
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    System.out.println("Your server version is not compatible with this plugins version! Plugin will be disabled: " + version2 + " and server will shutdown");
                    this.setEnabled(false);
                    Bukkit.shutdown();
                    return;
                }
                this.ABManager = new ActionBar();
                version2 = packageSplit[packageSplit.length - 1];
                try {
                    nmsClass = Class.forName("com.bekvon.bukkit.residence.actionBarNMS." + version2);
                    if (ABInterface.class.isAssignableFrom(nmsClass)) {
                        this.ab = (ABInterface)nmsClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    } else {
                        System.out.println("Something went wrong, please note down version and contact author v:" + version2);
                        this.setEnabled(false);
                        Bukkit.shutdown();
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    this.ab = this.ABManager;
                    return;
                }
                this.gmanager = new PermissionManager(this);
                this.imanager = new WorldItemManager(this);
                this.wmanager = new WorldFlagManager(this);
                this.chatmanager = new ChatManager();
                this.rentmanager = new RentManager(this);
                this.LocaleManager = new LocaleManager(this);
                this.PlayerManager = new PlayerManager(this);
                this.ShopSignUtilManager = new ShopSignUtil(this);
                this.RandomTpManager = new RandomTp(this);
                this.InformationPagerManager = new InformationPager(this);
                this.zip = new ZipLibrary(this);
                this.versionChecker = new VersionChecker(this);
                Plugin lwcp = Bukkit.getPluginManager().getPlugin("LWC");
                if (lwcp != null) {
                    this.lwc = ((LWCPlugin)lwcp).getLWC();
                }
                object = validLanguages;
                int n = validLanguages.length;
                int n3 = 0;
                while (n3 < n) {
                    lang = object[n3];
                    YmlMaker langFile = new YmlMaker(this, "Language" + File.separator + lang + ".yml");
                    langFile.saveDefaultConfig();
                    ++n3;
                }
                object = validLanguages;
                n = validLanguages.length;
                n3 = 0;
                while (n3 < n) {
                    lang = object[n3];
                    this.getLocaleManager().LoadLang(lang);
                    ++n3;
                }
                this.getConfigManager().UpdateFlagFile();
                try {
                    File langFile = new File(new File(this.dataFolder, "Language"), String.valueOf(this.cmanager.getLanguage()) + ".yml");
                    BufferedReader in = null;
                    try {
                        in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(langFile), "UTF8"));
                    }
                    catch (UnsupportedEncodingException e1) {
                        e1.printStackTrace();
                    }
                    catch (FileNotFoundException e1) {
                        e1.printStackTrace();
                    }
                    if (langFile.isFile()) {
                        YamlConfiguration langconfig = new YamlConfiguration();
                        langconfig.load((Reader)in);
                        this.helppages = HelpEntry.parseHelp((FileConfiguration)langconfig, "CommandHelp");
                    } else {
                        Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " Language file does not exist...");
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception ex) {
                    Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " Failed to load language file: " + this.cmanager.getLanguage() + ".yml setting to default - English");
                    File langFile = new File(new File(this.dataFolder, "Language"), "English.yml");
                    BufferedReader in = null;
                    try {
                        in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(langFile), "UTF8"));
                    }
                    catch (UnsupportedEncodingException e1) {
                        e1.printStackTrace();
                    }
                    catch (FileNotFoundException e1) {
                        e1.printStackTrace();
                    }
                    if (langFile.isFile()) {
                        YamlConfiguration langconfig = new YamlConfiguration();
                        langconfig.load((Reader)in);
                        this.helppages = HelpEntry.parseHelp((FileConfiguration)langconfig, "CommandHelp");
                    } else {
                        Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " Language file does not exist...");
                    }
                    if (in == null) break block78;
                    in.close();
                }
            }
            this.economy = null;
            if (this.getConfig().getBoolean("Global.EnableEconomy", false)) {
                ResidenceVaultAdapter vault;
                Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " Scanning for economy systems...");
                if (this.gmanager.getPermissionsPlugin() instanceof ResidenceVaultAdapter && (vault = (ResidenceVaultAdapter)this.gmanager.getPermissionsPlugin()).economyOK()) {
                    this.economy = vault;
                    Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " Found Vault using economy system: " + vault.getEconomyName());
                }
                if (this.economy == null) {
                    this.loadVaultEconomy();
                }
                if (this.economy == null) {
                    this.loadBOSEconomy();
                }
                if (this.economy == null) {
                    this.loadEssentialsEconomy();
                }
                if (this.economy == null) {
                    this.loadRealEconomy();
                }
                if (this.economy == null) {
                    this.loadIConomy();
                }
                if (this.economy == null) {
                    Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " Unable to find an economy system...");
                }
            }
            if (this.getConfigManager().isUUIDConvertion()) {
                Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " Loading (" + Bukkit.getOfflinePlayers().length + ") player data");
                object = Bukkit.getOfflinePlayers();
                int in = ((OfflinePlayer[])object).length;
                int langFile = 0;
                while (langFile < in) {
                    String name;
                    String player = object[langFile];
                    if (player != null && (name = player.getName()) != null) {
                        this.getOfflinePlayerMap().put(name.toLowerCase(), (OfflinePlayer)player);
                        this.getCachedPlayerNameUUIDs().put(player.getUniqueId(), player.getName());
                    }
                    ++langFile;
                }
                Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " Player data loaded: " + this.getOfflinePlayerMap().size());
            } else {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, new Runnable(){

                    @Override
                    public void run() {
                        OfflinePlayer[] offlinePlayerArray = Bukkit.getOfflinePlayers();
                        int n = offlinePlayerArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String name;
                            OfflinePlayer player = offlinePlayerArray[n2];
                            if (player != null && (name = player.getName()) != null) {
                                Residence.this.getOfflinePlayerMap().put(name.toLowerCase(), player);
                                Residence.this.getCachedPlayerNameUUIDs().put(player.getUniqueId(), player.getName());
                            }
                            ++n2;
                        }
                    }
                });
            }
            if (this.rmanager == null) {
                this.rmanager = new ResidenceManager(this);
            }
            if (this.leasemanager == null) {
                this.leasemanager = new LeaseManager(this, this.rmanager);
            }
            if (this.tmanager == null) {
                this.tmanager = new TransactionManager(this);
            }
            if (this.pmanager == null) {
                this.pmanager = new PermissionListManager(this);
            }
            try {
                this.loadYml();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Unable to load save file", e);
                throw e;
            }
            this.signmanager = new SignUtil(this);
            this.getSignUtil().LoadSigns();
            if (this.getConfigManager().isUseResidenceFileClean()) {
                new FileCleanUp(this).cleanFiles();
            }
            if (this.firstenable) {
                if (!this.isEnabled()) {
                    return;
                }
                FlagPermissions.initValidFlags();
                this.setWorldEdit();
                this.setWorldGuard();
                this.blistener = new ResidenceBlockListener(this);
                this.plistener = new ResidencePlayerListener(this);
                this.elistener = new ResidenceEntityListener(this);
                this.flistener = new ResidenceFixesListener();
                this.shlistener = new ShopListener(this);
                this.spigotlistener = new SpigotListener();
                PluginManager pm = this.getServer().getPluginManager();
                pm.registerEvents((Listener)this.blistener, (Plugin)this);
                pm.registerEvents((Listener)this.plistener, (Plugin)this);
                pm.registerEvents((Listener)this.elistener, (Plugin)this);
                pm.registerEvents((Listener)this.flistener, (Plugin)this);
                pm.registerEvents((Listener)this.shlistener, (Plugin)this);
                if (this.getVersionChecker().GetVersion() >= 1800) {
                    pm.registerEvents((Listener)new v1_8Events(), (Plugin)this);
                }
                if (this.getVersionChecker().GetVersion() >= 1900) {
                    pm.registerEvents((Listener)new v1_9Events(), (Plugin)this);
                }
                if (this.getVersionChecker().GetVersion() >= 11000) {
                    pm.registerEvents((Listener)new v1_10Events(), (Plugin)this);
                }
                if (this.cmanager.enableSpout()) {
                    this.slistener = new ResidenceSpoutListener(this);
                    pm.registerEvents((Listener)this.slistener, (Plugin)this);
                    this.spout = new ResidenceSpout(this);
                }
                this.firstenable = false;
            } else {
                this.plistener.reload();
            }
            this.NewLanguageManager = new Language(this);
            this.getLM().LanguageReload();
            this.AutoSelectionManager = new AutoSelection(this);
            if (this.wep != null) {
                this.SchematicManager = new SchematicsManager(this);
            }
            try {
                Class.forName("org.bukkit.event.player.PlayerItemDamageEvent");
                this.getServer().getPluginManager().registerEvents((Listener)this.spigotlistener, (Plugin)this);
            }
            catch (Exception pm) {
                // empty catch block
            }
            if (this.getServer().getPluginManager().getPlugin("CrackShot") != null) {
                this.getServer().getPluginManager().registerEvents((Listener)new CrackShot(this), (Plugin)this);
            }
            if ((dynmap = Bukkit.getPluginManager().getPlugin("dynmap")) != null && this.getConfigManager().DynMapUse) {
                this.DynManager = new DynMapManager(this);
                this.getServer().getPluginManager().registerEvents((Listener)new DynMapListeners(this), (Plugin)this);
                this.getDynManager().api = (DynmapAPI)dynmap;
                this.getDynManager().activate();
            }
            if ((autosaveInt = this.cmanager.getAutoSaveInterval()) < 1) {
                autosaveInt = 1;
            }
            autosaveInt = autosaveInt * 60 * 20;
            this.autosaveBukkitId = this.server.getScheduler().scheduleSyncRepeatingTask((Plugin)this, this.autoSave, (long)autosaveInt, (long)autosaveInt);
            this.healBukkitId = this.server.getScheduler().scheduleSyncRepeatingTask((Plugin)this, this.doHeals, 20L, (long)(this.getConfigManager().getHealInterval() * 20));
            this.feedBukkitId = this.server.getScheduler().scheduleSyncRepeatingTask((Plugin)this, this.doFeed, 20L, (long)(this.getConfigManager().getFeedInterval() * 20));
            if (this.getConfigManager().AutoMobRemoval()) {
                this.DespawnMobsBukkitId = this.server.getScheduler().scheduleSyncRepeatingTask((Plugin)this, this.DespawnMobs, (long)(20 * this.getConfigManager().AutoMobRemovalInterval()), (long)(20 * this.getConfigManager().AutoMobRemovalInterval()));
            }
            if (this.cmanager.useLeases()) {
                int leaseInterval = this.cmanager.getLeaseCheckInterval();
                if (leaseInterval < 1) {
                    leaseInterval = 1;
                }
                leaseInterval = leaseInterval * 60 * 20;
                this.leaseBukkitId = this.server.getScheduler().scheduleSyncRepeatingTask((Plugin)this, this.leaseExpire, (long)leaseInterval, (long)leaseInterval);
            }
            if (this.cmanager.enabledRentSystem()) {
                int rentint = this.cmanager.getRentCheckInterval();
                if (rentint < 1) {
                    rentint = 1;
                }
                rentint = rentint * 60 * 20;
                this.rentBukkitId = this.server.getScheduler().scheduleSyncRepeatingTask((Plugin)this, this.rentExpire, (long)rentint, (long)rentint);
            }
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                if (!this.getPermissionManager().isResidenceAdmin((CommandSender)player)) continue;
                this.turnResAdminOn(player);
            }
            try {
                Metrics metrics = new Metrics((Plugin)this);
                metrics.start();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " Enabled! Version " + this.getDescription().getVersion() + " by Zrips");
            this.initsuccess = true;
            this.PlayerManager.fillList();
        }
        catch (Exception ex) {
            this.initsuccess = false;
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " - FAILED INITIALIZATION! DISABLED! ERROR:");
            Logger.getLogger(Residence.class.getName()).log(Level.SEVERE, null, ex);
            Bukkit.getServer().shutdown();
        }
        this.getShopSignUtilManager().LoadShopVotes();
        this.getShopSignUtilManager().LoadSigns();
        this.getShopSignUtilManager().BoardUpdate();
        this.getVersionChecker().VersionCheck(null);
    }

    public SignUtil getSignUtil() {
        return this.signmanager;
    }

    public void consoleMessage(String message2) {
        Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " " + message2);
    }

    public boolean validName(String name) {
        if (name.contains(":") || name.contains(".") || name.contains("|")) {
            return false;
        }
        if (this.cmanager.getResidenceNameRegex() == null) {
            return true;
        }
        String namecheck = name.replaceAll(this.cmanager.getResidenceNameRegex(), "");
        return name.equals(namecheck);
    }

    private void setWorldEdit() {
        Plugin plugin = this.server.getPluginManager().getPlugin("WorldEdit");
        if (plugin != null) {
            this.smanager = new WorldEditSelectionManager(this.server, this);
            this.wep = (WorldEditPlugin)plugin;
            this.wepid = this.getWorldEdit().getConfig().getInt("wand-item");
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " Found WorldEdit");
        } else {
            this.smanager = new SelectionManager(this.server, this);
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " WorldEdit NOT found!");
        }
    }

    private void setWorldGuard() {
        Plugin wgplugin = this.server.getPluginManager().getPlugin("WorldGuard");
        if (wgplugin != null) {
            try {
                Class.forName("com.sk89q.worldedit.BlockVector");
                Class.forName("com.sk89q.worldguard.protection.ApplicableRegionSet");
                Class.forName("com.sk89q.worldguard.protection.managers.RegionManager");
                Class.forName("com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion");
                Class.forName("com.sk89q.worldguard.protection.regions.ProtectedRegion");
            }
            catch (Exception e) {
                Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + ChatColor.RED + " Found WorldGuard, but its not supported by Residence plugin. Please update WorldGuard to latest version");
                return;
            }
            this.wg = (WorldGuardPlugin)wgplugin;
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " Found WorldGuard");
        }
    }

    public Residence getPlugin() {
        return this;
    }

    public VersionChecker getVersionChecker() {
        return this.versionChecker;
    }

    public LWC getLwc() {
        return this.lwc;
    }

    public File getDataLocation() {
        return this.dataFolder;
    }

    public ShopSignUtil getShopSignUtilManager() {
        return this.ShopSignUtilManager;
    }

    public ResidenceSpout getSpout() {
        return this.spout;
    }

    public ResidenceSpoutListener getSpoutListener() {
        return this.slistener;
    }

    public CommandFiller getCommandFiller() {
        if (this.cmdFiller == null) {
            this.cmdFiller = new CommandFiller();
            this.cmdFiller.fillCommands();
        }
        return this.cmdFiller;
    }

    public ResidenceManager getResidenceManager() {
        return this.rmanager;
    }

    public SelectionManager getSelectionManager() {
        return this.smanager;
    }

    public FlagUtil getFlagUtilManager() {
        return this.FlagUtilManager;
    }

    public PermissionManager getPermissionManager() {
        return this.gmanager;
    }

    public PermissionListManager getPermissionListManager() {
        return this.pmanager;
    }

    public DynMapManager getDynManager() {
        return this.DynManager;
    }

    public SchematicsManager getSchematicManager() {
        return this.SchematicManager;
    }

    public AutoSelection getAutoSelectionManager() {
        return this.AutoSelectionManager;
    }

    public Sorting getSortingManager() {
        return this.SortingManager;
    }

    public RandomTp getRandomTpManager() {
        return this.RandomTpManager;
    }

    public EconomyInterface getEconomyManager() {
        return this.economy;
    }

    public Server getServ() {
        return this.server;
    }

    public LeaseManager getLeaseManager() {
        return this.leasemanager;
    }

    public PlayerManager getPlayerManager() {
        return this.PlayerManager;
    }

    public HelpEntry getHelpPages() {
        return this.helppages;
    }

    public void setConfigManager(ConfigManager cm) {
        this.cmanager = cm;
    }

    public ConfigManager getConfigManager() {
        return this.cmanager;
    }

    public TransactionManager getTransactionManager() {
        return this.tmanager;
    }

    public WorldItemManager getItemManager() {
        return this.imanager;
    }

    public WorldFlagManager getWorldFlags() {
        return this.wmanager;
    }

    public RentManager getRentManager() {
        return this.rentmanager;
    }

    public LocaleManager getLocaleManager() {
        return this.LocaleManager;
    }

    public Language getLM() {
        return this.NewLanguageManager;
    }

    public ResidencePlayerListener getPlayerListener() {
        return this.plistener;
    }

    public ResidenceBlockListener getBlockListener() {
        return this.blistener;
    }

    public ResidenceEntityListener getEntityListener() {
        return this.elistener;
    }

    public ChatManager getChatManager() {
        return this.chatmanager;
    }

    public String getResidenceVersion() {
        return this.ResidenceVersion;
    }

    public List<String> getAuthors() {
        return this.authlist;
    }

    public FlagPermissions getPermsByLoc(Location loc) {
        ClaimedResidence res = this.rmanager.getByLoc(loc);
        if (res != null) {
            return res.getPermissions();
        }
        return this.wmanager.getPerms(loc.getWorld().getName());
    }

    public FlagPermissions getPermsByLocForPlayer(Location loc, Player player) {
        ClaimedResidence res = this.rmanager.getByLoc(loc);
        if (res != null) {
            return res.getPermissions();
        }
        if (player != null) {
            return this.wmanager.getPerms(player);
        }
        return this.wmanager.getPerms(loc.getWorld().getName());
    }

    private void loadIConomy() {
        Plugin p = this.getServer().getPluginManager().getPlugin("iConomy");
        if (p != null) {
            if (p.getDescription().getVersion().startsWith("6")) {
                this.economy = new IConomy6Adapter((iConomy)p);
            } else if (p.getDescription().getVersion().startsWith("5")) {
                this.economy = new IConomy5Adapter();
            } else {
                Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " UNKNOWN iConomy version!");
                return;
            }
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " Successfully linked with iConomy! Version: " + p.getDescription().getVersion());
        } else {
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " iConomy NOT found!");
        }
    }

    private void loadBOSEconomy() {
        Plugin p = this.getServer().getPluginManager().getPlugin("BOSEconomy");
        if (p != null) {
            this.economy = new BOSEAdapter((BOSEconomy)p);
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " Successfully linked with BOSEconomy!");
        } else {
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " BOSEconomy NOT found!");
        }
    }

    private void loadEssentialsEconomy() {
        Plugin p = this.getServer().getPluginManager().getPlugin("Essentials");
        if (p != null) {
            this.economy = new EssentialsEcoAdapter((Essentials)p);
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " Successfully linked with Essentials Economy!");
        } else {
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " Essentials Economy NOT found!");
        }
    }

    private void loadRealEconomy() {
        Plugin p = this.getServer().getPluginManager().getPlugin("RealPlugin");
        if (p != null) {
            this.economy = new RealShopEconomy(new RealEconomy((RealPlugin)p));
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " Successfully linked with RealShop Economy!");
        } else {
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " RealShop Economy NOT found!");
        }
    }

    private void loadVaultEconomy() {
        Plugin p = this.getServer().getPluginManager().getPlugin("Vault");
        if (p != null) {
            ResidenceVaultAdapter vault = new ResidenceVaultAdapter(this.getServer());
            if (vault.economyOK()) {
                Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " Found Vault using economy: " + vault.getEconomyName());
                this.economy = vault;
            } else {
                Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " Found Vault, but Vault reported no usable economy system...");
            }
        } else {
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " Vault NOT found!");
        }
    }

    public boolean isResAdminOn(CommandSender sender) {
        if (sender instanceof Player) {
            return this.isResAdminOn((Player)sender);
        }
        return true;
    }

    public boolean isResAdminOn(Player player) {
        return this.resadminToggle.contains(player.getName());
    }

    public void turnResAdminOn(Player player) {
        this.resadminToggle.add(player.getName());
    }

    public boolean isResAdminOn(String player) {
        return this.resadminToggle.contains(player);
    }

    private void saveYml() throws IOException {
        File backupFile;
        File backupFolder;
        YMLSaveHelper yml;
        File saveFolder = new File(this.dataFolder, "Save");
        File worldFolder = new File(saveFolder, "Worlds");
        worldFolder.mkdirs();
        Map<String, Object> save = this.rmanager.save();
        for (Map.Entry<String, Object> entry : save.entrySet()) {
            File ymlSaveLoc = new File(worldFolder, "res_" + entry.getKey() + ".yml");
            File tmpFile = new File(worldFolder, "tmp_res_" + entry.getKey() + ".yml");
            yml = new YMLSaveHelper(tmpFile);
            yml.getRoot().put("Version", this.saveVersion);
            World world = this.server.getWorld(entry.getKey());
            if (world != null) {
                yml.getRoot().put("Seed", world.getSeed());
            }
            yml.getRoot().put("Residences", entry.getValue());
            yml.save();
            if (ymlSaveLoc.isFile()) {
                File backupFolder2 = new File(worldFolder, "Backup");
                backupFolder2.mkdirs();
                File backupFile2 = new File(backupFolder2, "res_" + entry.getKey() + ".yml");
                if (backupFile2.isFile()) {
                    backupFile2.delete();
                }
                ymlSaveLoc.renameTo(backupFile2);
            }
            tmpFile.renameTo(ymlSaveLoc);
        }
        File ymlSaveLoc = new File(saveFolder, "forsale.yml");
        File tmpFile = new File(saveFolder, "tmp_forsale.yml");
        yml = new YMLSaveHelper(tmpFile);
        yml.save();
        yml.getRoot().put("Version", this.saveVersion);
        yml.getRoot().put("Economy", this.tmanager.save());
        yml.save();
        if (ymlSaveLoc.isFile()) {
            backupFolder = new File(saveFolder, "Backup");
            backupFolder.mkdirs();
            backupFile = new File(backupFolder, "forsale.yml");
            if (backupFile.isFile()) {
                backupFile.delete();
            }
            ymlSaveLoc.renameTo(backupFile);
        }
        tmpFile.renameTo(ymlSaveLoc);
        ymlSaveLoc = new File(saveFolder, "leases.yml");
        tmpFile = new File(saveFolder, "tmp_leases.yml");
        yml = new YMLSaveHelper(tmpFile);
        yml.getRoot().put("Version", this.saveVersion);
        yml.getRoot().put("Leases", this.leasemanager.save());
        yml.save();
        if (ymlSaveLoc.isFile()) {
            backupFolder = new File(saveFolder, "Backup");
            backupFolder.mkdirs();
            backupFile = new File(backupFolder, "leases.yml");
            if (backupFile.isFile()) {
                backupFile.delete();
            }
            ymlSaveLoc.renameTo(backupFile);
        }
        tmpFile.renameTo(ymlSaveLoc);
        ymlSaveLoc = new File(saveFolder, "permlists.yml");
        tmpFile = new File(saveFolder, "tmp_permlists.yml");
        yml = new YMLSaveHelper(tmpFile);
        yml.getRoot().put("Version", this.saveVersion);
        yml.getRoot().put("PermissionLists", this.pmanager.save());
        yml.save();
        if (ymlSaveLoc.isFile()) {
            backupFolder = new File(saveFolder, "Backup");
            backupFolder.mkdirs();
            backupFile = new File(backupFolder, "permlists.yml");
            if (backupFile.isFile()) {
                backupFile.delete();
            }
            ymlSaveLoc.renameTo(backupFile);
        }
        tmpFile.renameTo(ymlSaveLoc);
        ymlSaveLoc = new File(saveFolder, "rent.yml");
        tmpFile = new File(saveFolder, "tmp_rent.yml");
        yml = new YMLSaveHelper(tmpFile);
        yml.getRoot().put("Version", this.saveVersion);
        yml.getRoot().put("RentSystem", this.rentmanager.save());
        yml.save();
        if (ymlSaveLoc.isFile()) {
            backupFolder = new File(saveFolder, "Backup");
            backupFolder.mkdirs();
            backupFile = new File(backupFolder, "rent.yml");
            if (backupFile.isFile()) {
                backupFile.delete();
            }
            ymlSaveLoc.renameTo(backupFile);
        }
        tmpFile.renameTo(ymlSaveLoc);
        if (this.cmanager.showIntervalMessages()) {
            System.out.println("[Residence] - Saved Residences...");
        }
    }

    protected boolean loadYml() throws Exception {
        File worldFolder;
        File saveFolder;
        block11: {
            saveFolder = new File(this.dataFolder, "Save");
            worldFolder = new File(saveFolder, "Worlds");
            if (saveFolder.isDirectory()) break block11;
            this.getLogger().warning("Save directory does not exist...");
            this.getLogger().warning("Please restart server");
            return true;
        }
        try {
            YMLSaveHelper yml;
            File loadFile;
            HashMap<String, Object> worlds = new HashMap<String, Object>();
            for (World world : this.getServ().getWorlds()) {
                loadFile = new File(worldFolder, "res_" + world.getName() + ".yml");
                if (!loadFile.isFile()) continue;
                long time = System.currentTimeMillis();
                Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " Loading save data for world " + world.getName() + "...");
                yml = new YMLSaveHelper(loadFile);
                yml.load();
                worlds.put(world.getName(), yml.getRoot().get("Residences"));
                int pass = (int)(System.currentTimeMillis() - time);
                String PastTime = pass > 1000 ? String.valueOf(String.format("%.2f", Float.valueOf((float)pass / 1000.0f))) + " sec" : String.valueOf(pass) + " ms";
                Bukkit.getConsoleSender().sendMessage(String.valueOf(this.getPrefix()) + " Loaded " + world.getName() + " data. (" + PastTime + ")");
            }
            this.rmanager = this.getResidenceManager().load(worlds);
            Map<String, ClaimedResidence> resList = this.rmanager.getResidences();
            for (Map.Entry<String, ClaimedResidence> entry : resList.entrySet()) {
                this.addShops(entry.getValue());
            }
            if (this.getConfigManager().isUUIDConvertion()) {
                this.getConfigManager().ChangeConfig("Global.UUIDConvertion", false);
            }
            if ((loadFile = new File(saveFolder, "forsale.yml")).isFile()) {
                yml = new YMLSaveHelper(loadFile);
                yml.load();
                this.tmanager = new TransactionManager(this);
                this.tmanager.load((Map)yml.getRoot().get("Economy"));
            }
            if ((loadFile = new File(saveFolder, "leases.yml")).isFile()) {
                yml = new YMLSaveHelper(loadFile);
                yml.load();
                this.leasemanager = this.getLeaseManager().load((Map)yml.getRoot().get("Leases"), this.rmanager);
            }
            if ((loadFile = new File(saveFolder, "permlists.yml")).isFile()) {
                yml = new YMLSaveHelper(loadFile);
                yml.load();
                this.pmanager = this.getPermissionListManager().load((Map)yml.getRoot().get("PermissionLists"));
            }
            if ((loadFile = new File(saveFolder, "rent.yml")).isFile()) {
                yml = new YMLSaveHelper(loadFile);
                yml.load();
                this.rentmanager.load((Map)yml.getRoot().get("RentSystem"));
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                ResidencePlayer rplayer = this.getPlayerManager().getResidencePlayer(player);
                if (rplayer == null) continue;
                rplayer.recountRes();
            }
            return true;
        }
        catch (Exception ex) {
            Logger.getLogger(Residence.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
    }

    private void addShops(ClaimedResidence res) {
        ResidencePermissions perms = res.getPermissions();
        if (perms.has(Flags.shop, FlagPermissions.FlagCombo.OnlyTrue, false)) {
            this.rmanager.addShop(res);
        }
        for (ClaimedResidence one : res.getSubzones()) {
            this.addShops(one);
        }
    }

    private void writeDefaultConfigFromJar() {
        if (this.writeDefaultFileFromJar(new File(this.getDataFolder(), "config.yml"), "config.yml", true)) {
            System.out.println("[Residence] Wrote default config...");
        }
    }

    private void writeDefaultGroupsFromJar() {
        if (this.writeDefaultFileFromJar(new File(this.getDataFolder(), "groups.yml"), "groups.yml", true)) {
            System.out.println("[Residence] Wrote default groups...");
        }
    }

    private void writeDefaultFlagsFromJar() {
        if (this.writeDefaultFileFromJar(new File(this.getDataFolder(), "flags.yml"), "flags.yml", true)) {
            System.out.println("[Residence] Wrote default flags...");
        }
    }

    private void ConvertFile() {
        File file = new File(this.getDataFolder(), "config.yml");
        File file_old = new File(this.getDataFolder(), "config_old.yml");
        File newfile = new File(this.getDataFolder(), "groups.yml");
        File newTempFlags = new File(this.getDataFolder(), "flags.yml");
        try {
            Residence.copy(file, file_old);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            Residence.copy(file, newfile);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            Residence.copy(file, newTempFlags);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        File newGroups = new File(this.getDataFolder(), "config.yml");
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("ResidenceVersion");
        list2.add("Global.Flags");
        list2.add("Global.FlagPermission");
        list2.add("Global.ResidenceDefault");
        list2.add("Global.CreatorDefault");
        list2.add("Global.GroupDefault");
        list2.add("Groups");
        list2.add("GroupAssignments");
        list2.add("ItemList");
        try {
            Residence.remove(newGroups, list2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File newConfig = new File(this.getDataFolder(), "groups.yml");
        list2.clear();
        list2 = new ArrayList();
        list2.add("ResidenceVersion");
        list2.add("Global");
        list2.add("ItemList");
        try {
            Residence.remove(newConfig, list2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File newFlags = new File(this.getDataFolder(), "flags.yml");
        list2.clear();
        list2 = new ArrayList();
        list2.add("ResidenceVersion");
        list2.add("GroupAssignments");
        list2.add("Groups");
        list2.add("Global.Language");
        list2.add("Global.SelectionToolId");
        list2.add("Global.InfoToolId");
        list2.add("Global.MoveCheckInterval");
        list2.add("Global.SaveInterval");
        list2.add("Global.DefaultGroup");
        list2.add("Global.UseLeaseSystem");
        list2.add("Global.LeaseCheckInterval");
        list2.add("Global.LeaseAutoRenew");
        list2.add("Global.EnablePermissions");
        list2.add("Global.LegacyPermissions");
        list2.add("Global.EnableEconomy");
        list2.add("Global.EnableRentSystem");
        list2.add("Global.RentCheckInterval");
        list2.add("Global.ResidenceChatEnable");
        list2.add("Global.UseActionBar");
        list2.add("Global.ResidenceChatColor");
        list2.add("Global.AdminOnlyCommands");
        list2.add("Global.AdminOPs");
        list2.add("Global.MultiWorldPlugin");
        list2.add("Global.ResidenceFlagsInherit");
        list2.add("Global.PreventRentModify");
        list2.add("Global.StopOnSaveFault");
        list2.add("Global.ResidenceNameRegex");
        list2.add("Global.ShowIntervalMessages");
        list2.add("Global.VersionCheck");
        list2.add("Global.CustomContainers");
        list2.add("Global.CustomBothClick");
        list2.add("Global.CustomRightClick");
        try {
            Residence.remove(newFlags, list2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void remove(File newGroups, List<String> list2) throws IOException {
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)newGroups);
        conf.options().copyDefaults(true);
        for (String one : list2) {
            conf.set(one, null);
        }
        try {
            conf.save(newGroups);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void copy(File source, File target) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(source);
        FileOutputStream out = new FileOutputStream(target);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private boolean writeDefaultFileFromJar(File writeName, String jarPath, boolean backupOld) {
        block8: {
            JarFile jar;
            block9: {
                try {
                    File fileBackup = new File(this.getDataFolder(), "backup-" + writeName);
                    File jarloc = new File(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).getCanonicalFile();
                    if (!jarloc.isFile()) break block8;
                    jar = new JarFile(jarloc);
                    JarEntry entry = jar.getJarEntry(jarPath);
                    if (entry == null || entry.isDirectory()) break block9;
                    InputStream in = jar.getInputStream(entry);
                    InputStreamReader isr = new InputStreamReader(in, "UTF8");
                    if (writeName.isFile()) {
                        if (backupOld) {
                            if (fileBackup.isFile()) {
                                fileBackup.delete();
                            }
                            writeName.renameTo(fileBackup);
                        } else {
                            writeName.delete();
                        }
                    }
                    FileOutputStream out = new FileOutputStream(writeName);
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)out, "UTF8");
                    char[] tempbytes = new char[512];
                    int readbytes = isr.read(tempbytes, 0, 512);
                    while (readbytes > -1) {
                        osw.write(tempbytes, 0, readbytes);
                        readbytes = isr.read(tempbytes, 0, 512);
                    }
                    osw.close();
                    isr.close();
                    return true;
                }
                catch (Exception ex) {
                    System.out.println("[Residence] Failed to write file: " + writeName);
                    return false;
                }
            }
            jar.close();
        }
        return false;
    }

    public boolean isPlayerExist(CommandSender sender, String name, boolean inform) {
        if (this.getPlayerUUID(name) != null) {
            return true;
        }
        if (inform) {
            sender.sendMessage(this.msg(lm.Invalid_Player, new Object[0]));
        }
        String a = "%%__USER__%%";
        String b = "%%__RESOURCE__%%";
        String c = "%%__NONCE__%%";
        return false;
    }

    public UUID getPlayerUUID(String playername) {
        Player p = this.getServ().getPlayer(playername);
        if (p == null) {
            if (this.getOfflinePlayerMap().containsKey(playername.toLowerCase())) {
                return this.getOfflinePlayerMap().get(playername.toLowerCase()).getUniqueId();
            }
        } else {
            return p.getUniqueId();
        }
        return null;
    }

    public ConcurrentHashMap<String, OfflinePlayer> getOfflinePlayerMap() {
        return this.OfflinePlayerList;
    }

    public OfflinePlayer getOfflinePlayer(String Name2) {
        if (this.getOfflinePlayerMap().containsKey(Name2.toLowerCase())) {
            return this.getOfflinePlayerMap().get(Name2.toLowerCase());
        }
        Player player = Bukkit.getPlayer((String)Name2);
        Player offPlayer = null;
        if (player != null) {
            offPlayer = player;
        }
        if (offPlayer == null) {
            offPlayer = Bukkit.getOfflinePlayer((String)Name2);
        }
        if (offPlayer != null) {
            this.getOfflinePlayerMap().put(Name2.toLowerCase(), (OfflinePlayer)offPlayer);
        }
        return offPlayer;
    }

    public String getPlayerUUIDString(String playername) {
        UUID playerUUID = this.getPlayerUUID(playername);
        if (playerUUID != null) {
            return playerUUID.toString();
        }
        return null;
    }

    public String getPlayerName(String uuid) {
        try {
            return this.getPlayerName(UUID.fromString(uuid));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public String getServerLandname() {
        return this.ServerLandname;
    }

    public String getServerLandUUID() {
        return this.ServerLandUUID;
    }

    public String getTempUserUUID() {
        return this.TempUserUUID;
    }

    public String getPlayerName(UUID uuid) {
        Player p = this.getServ().getPlayer(uuid);
        if (p == null) {
            p = this.getServ().getOfflinePlayer(uuid);
        }
        if (p != null) {
            return p.getName();
        }
        return null;
    }

    public boolean isDisabledWorldListener(World world) {
        return this.isDisabledWorldListener(world.getName());
    }

    public boolean isDisabledWorldListener(String worldname) {
        return this.getConfigManager().DisabledWorldsList.contains(worldname) && this.getConfigManager().DisableListeners;
    }

    public boolean isDisabledWorldCommand(World world) {
        return this.isDisabledWorldCommand(world.getName());
    }

    public boolean isDisabledWorldCommand(String worldname) {
        return this.getConfigManager().DisabledWorldsList.contains(worldname) && this.getConfigManager().DisableCommands;
    }

    public String msg(String path) {
        return this.getLM().getMessage(path);
    }

    public void msg(CommandSender sender, String text) {
        if (sender != null && text.length() > 0) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)text));
        }
    }

    public void msg(Player player, String text) {
        if (player != null && text.length() > 0) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)text));
        }
    }

    public void msg(CommandSender sender, lm lm2, Object ... variables) {
        if (sender != null) {
            if (this.getLM().containsKey(lm2.getPath())) {
                String msg = this.getLM().getMessage(lm2, variables);
                if (msg.length() > 0) {
                    sender.sendMessage(msg);
                }
            } else {
                String msg = lm2.getPath();
                if (msg.length() > 0) {
                    sender.sendMessage(lm2.getPath());
                }
            }
        }
    }

    public List<String> msgL(lm lm2) {
        return this.getLM().getMessageList(lm2);
    }

    public String msg(lm lm2, Object ... variables) {
        return this.getLM().getMessage(lm2, variables);
    }

    public InformationPager getInfoPageManager() {
        return this.InformationPagerManager;
    }

    public Map<UUID, String> getCachedPlayerNameUUIDs() {
        return this.cachedPlayerNameUUIDs;
    }

    public void addCachedPlayerNameUUIDs(UUID uuid, String name) {
        this.cachedPlayerNameUUIDs.put(uuid, name);
    }

    public void addCachedPlayerNameUUIDs(Map<UUID, String> cachedPlayerNameUUIDs2) {
        this.cachedPlayerNameUUIDs.putAll(cachedPlayerNameUUIDs2);
    }

    public WorldEditPlugin getWorldEdit() {
        return this.wep;
    }

    public WorldGuardPlugin getWorldGuard() {
        return this.wg;
    }

    public int getWepid() {
        return this.wepid;
    }

    public WorldGuardUtil getWorldGuardUtil() {
        if (this.worldGuardUtil == null) {
            this.worldGuardUtil = new WorldGuardUtil(this);
        }
        return this.worldGuardUtil;
    }

    public boolean hasPermission(CommandSender sender, String permision, boolean output) {
        return this.hasPermission(sender, permision, output, null);
    }

    public boolean hasPermission(CommandSender sender, String permision) {
        return this.hasPermission(sender, permision, true, null);
    }

    public boolean hasPermission(CommandSender sender, String permision, String message2) {
        return this.hasPermission(sender, permision, true, message2);
    }

    public boolean hasPermission(CommandSender sender, String permision, lm message2) {
        return this.hasPermission(sender, permision, true, this.getLM().getMessage(message2, new Object[0]));
    }

    public boolean hasPermission(CommandSender sender, String permision, Boolean output, String message2) {
        if (sender == null) {
            return false;
        }
        if (sender instanceof ConsoleCommandSender) {
            return true;
        }
        if (sender instanceof Player) {
            if (sender.hasPermission(permision)) {
                return true;
            }
            if (output.booleanValue()) {
                String outMsg = this.getLM().getMessage(lm.General_NoPermission, new Object[0]);
                if (message2 != null) {
                    outMsg = message2;
                }
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + sender.getName() + " {\"text\":\"\",\"extra\":[{\"text\":\"" + outMsg + "\",\"hoverEvent\":{\"action\":\"show_text\",\"value\":\"\u00a72" + permision + "\"}}]}"));
                ConsoleCommandSender console = Bukkit.getServer().getConsoleSender();
                console.sendMessage(ChatColor.RED + sender.getName() + " No permission -> " + permision);
            }
        }
        return false;
    }

    public static Residence getInstance() {
        return instance;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

