/**
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * Copyright 2011-2017 Peter Güttinger and contributors
 */
package ch.njol.skript.log;

import java.util.logging.Level;

/**
 * Counts logged messages of a certain type
 * 
 * @author Peter Güttinger
 */
public class CountingLogHandler extends LogHandler {
	
	private final int minimum;
	
	private int count;
	
	public CountingLogHandler(final Level minimum) {
		this.minimum = minimum.intValue();
	}
	
	@Override
	public LogResult log(final LogEntry entry) {
		if (entry.level.intValue() >= minimum)
			count++;
		return LogResult.LOG;
	}
	
	public int getCount() {
		return count;
	}
	
}
