/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import com.google.common.base.Charsets;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.OfflinePlayer;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

class UUIDFetcher {
    private static int PROFILES_PER_REQUEST = 100;
    private static final String PROFILE_URL = "https://api.mojang.com/profiles/minecraft";
    private final JSONParser jsonParser = new JSONParser();
    private final List<String> names;
    private final boolean rateLimiting;
    static HashMap<String, UUID> lookupCache;
    static HashMap<String, String> correctedNames;

    public UUIDFetcher(List<String> names, boolean rateLimiting) {
        this.names = names;
        this.rateLimiting = rateLimiting;
    }

    public UUIDFetcher(List<String> names) {
        this(names, true);
    }

    public void call() throws Exception {
        OfflinePlayer[] players;
        if (lookupCache == null) {
            lookupCache = new HashMap();
        }
        if (correctedNames == null) {
            correctedNames = new HashMap();
        }
        GriefPrevention.AddLogEntry("UUID conversion process started.  Please be patient - this may take a while.");
        GriefPrevention.AddLogEntry("Mining your local world data to save calls to Mojang...");
        OfflinePlayer[] offlinePlayerArray = players = GriefPrevention.instance.getServer().getOfflinePlayers();
        int n = players.length;
        int n2 = 0;
        while (n2 < n) {
            OfflinePlayer player = offlinePlayerArray[n2];
            if (player.getName() != null && player.getUniqueId() != null) {
                lookupCache.put(player.getName(), player.getUniqueId());
                lookupCache.put(player.getName().toLowerCase(), player.getUniqueId());
                correctedNames.put(player.getName().toLowerCase(), player.getName());
            }
            ++n2;
        }
        GriefPrevention.AddLogEntry("Checking local server data to get correct casing for player names...");
        int i = 0;
        while (i < this.names.size()) {
            String name = this.names.get(i);
            String correctCasingName = correctedNames.get(name);
            if (correctCasingName != null && !name.equals(correctCasingName)) {
                GriefPrevention.AddLogEntry(String.valueOf(name) + " --> " + correctCasingName);
                this.names.set(i, correctCasingName);
            }
            ++i;
        }
        GriefPrevention.AddLogEntry("Checking local server data for UUIDs already seen...");
        i = 0;
        while (i < this.names.size()) {
            String name = this.names.get(i);
            UUID uuid = lookupCache.get(name);
            if (uuid != null) {
                GriefPrevention.AddLogEntry(String.valueOf(name) + " --> " + uuid.toString());
                this.names.remove(i--);
            }
            ++i;
        }
        if (GriefPrevention.instance.getServer().getOnlineMode()) {
            GriefPrevention.AddLogEntry("Calling Mojang to get UUIDs for remaining unresolved players (this is the slowest step)...");
            i = 0;
            while (i * PROFILES_PER_REQUEST < this.names.size()) {
                boolean retry = false;
                JSONArray array = null;
                do {
                    HttpURLConnection connection = UUIDFetcher.createConnection();
                    String body = JSONArray.toJSONString(this.names.subList(i * PROFILES_PER_REQUEST, Math.min((i + 1) * PROFILES_PER_REQUEST, this.names.size())));
                    UUIDFetcher.writeBody(connection, body);
                    retry = false;
                    array = null;
                    try {
                        array = (JSONArray)this.jsonParser.parse((Reader)new InputStreamReader(connection.getInputStream()));
                    }
                    catch (Exception e) {
                        if (e.getMessage().contains("429")) {
                            retry = true;
                            if (i == 0 && PROFILES_PER_REQUEST > 1) {
                                GriefPrevention.AddLogEntry("Batch size " + PROFILES_PER_REQUEST + " seems too large.  Looking for a workable batch size...");
                                PROFILES_PER_REQUEST = Math.max(PROFILES_PER_REQUEST - 5, 1);
                                continue;
                            }
                            GriefPrevention.AddLogEntry("Mojang says we're sending requests too fast.  Will retry every 30 seconds until we succeed...");
                            Thread.sleep(30000L);
                            continue;
                        }
                        throw e;
                    }
                } while (retry);
                for (Object profile : array) {
                    JSONObject jsonProfile = (JSONObject)profile;
                    String id = (String)jsonProfile.get((Object)"id");
                    String name = (String)jsonProfile.get((Object)"name");
                    UUID uuid = UUIDFetcher.getUUID(id);
                    GriefPrevention.AddLogEntry(String.valueOf(name) + " --> " + uuid.toString());
                    lookupCache.put(name, uuid);
                    lookupCache.put(name.toLowerCase(), uuid);
                }
                if (this.rateLimiting) {
                    Thread.sleep(200L);
                }
                ++i;
            }
        } else {
            GriefPrevention.AddLogEntry("Generating offline mode UUIDs for remaining unresolved players...");
            i = 0;
            while (i < this.names.size()) {
                String name = this.names.get(i);
                UUID uuid = UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(Charsets.UTF_8));
                GriefPrevention.AddLogEntry(String.valueOf(name) + " --> " + uuid.toString());
                lookupCache.put(name, uuid);
                lookupCache.put(name.toLowerCase(), uuid);
                ++i;
            }
        }
    }

    private static void writeBody(HttpURLConnection connection, String body) throws Exception {
        OutputStream stream = connection.getOutputStream();
        stream.write(body.getBytes());
        stream.flush();
        stream.close();
    }

    private static HttpURLConnection createConnection() throws Exception {
        URL url = new URL(PROFILE_URL);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        return connection;
    }

    private static UUID getUUID(String id) {
        return UUID.fromString(String.valueOf(id.substring(0, 8)) + "-" + id.substring(8, 12) + "-" + id.substring(12, 16) + "-" + id.substring(16, 20) + "-" + id.substring(20, 32));
    }

    public static byte[] toBytes(UUID uuid) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
        byteBuffer.putLong(uuid.getMostSignificantBits());
        byteBuffer.putLong(uuid.getLeastSignificantBits());
        return byteBuffer.array();
    }

    public static UUID fromBytes(byte[] array) {
        if (array.length != 16) {
            throw new IllegalArgumentException("Illegal byte array length: " + array.length);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(array);
        long mostSignificant = byteBuffer.getLong();
        long leastSignificant = byteBuffer.getLong();
        return new UUID(mostSignificant, leastSignificant);
    }

    public static UUID getUUIDOf(String name) throws Exception {
        UUID result = lookupCache.get(name);
        if (result == null) {
            throw new IllegalArgumentException(name);
        }
        return result;
    }
}

