/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import me.ryanhamshire.GriefPrevention.BroadcastMessageTask;
import me.ryanhamshire.GriefPrevention.CheckForPortalTrapTask;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.ClaimsMode;
import me.ryanhamshire.GriefPrevention.CommandCategory;
import me.ryanhamshire.GriefPrevention.CreateClaimResult;
import me.ryanhamshire.GriefPrevention.CustomLogEntryTypes;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.EquipShovelProcessingTask;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.IgnoreLoaderThread;
import me.ryanhamshire.GriefPrevention.IpBanInfo;
import me.ryanhamshire.GriefPrevention.MaterialInfo;
import me.ryanhamshire.GriefPrevention.Messages;
import me.ryanhamshire.GriefPrevention.PlayerData;
import me.ryanhamshire.GriefPrevention.PlayerKickBanTask;
import me.ryanhamshire.GriefPrevention.ShovelMode;
import me.ryanhamshire.GriefPrevention.TextMode;
import me.ryanhamshire.GriefPrevention.Visualization;
import me.ryanhamshire.GriefPrevention.VisualizationType;
import me.ryanhamshire.GriefPrevention.WelcomeTask;
import me.ryanhamshire.GriefPrevention.WordFinder;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.TravelAgent;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.BlockIterator;

class PlayerEventHandler
implements Listener {
    private DataStore dataStore;
    private ArrayList<IpBanInfo> tempBannedIps = new ArrayList();
    private final long MILLISECONDS_IN_DAY = 86400000L;
    private ArrayList<Long> recentLoginLogoutNotifications = new ArrayList();
    private Pattern howToClaimPattern = null;
    private WordFinder bannedWordFinder;
    private String lastChatMessage;
    private long lastChatMessageTimestamp;
    private int duplicateMessageCount;
    private ConcurrentHashMap<String, CommandCategory> commandCategoryMap;
    static int longestNameLength = 10;
    private ConcurrentHashMap<UUID, Date> lastLoginThisServerSessionMap;
    private ConcurrentHashMap<String, Integer> ipCountHash;
    private HashMap<UUID, Long> deathTimestamps;
    private HashMap<UUID, Integer> heldLogoutMessages;
    static ConcurrentHashMap<UUID, Location> portalReturnMap = new ConcurrentHashMap();
    private HashSet<Material> commonAdjacentBlocks_water;
    private HashSet<Material> commonAdjacentBlocks_lava;
    private ConcurrentHashMap<Integer, Boolean> inventoryHolderCache;

    PlayerEventHandler(DataStore dataStore, GriefPrevention plugin) {
        this.bannedWordFinder = new WordFinder(GriefPrevention.instance.dataStore.loadBannedWords());
        this.lastChatMessage = "";
        this.lastChatMessageTimestamp = 0L;
        this.duplicateMessageCount = 0;
        this.commandCategoryMap = new ConcurrentHashMap();
        this.lastLoginThisServerSessionMap = new ConcurrentHashMap();
        this.ipCountHash = new ConcurrentHashMap();
        this.deathTimestamps = new HashMap();
        this.heldLogoutMessages = new HashMap();
        this.commonAdjacentBlocks_water = new HashSet<Material>(Arrays.asList(Material.WATER, Material.STATIONARY_WATER, Material.SOIL, Material.DIRT, Material.STONE));
        this.commonAdjacentBlocks_lava = new HashSet<Material>(Arrays.asList(Material.LAVA, Material.STATIONARY_LAVA, Material.DIRT, Material.STONE));
        this.inventoryHolderCache = new ConcurrentHashMap();
        this.dataStore = dataStore;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    synchronized void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (!player.isOnline()) {
            event.setCancelled(true);
            return;
        }
        String message = event.getMessage();
        boolean muted = this.handlePlayerChat(player, message, (PlayerEvent)event);
        Set recipients = event.getRecipients();
        if (muted) {
            recipients.clear();
            recipients.add(player);
        } else if (this.dataStore.isSoftMuted(player.getUniqueId())) {
            String notificationMessage = "(Muted " + player.getName() + "): " + message;
            HashSet<Player> recipientsToKeep = new HashSet<Player>();
            for (Player recipient : recipients) {
                if (this.dataStore.isSoftMuted(recipient.getUniqueId())) {
                    recipientsToKeep.add(recipient);
                    continue;
                }
                if (!recipient.hasPermission("griefprevention.eavesdrop")) continue;
                recipient.sendMessage(ChatColor.GRAY + notificationMessage);
            }
            recipients.clear();
            recipients.addAll(recipientsToKeep);
            GriefPrevention.AddLogEntry(notificationMessage, CustomLogEntryTypes.MutedChat, false);
        } else if (!player.hasPermission("griefprevention.spam") && this.bannedWordFinder.hasMatch(message)) {
            recipients.clear();
            recipients.add(player);
            if (!GriefPrevention.isNewToServer(player)) {
                PlayerData playerData = GriefPrevention.instance.dataStore.getPlayerData(player.getUniqueId());
                if (!playerData.profanityWarned) {
                    playerData.profanityWarned = true;
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.NoProfanity, new String[0]);
                    event.setCancelled(true);
                    return;
                }
            } else if (GriefPrevention.instance.config_trollFilterEnabled) {
                String notificationMessage = "(Auto-Muted " + player.getName() + "): " + message;
                GriefPrevention.AddLogEntry("Auto-muted new player " + player.getName() + " for profanity shortly after join.  Use /SoftMute to undo.", CustomLogEntryTypes.AdminActivity);
                GriefPrevention.AddLogEntry(notificationMessage, CustomLogEntryTypes.MutedChat, false);
                GriefPrevention.instance.dataStore.toggleSoftMute(player.getUniqueId());
            }
        } else {
            PlayerEventHandler.makeSocialLogEntry(player.getName(), message);
            if (!player.hasPermission("griefprevention.notignorable")) {
                HashSet<Player> recipientsToRemove = new HashSet<Player>();
                PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
                for (Player recipient : recipients) {
                    if (recipient.hasPermission("griefprevention.notignorable")) continue;
                    if (playerData.ignoredPlayers.containsKey(recipient.getUniqueId())) {
                        recipientsToRemove.add(recipient);
                        continue;
                    }
                    PlayerData targetPlayerData = this.dataStore.getPlayerData(recipient.getUniqueId());
                    if (!targetPlayerData.ignoredPlayers.containsKey(player.getUniqueId())) continue;
                    recipientsToRemove.add(recipient);
                }
                recipients.removeAll(recipientsToRemove);
            }
        }
    }

    private boolean handlePlayerChat(Player player, String message, PlayerEvent event) {
        if (this.howToClaimPattern == null) {
            this.howToClaimPattern = Pattern.compile(this.dataStore.getMessage(Messages.HowToClaimRegex, new String[0]), 2);
        }
        if (this.howToClaimPattern.matcher(message).matches()) {
            if (GriefPrevention.instance.creativeRulesApply(player.getLocation())) {
                GriefPrevention.sendMessage(player, TextMode.Info, Messages.CreativeBasicsVideo2, 10L, DataStore.CREATIVE_VIDEO_URL);
            } else {
                GriefPrevention.sendMessage(player, TextMode.Info, Messages.SurvivalBasicsVideo2, 10L, DataStore.SURVIVAL_VIDEO_URL);
            }
        }
        if (!message.contains("/trapped") && (message.contains("trapped") || message.contains("stuck") || message.contains(this.dataStore.getMessage(Messages.TrappedChatKeyword, new String[0])))) {
            GriefPrevention.sendMessage(player, TextMode.Info, Messages.TrappedInstructions, 10L, new String[0]);
        }
        if (!GriefPrevention.instance.config_spam_enabled) {
            return false;
        }
        if (player.hasPermission("griefprevention.spam")) {
            return false;
        }
        boolean spam = false;
        String mutedReason = null;
        PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
        if (playerData.noChatLocation != null) {
            Location currentLocation = player.getLocation();
            if (currentLocation.getBlockX() == playerData.noChatLocation.getBlockX() && currentLocation.getBlockZ() == playerData.noChatLocation.getBlockZ()) {
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.NoChatUntilMove, 10L, new String[0]);
                spam = true;
                mutedReason = "pre-movement chat";
            } else {
                playerData.noChatLocation = null;
            }
        }
        if (message.length() > 4 && this.stringsAreSimilar(message.toUpperCase(), message) && event instanceof AsyncPlayerChatEvent) {
            ((AsyncPlayerChatEvent)event).setMessage(message.toLowerCase());
        }
        long now = new Date().getTime();
        if (mutedReason != null && message.equals(this.lastChatMessage) && now - this.lastChatMessageTimestamp < 750L) {
            playerData.spamCount += ++this.duplicateMessageCount;
            spam = true;
            mutedReason = "repeat message";
        } else {
            this.lastChatMessage = message;
            this.lastChatMessageTimestamp = now;
            this.duplicateMessageCount = 0;
        }
        message = message.toLowerCase();
        long millisecondsSinceLastMessage = now - playerData.lastMessageTimestamp.getTime();
        if (millisecondsSinceLastMessage < 1500L) {
            ++playerData.spamCount;
            spam = true;
        }
        if (mutedReason == null && this.stringsAreSimilar(message, playerData.lastMessage) && now - playerData.lastMessageTimestamp.getTime() < 10000L) {
            ++playerData.spamCount;
            spam = true;
            mutedReason = "similar message";
        }
        if (mutedReason == null && GriefPrevention.instance.containsBlockedIP(message)) {
            ++playerData.spamCount;
            spam = true;
            mutedReason = "IP address";
        }
        if (mutedReason == null && message.length() > 5) {
            int symbolsCount = 0;
            int whitespaceCount = 0;
            int i = 0;
            while (i < message.length()) {
                char character = message.charAt(i);
                if (!Character.isLetterOrDigit(character)) {
                    ++symbolsCount;
                }
                if (Character.isWhitespace(character)) {
                    ++whitespaceCount;
                }
                ++i;
            }
            if (symbolsCount > message.length() / 2 || message.length() > 15 && whitespaceCount < message.length() / 10) {
                spam = true;
                if (playerData.spamCount > 0) {
                    mutedReason = "gibberish";
                }
                ++playerData.spamCount;
            }
        }
        if (mutedReason == null && message.length() < 5 && millisecondsSinceLastMessage < 3000L) {
            spam = true;
            ++playerData.spamCount;
        }
        playerData.lastMessageTimestamp = new Date();
        playerData.lastMessage = message;
        if (spam) {
            if (playerData.spamCount > 8 && playerData.spamWarned) {
                if (GriefPrevention.instance.config_spam_banOffenders) {
                    GriefPrevention.AddLogEntry("Banning " + player.getName() + " for spam.", CustomLogEntryTypes.AdminActivity);
                    PlayerKickBanTask task = new PlayerKickBanTask(player, GriefPrevention.instance.config_spam_banMessage, "GriefPrevention Anti-Spam", true);
                    GriefPrevention.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)GriefPrevention.instance, (Runnable)task, 1L);
                } else {
                    GriefPrevention.AddLogEntry("Kicking " + player.getName() + " for spam.", CustomLogEntryTypes.AdminActivity);
                    PlayerKickBanTask task = new PlayerKickBanTask(player, "", "GriefPrevention Anti-Spam", false);
                    GriefPrevention.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)GriefPrevention.instance, (Runnable)task, 1L);
                }
                return true;
            }
            if (playerData.spamCount >= 4) {
                if (mutedReason == null) {
                    mutedReason = "too-frequent text";
                }
                if (!playerData.spamWarned) {
                    GriefPrevention.sendMessage(player, TextMode.Warn, GriefPrevention.instance.config_spam_warningMessage, 10L);
                    GriefPrevention.AddLogEntry("Warned " + player.getName() + " about spam penalties.", CustomLogEntryTypes.Debug, true);
                    playerData.spamWarned = true;
                }
            }
            if (mutedReason != null) {
                GriefPrevention.AddLogEntry("Muted " + mutedReason + ".");
                GriefPrevention.AddLogEntry("Muted " + player.getName() + " " + mutedReason + ":" + message, CustomLogEntryTypes.Debug, true);
                return true;
            }
        } else {
            playerData.spamCount = 0;
            playerData.spamWarned = false;
        }
        return false;
    }

    private boolean stringsAreSimilar(String message, String lastMessage) {
        String longerString;
        String shorterString;
        if (lastMessage.length() < message.length()) {
            shorterString = lastMessage;
            longerString = message;
        } else {
            shorterString = message;
            longerString = lastMessage;
        }
        if (shorterString.length() <= 5) {
            return shorterString.equals(longerString);
        }
        int maxIdenticalCharacters = longerString.length() - longerString.length() / 4;
        if (shorterString.length() < maxIdenticalCharacters) {
            return false;
        }
        int identicalCount = 0;
        int i = 0;
        while (i < shorterString.length()) {
            if (shorterString.charAt(i) == longerString.charAt(i)) {
                ++identicalCount;
            }
            if (identicalCount > maxIdenticalCharacters) {
                return true;
            }
            ++i;
        }
        int j = 0;
        while (j < shorterString.length() - i) {
            if (shorterString.charAt(shorterString.length() - j - 1) == longerString.charAt(longerString.length() - j - 1)) {
                ++identicalCount;
            }
            if (identicalCount > maxIdenticalCharacters) {
                return true;
            }
            ++j;
        }
        return false;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    synchronized void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        Claim claim;
        boolean isMonitoredCommand;
        Object object;
        String message = event.getMessage();
        String[] args = message.split(" ");
        String command = args[0].toLowerCase();
        CommandCategory category = this.getCommandCategory(command);
        Player player = event.getPlayer();
        PlayerData playerData = null;
        if (category == CommandCategory.Whisper && args.length > 1) {
            Player targetPlayer = GriefPrevention.instance.getServer().getPlayer(args[1]);
            if (this.dataStore.isSoftMuted(player.getUniqueId()) && targetPlayer != null && !this.dataStore.isSoftMuted(targetPlayer.getUniqueId())) {
                event.setCancelled(true);
                return;
            }
            if (!(!GriefPrevention.instance.config_whisperNotifications || player.hasPermission("griefprevention.eavesdropimmune") || targetPlayer != null && targetPlayer.hasPermission("griefprevention.eavesdropimmune"))) {
                StringBuilder logMessageBuilder = new StringBuilder();
                logMessageBuilder.append("[[").append(event.getPlayer().getName()).append("]] ");
                int i = 1;
                while (i < args.length) {
                    logMessageBuilder.append(args[i]).append(" ");
                    ++i;
                }
                String logMessage = logMessageBuilder.toString();
                Collection players = GriefPrevention.instance.getServer().getOnlinePlayers();
                object = players.iterator();
                while (object.hasNext()) {
                    Player onlinePlayer = (Player)object.next();
                    if (!onlinePlayer.hasPermission("griefprevention.eavesdrop") || onlinePlayer.equals(targetPlayer) || onlinePlayer.equals(player)) continue;
                    onlinePlayer.sendMessage(ChatColor.GRAY + logMessage);
                }
            }
            if (targetPlayer != null && targetPlayer.isOnline()) {
                playerData = this.dataStore.getPlayerData(player.getUniqueId());
                if (playerData.ignoredPlayers.containsKey(targetPlayer.getUniqueId()) && !targetPlayer.hasPermission("griefprevention.notignorable")) {
                    event.setCancelled(true);
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.IsIgnoringYou, new String[0]);
                    return;
                }
                PlayerData targetPlayerData = this.dataStore.getPlayerData(targetPlayer.getUniqueId());
                if (targetPlayerData.ignoredPlayers.containsKey(player.getUniqueId())) {
                    event.setCancelled(true);
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.IsIgnoringYou, new String[0]);
                    return;
                }
            }
        }
        if (playerData == null) {
            playerData = this.dataStore.getPlayerData(event.getPlayer().getUniqueId());
        }
        if ((playerData.inPvpCombat() || playerData.siegeData != null) && GriefPrevention.instance.config_pvp_blockedCommands.contains(command)) {
            event.setCancelled(true);
            GriefPrevention.sendMessage(event.getPlayer(), TextMode.Err, Messages.CommandBannedInPvP, new String[0]);
            return;
        }
        if (category == CommandCategory.Chat && this.dataStore.isSoftMuted(player.getUniqueId())) {
            event.setCancelled(true);
            return;
        }
        boolean bl = isMonitoredCommand = category == CommandCategory.Chat || category == CommandCategory.Whisper;
        if (isMonitoredCommand) {
            if (GriefPrevention.instance.config_spam_enabled) {
                event.setCancelled(this.handlePlayerChat(event.getPlayer(), event.getMessage(), (PlayerEvent)event));
            }
            if (!player.hasPermission("griefprevention.spam") && this.bannedWordFinder.hasMatch(message)) {
                event.setCancelled(true);
            }
            if (!event.isCancelled()) {
                StringBuilder builder = new StringBuilder();
                object = args;
                int n = args.length;
                int players = 0;
                while (players < n) {
                    String arg = object[players];
                    builder.append(String.valueOf(arg) + " ");
                    ++players;
                }
                PlayerEventHandler.makeSocialLogEntry(event.getPlayer().getName(), builder.toString());
            }
        }
        isMonitoredCommand = false;
        String lowerCaseMessage = message.toLowerCase();
        for (String monitoredCommand : GriefPrevention.instance.config_claims_commandsRequiringAccessTrust) {
            if (!lowerCaseMessage.startsWith(monitoredCommand)) continue;
            isMonitoredCommand = true;
            break;
        }
        if (isMonitoredCommand && (claim = this.dataStore.getClaimAt(player.getLocation(), false, playerData.lastClaim)) != null) {
            playerData.lastClaim = claim;
            String reason = claim.allowAccess(player);
            if (reason != null) {
                GriefPrevention.sendMessage(player, TextMode.Err, reason);
                event.setCancelled(true);
            }
        }
    }

    private CommandCategory getCommandCategory(String commandName) {
        CommandCategory category;
        if (commandName.startsWith("/")) {
            commandName = commandName.substring(1);
        }
        if ((category = this.commandCategoryMap.get(commandName)) != null) {
            return category;
        }
        HashSet<String> aliases = new HashSet<String>();
        aliases.add(commandName);
        aliases.add("minecraft:" + commandName);
        Plugin[] pluginArray = Bukkit.getServer().getPluginManager().getPlugins();
        int n = pluginArray.length;
        int n2 = 0;
        while (n2 < n) {
            Plugin plugin = pluginArray[n2];
            JavaPlugin javaPlugin = (JavaPlugin)plugin;
            PluginCommand command = javaPlugin.getCommand(commandName);
            if (command != null) {
                aliases.add(command.getName().toLowerCase());
                aliases.add(String.valueOf(plugin.getName().toLowerCase()) + ":" + command.getName().toLowerCase());
                for (String alias : command.getAliases()) {
                    aliases.add(alias.toLowerCase());
                    aliases.add(String.valueOf(plugin.getName().toLowerCase()) + ":" + alias.toLowerCase());
                }
            }
            ++n2;
        }
        PluginCommand command = Bukkit.getServer().getPluginCommand(commandName);
        if (command != null) {
            aliases.add(command.getName().toLowerCase());
            aliases.add("minecraft:" + command.getName().toLowerCase());
            for (String alias : command.getAliases()) {
                aliases.add(alias.toLowerCase());
                aliases.add("minecraft:" + alias.toLowerCase());
            }
        }
        category = CommandCategory.None;
        for (String alias : aliases) {
            if (GriefPrevention.instance.config_eavesdrop_whisperCommands.contains("/" + alias)) {
                category = CommandCategory.Whisper;
            } else if (GriefPrevention.instance.config_spam_monitorSlashCommands.contains("/" + alias)) {
                category = CommandCategory.Chat;
            }
            this.commandCategoryMap.put(alias.toLowerCase(), category);
        }
        return category;
    }

    static void makeSocialLogEntry(String name, String message) {
        StringBuilder entryBuilder = new StringBuilder(name);
        int i = name.length();
        while (i < longestNameLength) {
            entryBuilder.append(' ');
            ++i;
        }
        entryBuilder.append(": " + message);
        longestNameLength = Math.max(longestNameLength, name.length());
        GriefPrevention.AddLogEntry(entryBuilder.toString(), CustomLogEntryTypes.SocialActivity, true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    void onPlayerLogin(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        if (GriefPrevention.instance.config_spam_enabled) {
            long millisecondsSinceLastLogin;
            long secondsSinceLastLogin;
            long cooldownRemaining;
            Date lastLoginThisSession;
            long now = Calendar.getInstance().getTimeInMillis();
            if (GriefPrevention.instance.config_spam_loginCooldownSeconds > 0 && event.getResult() == PlayerLoginEvent.Result.ALLOWED && !player.hasPermission("griefprevention.spam") && (lastLoginThisSession = this.lastLoginThisServerSessionMap.get(player.getUniqueId())) != null && (cooldownRemaining = (long)GriefPrevention.instance.config_spam_loginCooldownSeconds - (secondsSinceLastLogin = (millisecondsSinceLastLogin = now - lastLoginThisSession.getTime()) / 1000L)) > 0L) {
                event.setResult(PlayerLoginEvent.Result.KICK_OTHER);
                event.setKickMessage("You must wait " + cooldownRemaining + " seconds before logging-in again.");
                event.disallow(event.getResult(), event.getKickMessage());
                return;
            }
            if (GriefPrevention.instance.config_smartBan && event.getResult() == PlayerLoginEvent.Result.KICK_BANNED) {
                this.tempBannedIps.add(new IpBanInfo(event.getAddress(), now + 86400000L, player.getName()));
            }
        }
        PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
        playerData.ipAddress = event.getAddress();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    void onPlayerJoin(PlayerJoinEvent event) {
        Integer taskID;
        String joinMessage;
        Player player = event.getPlayer();
        UUID playerID = player.getUniqueId();
        Date nowDate = new Date();
        long now = nowDate.getTime();
        PlayerData playerData = this.dataStore.getPlayerData(playerID);
        playerData.lastSpawn = now;
        playerData.setLastLogin(nowDate);
        this.lastLoginThisServerSessionMap.put(playerID, nowDate);
        if (GriefPrevention.isNewToServer(player)) {
            playerData.noChatLocation = player.getLocation();
        }
        if (!player.hasPlayedBefore()) {
            GriefPrevention.instance.checkPvpProtectionNeeded(player);
            if (GriefPrevention.instance.config_claims_worldModes.get(player.getWorld()) == ClaimsMode.Survival && !player.hasPermission("griefprevention.adminclaims") && this.dataStore.claims.size() > 10) {
                WelcomeTask task = new WelcomeTask(player);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)GriefPrevention.instance, (Runnable)task, (long)GriefPrevention.instance.config_claims_manualDeliveryDelaySeconds * 20L);
            }
        }
        if (event.getJoinMessage() != null && this.shouldSilenceNotification()) {
            event.setJoinMessage(null);
        }
        if (GriefPrevention.instance.config_smartBan && !player.hasPlayedBefore()) {
            int i = 0;
            while (i < this.tempBannedIps.size()) {
                IpBanInfo info = this.tempBannedIps.get(i);
                String address = info.address.toString();
                if (now > info.expirationTimestamp) {
                    this.tempBannedIps.remove(i--);
                } else if (address.equals(playerData.ipAddress.toString())) {
                    OfflinePlayer bannedPlayer = GriefPrevention.instance.getServer().getOfflinePlayer(info.bannedAccountName);
                    if (!bannedPlayer.isBanned()) {
                        int j = 0;
                        while (j < this.tempBannedIps.size()) {
                            IpBanInfo info2 = this.tempBannedIps.get(j);
                            if (info2.address.toString().equals(address)) {
                                OfflinePlayer bannedAccount = GriefPrevention.instance.getServer().getOfflinePlayer(info2.bannedAccountName);
                                bannedAccount.setBanned(false);
                                this.tempBannedIps.remove(j--);
                            }
                            ++j;
                        }
                        break;
                    }
                    GriefPrevention.AddLogEntry("Auto-banned new player " + player.getName() + " because that account is using an IP address very recently used by banned player " + info.bannedAccountName + " (" + info.address.toString() + ").", CustomLogEntryTypes.AdminActivity);
                    Collection players = GriefPrevention.instance.getServer().getOnlinePlayers();
                    for (Player otherPlayer : players) {
                        if (!otherPlayer.isOp()) continue;
                        GriefPrevention.sendMessage(otherPlayer, TextMode.Success, Messages.AutoBanNotify, player.getName(), info.bannedAccountName);
                    }
                    PlayerKickBanTask task = new PlayerKickBanTask(player, "", "GriefPrevention Smart Ban - Shared Login:" + info.bannedAccountName, true);
                    GriefPrevention.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)GriefPrevention.instance, (Runnable)task, 10L);
                    event.setJoinMessage("");
                    break;
                }
                ++i;
            }
        }
        GriefPrevention.cacheUUIDNamePair(player.getUniqueId(), player.getName());
        InetAddress ipAddress = playerData.ipAddress;
        if (ipAddress != null) {
            String ipAddressString = ipAddress.toString();
            int ipLimit = GriefPrevention.instance.config_ipLimit;
            if (ipLimit > 0 && GriefPrevention.isNewToServer(player)) {
                Integer ipCount = this.ipCountHash.get(ipAddressString);
                if (ipCount == null) {
                    ipCount = 0;
                }
                if (ipCount >= ipLimit) {
                    PlayerKickBanTask task = new PlayerKickBanTask(player, "Sorry, there are too many players logged in with your IP address.", "GriefPrevention IP-sharing limit.", false);
                    GriefPrevention.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)GriefPrevention.instance, (Runnable)task, 10L);
                    event.setJoinMessage(null);
                    return;
                }
                this.ipCountHash.put(ipAddressString, ipCount + 1);
                playerData.ipLimited = true;
            }
        }
        new IgnoreLoaderThread(playerID, playerData.ignoredPlayers).start();
        Location returnLocation = portalReturnMap.get(player.getUniqueId());
        if (returnLocation != null) {
            portalReturnMap.remove(player.getUniqueId());
            if (player.getLocation().getBlock().getType() == Material.PORTAL) {
                player.teleport(returnLocation);
            }
        }
        if (GriefPrevention.instance.config_spam_logoutMessageDelaySeconds > 0 && (joinMessage = event.getJoinMessage()) != null && !joinMessage.isEmpty() && (taskID = this.heldLogoutMessages.get(player.getUniqueId())) != null && Bukkit.getScheduler().isQueued(taskID.intValue())) {
            Bukkit.getScheduler().cancelTask(taskID.intValue());
            player.sendMessage(event.getJoinMessage());
            event.setJoinMessage("");
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        PlayerData playerData = GriefPrevention.instance.dataStore.getPlayerData(player.getUniqueId());
        playerData.lastSpawn = Calendar.getInstance().getTimeInMillis();
        playerData.lastPvpTimestamp = 0L;
        if (playerData.messageOnRespawn != null) {
            GriefPrevention.sendMessage(player, ChatColor.RESET, playerData.messageOnRespawn, 40L);
            playerData.messageOnRespawn = null;
        }
        GriefPrevention.instance.checkPvpProtectionNeeded(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        Long lastDeathTime = this.deathTimestamps.get(player.getUniqueId());
        long now = Calendar.getInstance().getTimeInMillis();
        if (lastDeathTime != null && now - lastDeathTime < (long)(GriefPrevention.instance.config_spam_deathMessageCooldownSeconds * 1000)) {
            player.sendMessage(event.getDeathMessage());
            event.setDeathMessage("");
        }
        this.deathTimestamps.put(player.getUniqueId(), now);
        PlayerData playerData = GriefPrevention.instance.dataStore.getPlayerData(player.getUniqueId());
        playerData.dropsAreUnlocked = false;
        playerData.receivedDropUnlockAdvertisement = false;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    void onPlayerKicked(PlayerKickEvent event) {
        Player player = event.getPlayer();
        PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
        playerData.wasKicked = true;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    void onPlayerQuit(PlayerQuitEvent event) {
        String quitMessage;
        InetAddress ipAddress;
        Player player = event.getPlayer();
        UUID playerID = player.getUniqueId();
        PlayerData playerData = this.dataStore.getPlayerData(playerID);
        boolean isBanned = playerData.wasKicked ? player.isBanned() : false;
        if (isBanned && playerData.ipAddress != null) {
            long now = Calendar.getInstance().getTimeInMillis();
            this.tempBannedIps.add(new IpBanInfo(playerData.ipAddress, now + 86400000L, player.getName()));
        }
        if (event.getQuitMessage() != null && this.shouldSilenceNotification()) {
            event.setQuitMessage(null);
        }
        if (isBanned) {
            event.setQuitMessage(null);
        } else {
            this.dataStore.savePlayerData(player.getUniqueId(), playerData);
        }
        if (GriefPrevention.instance.config_pvp_punishLogout && playerData.inPvpCombat()) {
            player.setHealth(0.0);
        }
        if (playerData.siegeData != null && player.getHealth() > 0.0) {
            player.setHealth(0.0);
        }
        if (GriefPrevention.instance.config_ipLimit > 0 && playerData.ipLimited && (ipAddress = playerData.ipAddress) != null) {
            String ipAddressString = ipAddress.toString();
            Integer count = this.ipCountHash.get(ipAddressString);
            if (count == null) {
                count = 1;
            }
            this.ipCountHash.put(ipAddressString, count - 1);
        }
        this.dataStore.clearCachedPlayerData(playerID);
        if (GriefPrevention.instance.config_spam_logoutMessageDelaySeconds > 0 && (quitMessage = event.getQuitMessage()) != null && !quitMessage.isEmpty()) {
            BroadcastMessageTask task = new BroadcastMessageTask(quitMessage);
            int taskID = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)GriefPrevention.instance, (Runnable)task, 20L * (long)GriefPrevention.instance.config_spam_logoutMessageDelaySeconds);
            this.heldLogoutMessages.put(playerID, taskID);
            event.setQuitMessage("");
        }
    }

    private boolean shouldSilenceNotification() {
        long ONE_MINUTE = 60000L;
        int MAX_ALLOWED = 5;
        Long now = Calendar.getInstance().getTimeInMillis();
        int i = 0;
        while (i < this.recentLoginLogoutNotifications.size()) {
            Long notificationTimestamp = this.recentLoginLogoutNotifications.get(i);
            if (now - notificationTimestamp <= 60000L) break;
            this.recentLoginLogoutNotifications.remove(i--);
            ++i;
        }
        this.recentLoginLogoutNotifications.add(now);
        return this.recentLoginLogoutNotifications.size() > 5;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        if (GriefPrevention.instance.creativeRulesApply(player.getLocation())) {
            event.setCancelled(true);
            return;
        }
        PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
        if (!GriefPrevention.instance.config_pvp_allowCombatItemDrop && playerData.inPvpCombat()) {
            GriefPrevention.sendMessage(player, TextMode.Err, Messages.PvPNoDrop, new String[0]);
            event.setCancelled(true);
        } else if (playerData.siegeData != null) {
            GriefPrevention.sendMessage(player, TextMode.Err, Messages.SiegeNoDrop, new String[0]);
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    void onPlayerPortal(PlayerPortalEvent event) {
        if (event.getTo() == null || event.getTo().getWorld() == null) {
            return;
        }
        if (!GriefPrevention.instance.claimsEnabledForWorld(event.getTo().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.NETHER_PORTAL) {
            CheckForPortalTrapTask task = new CheckForPortalTrapTask(player, event.getFrom());
            GriefPrevention.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)GriefPrevention.instance, (Runnable)task, 600L);
            portalReturnMap.put(player.getUniqueId(), event.getFrom());
            if (GriefPrevention.instance.config_claims_portalsRequirePermission) {
                Claim claim;
                Location destination = event.getTo();
                if (event.useTravelAgent()) {
                    if (event.getPortalTravelAgent().getCanCreatePortal()) {
                        TravelAgent agent = event.getPortalTravelAgent();
                        agent.setCanCreatePortal(false);
                        destination = agent.findOrCreate(destination);
                        agent.setCanCreatePortal(true);
                    } else {
                        return;
                    }
                }
                if (destination.getBlock().getType() != Material.PORTAL && (claim = this.dataStore.getClaimAt(destination, false, null)) != null && claim.allowBuild(player, Material.PORTAL) != null) {
                    event.setCancelled(true);
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.NoBuildPortalPermission, claim.getOwnerName());
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Claim toClaim;
        Player player = event.getPlayer();
        PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
        PlayerTeleportEvent.TeleportCause cause = event.getCause();
        if ((cause == PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT || cause == PlayerTeleportEvent.TeleportCause.ENDER_PEARL && GriefPrevention.instance.config_claims_enderPearlsRequireAccessTrust) && (toClaim = this.dataStore.getClaimAt(event.getTo(), false, playerData.lastClaim)) != null) {
            playerData.lastClaim = toClaim;
            String noAccessReason = toClaim.allowAccess(player);
            if (noAccessReason != null) {
                GriefPrevention.sendMessage(player, TextMode.Err, noAccessReason);
                event.setCancelled(true);
                if (cause == PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
                    player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.ENDER_PEARL)});
                }
            }
        }
        if (!GriefPrevention.instance.config_siege_enabledWorlds.contains(player.getWorld())) {
            return;
        }
        Location source = event.getFrom();
        Claim sourceClaim = this.dataStore.getClaimAt(source, false, playerData.lastClaim);
        if (sourceClaim != null && sourceClaim.siegeData != null) {
            GriefPrevention.sendMessage(player, TextMode.Err, Messages.SiegeNoTeleport, new String[0]);
            event.setCancelled(true);
            return;
        }
        Location destination = event.getTo();
        Claim destinationClaim = this.dataStore.getClaimAt(destination, false, null);
        if (destinationClaim != null && destinationClaim.siegeData != null) {
            GriefPrevention.sendMessage(player, TextMode.Err, Messages.BesiegedNoTeleport, new String[0]);
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent event) {
        if (event.getRightClicked().getType() == EntityType.ARMOR_STAND) {
            this.onPlayerInteractEntity((PlayerInteractEntityEvent)event);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        String failureReason;
        String noContainersReason;
        Claim claim;
        String noBuildReason;
        Player player = event.getPlayer();
        Entity entity = event.getRightClicked();
        if (!GriefPrevention.instance.claimsEnabledForWorld(entity.getWorld())) {
            return;
        }
        if (!GriefPrevention.instance.config_claims_protectHorses && entity instanceof Horse) {
            return;
        }
        PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
        if (entity instanceof Tameable) {
            Tameable tameable = (Tameable)entity;
            if (tameable.isTamed()) {
                if (tameable.getOwner() != null) {
                    UUID ownerID = tameable.getOwner().getUniqueId();
                    if (player.getUniqueId().equals(ownerID) || playerData.ignoreClaims) {
                        if (playerData.petGiveawayRecipient != null) {
                            tameable.setOwner((AnimalTamer)playerData.petGiveawayRecipient);
                            playerData.petGiveawayRecipient = null;
                            GriefPrevention.sendMessage(player, TextMode.Success, Messages.PetGiveawayConfirmation, new String[0]);
                            event.setCancelled(true);
                        }
                        return;
                    }
                    if (!GriefPrevention.instance.pvpRulesApply(entity.getLocation().getWorld()) || GriefPrevention.instance.config_pvp_protectPets) {
                        OfflinePlayer owner = GriefPrevention.instance.getServer().getOfflinePlayer(ownerID);
                        String ownerName = owner.getName();
                        if (ownerName == null) {
                            ownerName = "someone";
                        }
                        String message = GriefPrevention.instance.dataStore.getMessage(Messages.NotYourPet, ownerName);
                        if (player.hasPermission("griefprevention.ignoreclaims")) {
                            message = String.valueOf(message) + "  " + GriefPrevention.instance.dataStore.getMessage(Messages.IgnoreClaimsAdvertisement, new String[0]);
                        }
                        GriefPrevention.sendMessage(player, TextMode.Err, message);
                        event.setCancelled(true);
                        return;
                    }
                }
            } else {
                tameable.setOwner(null);
                if (tameable instanceof InventoryHolder) {
                    InventoryHolder holder = (InventoryHolder)tameable;
                    holder.getInventory().clear();
                }
            }
        }
        if ((entity.getType() == EntityType.ARMOR_STAND || entity instanceof Hanging) && (noBuildReason = GriefPrevention.instance.allowBuild(player, entity.getLocation(), Material.ITEM_FRAME)) != null) {
            GriefPrevention.sendMessage(player, TextMode.Err, noBuildReason);
            event.setCancelled(true);
            return;
        }
        if (entity.getType() == EntityType.ARMOR_STAND && GriefPrevention.instance.creativeRulesApply(player.getLocation())) {
            if (playerData == null) {
                playerData = this.dataStore.getPlayerData(player.getUniqueId());
            }
            if ((claim = this.dataStore.getClaimAt(entity.getLocation(), false, playerData.lastClaim)) == null) {
                return;
            }
            String noEntitiesReason = claim.allowMoreEntities(false);
            if (noEntitiesReason != null) {
                GriefPrevention.sendMessage(player, TextMode.Err, noEntitiesReason);
                event.setCancelled(true);
                return;
            }
        }
        if (playerData.ignoreClaims) {
            return;
        }
        if (entity instanceof StorageMinecart || entity instanceof PoweredMinecart) {
            if (playerData.siegeData != null) {
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.SiegeNoContainers, new String[0]);
                event.setCancelled(true);
                return;
            }
            if (playerData.inPvpCombat()) {
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.PvPNoContainers, new String[0]);
                event.setCancelled(true);
                return;
            }
        }
        if (GriefPrevention.instance.config_claims_preventTheft && entity instanceof Vehicle && (claim = this.dataStore.getClaimAt(entity.getLocation(), false, null)) != null && entity instanceof InventoryHolder && (noContainersReason = claim.allowContainers(player)) != null) {
            GriefPrevention.sendMessage(player, TextMode.Err, noContainersReason);
            event.setCancelled(true);
            return;
        }
        if ((GriefPrevention.instance.config_claims_preventTheft && entity instanceof Animals || entity.getType() == EntityType.VILLAGER && GriefPrevention.instance.config_claims_villagerTradingRequiresTrust) && (claim = this.dataStore.getClaimAt(entity.getLocation(), false, null)) != null && claim.allowContainers(player) != null) {
            String message = GriefPrevention.instance.dataStore.getMessage(Messages.NoDamageClaimedEntity, claim.getOwnerName());
            if (player.hasPermission("griefprevention.ignoreclaims")) {
                message = String.valueOf(message) + "  " + GriefPrevention.instance.dataStore.getMessage(Messages.IgnoreClaimsAdvertisement, new String[0]);
            }
            GriefPrevention.sendMessage(player, TextMode.Err, message);
            event.setCancelled(true);
            return;
        }
        if (GriefPrevention.instance.config_claims_preventTheft && entity instanceof Creature && GriefPrevention.instance.getItemInHand(player, event.getHand()).getType() == Material.LEASH && (claim = this.dataStore.getClaimAt(entity.getLocation(), false, playerData.lastClaim)) != null && (failureReason = claim.allowContainers(player)) != null) {
            event.setCancelled(true);
            GriefPrevention.sendMessage(player, TextMode.Err, failureReason);
            return;
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerFish(PlayerFishEvent event) {
        Entity entity = event.getCaught();
        if (entity == null) {
            return;
        }
        if (entity.getType() == EntityType.ARMOR_STAND || entity instanceof Animals) {
            String errorMessage;
            Player player = event.getPlayer();
            PlayerData playerData = GriefPrevention.instance.dataStore.getPlayerData(player.getUniqueId());
            Claim claim = GriefPrevention.instance.dataStore.getClaimAt(entity.getLocation(), false, playerData.lastClaim);
            if (claim != null && (errorMessage = claim.allowContainers(player)) != null) {
                event.setCancelled(true);
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.NoDamageClaimedEntity, claim.getOwnerName());
                return;
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        Player player = event.getPlayer();
        Item item = event.getItem();
        List data = item.getMetadata("GP_ITEMOWNER");
        if (data != null && data.size() > 0) {
            UUID ownerID = (UUID)((MetadataValue)data.get(0)).value();
            OfflinePlayer owner = GriefPrevention.instance.getServer().getOfflinePlayer(ownerID);
            String ownerName = GriefPrevention.lookupPlayerName(ownerID);
            if (owner.isOnline() && !player.equals(owner)) {
                PlayerData playerData = this.dataStore.getPlayerData(ownerID);
                if (!playerData.dropsAreUnlocked) {
                    event.setCancelled(true);
                    if (!playerData.receivedDropUnlockAdvertisement) {
                        GriefPrevention.sendMessage(owner.getPlayer(), TextMode.Instr, Messages.DropUnlockAdvertisement, new String[0]);
                        GriefPrevention.sendMessage(player, TextMode.Err, Messages.PickupBlockedExplanation, ownerName);
                        playerData.receivedDropUnlockAdvertisement = true;
                    }
                    return;
                }
            }
        }
        if (!GriefPrevention.instance.pvpRulesApply(player.getWorld())) {
            return;
        }
        if (GriefPrevention.instance.config_pvp_protectFreshSpawns && GriefPrevention.instance.getItemInHand(player, EquipmentSlot.HAND).getType() == Material.AIR) {
            PlayerData playerData = this.dataStore.getPlayerData(event.getPlayer().getUniqueId());
            if (playerData.pvpImmune) {
                long now = Calendar.getInstance().getTimeInMillis();
                long elapsedSinceLastSpawn = now - playerData.lastSpawn;
                if (elapsedSinceLastSpawn < 10000L) {
                    event.setCancelled(true);
                    return;
                }
                playerData.pvpImmune = false;
                GriefPrevention.sendMessage(player, TextMode.Warn, Messages.PvPImmunityEnd, new String[0]);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemHeldChange(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        int newSlot = event.getNewSlot();
        ItemStack newItemStack = player.getInventory().getItem(newSlot);
        if (newItemStack != null && newItemStack.getType() == GriefPrevention.instance.config_claims_modificationTool && GriefPrevention.instance.claimsEnabledForWorld(player.getWorld())) {
            EquipShovelProcessingTask task = new EquipShovelProcessingTask(player);
            GriefPrevention.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)GriefPrevention.instance, (Runnable)task, 15L);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent bucketEvent) {
        if (!GriefPrevention.instance.claimsEnabledForWorld(bucketEvent.getBlockClicked().getWorld())) {
            return;
        }
        Player player = bucketEvent.getPlayer();
        Block block = bucketEvent.getBlockClicked().getRelative(bucketEvent.getBlockFace());
        int minLavaDistance = 10;
        String noBuildReason = GriefPrevention.instance.allowBuild(player, block.getLocation(), Material.WATER);
        if (noBuildReason != null) {
            GriefPrevention.sendMessage(player, TextMode.Err, noBuildReason);
            bucketEvent.setCancelled(true);
            return;
        }
        PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
        Claim claim = this.dataStore.getClaimAt(block.getLocation(), false, playerData.lastClaim);
        if (claim != null) {
            minLavaDistance = 3;
        } else if (GriefPrevention.instance.creativeRulesApply(block.getLocation()) && block.getY() >= GriefPrevention.instance.getSeaLevel(block.getWorld()) - 5 && !player.hasPermission("griefprevention.lava") && bucketEvent.getBucket() == Material.LAVA_BUCKET) {
            GriefPrevention.sendMessage(player, TextMode.Err, Messages.NoWildernessBuckets, new String[0]);
            bucketEvent.setCancelled(true);
            return;
        }
        if (!(GriefPrevention.instance.pvpRulesApply(block.getWorld()) && GriefPrevention.instance.config_pvp_allowLavaNearPlayers || player.hasPermission("griefprevention.lava") || bucketEvent.getBucket() != Material.LAVA_BUCKET)) {
            List players = block.getWorld().getPlayers();
            int i = 0;
            while (i < players.size()) {
                Player otherPlayer = (Player)players.get(i);
                Location location = otherPlayer.getLocation();
                if (!otherPlayer.equals(player) && otherPlayer.getGameMode() == GameMode.SURVIVAL && block.getY() >= location.getBlockY() - 1 && location.distanceSquared(block.getLocation()) < (double)(minLavaDistance * minLavaDistance)) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.NoLavaNearOtherPlayer, "another player");
                    bucketEvent.setCancelled(true);
                    return;
                }
                ++i;
            }
        }
        if (block.getY() >= GriefPrevention.instance.getSeaLevel(block.getWorld()) - 5 && !player.hasPermission("griefprevention.lava") && block.getWorld().getEnvironment() != World.Environment.NETHER) {
            BlockFace[] adjacentDirections;
            HashSet<Material> exclusionAdjacentTypes = bucketEvent.getBucket() == Material.WATER_BUCKET ? this.commonAdjacentBlocks_water : this.commonAdjacentBlocks_lava;
            boolean makeLogEntry = true;
            BlockFace[] blockFaceArray = adjacentDirections = new BlockFace[]{BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.DOWN};
            int n = adjacentDirections.length;
            int n2 = 0;
            while (n2 < n) {
                BlockFace direction = blockFaceArray[n2];
                Material adjacentBlockType = block.getRelative(direction).getType();
                if (exclusionAdjacentTypes.contains(adjacentBlockType)) {
                    makeLogEntry = false;
                    break;
                }
                ++n2;
            }
            if (makeLogEntry) {
                GriefPrevention.AddLogEntry(String.valueOf(player.getName()) + " placed suspicious " + bucketEvent.getBucket().name() + " @ " + GriefPrevention.getfriendlyLocationString(block.getLocation()), CustomLogEntryTypes.SuspiciousActivity);
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerBucketFill(PlayerBucketFillEvent bucketEvent) {
        Player player = bucketEvent.getPlayer();
        Block block = bucketEvent.getBlockClicked();
        if (!GriefPrevention.instance.claimsEnabledForWorld(block.getWorld())) {
            return;
        }
        String noBuildReason = GriefPrevention.instance.allowBuild(player, block.getLocation(), Material.AIR);
        if (noBuildReason != null) {
            Material blockType = block.getType();
            if (blockType == Material.AIR || blockType.isSolid()) {
                return;
            }
            GriefPrevention.sendMessage(player, TextMode.Err, noBuildReason);
            bucketEvent.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    void onPlayerInteract(PlayerInteractEvent event) {
        Claim claim;
        String noBuildReason;
        Action action = event.getAction();
        if (action == Action.LEFT_CLICK_AIR) {
            return;
        }
        if (action == Action.PHYSICAL) {
            return;
        }
        Player player = event.getPlayer();
        Block clickedBlock = event.getClickedBlock();
        Material clickedBlockType = null;
        clickedBlockType = clickedBlock != null ? clickedBlock.getType() : Material.AIR;
        PlayerData playerData = null;
        if (action == Action.LEFT_CLICK_BLOCK && clickedBlock != null) {
            Block adjacentBlock;
            byte lightLevel;
            if ((clickedBlock.getY() < clickedBlock.getWorld().getMaxHeight() - 1 || event.getBlockFace() != BlockFace.UP) && (lightLevel = (adjacentBlock = clickedBlock.getRelative(event.getBlockFace())).getLightFromBlocks()) == 15 && adjacentBlock.getType() == Material.FIRE) {
                Claim claim2;
                if (playerData == null) {
                    playerData = this.dataStore.getPlayerData(player.getUniqueId());
                }
                if ((claim2 = this.dataStore.getClaimAt(clickedBlock.getLocation(), false, playerData.lastClaim)) != null) {
                    playerData.lastClaim = claim2;
                    noBuildReason = claim2.allowBuild(player, Material.AIR);
                    if (noBuildReason != null) {
                        event.setCancelled(true);
                        GriefPrevention.sendMessage(player, TextMode.Err, noBuildReason);
                        player.sendBlockChange(adjacentBlock.getLocation(), adjacentBlock.getTypeId(), adjacentBlock.getData());
                        return;
                    }
                }
            }
            if (!this.onLeftClickWatchList(clickedBlockType) && !GriefPrevention.instance.config_mods_accessTrustIds.Contains(new MaterialInfo(clickedBlock.getTypeId(), clickedBlock.getData(), null))) {
                return;
            }
        }
        if (clickedBlock != null && GriefPrevention.instance.config_claims_preventTheft && event.getAction() == Action.RIGHT_CLICK_BLOCK && (this.isInventoryHolder(clickedBlock) || clickedBlockType == Material.CAULDRON || clickedBlockType == Material.JUKEBOX || clickedBlockType == Material.ANVIL || clickedBlockType == Material.CAKE_BLOCK || GriefPrevention.instance.config_mods_containerTrustIds.Contains(new MaterialInfo(clickedBlock.getTypeId(), clickedBlock.getData(), null)))) {
            if (playerData == null) {
                playerData = this.dataStore.getPlayerData(player.getUniqueId());
            }
            if (playerData.siegeData != null) {
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.SiegeNoContainers, new String[0]);
                event.setCancelled(true);
                return;
            }
            if (playerData.inPvpCombat()) {
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.PvPNoContainers, new String[0]);
                event.setCancelled(true);
                return;
            }
            claim = this.dataStore.getClaimAt(clickedBlock.getLocation(), false, playerData.lastClaim);
            if (claim != null) {
                playerData.lastClaim = claim;
                String noContainersReason = claim.allowContainers(player);
                if (noContainersReason != null) {
                    event.setCancelled(true);
                    GriefPrevention.sendMessage(player, TextMode.Err, noContainersReason);
                    return;
                }
            }
            if (playerData.pvpImmune) {
                playerData.pvpImmune = false;
                GriefPrevention.sendMessage(player, TextMode.Warn, Messages.PvPImmunityEnd, new String[0]);
            }
        } else if (clickedBlock != null && GriefPrevention.instance.config_claims_lockWoodenDoors && (clickedBlockType == Material.WOODEN_DOOR || clickedBlockType == Material.ACACIA_DOOR || clickedBlockType == Material.BIRCH_DOOR || clickedBlockType == Material.JUNGLE_DOOR || clickedBlockType == Material.SPRUCE_DOOR || clickedBlockType == Material.DARK_OAK_DOOR) || GriefPrevention.instance.config_claims_preventButtonsSwitches && clickedBlockType == Material.BED_BLOCK || GriefPrevention.instance.config_claims_lockTrapDoors && clickedBlockType == Material.TRAP_DOOR || GriefPrevention.instance.config_claims_lockFenceGates && (clickedBlockType == Material.FENCE_GATE || clickedBlockType == Material.ACACIA_FENCE_GATE || clickedBlockType == Material.BIRCH_FENCE_GATE || clickedBlockType == Material.JUNGLE_FENCE_GATE || clickedBlockType == Material.SPRUCE_FENCE_GATE || clickedBlockType == Material.DARK_OAK_FENCE_GATE)) {
            if (playerData == null) {
                playerData = this.dataStore.getPlayerData(player.getUniqueId());
            }
            if ((claim = this.dataStore.getClaimAt(clickedBlock.getLocation(), false, playerData.lastClaim)) != null) {
                playerData.lastClaim = claim;
                String noAccessReason = claim.allowAccess(player);
                if (noAccessReason != null) {
                    event.setCancelled(true);
                    GriefPrevention.sendMessage(player, TextMode.Err, noAccessReason);
                    return;
                }
            }
        } else if (clickedBlock != null && GriefPrevention.instance.config_claims_preventButtonsSwitches && (clickedBlockType == null || clickedBlockType == Material.STONE_BUTTON || clickedBlockType == Material.WOOD_BUTTON || clickedBlockType == Material.LEVER || GriefPrevention.instance.config_mods_accessTrustIds.Contains(new MaterialInfo(clickedBlock.getTypeId(), clickedBlock.getData(), null)))) {
            if (playerData == null) {
                playerData = this.dataStore.getPlayerData(player.getUniqueId());
            }
            if ((claim = this.dataStore.getClaimAt(clickedBlock.getLocation(), false, playerData.lastClaim)) != null) {
                playerData.lastClaim = claim;
                String noAccessReason = claim.allowAccess(player);
                if (noAccessReason != null) {
                    event.setCancelled(true);
                    GriefPrevention.sendMessage(player, TextMode.Err, noAccessReason);
                    return;
                }
            }
        } else if (clickedBlock != null && GriefPrevention.instance.config_claims_preventTheft && clickedBlockType == Material.CAKE_BLOCK) {
            if (playerData == null) {
                playerData = this.dataStore.getPlayerData(player.getUniqueId());
            }
            if ((claim = this.dataStore.getClaimAt(clickedBlock.getLocation(), false, playerData.lastClaim)) != null) {
                playerData.lastClaim = claim;
                String noContainerReason = claim.allowAccess(player);
                if (noContainerReason != null) {
                    event.setCancelled(true);
                    GriefPrevention.sendMessage(player, TextMode.Err, noContainerReason);
                    return;
                }
            }
        } else if (clickedBlock != null && (clickedBlockType == Material.NOTE_BLOCK || clickedBlockType == Material.DIODE_BLOCK_ON || clickedBlockType == Material.DIODE_BLOCK_OFF || clickedBlockType == Material.DRAGON_EGG || clickedBlockType == Material.DAYLIGHT_DETECTOR || clickedBlockType == Material.DAYLIGHT_DETECTOR_INVERTED || clickedBlockType == Material.REDSTONE_COMPARATOR_ON || clickedBlockType == Material.REDSTONE_COMPARATOR_OFF)) {
            String noBuildReason2;
            if (playerData == null) {
                playerData = this.dataStore.getPlayerData(player.getUniqueId());
            }
            if ((claim = this.dataStore.getClaimAt(clickedBlock.getLocation(), false, playerData.lastClaim)) != null && (noBuildReason2 = claim.allowBuild(player, clickedBlockType)) != null) {
                event.setCancelled(true);
                GriefPrevention.sendMessage(player, TextMode.Err, noBuildReason2);
                return;
            }
        } else {
            Claim claim3;
            if (action != Action.RIGHT_CLICK_BLOCK && action != Action.RIGHT_CLICK_AIR) {
                return;
            }
            EquipmentSlot hand = event.getHand();
            ItemStack itemInHand = GriefPrevention.instance.getItemInHand(player, hand);
            Material materialInHand = itemInHand.getType();
            if (clickedBlock != null && (materialInHand == Material.INK_SACK || materialInHand == Material.ARMOR_STAND || materialInHand == Material.MONSTER_EGG)) {
                noBuildReason = GriefPrevention.instance.allowBuild(player, clickedBlock.getLocation(), clickedBlockType);
                if (noBuildReason != null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, noBuildReason);
                    event.setCancelled(true);
                }
                return;
            }
            if (clickedBlock != null && (materialInHand == Material.BOAT || materialInHand == Material.BOAT_ACACIA || materialInHand == Material.BOAT_BIRCH || materialInHand == Material.BOAT_DARK_OAK || materialInHand == Material.BOAT_JUNGLE || materialInHand == Material.BOAT_SPRUCE)) {
                String noBuildReason3;
                if (playerData == null) {
                    playerData = this.dataStore.getPlayerData(player.getUniqueId());
                }
                if ((claim3 = this.dataStore.getClaimAt(clickedBlock.getLocation(), false, playerData.lastClaim)) != null && (noBuildReason3 = claim3.allowBuild(player, Material.BOAT)) != null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, noBuildReason3);
                    event.setCancelled(true);
                }
                return;
            }
            if (!(clickedBlock == null || materialInHand != Material.MINECART && materialInHand != Material.POWERED_MINECART && materialInHand != Material.STORAGE_MINECART && materialInHand != Material.EXPLOSIVE_MINECART && materialInHand != Material.HOPPER_MINECART || GriefPrevention.instance.creativeRulesApply(clickedBlock.getLocation()))) {
                String reason;
                if (playerData == null) {
                    playerData = this.dataStore.getPlayerData(player.getUniqueId());
                }
                if ((claim3 = this.dataStore.getClaimAt(clickedBlock.getLocation(), false, playerData.lastClaim)) != null && (reason = claim3.allowContainers(player)) != null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, reason);
                    event.setCancelled(true);
                }
                return;
            }
            if (clickedBlock != null && (materialInHand == Material.MINECART || materialInHand == Material.POWERED_MINECART || materialInHand == Material.STORAGE_MINECART || materialInHand == Material.ARMOR_STAND || materialInHand == Material.ITEM_FRAME || materialInHand == Material.MONSTER_EGG || materialInHand == Material.MONSTER_EGGS || materialInHand == Material.EXPLOSIVE_MINECART || materialInHand == Material.HOPPER_MINECART) && GriefPrevention.instance.creativeRulesApply(clickedBlock.getLocation())) {
                Claim claim4;
                noBuildReason = GriefPrevention.instance.allowBuild(player, clickedBlock.getLocation(), Material.MINECART);
                if (noBuildReason != null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, noBuildReason);
                    event.setCancelled(true);
                    return;
                }
                if (playerData == null) {
                    playerData = this.dataStore.getPlayerData(player.getUniqueId());
                }
                if ((claim4 = this.dataStore.getClaimAt(clickedBlock.getLocation(), false, playerData.lastClaim)) == null) {
                    return;
                }
                String noEntitiesReason = claim4.allowMoreEntities(false);
                if (noEntitiesReason != null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, noEntitiesReason);
                    event.setCancelled(true);
                    return;
                }
                return;
            }
            if (materialInHand == GriefPrevention.instance.config_claims_investigationTool && hand == EquipmentSlot.HAND) {
                if (!GriefPrevention.instance.claimsEnabledForWorld(player.getWorld())) {
                    return;
                }
                if (player.isSneaking() && player.hasPermission("griefprevention.visualizenearbyclaims")) {
                    Set<Claim> claims = this.dataStore.getNearbyClaims(player.getLocation());
                    Visualization visualization = Visualization.fromClaims(claims, player.getEyeLocation().getBlockY(), VisualizationType.Claim, player.getLocation());
                    Visualization.Apply(player, visualization);
                    GriefPrevention.sendMessage(player, TextMode.Info, Messages.ShowNearbyClaims, String.valueOf(claims.size()));
                    return;
                }
                if (action == Action.RIGHT_CLICK_AIR) {
                    clickedBlock = PlayerEventHandler.getTargetBlock(player, 100);
                    clickedBlockType = clickedBlock.getType();
                }
                if (clickedBlock == null) {
                    return;
                }
                if (clickedBlockType == Material.AIR) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.TooFarAway, new String[0]);
                    Visualization.Revert(player);
                    return;
                }
                if (playerData == null) {
                    playerData = this.dataStore.getPlayerData(player.getUniqueId());
                }
                if ((claim3 = this.dataStore.getClaimAt(clickedBlock.getLocation(), false, playerData.lastClaim)) == null) {
                    GriefPrevention.sendMessage(player, TextMode.Info, Messages.BlockNotClaimed, new String[0]);
                    Visualization.Revert(player);
                } else {
                    playerData.lastClaim = claim3;
                    GriefPrevention.sendMessage(player, TextMode.Info, Messages.BlockClaimed, claim3.getOwnerName());
                    Visualization visualization = Visualization.FromClaim(claim3, player.getEyeLocation().getBlockY(), VisualizationType.Claim, player.getLocation());
                    Visualization.Apply(player, visualization);
                    if (claim3.allowEdit(player) == null) {
                        GriefPrevention.sendMessage(player, TextMode.Info, "  " + claim3.getWidth() + "x" + claim3.getHeight() + "=" + claim3.getArea());
                    }
                    if (!claim3.isAdminClaim() && (player.hasPermission("griefprevention.deleteclaims") || player.hasPermission("griefprevention.seeinactivity"))) {
                        if (claim3.parent != null) {
                            claim3 = claim3.parent;
                        }
                        PlayerData otherPlayerData = this.dataStore.getPlayerData(claim3.ownerID);
                        Date lastLogin = otherPlayerData.getLastLogin();
                        Date now = new Date();
                        long daysElapsed = (now.getTime() - lastLogin.getTime()) / 86400000L;
                        GriefPrevention.sendMessage(player, TextMode.Info, Messages.PlayerOfflineTime, String.valueOf(daysElapsed));
                        if (GriefPrevention.instance.getServer().getPlayer(claim3.ownerID) == null) {
                            this.dataStore.clearCachedPlayerData(claim3.ownerID);
                        }
                    }
                }
                return;
            }
            if (Material.getMaterial((int)itemInHand.getTypeId()) == null) {
                String reason;
                if (action == Action.RIGHT_CLICK_AIR) {
                    clickedBlock = PlayerEventHandler.getTargetBlock(player, 100);
                }
                if (playerData == null) {
                    playerData = this.dataStore.getPlayerData(player.getUniqueId());
                }
                if ((claim3 = this.dataStore.getClaimAt(clickedBlock.getLocation(), false, playerData.lastClaim)) != null && (reason = claim3.allowBreak(player, Material.AIR)) != null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, reason);
                    event.setCancelled(true);
                    return;
                }
                return;
            }
            if (materialInHand != GriefPrevention.instance.config_claims_modificationTool || hand != EquipmentSlot.HAND) {
                return;
            }
            event.setCancelled(true);
            if (playerData == null) {
                playerData = this.dataStore.getPlayerData(player.getUniqueId());
            }
            if (playerData.siegeData != null) {
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.SiegeNoShovel, new String[0]);
                event.setCancelled(true);
                return;
            }
            if (action == Action.RIGHT_CLICK_AIR) {
                clickedBlock = PlayerEventHandler.getTargetBlock(player, 100);
                clickedBlockType = clickedBlock.getType();
            }
            if (clickedBlock == null) {
                return;
            }
            if (clickedBlockType == Material.AIR) {
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.TooFarAway, new String[0]);
                return;
            }
            UUID playerID = player.getUniqueId();
            playerData = this.dataStore.getPlayerData(player.getUniqueId());
            if (playerData.shovelMode == ShovelMode.RestoreNature || playerData.shovelMode == ShovelMode.RestoreNatureAggressive) {
                Claim claim5 = this.dataStore.getClaimAt(clickedBlock.getLocation(), false, playerData.lastClaim);
                if (claim5 != null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.BlockClaimed, claim5.getOwnerName());
                    Visualization visualization = Visualization.FromClaim(claim5, clickedBlock.getY(), VisualizationType.ErrorClaim, player.getLocation());
                    Visualization.Apply(player, visualization);
                    return;
                }
                Chunk chunk = player.getWorld().getChunkAt(clickedBlock.getLocation());
                int miny = clickedBlock.getY();
                if (playerData.shovelMode != ShovelMode.RestoreNatureAggressive && miny > GriefPrevention.instance.getSeaLevel(chunk.getWorld()) - 10) {
                    miny = GriefPrevention.instance.getSeaLevel(chunk.getWorld()) - 10;
                }
                GriefPrevention.instance.restoreChunk(chunk, miny, playerData.shovelMode == ShovelMode.RestoreNatureAggressive, 0L, player);
                return;
            }
            if (playerData.shovelMode == ShovelMode.RestoreNatureFill) {
                ArrayList<Material> allowedFillBlocks = new ArrayList<Material>();
                World.Environment environment = clickedBlock.getWorld().getEnvironment();
                if (environment == World.Environment.NETHER) {
                    allowedFillBlocks.add(Material.NETHERRACK);
                } else if (environment == World.Environment.THE_END) {
                    allowedFillBlocks.add(Material.ENDER_STONE);
                } else {
                    allowedFillBlocks.add(Material.GRASS);
                    allowedFillBlocks.add(Material.DIRT);
                    allowedFillBlocks.add(Material.STONE);
                    allowedFillBlocks.add(Material.SAND);
                    allowedFillBlocks.add(Material.SANDSTONE);
                    allowedFillBlocks.add(Material.ICE);
                }
                Block centerBlock = clickedBlock;
                int maxHeight = centerBlock.getY();
                int minx = centerBlock.getX() - playerData.fillRadius;
                int maxx = centerBlock.getX() + playerData.fillRadius;
                int minz = centerBlock.getZ() - playerData.fillRadius;
                int maxz = centerBlock.getZ() + playerData.fillRadius;
                int minHeight = maxHeight - 10;
                if (minHeight < 0) {
                    minHeight = 0;
                }
                Claim cachedClaim = null;
                int x = minx;
                while (x <= maxx) {
                    int z = minz;
                    while (z <= maxz) {
                        Location location = new Location(centerBlock.getWorld(), (double)x, (double)centerBlock.getY(), (double)z);
                        if (!(location.distance(centerBlock.getLocation()) > (double)playerData.fillRadius)) {
                            Material defaultFiller = (Material)allowedFillBlocks.get(0);
                            if (allowedFillBlocks.contains(centerBlock.getType())) {
                                defaultFiller = centerBlock.getType();
                            } else if (centerBlock.getType() == Material.WATER || centerBlock.getType() == Material.STATIONARY_WATER) {
                                Block block = centerBlock.getWorld().getBlockAt(centerBlock.getLocation());
                                while (!allowedFillBlocks.contains(block.getType()) && block.getY() > centerBlock.getY() - 10) {
                                    block = block.getRelative(BlockFace.DOWN);
                                }
                                if (allowedFillBlocks.contains(block.getType())) {
                                    defaultFiller = block.getType();
                                }
                            }
                            int y = minHeight;
                            while (y <= maxHeight) {
                                Block block = centerBlock.getWorld().getBlockAt(x, y, z);
                                Claim claim6 = this.dataStore.getClaimAt(block.getLocation(), false, cachedClaim);
                                if (claim6 != null) {
                                    cachedClaim = claim6;
                                    break;
                                }
                                if (block.getType() == Material.AIR || block.getType() == Material.SNOW || block.getType() == Material.STATIONARY_WATER && block.getData() != 0 || block.getType() == Material.LONG_GRASS) {
                                    if (y == maxHeight) {
                                        block.setType(defaultFiller);
                                    } else {
                                        Block eastBlock = block.getRelative(BlockFace.EAST);
                                        Block westBlock = block.getRelative(BlockFace.WEST);
                                        Block northBlock = block.getRelative(BlockFace.NORTH);
                                        Block southBlock = block.getRelative(BlockFace.SOUTH);
                                        if (allowedFillBlocks.contains(eastBlock.getType())) {
                                            block.setType(eastBlock.getType());
                                        } else if (allowedFillBlocks.contains(westBlock.getType())) {
                                            block.setType(westBlock.getType());
                                        } else if (allowedFillBlocks.contains(northBlock.getType())) {
                                            block.setType(northBlock.getType());
                                        } else if (allowedFillBlocks.contains(southBlock.getType())) {
                                            block.setType(southBlock.getType());
                                        } else {
                                            block.setType(defaultFiller);
                                        }
                                    }
                                }
                                ++y;
                            }
                        }
                        ++z;
                    }
                    ++x;
                }
                return;
            }
            if (!player.hasPermission("griefprevention.createclaims")) {
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.NoCreateClaimPermission, new String[0]);
                return;
            }
            if (playerData.claimResizing != null && playerData.claimResizing.inDataStore) {
                if (clickedBlock.getLocation().equals((Object)playerData.lastShovelLocation)) {
                    return;
                }
                int newx1 = playerData.lastShovelLocation.getBlockX() == playerData.claimResizing.getLesserBoundaryCorner().getBlockX() ? clickedBlock.getX() : playerData.claimResizing.getLesserBoundaryCorner().getBlockX();
                int newx2 = playerData.lastShovelLocation.getBlockX() == playerData.claimResizing.getGreaterBoundaryCorner().getBlockX() ? clickedBlock.getX() : playerData.claimResizing.getGreaterBoundaryCorner().getBlockX();
                int newz1 = playerData.lastShovelLocation.getBlockZ() == playerData.claimResizing.getLesserBoundaryCorner().getBlockZ() ? clickedBlock.getZ() : playerData.claimResizing.getLesserBoundaryCorner().getBlockZ();
                int newz2 = playerData.lastShovelLocation.getBlockZ() == playerData.claimResizing.getGreaterBoundaryCorner().getBlockZ() ? clickedBlock.getZ() : playerData.claimResizing.getGreaterBoundaryCorner().getBlockZ();
                int newy1 = playerData.claimResizing.getLesserBoundaryCorner().getBlockY();
                int newy2 = clickedBlock.getY() - GriefPrevention.instance.config_claims_claimsExtendIntoGroundDistance;
                this.dataStore.resizeClaimWithChecks(player, playerData, newx1, newx2, newy1, newy2, newz1, newz2);
                return;
            }
            Claim claim7 = this.dataStore.getClaimAt(clickedBlock.getLocation(), true, playerData.lastClaim);
            if (claim7 != null) {
                String noEditReason = claim7.allowEdit(player);
                if (noEditReason == null) {
                    if (!(clickedBlock.getX() != claim7.getLesserBoundaryCorner().getBlockX() && clickedBlock.getX() != claim7.getGreaterBoundaryCorner().getBlockX() || clickedBlock.getZ() != claim7.getLesserBoundaryCorner().getBlockZ() && clickedBlock.getZ() != claim7.getGreaterBoundaryCorner().getBlockZ())) {
                        playerData.claimResizing = claim7;
                        playerData.lastShovelLocation = clickedBlock.getLocation();
                        GriefPrevention.sendMessage(player, TextMode.Instr, Messages.ResizeStart, new String[0]);
                    } else if (playerData.shovelMode == ShovelMode.Subdivide) {
                        if (playerData.lastShovelLocation == null) {
                            if (claim7.parent != null) {
                                GriefPrevention.sendMessage(player, TextMode.Err, Messages.ResizeFailOverlapSubdivision, new String[0]);
                            } else {
                                GriefPrevention.sendMessage(player, TextMode.Instr, Messages.SubdivisionStart, new String[0]);
                                playerData.lastShovelLocation = clickedBlock.getLocation();
                                playerData.claimSubdividing = claim7;
                            }
                        } else {
                            if (!playerData.lastShovelLocation.getWorld().equals(clickedBlock.getWorld())) {
                                playerData.lastShovelLocation = null;
                                this.onPlayerInteract(event);
                                return;
                            }
                            CreateClaimResult result = this.dataStore.createClaim(player.getWorld(), playerData.lastShovelLocation.getBlockX(), clickedBlock.getX(), playerData.lastShovelLocation.getBlockY() - GriefPrevention.instance.config_claims_claimsExtendIntoGroundDistance, clickedBlock.getY() - GriefPrevention.instance.config_claims_claimsExtendIntoGroundDistance, playerData.lastShovelLocation.getBlockZ(), clickedBlock.getZ(), null, playerData.claimSubdividing, null, player);
                            if (!result.succeeded) {
                                GriefPrevention.sendMessage(player, TextMode.Err, Messages.CreateSubdivisionOverlap, new String[0]);
                                Visualization visualization = Visualization.FromClaim(result.claim, clickedBlock.getY(), VisualizationType.ErrorClaim, player.getLocation());
                                Visualization.Apply(player, visualization);
                                return;
                            }
                            GriefPrevention.sendMessage(player, TextMode.Success, Messages.SubdivisionSuccess, new String[0]);
                            Visualization visualization = Visualization.FromClaim(result.claim, clickedBlock.getY(), VisualizationType.Claim, player.getLocation());
                            Visualization.Apply(player, visualization);
                            playerData.lastShovelLocation = null;
                            playerData.claimSubdividing = null;
                        }
                    } else {
                        GriefPrevention.sendMessage(player, TextMode.Err, Messages.CreateClaimFailOverlap, new String[0]);
                        Visualization visualization = Visualization.FromClaim(claim7, clickedBlock.getY(), VisualizationType.Claim, player.getLocation());
                        Visualization.Apply(player, visualization);
                    }
                } else {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.CreateClaimFailOverlapOtherPlayer, claim7.getOwnerName());
                    Visualization visualization = Visualization.FromClaim(claim7, clickedBlock.getY(), VisualizationType.ErrorClaim, player.getLocation());
                    Visualization.Apply(player, visualization);
                }
                return;
            }
            Location lastShovelLocation = playerData.lastShovelLocation;
            if (lastShovelLocation == null) {
                if (!GriefPrevention.instance.claimsEnabledForWorld(player.getWorld())) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.ClaimsDisabledWorld, new String[0]);
                    return;
                }
                if (GriefPrevention.instance.config_claims_maxClaimsPerPlayer > 0 && !player.hasPermission("griefprevention.overrideclaimcountlimit") && playerData.getClaims().size() >= GriefPrevention.instance.config_claims_maxClaimsPerPlayer) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.ClaimCreationFailedOverClaimCountLimit, new String[0]);
                    return;
                }
                playerData.lastShovelLocation = clickedBlock.getLocation();
                GriefPrevention.sendMessage(player, TextMode.Instr, Messages.ClaimStart, new String[0]);
                Visualization visualization = Visualization.FromClaim(new Claim(clickedBlock.getLocation(), clickedBlock.getLocation(), null, new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), null), clickedBlock.getY(), VisualizationType.RestoreNature, player.getLocation());
                Visualization.Apply(player, visualization);
            } else {
                if (!lastShovelLocation.getWorld().equals(clickedBlock.getWorld())) {
                    playerData.lastShovelLocation = null;
                    this.onPlayerInteract(event);
                    return;
                }
                if (playerData.inPvpCombat()) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.NoClaimDuringPvP, new String[0]);
                    return;
                }
                int newClaimWidth = Math.abs(playerData.lastShovelLocation.getBlockX() - clickedBlock.getX()) + 1;
                int newClaimHeight = Math.abs(playerData.lastShovelLocation.getBlockZ() - clickedBlock.getZ()) + 1;
                if (playerData.shovelMode != ShovelMode.Admin) {
                    if (newClaimWidth < GriefPrevention.instance.config_claims_minWidth || newClaimHeight < GriefPrevention.instance.config_claims_minWidth) {
                        if (newClaimWidth != 1 && newClaimHeight != 1) {
                            GriefPrevention.sendMessage(player, TextMode.Err, Messages.NewClaimTooNarrow, String.valueOf(GriefPrevention.instance.config_claims_minWidth));
                        }
                        return;
                    }
                    int newArea = newClaimWidth * newClaimHeight;
                    if (newArea < GriefPrevention.instance.config_claims_minArea) {
                        if (newArea != 1) {
                            GriefPrevention.sendMessage(player, TextMode.Err, Messages.ResizeClaimInsufficientArea, String.valueOf(GriefPrevention.instance.config_claims_minArea));
                        }
                        return;
                    }
                }
                if (playerData.shovelMode != ShovelMode.Admin) {
                    int newClaimArea = newClaimWidth * newClaimHeight;
                    int remainingBlocks = playerData.getRemainingClaimBlocks();
                    if (newClaimArea > remainingBlocks) {
                        GriefPrevention.sendMessage(player, TextMode.Err, Messages.CreateClaimInsufficientBlocks, String.valueOf(newClaimArea - remainingBlocks));
                        GriefPrevention.instance.dataStore.tryAdvertiseAdminAlternatives(player);
                        return;
                    }
                } else {
                    playerID = null;
                }
                CreateClaimResult result = this.dataStore.createClaim(player.getWorld(), lastShovelLocation.getBlockX(), clickedBlock.getX(), lastShovelLocation.getBlockY() - GriefPrevention.instance.config_claims_claimsExtendIntoGroundDistance, clickedBlock.getY() - GriefPrevention.instance.config_claims_claimsExtendIntoGroundDistance, lastShovelLocation.getBlockZ(), clickedBlock.getZ(), playerID, null, null, player);
                if (!result.succeeded) {
                    if (result.claim != null) {
                        GriefPrevention.sendMessage(player, TextMode.Err, Messages.CreateClaimFailOverlapShort, new String[0]);
                        Visualization visualization = Visualization.FromClaim(result.claim, clickedBlock.getY(), VisualizationType.ErrorClaim, player.getLocation());
                        Visualization.Apply(player, visualization);
                    } else {
                        GriefPrevention.sendMessage(player, TextMode.Err, Messages.CreateClaimFailOverlapRegion, new String[0]);
                    }
                    return;
                }
                GriefPrevention.sendMessage(player, TextMode.Success, Messages.CreateClaimSuccess, new String[0]);
                Visualization visualization = Visualization.FromClaim(result.claim, clickedBlock.getY(), VisualizationType.Claim, player.getLocation());
                Visualization.Apply(player, visualization);
                playerData.lastShovelLocation = null;
                if (!player.hasPermission("griefprevention.adminclaims") && result.claim.getArea() >= 1000) {
                    GriefPrevention.sendMessage(player, TextMode.Info, Messages.BecomeMayor, 200L, new String[0]);
                    GriefPrevention.sendMessage(player, TextMode.Instr, Messages.SubdivisionVideo2, 201L, DataStore.SUBDIVISION_VIDEO_URL);
                }
                GriefPrevention.instance.autoExtendClaim(result.claim);
            }
        }
    }

    private boolean isInventoryHolder(Block clickedBlock) {
        Integer cacheKey = clickedBlock.getTypeId();
        Boolean cachedValue = this.inventoryHolderCache.get(cacheKey);
        if (cachedValue != null) {
            return cachedValue;
        }
        boolean isHolder = clickedBlock.getState() instanceof InventoryHolder;
        this.inventoryHolderCache.put(cacheKey, isHolder);
        return isHolder;
    }

    private boolean onLeftClickWatchList(Material material) {
        switch (material) {
            case LEVER: 
            case STONE_BUTTON: 
            case CAKE_BLOCK: 
            case DIODE_BLOCK_OFF: 
            case DIODE_BLOCK_ON: 
            case DRAGON_EGG: 
            case WOOD_BUTTON: {
                return true;
            }
        }
        return false;
    }

    static Block getTargetBlock(Player player, int maxDistance) throws IllegalStateException {
        Location eye = player.getEyeLocation();
        Material eyeMaterial = eye.getBlock().getType();
        boolean passThroughWater = eyeMaterial == Material.WATER || eyeMaterial == Material.STATIONARY_WATER;
        BlockIterator iterator = new BlockIterator(player.getLocation(), player.getEyeHeight(), maxDistance);
        Block result = player.getLocation().getBlock().getRelative(BlockFace.UP);
        while (iterator.hasNext()) {
            result = iterator.next();
            Material type = result.getType();
            if (type == Material.AIR || passThroughWater && type == Material.STATIONARY_WATER || passThroughWater && type == Material.WATER || type == Material.LONG_GRASS || type == Material.SNOW) continue;
            return result;
        }
        return result;
    }
}

