/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.listeners;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.chat.ChatChannel;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.Visualizer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.economy.rent.RentableLand;
import com.bekvon.bukkit.residence.economy.rent.RentedLand;
import com.bekvon.bukkit.residence.event.ResidenceChangedEvent;
import com.bekvon.bukkit.residence.event.ResidenceDeleteEvent;
import com.bekvon.bukkit.residence.event.ResidenceFlagChangeEvent;
import com.bekvon.bukkit.residence.event.ResidenceRenameEvent;
import com.bekvon.bukkit.residence.gui.SetFlag;
import com.bekvon.bukkit.residence.listeners.ResidenceEntityListener;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.signsStuff.Signs;
import com.bekvon.bukkit.residence.utils.GetTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.WeatherType;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ResidencePlayerListener
implements Listener {
    protected Map<String, String> currentRes;
    protected Map<String, Long> lastUpdate;
    protected Map<String, Location> lastOutsideLoc;
    protected int minUpdateTime;
    protected boolean chatenabled;
    protected List<String> playerToggleChat = new ArrayList<String>();
    public Map<String, SetFlag> GUI = new HashMap<String, SetFlag>();
    private Residence plugin;

    public ResidencePlayerListener(Residence plugin) {
        this.currentRes = new HashMap<String, String>();
        this.lastUpdate = new HashMap<String, Long>();
        this.lastOutsideLoc = new HashMap<String, Location>();
        this.playerToggleChat.clear();
        this.minUpdateTime = plugin.getConfigManager().getMinMoveUpdateInterval();
        this.chatenabled = plugin.getConfigManager().chatEnabled();
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.lastUpdate.put(player.getName(), System.currentTimeMillis());
        }
        this.plugin = plugin;
    }

    public Map<String, SetFlag> getGUImap() {
        return this.GUI;
    }

    public void reload() {
        this.currentRes = new HashMap<String, String>();
        this.lastUpdate = new HashMap<String, Long>();
        this.lastOutsideLoc = new HashMap<String, Location>();
        this.playerToggleChat.clear();
        this.minUpdateTime = this.plugin.getConfigManager().getMinMoveUpdateInterval();
        this.chatenabled = this.plugin.getConfigManager().chatEnabled();
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.lastUpdate.put(player.getName(), System.currentTimeMillis());
        }
    }

    @EventHandler
    public void onJump(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (player.isFlying()) {
            return;
        }
        if (event.getTo().getY() - event.getFrom().getY() != (double)0.42f) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(player.getLocation());
        if (perms.has(Flags.jump2, FlagPermissions.FlagCombo.OnlyTrue)) {
            player.setVelocity(player.getVelocity().add(player.getVelocity().multiply(0.3)));
        } else if (perms.has(Flags.jump3, FlagPermissions.FlagCombo.OnlyTrue)) {
            player.setVelocity(player.getVelocity().add(player.getVelocity().multiply(0.6)));
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerGlobalChat(AsyncPlayerChatEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (!this.plugin.getConfigManager().isGlobalChatEnabled()) {
            return;
        }
        if (!this.plugin.getConfigManager().isGlobalChatSelfModify()) {
            return;
        }
        Player player = event.getPlayer();
        ResidencePlayer rPlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        if (rPlayer == null) {
            return;
        }
        if (rPlayer.getResList().size() == 0) {
            return;
        }
        ClaimedResidence res = rPlayer.getMainResidence();
        if (res == null) {
            return;
        }
        String honorific = this.plugin.getConfigManager().getGlobalChatFormat().replace("%1", res.getTopParentName());
        String format = event.getFormat();
        format = format.replace("%1$s", String.valueOf(honorific) + "%1$s");
        event.setFormat(format);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerChatGlobalLow(AsyncPlayerChatEvent event) {
        String format;
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (!this.plugin.getConfigManager().isGlobalChatEnabled()) {
            return;
        }
        if (this.plugin.getConfigManager().isGlobalChatSelfModify()) {
            return;
        }
        Player player = event.getPlayer();
        ResidencePlayer rPlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        if (rPlayer == null) {
            return;
        }
        if (rPlayer.getResList().size() == 0) {
            return;
        }
        ClaimedResidence res = rPlayer.getMainResidence();
        if (res == null) {
            return;
        }
        String honorific = this.plugin.getConfigManager().getGlobalChatFormat().replace("%1", res.getTopParentName());
        if (honorific.equalsIgnoreCase(" ")) {
            honorific = "";
        }
        if (!(format = event.getFormat()).contains("{residence}")) {
            return;
        }
        format = format.replace("{residence}", honorific);
        event.setFormat(format);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceBackup(ResidenceFlagChangeEvent event) {
        if (!event.getFlag().equalsIgnoreCase(Flags.backup.getName())) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.plugin.getConfigManager().RestoreAfterRentEnds) {
            return;
        }
        if (!this.plugin.getConfigManager().SchematicsSaveOnFlagChange) {
            return;
        }
        if (this.plugin.getSchematicManager() == null) {
            return;
        }
        if (player != null && !player.hasPermission("residence.backup")) {
            event.setCancelled(true);
        } else {
            this.plugin.getSchematicManager().save(event.getResidence());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceBackupRename(ResidenceRenameEvent event) {
        if (this.plugin.getSchematicManager() == null) {
            return;
        }
        this.plugin.getSchematicManager().rename(event.getResidence(), event.getNewResidenceName());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceDelete(ResidenceDeleteEvent event) {
        if (this.plugin.getSchematicManager() == null) {
            return;
        }
        this.plugin.getSchematicManager().delete(event.getResidence());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerLogin(PlayerLoginEvent event) {
        if (!this.plugin.getConfigManager().isRentInformOnEnding()) {
            return;
        }
        final Player player = event.getPlayer();
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (!player.isOnline()) {
                    return;
                }
                List<String> list2 = ResidencePlayerListener.this.plugin.getRentManager().getRentedLandsList(player.getName());
                if (list2.isEmpty()) {
                    return;
                }
                for (String one : list2) {
                    RentedLand rentedland = ResidencePlayerListener.this.plugin.getRentManager().getRentedLand(one);
                    if (rentedland == null || rentedland.AutoPay || rentedland.endTime - System.currentTimeMillis() >= (long)(ResidencePlayerListener.this.plugin.getConfigManager().getRentInformBefore() * 60 * 24 * 7)) continue;
                    ResidencePlayerListener.this.plugin.msg((CommandSender)player, lm.Residence_EndingRent, one, GetTime.getTime(rentedland.endTime));
                }
            }
        }, (long)this.plugin.getConfigManager().getRentInformDelay() * 20L);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onFishingRodUse(PlayerFishEvent event) {
        if (event == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (event.getCaught() == null) {
            return;
        }
        if (this.plugin.getNms().isArmorStandEntity(event.getCaught().getType()) || event.getCaught() instanceof Boat || event.getCaught() instanceof LivingEntity) {
            FlagPermissions perm = this.plugin.getPermsByLoc(event.getCaught().getLocation());
            ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(event.getCaught().getLocation());
            if (perm.has(Flags.hook, FlagPermissions.FlagCombo.OnlyFalse)) {
                event.setCancelled(true);
                if (res != null) {
                    this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, Flags.hook.getName(), res.getName());
                }
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeDayNight(ResidenceFlagChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getFlag().equalsIgnoreCase(Flags.day.getName()) && !event.getFlag().equalsIgnoreCase(Flags.night.getName())) {
            return;
        }
        switch (event.getNewState()) {
            case FALSE: 
            case NEITHER: {
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.resetPlayerTime();
                }
                break;
            }
            case INVALID: {
                break;
            }
            case TRUE: {
                if (event.getFlag().equalsIgnoreCase(Flags.day.getName())) {
                    for (Player one : event.getResidence().getPlayersInResidence()) {
                        one.setPlayerTime(6000L, false);
                    }
                }
                if (!event.getFlag().equalsIgnoreCase(Flags.night.getName())) break;
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.setPlayerTime(14000L, false);
                }
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeGlow(ResidenceFlagChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getFlag().equalsIgnoreCase(Flags.glow.getName())) {
            return;
        }
        switch (event.getNewState()) {
            case FALSE: 
            case NEITHER: {
                if (this.plugin.getVersionChecker().GetVersion() <= 1900 || !event.getFlag().equalsIgnoreCase(Flags.glow.getName())) break;
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.setGlowing(false);
                }
                break;
            }
            case INVALID: {
                break;
            }
            case TRUE: {
                if (!event.getFlag().equalsIgnoreCase(Flags.glow.getName()) || this.plugin.getVersionChecker().GetVersion() <= 1900) break;
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.setGlowing(true);
                }
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeWSpeed(ResidenceFlagChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getFlag().equalsIgnoreCase(Flags.wspeed1.getName()) && !event.getFlag().equalsIgnoreCase(Flags.wspeed2.getName())) {
            return;
        }
        switch (event.getNewState()) {
            case FALSE: 
            case NEITHER: {
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.setWalkSpeed(0.2f);
                }
                break;
            }
            case INVALID: {
                break;
            }
            case TRUE: {
                if (event.getFlag().equalsIgnoreCase(Flags.wspeed1.getName())) {
                    for (Player one : event.getResidence().getPlayersInResidence()) {
                        one.setWalkSpeed(this.plugin.getConfigManager().getWalkSpeed1().floatValue());
                    }
                    if (!event.getResidence().getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) break;
                    event.getResidence().getPermissions().setFlag(Flags.wspeed2.getName(), FlagPermissions.FlagState.NEITHER);
                    break;
                }
                if (!event.getFlag().equalsIgnoreCase(Flags.wspeed2.getName())) break;
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.setWalkSpeed(this.plugin.getConfigManager().getWalkSpeed2().floatValue());
                }
                if (!event.getResidence().getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue)) break;
                event.getResidence().getPermissions().setFlag(Flags.wspeed1.getName(), FlagPermissions.FlagState.NEITHER);
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeJump(ResidenceFlagChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getFlag().equalsIgnoreCase(Flags.jump2.getName()) && !event.getFlag().equalsIgnoreCase(Flags.jump3.getName())) {
            return;
        }
        switch (event.getNewState()) {
            case FALSE: 
            case NEITHER: 
            case INVALID: {
                break;
            }
            case TRUE: {
                if (event.getFlag().equalsIgnoreCase(Flags.jump2.getName())) {
                    if (!event.getResidence().getPermissions().has(Flags.jump3, FlagPermissions.FlagCombo.OnlyTrue)) break;
                    event.getResidence().getPermissions().setFlag(Flags.jump3.getName(), FlagPermissions.FlagState.NEITHER);
                    break;
                }
                if (!event.getFlag().equalsIgnoreCase(Flags.jump3.getName()) || !event.getResidence().getPermissions().has(Flags.jump2, FlagPermissions.FlagCombo.OnlyTrue)) break;
                event.getResidence().getPermissions().setFlag(Flags.jump2.getName(), FlagPermissions.FlagState.NEITHER);
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeSunRain(ResidenceFlagChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getFlag().equalsIgnoreCase(Flags.sun.getName()) && !event.getFlag().equalsIgnoreCase(Flags.rain.getName())) {
            return;
        }
        switch (event.getNewState()) {
            case FALSE: 
            case NEITHER: {
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.resetPlayerWeather();
                }
                break;
            }
            case INVALID: {
                break;
            }
            case TRUE: {
                if (event.getFlag().equalsIgnoreCase(Flags.sun.getName())) {
                    for (Player one : event.getResidence().getPlayersInResidence()) {
                        one.setPlayerWeather(WeatherType.CLEAR);
                    }
                }
                if (!event.getFlag().equalsIgnoreCase(Flags.rain.getName())) break;
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.setPlayerWeather(WeatherType.DOWNFALL);
                }
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onCommand(PlayerCommandPreprocessEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        String resname = this.plugin.getPlayerListener().getCurrentResidenceName(player.getName());
        if (resname == null) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByName(resname);
        if (res == null) {
            return;
        }
        if (!res.getPermissions().playerHas(player, Flags.command, FlagPermissions.FlagCombo.OnlyFalse)) {
            return;
        }
        if (this.plugin.getPermissionManager().isResidenceAdmin((CommandSender)player)) {
            return;
        }
        if (player.hasPermission("residence.flag.command.bypass")) {
            return;
        }
        String msg = event.getMessage().replace(" ", "_");
        int white = 0;
        int black = 0;
        for (String oneWhite : res.getCmdWhiteList()) {
            if (!msg.startsWith("/" + oneWhite)) continue;
            if (oneWhite.contains("_") && oneWhite.split("_").length > white) {
                white = oneWhite.split("_").length;
                continue;
            }
            if (white != 0) continue;
            white = 1;
        }
        for (String oneBlack : res.getCmdBlackList()) {
            if (!msg.startsWith("/" + oneBlack)) continue;
            if (msg.contains("_")) {
                black = oneBlack.split("_").length;
                break;
            }
            black = 1;
            break;
        }
        if (black == 0) {
            for (String oneBlack : res.getCmdBlackList()) {
                if (!oneBlack.equalsIgnoreCase("*")) continue;
                if (!msg.contains("_")) break;
                black = msg.split("_").length;
                break;
            }
        }
        if (white != 0 && white >= black || black == 0) {
            return;
        }
        event.setCancelled(true);
        this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, Flags.command.getName(), res.getName());
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onFlagGuiClick(InventoryClickEvent event) {
        if (this.getGUImap().size() == 0) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.getGUImap().containsKey(player.getName())) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        if (slot > 53 || slot < 0) {
            return;
        }
        SetFlag setFlag = this.getGUImap().get(player.getName());
        ClickType click = event.getClick();
        InventoryAction action = event.getAction();
        setFlag.toggleFlag(slot, click, action);
        setFlag.recalculateInv();
        player.getOpenInventory().getTopInventory().setContents(setFlag.getInventory().getContents());
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onFlagGuiClose(InventoryCloseEvent event) {
        if (this.getGUImap().isEmpty()) {
            return;
        }
        HumanEntity player = event.getPlayer();
        if (!this.getGUImap().containsKey(player.getName())) {
            return;
        }
        this.getGUImap().remove(player.getName());
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onSignInteract(PlayerInteractEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        if (!(block.getState() instanceof Sign)) {
            return;
        }
        Player player = event.getPlayer();
        Location loc = block.getLocation();
        for (Signs one : this.plugin.getSignUtil().getSigns().GetAllSigns()) {
            if (!one.GetLocation().getWorld().getName().equalsIgnoreCase(loc.getWorld().getName()) || one.GetLocation().getBlockX() != loc.getBlockX() || one.GetLocation().getBlockY() != loc.getBlockY() || one.GetLocation().getBlockZ() != loc.getBlockZ()) continue;
            ClaimedResidence res = one.GetResidence();
            boolean ForSale = res.isForSell();
            boolean ForRent = res.isForRent();
            String landName = res.getName();
            if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                if (ForSale) {
                    Bukkit.dispatchCommand((CommandSender)player, (String)("res market buy " + landName));
                    break;
                }
                if (!ForRent) continue;
                if (res.isRented() && player.isSneaking()) {
                    Bukkit.dispatchCommand((CommandSender)player, (String)("res market release " + landName));
                    break;
                }
                boolean stage = true;
                if (player.isSneaking()) {
                    stage = false;
                }
                Bukkit.dispatchCommand((CommandSender)player, (String)("res market rent " + landName + " " + stage));
                break;
            }
            if (event.getAction() != Action.LEFT_CLICK_BLOCK || !ForRent || !res.isRented() || !this.plugin.getRentManager().getRentingPlayer(res).equals(player.getName())) continue;
            this.plugin.getRentManager().payRent(player, res, false);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onSignCreate(SignChangeEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Block block = event.getBlock();
        if (!(block.getState() instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)block.getState();
        if (!ChatColor.stripColor((String)event.getLine(0)).equalsIgnoreCase(this.plugin.msg(lm.Sign_TopLine, new Object[0]))) {
            return;
        }
        Signs signInfo = new Signs();
        Location loc = sign.getLocation();
        String landName = null;
        Player player = event.getPlayer();
        ClaimedResidence res = null;
        if (!event.getLine(1).equalsIgnoreCase("")) {
            String resname = event.getLine(1);
            if (!event.getLine(2).equalsIgnoreCase("")) {
                resname = String.valueOf(resname) + "." + event.getLine(2);
            }
            if (!event.getLine(3).equalsIgnoreCase("")) {
                resname = String.valueOf(resname) + "." + event.getLine(3);
            }
            if ((res = this.plugin.getResidenceManager().getByName(resname)) == null) {
                this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
                return;
            }
            landName = res.getName();
        } else {
            res = this.plugin.getResidenceManager().getByLoc(loc);
            landName = this.plugin.getResidenceManager().getNameByLoc(loc);
        }
        if (res == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return;
        }
        final ClaimedResidence residence = res;
        boolean ForSale = this.plugin.getTransactionManager().isForSale(landName);
        boolean ForRent = this.plugin.getRentManager().isForRent(landName);
        int category = 1;
        if (this.plugin.getSignUtil().getSigns().GetAllSigns().size() > 0) {
            category = this.plugin.getSignUtil().getSigns().GetAllSigns().get(this.plugin.getSignUtil().getSigns().GetAllSigns().size() - 1).GetCategory() + 1;
        }
        if (ForSale || ForRent) {
            signInfo.setCategory(category);
            signInfo.setResidence(res);
            signInfo.setLocation(loc);
            this.plugin.getSignUtil().getSigns().addSign(signInfo);
            this.plugin.getSignUtil().saveSigns();
        }
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                ResidencePlayerListener.this.plugin.getSignUtil().CheckSign(residence);
            }
        }, 5L);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onSignDestroy(BlockBreakEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        if (block == null) {
            return;
        }
        if (!(block.getState() instanceof Sign)) {
            return;
        }
        Location loc = block.getLocation();
        for (Signs one : this.plugin.getSignUtil().getSigns().GetAllSigns()) {
            if (!one.GetLocation().getWorld().getName().equalsIgnoreCase(loc.getWorld().getName()) || one.GetLocation().getBlockX() != loc.getBlockX() || one.GetLocation().getBlockY() != loc.getBlockY() || one.GetLocation().getBlockZ() != loc.getBlockZ()) continue;
            this.plugin.getSignUtil().getSigns().removeSign(one);
            this.plugin.getSignUtil().saveSigns();
            break;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        String pname = event.getPlayer().getName();
        this.currentRes.remove(pname);
        this.lastUpdate.remove(pname);
        this.lastOutsideLoc.remove(pname);
        this.plugin.getChatManager().removeFromChannel(pname);
        this.plugin.getPlayerListener().removePlayerResidenceChat(pname);
        this.plugin.getOfflinePlayerMap().put(pname, (OfflinePlayer)event.getPlayer());
        if (this.plugin.getAutoSelectionManager().getList().containsKey(pname.toLowerCase())) {
            this.plugin.getAutoSelectionManager().getList().remove(pname);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoin(PlayerChangedWorldEvent event) {
        ClaimedResidence res;
        Player player = event.getPlayer();
        if (this.plugin.getPermissionManager().isResidenceAdmin((CommandSender)player)) {
            this.plugin.turnResAdminOn(player);
        }
        this.plugin.getPermissionManager().updateGroupNameForPlayer(player, true);
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(player.getLocation(), player);
        if (!(!player.getAllowFlight() && !player.isFlying() || !perms.has(Flags.nofly, false) || this.plugin.isResAdminOn(player) || player.hasPermission("residence.nofly.bypass") || (res = this.plugin.getResidenceManager().getByLoc(player.getLocation())) != null && res.isOwner(player))) {
            Location lc = player.getLocation();
            Location location = new Location(lc.getWorld(), lc.getX(), (double)lc.getBlockY(), lc.getZ());
            location.setPitch(lc.getPitch());
            location.setYaw(lc.getYaw());
            int from = location.getBlockY();
            int maxH = location.getWorld().getMaxHeight() - 1;
            int i = 0;
            while (i < maxH) {
                location.setY((double)(from - i));
                Block block = location.getBlock();
                if (!this.plugin.getNms().isEmptyBlock(block)) {
                    location.setY((double)(from - i + 1));
                    break;
                }
                if (location.getBlockY() <= 0) {
                    player.setFlying(false);
                    player.setAllowFlight(false);
                    this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, Flags.nofly.getName(), location.getWorld().getName());
                    return;
                }
                ++i;
            }
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, Flags.nofly.getName(), location.getWorld().getName());
            player.teleport(location);
            player.setFlying(false);
            player.setAllowFlight(false);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.lastUpdate.put(player.getName(), 0L);
        if (this.plugin.getPermissionManager().isResidenceAdmin((CommandSender)player)) {
            this.plugin.turnResAdminOn(player);
        }
        this.handleNewLocation(player, player.getLocation(), true);
        this.plugin.getPlayerManager().playerJoin(player);
        this.plugin.getPermissionManager().updateGroupNameForPlayer(player, true);
        if (player.hasPermission("residence.versioncheck")) {
            this.plugin.getVersionChecker().VersionCheck(player);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerSpawn(PlayerRespawnEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getRespawnLocation().getWorld())) {
            return;
        }
        Location loc = event.getRespawnLocation();
        Boolean bed = event.isBedSpawn();
        Player player = event.getPlayer();
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(loc);
        if (res == null) {
            return;
        }
        if (!res.getPermissions().playerHas(player, Flags.move, FlagPermissions.FlagCombo.OnlyFalse)) {
            return;
        }
        if (bed.booleanValue()) {
            loc = player.getWorld().getSpawnLocation();
        }
        if ((res = this.plugin.getResidenceManager().getByLoc(loc)) != null && res.getPermissions().playerHas(player, Flags.move, FlagPermissions.FlagCombo.OnlyFalse)) {
            loc = res.getOutsideFreeLoc(loc, player);
        }
        this.plugin.msg((CommandSender)player, lm.General_NoSpawn, new Object[0]);
        event.setRespawnLocation(loc);
    }

    private boolean isContainer(Material mat, Block block) {
        return FlagPermissions.getMaterialUseFlagList().containsKey(mat) && FlagPermissions.getMaterialUseFlagList().get(mat).equals(Flags.container.getName()) || this.plugin.getConfigManager().getCustomContainers().contains(block.getTypeId());
    }

    private boolean isCanUseEntity_RClickOnly(Material mat, Block block) {
        switch (mat.name()) {
            case "REDSTONE_COMPARATOR": 
            case "DIODE_BLOCK_OFF": 
            case "DAYLIGHT_DETECTOR": 
            case "REDSTONE_COMPARATOR_OFF": 
            case "REDSTONE_COMPARATOR_ON": 
            case "DIODE_BLOCK_ON": 
            case "ITEM_FRAME": 
            case "WORKBENCH": 
            case "CAKE_BLOCK": 
            case "BED_BLOCK": 
            case "ANVIL": 
            case "DIODE": 
            case "NOTE_BLOCK": 
            case "DAYLIGHT_DETECTOR_INVERTED": 
            case "FLOWER_POT": 
            case "BREWING_STAND": 
            case "ENCHANTMENT_TABLE": 
            case "COMMAND": 
            case "BEACON": {
                return true;
            }
        }
        return this.plugin.getConfigManager().getCustomRightClick().contains(block.getTypeId());
    }

    private boolean isCanUseEntity(Material mat, Block block) {
        return this.plugin.getNms().isCanUseEntity_BothClick(mat, block) || this.isCanUseEntity_RClickOnly(mat, block);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerFireInteract(PlayerInteractEvent event) {
        boolean hasplace;
        if (event.getPlayer() == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Block relativeBlock = block.getRelative(event.getBlockFace());
        if (relativeBlock == null) {
            return;
        }
        Player player = event.getPlayer();
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(block.getLocation(), player);
        if (relativeBlock.getType() == Material.FIRE && !(hasplace = perms.playerHas(player.getName(), player.getWorld().getName(), Flags.place, perms.playerHas(player.getName(), player.getWorld().getName(), Flags.build, true)))) {
            event.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, Flags.build.getName());
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlatePress(PlayerInteractEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getAction() != Action.PHYSICAL) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Material mat = block.getType();
        Player player = event.getPlayer();
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(block.getLocation(), player);
        String world = player.getWorld().getName();
        boolean resadmin2 = this.plugin.isResAdminOn(player);
        if (!resadmin2) {
            boolean hasuse = perms.playerHas(player.getName(), world, Flags.use, true);
            boolean haspressure = perms.playerHas(player.getName(), world, Flags.pressure, hasuse);
            if (!((hasuse || haspressure) && haspressure || mat != Material.STONE_PLATE && mat != Material.WOOD_PLATE && !this.plugin.getNms().isPlate(mat))) {
                event.setCancelled(true);
                return;
            }
        }
        if (!(perms.playerHas(player.getName(), world, Flags.trample, perms.playerHas(player.getName(), world, Flags.build, true)) || mat != Material.SOIL && mat != Material.SOUL_SAND)) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSelection(PlayerInteractEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        int heldItemId = player.getItemInHand().getTypeId();
        if (heldItemId != this.plugin.getConfigManager().getSelectionTooldID()) {
            return;
        }
        if (this.plugin.getWepid() == this.plugin.getConfigManager().getSelectionTooldID()) {
            return;
        }
        if (player.getGameMode() == GameMode.CREATIVE) {
            event.setCancelled(true);
        }
        boolean resadmin2 = this.plugin.isResAdminOn(player);
        ResidencePlayer rPlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup group = rPlayer.getGroup();
        if (player.hasPermission("residence.select") || player.hasPermission("residence.create") && !player.isPermissionSet("residence.select") || group.canCreateResidences() && !player.isPermissionSet("residence.create") && !player.isPermissionSet("residence.select") || resadmin2) {
            Block block = event.getClickedBlock();
            if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
                Location loc = block.getLocation();
                this.plugin.getSelectionManager().placeLoc1(player, loc, true);
                this.plugin.msg((CommandSender)player, lm.Select_PrimaryPoint, this.plugin.msg(lm.General_CoordsTop, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
                event.setCancelled(true);
            } else if (event.getAction() == Action.RIGHT_CLICK_BLOCK && this.plugin.getNms().isMainHand(event)) {
                Location loc = block.getLocation();
                this.plugin.getSelectionManager().placeLoc2(player, loc, true);
                this.plugin.msg((CommandSender)player, lm.Select_SecondaryPoint, this.plugin.msg(lm.General_CoordsBottom, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
                event.setCancelled(true);
            }
            if (this.plugin.getSelectionManager().hasPlacedBoth(player.getName())) {
                this.plugin.getSelectionManager().showSelectionInfoInActionBar(player);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onInfoCheck(PlayerInteractEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        int heldItemId = item.getTypeId();
        if (heldItemId != this.plugin.getConfigManager().getInfoToolID()) {
            return;
        }
        Location loc = block.getLocation();
        String res = this.plugin.getResidenceManager().getNameByLoc(loc);
        if (res != null) {
            this.plugin.getResidenceManager().printAreaInfo(res, (CommandSender)player, false);
        } else {
            this.plugin.msg((CommandSender)player, lm.Residence_NoResHere, new Object[0]);
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack iih = this.plugin.getNms().itemInMainHand(player);
        Material heldItem = iih.getType();
        int heldItemId = iih.getTypeId();
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Material mat = block.getType();
        if (!(event.getAction() == Action.PHYSICAL || (this.isContainer(mat, block) || this.isCanUseEntity_RClickOnly(mat, block)) && event.getAction() == Action.RIGHT_CLICK_BLOCK || this.plugin.getNms().isCanUseEntity_BothClick(mat, block) || heldItemId == this.plugin.getConfigManager().getSelectionTooldID() || heldItemId == this.plugin.getConfigManager().getInfoToolID() || heldItem == Material.INK_SACK || this.plugin.getNms().isArmorStandMaterial(heldItem) || this.plugin.getNms().isBoat(heldItem))) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        String world = player.getWorld().getName();
        String permgroup = this.plugin.getPermissionManager().getGroupNameByPlayer(player);
        boolean resadmin2 = this.plugin.isResAdminOn(player);
        if (!resadmin2 && !this.plugin.getItemManager().isAllowed(heldItem, permgroup, world)) {
            this.plugin.msg((CommandSender)player, lm.General_ItemBlacklisted, new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (resadmin2) {
            return;
        }
        int blockId = block.getTypeId();
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(block.getLocation(), player);
        if (heldItem != null && event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            if (heldItem == Material.INK_SACK && (this.plugin.getNms().itemInMainHand(player).getData().getData() == 15 && block.getType() == Material.GRASS || iih.getData().getData() == 3 && blockId == 17 && (block.getData() == 3 || block.getData() == 7 || block.getData() == 11 || block.getData() == 15)) && !(perms = this.plugin.getPermsByLocForPlayer(block.getRelative(event.getBlockFace()).getLocation(), player)).playerHas(player.getName(), world, Flags.build, true)) {
                this.plugin.msg((CommandSender)player, lm.Flag_Deny, Flags.build.getName());
                event.setCancelled(true);
                return;
            }
            if ((this.plugin.getNms().isArmorStandMaterial(heldItem) || this.plugin.getNms().isBoat(heldItem)) && !(perms = this.plugin.getPermsByLocForPlayer(block.getRelative(event.getBlockFace()).getLocation(), player)).playerHas(player.getName(), world, Flags.build, true)) {
                this.plugin.msg((CommandSender)player, lm.Flag_Deny, Flags.build.getName());
                event.setCancelled(true);
                return;
            }
        }
        if (this.isContainer(mat, block) || this.isCanUseEntity(mat, block)) {
            boolean hasuse = perms.playerHas(player.getName(), world, Flags.use, true);
            for (Map.Entry<Material, String> checkMat : FlagPermissions.getMaterialUseFlagList().entrySet()) {
                if (mat != checkMat.getKey() || perms.playerHas(player.getName(), world, checkMat.getValue(), hasuse)) continue;
                if (hasuse || checkMat.getValue().equals(Flags.container.getName())) {
                    event.setCancelled(true);
                    this.plugin.msg((CommandSender)player, lm.Flag_Deny, checkMat.getValue());
                    return;
                }
                event.setCancelled(true);
                this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.use});
                return;
            }
            if (this.plugin.getConfigManager().getCustomContainers().contains(blockId) && !perms.playerHas(player.getName(), world, Flags.container, hasuse)) {
                event.setCancelled(true);
                this.plugin.msg((CommandSender)player, lm.Flag_Deny, Flags.container.getName());
                return;
            }
            if (this.plugin.getConfigManager().getCustomBothClick().contains(blockId) && !hasuse) {
                event.setCancelled(true);
                this.plugin.msg((CommandSender)player, lm.Flag_Deny, Flags.use.getName());
                return;
            }
            if (this.plugin.getConfigManager().getCustomRightClick().contains(blockId) && event.getAction() == Action.RIGHT_CLICK_BLOCK && !hasuse) {
                event.setCancelled(true);
                this.plugin.msg((CommandSender)player, lm.Flag_Deny, Flags.use.getName());
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerTradeEntity(PlayerInteractEntityEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (ent.getType() != EntityType.VILLAGER) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
        if (res != null && res.getPermissions().playerHas(player, Flags.trade, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, Flags.trade.getName(), res.getName());
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteractWithHorse(PlayerInteractEntityEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (ent.getType() != EntityType.HORSE) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
        if (res == null) {
            return;
        }
        if (!res.isOwner(player) && res.getPermissions().playerHas(player, Flags.container, FlagPermissions.FlagCombo.OnlyFalse) && player.isSneaking()) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, Flags.container.getName(), res.getName());
            event.setCancelled(true);
        } else if (!res.isOwner(player) && !res.getPermissions().playerHas(player.getName(), Flags.riding, FlagPermissions.FlagCombo.TrueOrNone)) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, Flags.riding.getName(), res.getName());
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteractWithMinecartStorage(PlayerInteractEntityEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (ent.getType() != EntityType.MINECART_CHEST && ent.getType() != EntityType.MINECART_HOPPER) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
        if (res == null) {
            return;
        }
        if (!res.isOwner(player) && res.getPermissions().playerHas(player, Flags.container, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, Flags.container.getName(), res.getName());
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteractWithMinecart(PlayerInteractEntityEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (ent.getType() != EntityType.MINECART && ent.getType() != EntityType.BOAT) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
        if (res == null) {
            return;
        }
        if (!res.isOwner(player) && res.getPermissions().playerHas(player, Flags.riding, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, Flags.riding.getName(), res.getName());
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerDyeSheep(PlayerInteractEntityEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (ent.getType() != EntityType.SHEEP) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
        if (res == null) {
            return;
        }
        if (!res.isOwner(player) && res.getPermissions().playerHas(player, Flags.dye, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, Flags.dye.getName(), res.getName());
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerShearEntity(PlayerShearEntityEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getEntity();
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
        if (res == null) {
            return;
        }
        if (!res.isOwner(player) && res.getPermissions().playerHas(player, Flags.shear, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, Flags.shear.getName(), res.getName());
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerItemFrameInteract(PlayerInteractEntityEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (!(ent instanceof Hanging)) {
            return;
        }
        Hanging hanging = (Hanging)ent;
        if (hanging.getType() != EntityType.ITEM_FRAME) {
            return;
        }
        Material heldItem = this.plugin.getNms().itemInMainHand(player).getType();
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(ent.getLocation(), player);
        String world = player.getWorld().getName();
        String permgroup = this.plugin.getPermissionManager().getGroupNameByPlayer(player);
        if (!this.plugin.getItemManager().isAllowed(heldItem, permgroup, world)) {
            this.plugin.msg((CommandSender)player, lm.General_ItemBlacklisted, new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (!perms.playerHas(player.getName(), world, Flags.container, perms.playerHas(player.getName(), world, Flags.use, true))) {
            event.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, Flags.container.getName());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        FlagPermissions perms;
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Location loc = event.getBlockClicked().getLocation();
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(loc);
        if (res != null) {
            if (this.plugin.getConfigManager().preventRentModify() && this.plugin.getConfigManager().enabledRentSystem() && this.plugin.getRentManager().isRented(res.getName())) {
                this.plugin.msg((CommandSender)player, lm.Rent_ModifyDeny, new Object[0]);
                event.setCancelled(true);
                return;
            }
            Material mat = event.getBucket();
            if (res.getPermissions().playerHas(player, Flags.build, FlagPermissions.FlagCombo.OnlyFalse) && this.plugin.getConfigManager().getNoPlaceWorlds().contains(loc.getWorld().getName()) && (mat == Material.LAVA_BUCKET || mat == Material.WATER_BUCKET)) {
                this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.build});
                event.setCancelled(true);
                return;
            }
        }
        if (!(perms = this.plugin.getPermsByLocForPlayer(loc, player)).playerHas(player, Flags.build, true)) {
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, Flags.build.getName());
            event.setCancelled(true);
            return;
        }
        Material mat = event.getBucket();
        int level = this.plugin.getConfigManager().getPlaceLevel();
        if (res == null && this.plugin.getConfigManager().isNoLavaPlace() && loc.getBlockY() >= level - 1 && this.plugin.getConfigManager().getNoPlaceWorlds().contains(loc.getWorld().getName()) && mat == Material.LAVA_BUCKET) {
            if (!this.plugin.msg(lm.General_CantPlaceLava, new Object[0]).equalsIgnoreCase("")) {
                this.plugin.msg((CommandSender)player, lm.General_CantPlaceLava, level);
            }
            event.setCancelled(true);
            return;
        }
        if (res == null && this.plugin.getConfigManager().isNoWaterPlace() && loc.getBlockY() >= level - 1 && this.plugin.getConfigManager().getNoPlaceWorlds().contains(loc.getWorld().getName()) && mat == Material.WATER_BUCKET) {
            if (!this.plugin.msg(lm.General_CantPlaceWater, new Object[0]).equalsIgnoreCase("")) {
                this.plugin.msg((CommandSender)player, lm.General_CantPlaceWater, level);
            }
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerBucketFill(PlayerBucketFillEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(event.getBlockClicked().getLocation());
        if (res != null && this.plugin.getConfigManager().preventRentModify() && this.plugin.getConfigManager().enabledRentSystem() && this.plugin.getRentManager().isRented(res.getName())) {
            this.plugin.msg((CommandSender)player, lm.Rent_ModifyDeny, new Object[0]);
            event.setCancelled(true);
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(event.getBlockClicked().getLocation(), player);
        boolean hasdestroy = perms.playerHas(player, Flags.destroy, perms.playerHas(player, Flags.build, true));
        if (!hasdestroy) {
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, Flags.destroy.getName());
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        Location loc = event.getTo();
        if (this.plugin.isResAdminOn(player)) {
            this.handleNewLocation(player, loc, false);
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(loc);
        if (res == null) {
            return;
        }
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.COMMAND || event.getCause() == PlayerTeleportEvent.TeleportCause.NETHER_PORTAL || event.getCause() == PlayerTeleportEvent.TeleportCause.PLUGIN) {
            if (res.getPermissions().playerHas(player, Flags.move, FlagPermissions.FlagCombo.OnlyFalse) && !res.isOwner(player)) {
                event.setCancelled(true);
                this.plugin.msg((CommandSender)player, lm.Residence_MoveDeny, res.getName());
                return;
            }
        } else if (event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL && res.getPermissions().playerHas(player, Flags.enderpearl, FlagPermissions.FlagCombo.OnlyFalse)) {
            event.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, Flags.enderpearl.getName(), res.getName());
            return;
        }
        if ((event.getCause() == PlayerTeleportEvent.TeleportCause.PLUGIN || event.getCause() == PlayerTeleportEvent.TeleportCause.COMMAND) && this.plugin.getConfigManager().isBlockAnyTeleportation() && !res.isOwner(player) && res.getPermissions().playerHas(player, Flags.tp, FlagPermissions.FlagCombo.OnlyFalse) && !player.hasPermission("residence.admin.tp")) {
            event.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.General_TeleportDeny, res.getName());
            return;
        }
        if (this.plugin.getNms().isChorusTeleport(event.getCause()) && !res.isOwner(player) && res.getPermissions().playerHas(player, Flags.chorustp, FlagPermissions.FlagCombo.OnlyFalse) && !player.hasPermission("residence.admin.tp")) {
            event.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, Flags.chorustp.getName(), res.getName());
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerDeath(final PlayerDeathEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        Location loc = player.getLocation();
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(loc);
        if (res == null) {
            return;
        }
        if (res.getPermissions().has(Flags.keepinv, false)) {
            event.setKeepInventory(true);
        }
        if (res.getPermissions().has(Flags.keepexp, false)) {
            event.setKeepLevel(true);
            event.setDroppedExp(0);
        }
        if (res.getPermissions().has(Flags.respawn, false) && Bukkit.getVersion().toString().contains("Spigot")) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    try {
                        event.getEntity().spigot().respawn();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, 1L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceChange(ResidenceChangedEvent event) {
        ClaimedResidence res = event.getTo();
        ClaimedResidence ResOld = event.getFrom();
        Player player = event.getPlayer();
        if (res == null && ResOld != null) {
            if (ResOld.getPermissions().has(Flags.night, FlagPermissions.FlagCombo.OnlyTrue) || ResOld.getPermissions().has(Flags.day, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.resetPlayerTime();
            }
            if (ResOld.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue) || ResOld.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setWalkSpeed(0.2f);
            }
            if (ResOld.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue) || ResOld.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.resetPlayerWeather();
            }
            if (this.plugin.getVersionChecker().GetVersion() > 1900 && ResOld.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setGlowing(false);
            }
        }
        if (res != null && ResOld != null && res != ResOld) {
            if (this.plugin.getVersionChecker().GetVersion() > 1900) {
                if (res.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue)) {
                    player.setGlowing(true);
                } else if (ResOld.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue) && !res.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue)) {
                    player.setGlowing(false);
                }
            }
            if (res.getPermissions().has(Flags.day, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerTime(6000L, false);
            } else if (ResOld.getPermissions().has(Flags.day, FlagPermissions.FlagCombo.OnlyTrue) && !res.getPermissions().has(Flags.day, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.resetPlayerTime();
            }
            if (res.getPermissions().has(Flags.night, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerTime(14000L, false);
            } else if (ResOld.getPermissions().has(Flags.night, FlagPermissions.FlagCombo.OnlyTrue) && !res.getPermissions().has(Flags.night, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.resetPlayerTime();
            }
            if (res.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setWalkSpeed(this.plugin.getConfigManager().getWalkSpeed1().floatValue());
            } else if (ResOld.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue) && !res.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setWalkSpeed(0.2f);
            }
            if (res.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setWalkSpeed(this.plugin.getConfigManager().getWalkSpeed2().floatValue());
            } else if (ResOld.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue) && !res.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setWalkSpeed(0.2f);
            }
            if (res.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerWeather(WeatherType.CLEAR);
            } else if (ResOld.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue) && !res.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.resetPlayerWeather();
            }
            if (res.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerWeather(WeatherType.DOWNFALL);
            } else if (ResOld.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue) && !res.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.resetPlayerWeather();
            }
        }
        if (res != null && ResOld == null) {
            if (this.plugin.getVersionChecker().GetVersion() > 1900 && res.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setGlowing(true);
            }
            if (res.getPermissions().has(Flags.day, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerTime(6000L, false);
            }
            if (res.getPermissions().has(Flags.night, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerTime(14000L, false);
            }
            if (res.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setWalkSpeed(this.plugin.getConfigManager().getWalkSpeed1().floatValue());
            }
            if (res.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setWalkSpeed(this.plugin.getConfigManager().getWalkSpeed2().floatValue());
            }
            if (res.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerWeather(WeatherType.CLEAR);
            }
            if (res.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerWeather(WeatherType.DOWNFALL);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        Location locfrom = event.getFrom();
        Location locto = event.getTo();
        if (locfrom.getBlockX() == locto.getBlockX() && locfrom.getBlockY() == locto.getBlockY() && locfrom.getBlockZ() == locto.getBlockZ()) {
            return;
        }
        String name = player.getName();
        if (name == null) {
            return;
        }
        Long last = this.lastUpdate.get(name);
        long now = System.currentTimeMillis();
        if (last != null && now - last < (long)this.plugin.getConfigManager().getMinMoveUpdateInterval()) {
            return;
        }
        this.lastUpdate.put(name, now);
        this.handleNewLocation(player, locto, true);
        if (!this.plugin.getTeleportDelayMap().isEmpty() && this.plugin.getConfigManager().getTeleportDelay() > 0 && this.plugin.getTeleportDelayMap().contains(player.getName())) {
            this.plugin.getTeleportDelayMap().remove(player.getName());
            this.plugin.msg((CommandSender)player, lm.General_TeleportCanceled, new Object[0]);
            if (this.plugin.getConfigManager().isTeleportTitleMessage()) {
                this.plugin.getAB().sendTitle(player, "", "");
            }
        }
    }

    public void handleNewLocation(final Player player, Location loc, boolean move) {
        ClaimedResidence res;
        String pname = player.getName();
        ClaimedResidence orres = res = this.plugin.getResidenceManager().getByLoc(loc);
        String areaname = null;
        String subzone2 = null;
        if (res != null) {
            areaname = res.getName();
            while (res.getSubzoneByLoc(loc) != null) {
                res = res.getSubzoneByLoc(player.getLocation());
                subzone2 = res.getName();
                areaname = String.valueOf(areaname) + "." + subzone2;
            }
        }
        ClaimedResidence ResOld = null;
        if (this.currentRes.containsKey(pname)) {
            ResOld = this.plugin.getResidenceManager().getByName(this.currentRes.get(pname));
            if (ResOld == null) {
                this.currentRes.remove(pname);
            } else if (res != null && ResOld.getName().equals(res.getName())) {
                if (player.isFlying() && res.getPermissions().playerHas(pname, Flags.nofly, FlagPermissions.FlagCombo.OnlyTrue) && !this.plugin.isResAdminOn(player) && !player.hasPermission("residence.nofly.bypass") && !res.isOwner(player)) {
                    Location lc = player.getLocation();
                    Location location = new Location(lc.getWorld(), lc.getX(), (double)lc.getBlockY(), lc.getZ());
                    location.setPitch(lc.getPitch());
                    location.setYaw(lc.getYaw());
                    int from = location.getBlockY();
                    int maxH = location.getWorld().getMaxHeight() - 1;
                    int i = 0;
                    while (i < maxH) {
                        location.setY((double)(from - i));
                        Block block = location.getBlock();
                        if (!this.plugin.getNms().isEmptyBlock(block)) {
                            location.setY((double)(from - i + 1));
                            break;
                        }
                        if (location.getBlockY() <= 0) {
                            Location lastLoc = this.lastOutsideLoc.get(pname);
                            if (lastLoc != null) {
                                player.teleport(lastLoc);
                            } else {
                                player.teleport(res.getOutsideFreeLoc(loc, player));
                            }
                            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, Flags.nofly.getName(), orres.getName());
                            return;
                        }
                        ++i;
                    }
                    this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, Flags.nofly.getName(), orres.getName());
                    player.teleport(location);
                    player.setFlying(false);
                    player.setAllowFlight(false);
                }
                this.lastOutsideLoc.put(pname, loc);
                return;
            }
        }
        if (!this.plugin.getAutoSelectionManager().getList().isEmpty()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    ResidencePlayerListener.this.plugin.getAutoSelectionManager().UpdateSelection(player);
                }
            });
        }
        if (res == null) {
            this.lastOutsideLoc.put(pname, loc);
            if (ResOld != null) {
                String leave = ResOld.getLeaveMessage();
                ResidenceChangedEvent chgEvent = new ResidenceChangedEvent(ResOld, null, player);
                this.plugin.getServ().getPluginManager().callEvent((Event)chgEvent);
                if (leave != null && !leave.equals("")) {
                    if (this.plugin.getConfigManager().useActionBar()) {
                        this.plugin.getAB().send(player, ChatColor.YELLOW + this.insertMessages(player, ResOld.getName(), ResOld, leave));
                    } else {
                        this.plugin.msg(player, ChatColor.YELLOW + this.insertMessages(player, ResOld.getName(), ResOld, leave));
                    }
                }
                this.currentRes.remove(pname);
            }
            return;
        }
        if (move) {
            if (res.getPermissions().playerHas(pname, Flags.move, FlagPermissions.FlagCombo.OnlyFalse) && !this.plugin.isResAdminOn(player) && !res.isOwner(player) && !player.hasPermission("residence.admin.move")) {
                ClaimedResidence preRes;
                Location lastLoc = this.lastOutsideLoc.get(pname);
                if (this.plugin.getConfigManager().BounceAnimation()) {
                    Visualizer v = new Visualizer(player);
                    v.setErrorAreas(res);
                    v.setOnce(true);
                    this.plugin.getSelectionManager().showBounds(player, v);
                }
                if ((preRes = this.plugin.getResidenceManager().getByLoc(lastLoc)) != null && preRes.getPermissions().playerHas(pname, Flags.tp, FlagPermissions.FlagCombo.OnlyFalse) && !player.hasPermission("residence.admin.tp")) {
                    Location newLoc = res.getOutsideFreeLoc(loc, player);
                    player.teleport(newLoc);
                } else if (lastLoc != null) {
                    player.teleport(lastLoc);
                } else {
                    Location newLoc = res.getOutsideFreeLoc(loc, player);
                    player.teleport(newLoc);
                }
                if (this.plugin.getConfigManager().useActionBar()) {
                    this.plugin.getAB().send(player, this.plugin.msg(lm.Residence_MoveDeny, orres.getName()));
                } else {
                    this.plugin.msg((CommandSender)player, lm.Residence_MoveDeny, orres.getName());
                }
                return;
            }
            if (player.isFlying() && res.getPermissions().playerHas(pname, Flags.nofly, FlagPermissions.FlagCombo.OnlyTrue) && !this.plugin.isResAdminOn(player) && !player.hasPermission("residence.nofly.bypass") && !res.isOwner(player)) {
                Location lc = player.getLocation();
                Location location = new Location(lc.getWorld(), lc.getX(), (double)lc.getBlockY(), lc.getZ());
                location.setPitch(lc.getPitch());
                location.setYaw(lc.getYaw());
                int from = location.getBlockY();
                int maxH = location.getWorld().getMaxHeight() - 1;
                int i = 0;
                while (i < maxH) {
                    location.setY((double)(from - i));
                    Block block = location.getBlock();
                    if (!this.plugin.getNms().isEmptyBlock(block)) {
                        location.setY((double)(from - i + 1));
                        break;
                    }
                    if (location.getBlockY() <= 0) {
                        Location lastLoc = this.lastOutsideLoc.get(pname);
                        if (lastLoc != null) {
                            player.teleport(lastLoc);
                        } else {
                            player.teleport(res.getOutsideFreeLoc(loc, player));
                        }
                        this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, Flags.nofly.getName(), orres.getName());
                        return;
                    }
                    ++i;
                }
                this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, Flags.nofly.getName(), orres.getName());
                player.teleport(location);
                player.setFlying(false);
                player.setAllowFlight(false);
            }
        }
        this.lastOutsideLoc.put(pname, loc);
        if (!this.currentRes.containsKey(pname) || ResOld != res) {
            this.currentRes.put(pname, areaname);
            ClaimedResidence chgFrom = null;
            if (ResOld != res && ResOld != null) {
                String leave = ResOld.getLeaveMessage();
                chgFrom = ResOld;
                if (leave != null && !leave.equals("") && ResOld != res.getParent()) {
                    if (this.plugin.getConfigManager().useActionBar()) {
                        this.plugin.getAB().send(player, ChatColor.YELLOW + this.insertMessages(player, ResOld.getName(), ResOld, leave));
                    } else {
                        this.plugin.msg(player, ChatColor.YELLOW + this.insertMessages(player, ResOld.getName(), ResOld, leave));
                    }
                }
            }
            String enterMessage = res.getEnterMessage();
            ResidenceChangedEvent chgEvent = new ResidenceChangedEvent(chgFrom, res, player);
            this.plugin.getServ().getPluginManager().callEvent((Event)chgEvent);
            if (ResOld == null || res != ResOld.getParent()) {
                if (this.plugin.getConfigManager().isExtraEnterMessage() && !res.isOwner(player) && (this.plugin.getRentManager().isForRent(areaname) || this.plugin.getTransactionManager().isForSale(areaname))) {
                    if (this.plugin.getRentManager().isForRent(areaname) && !this.plugin.getRentManager().isRented(areaname)) {
                        RentableLand rentable = this.plugin.getRentManager().getRentableLand(areaname);
                        if (rentable != null) {
                            this.plugin.getAB().send(player, this.plugin.msg(lm.Residence_CanBeRented, areaname, rentable.cost, rentable.days));
                        }
                    } else if (this.plugin.getTransactionManager().isForSale(areaname) && !res.isOwner(player)) {
                        int sale = this.plugin.getTransactionManager().getSaleAmount(areaname);
                        this.plugin.getAB().send(player, this.plugin.msg(lm.Residence_CanBeBought, areaname, sale));
                    }
                } else if (enterMessage != null && !enterMessage.equals("")) {
                    if (this.plugin.getConfigManager().useActionBar()) {
                        this.plugin.getAB().send(player, ChatColor.YELLOW + this.insertMessages(player, areaname, res, enterMessage));
                    } else {
                        this.plugin.msg(player, ChatColor.YELLOW + this.insertMessages(player, areaname, res, enterMessage));
                    }
                }
            }
        }
    }

    public String insertMessages(Player player, String areaname, ClaimedResidence res, String message2) {
        try {
            message2 = message2.replaceAll("%player", player.getName());
            message2 = message2.replaceAll("%owner", res.getPermissions().getOwner());
            message2 = message2.replaceAll("%residence", areaname);
        }
        catch (Exception ex) {
            return "";
        }
        return message2;
    }

    public void doHeals() {
        try {
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                Player damage;
                double health;
                String resname = this.plugin.getPlayerListener().getCurrentResidenceName(player.getName());
                ClaimedResidence res = null;
                if (resname == null || !(res = this.plugin.getResidenceManager().getByName(resname)).getPermissions().has(Flags.healing, false) || !((health = (damage = player).getHealth()) < damage.getMaxHealth()) || player.isDead()) continue;
                player.setHealth(health + 1.0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void feed() {
        try {
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                int food;
                ClaimedResidence res;
                String resname = this.plugin.getPlayerListener().getCurrentResidenceName(player.getName());
                if (resname == null || !(res = this.plugin.getResidenceManager().getByName(resname)).getPermissions().has(Flags.feed, false) || (food = player.getFoodLevel()) >= 20 || player.isDead()) continue;
                player.setFoodLevel(food + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void DespawnMobs() {
        try {
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                String resname = this.plugin.getPlayerListener().getCurrentResidenceName(player.getName());
                if (resname == null) continue;
                ClaimedResidence res = null;
                res = this.plugin.getResidenceManager().getByName(resname);
                if (!res.getPermissions().has(Flags.nomobs, false)) continue;
                List entities = Bukkit.getServer().getWorld(res.getWorld()).getEntities();
                for (Entity ent : entities) {
                    if (!ResidenceEntityListener.isMonster(ent) || !res.containsLoc(ent.getLocation())) continue;
                    ent.remove();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        String pname = event.getPlayer().getName();
        if (!this.chatenabled || !this.playerToggleChat.contains(pname)) {
            return;
        }
        ChatChannel channel = this.plugin.getChatManager().getPlayerChannel(pname);
        if (channel != null) {
            channel.chat(pname, event.getMessage());
        }
        event.setCancelled(true);
    }

    public void tooglePlayerResidenceChat(Player player, String residence) {
        String pname = player.getName();
        this.playerToggleChat.add(pname);
        this.plugin.msg((CommandSender)player, lm.Chat_ChatChannelChange, residence);
    }

    public void removePlayerResidenceChat(String pname) {
        this.playerToggleChat.remove(pname);
        Player player = Bukkit.getPlayer((String)pname);
        if (player != null) {
            this.plugin.msg((CommandSender)player, lm.Chat_ChatChannelLeave, new Object[0]);
        }
    }

    public void removePlayerResidenceChat(Player player) {
        String pname = player.getName();
        this.playerToggleChat.remove(pname);
        this.plugin.msg((CommandSender)player, lm.Chat_ChatChannelLeave, new Object[0]);
    }

    public String getCurrentResidenceName(String player) {
        return this.currentRes.get(player);
    }
}

