/*
 * Decompiled with CFR 0.152.
 */
package lib.PatPeter.SQLibrary;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Logger;
import lib.PatPeter.SQLibrary.DBMS;
import lib.PatPeter.SQLibrary.HostnameDatabase;
import lib.PatPeter.SQLibrary.StatementEnum;

public class FrontBase
extends HostnameDatabase {
    public FrontBase(Logger log, String prefix, String hostname, int port, String database, String username, String password) {
        super(log, prefix, DBMS.FrontBase, hostname, port, database, username, password);
    }

    public FrontBase(Logger log, String prefix, String database, String username, String password) {
        super(log, prefix, DBMS.FrontBase, "localhost", 20020, database, username, password);
    }

    public FrontBase(Logger log, String prefix, String database, String username) {
        super(log, prefix, DBMS.FrontBase, "localhost", 20020, database, username, "");
    }

    public FrontBase(Logger log, String prefix, String database) {
        super(log, prefix, DBMS.FrontBase, "localhost", 20020, database, "", "");
    }

    @Override
    protected boolean initialize() {
        try {
            Class.forName("om.frontbase.jdbc.FBJDriver");
            return true;
        }
        catch (ClassNotFoundException e) {
            this.error("FrontBase driver class missing: " + e.getMessage() + ".");
            return false;
        }
    }

    @Override
    public boolean open() {
        if (this.initialize()) {
            String url = "jdbc:FrontBase://" + this.getHostname() + ":" + this.getPort() + "/" + this.getDatabase() + ";";
            try {
                this.connection = DriverManager.getConnection(url, this.getUsername(), this.getPassword());
                return true;
            }
            catch (SQLException e) {
                this.error("Could not establish a FrontBase connection, SQLException: " + e.getMessage());
                return false;
            }
        }
        return false;
    }

    @Override
    protected void queryValidation(StatementEnum statement) throws SQLException {
    }

    @Override
    public StatementEnum getStatement(String query) throws SQLException {
        String[] statement = query.trim().split(" ", 2);
        try {
            Statements converted = Statements.valueOf(statement[0].toUpperCase());
            return converted;
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Unknown statement: \"" + statement[0] + "\".");
        }
    }

    @Override
    public boolean isTable(String table) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean truncate(String table) {
        throw new UnsupportedOperationException();
    }

    public static enum Statements implements StatementEnum
    {

    }
}

