/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.commands;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.CommandAnnotation;
import com.bekvon.bukkit.residence.containers.ConfigReader;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.cmd;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class select
implements cmd {
    @Override
    @CommandAnnotation(simple=true, priority=1300)
    public boolean perform(Residence plugin, String[] args, boolean resadmin2, Command command2, CommandSender sender) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        ResidencePlayer rPlayer = plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup group = rPlayer.getGroup();
        if (!group.selectCommandAccess() && !resadmin2) {
            plugin.msg((CommandSender)player, lm.Select_Disabled, new Object[0]);
            return true;
        }
        if (!group.canCreateResidences() && rPlayer.getMaxSubzones() <= 0 && !resadmin2) {
            plugin.msg((CommandSender)player, lm.Select_Disabled, new Object[0]);
            return true;
        }
        if (!player.hasPermission("residence.create") && player.isPermissionSet("residence.create") && !player.hasPermission("residence.select") && player.isPermissionSet("residence.select") && !resadmin2) {
            plugin.msg((CommandSender)player, lm.Select_Disabled, new Object[0]);
            return true;
        }
        if (args.length == 2) {
            if (args[1].equals("size") || args[1].equals("cost")) {
                if (plugin.getSelectionManager().hasPlacedBoth(player.getName())) {
                    try {
                        plugin.getSelectionManager().showSelectionInfo(player);
                        return true;
                    }
                    catch (Exception ex) {
                        Logger.getLogger(Residence.class.getName()).log(Level.SEVERE, null, ex);
                        return true;
                    }
                }
                if (plugin.getSelectionManager().worldEdit(player)) {
                    try {
                        plugin.getSelectionManager().showSelectionInfo(player);
                        return true;
                    }
                    catch (Exception ex) {
                        Logger.getLogger(Residence.class.getName()).log(Level.SEVERE, null, ex);
                        return true;
                    }
                }
            } else {
                if (args[1].equals("vert")) {
                    plugin.getSelectionManager().vert(player, resadmin2);
                    return true;
                }
                if (args[1].equals("sky")) {
                    plugin.getSelectionManager().sky(player, resadmin2);
                    return true;
                }
                if (args[1].equals("bedrock")) {
                    plugin.getSelectionManager().bedrock(player, resadmin2);
                    return true;
                }
                if (args[1].equals("coords")) {
                    Location playerLoc2;
                    plugin.msg((CommandSender)player, lm.General_Separator, new Object[0]);
                    Location playerLoc1 = plugin.getSelectionManager().getPlayerLoc1(player.getName());
                    if (playerLoc1 != null) {
                        plugin.msg((CommandSender)player, lm.Select_Primary, plugin.msg(lm.General_CoordsTop, playerLoc1.getBlockX(), playerLoc1.getBlockY(), playerLoc1.getBlockZ()));
                    }
                    if ((playerLoc2 = plugin.getSelectionManager().getPlayerLoc2(player.getName())) != null) {
                        plugin.msg((CommandSender)player, lm.Select_Secondary, plugin.msg(lm.General_CoordsBottom, playerLoc2.getBlockX(), playerLoc2.getBlockY(), playerLoc2.getBlockZ()));
                    }
                    plugin.msg((CommandSender)player, lm.General_Separator, new Object[0]);
                    return true;
                }
                if (args[1].equals("chunk")) {
                    plugin.getSelectionManager().selectChunk(player);
                    return true;
                }
                if (args[1].equals("worldedit")) {
                    if (plugin.getSelectionManager().worldEdit(player)) {
                        plugin.msg((CommandSender)player, lm.Select_Success, new Object[0]);
                    }
                    return true;
                }
            }
        } else if (args.length == 3) {
            if (args[1].equals("expand")) {
                int amount;
                try {
                    amount = Integer.parseInt(args[2]);
                }
                catch (Exception ex) {
                    plugin.msg((CommandSender)player, lm.Invalid_Amount, new Object[0]);
                    return true;
                }
                plugin.getSelectionManager().modify(player, false, amount);
                return true;
            }
            if (args[1].equals("shift")) {
                int amount;
                try {
                    amount = Integer.parseInt(args[2]);
                }
                catch (Exception ex) {
                    plugin.msg((CommandSender)player, lm.Invalid_Amount, new Object[0]);
                    return true;
                }
                plugin.getSelectionManager().modify(player, true, amount);
                return true;
            }
        }
        if ((args.length == 2 || args.length == 3) && args[1].equals("auto")) {
            Player target = player;
            if (args.length == 3) {
                if (!plugin.hasPermission((CommandSender)player, "residence.select.auto.others")) {
                    return true;
                }
                target = Bukkit.getPlayer((String)args[2]);
                if (target == null) {
                    plugin.msg((CommandSender)player, lm.General_NotOnline, new Object[0]);
                    return true;
                }
            }
            plugin.getAutoSelectionManager().switchAutoSelection(target);
            return true;
        }
        if (args.length > 1 && args[1].equals("residence")) {
            String areaName;
            ClaimedResidence res = null;
            res = args.length > 2 ? plugin.getResidenceManager().getByName(args[2]) : plugin.getResidenceManager().getByLoc(player.getLocation());
            if (res == null) {
                plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
                return true;
            }
            String resName = res.getName();
            CuboidArea area2 = null;
            if (args.length > 3) {
                area2 = res.getArea(args[3]);
                areaName = args[3];
            } else {
                areaName = res.getAreaIDbyLoc(player.getLocation());
                area2 = res.getArea(areaName);
            }
            if (area2 != null) {
                plugin.getSelectionManager().placeLoc1(player, area2.getHighLoc(), false);
                plugin.getSelectionManager().placeLoc2(player, area2.getLowLoc(), true);
                plugin.msg((CommandSender)player, lm.Select_Area, areaName, resName);
            } else {
                plugin.msg((CommandSender)player, lm.Area_NonExist, new Object[0]);
            }
            return true;
        }
        try {
            plugin.getSelectionManager().selectBySize(player, Integer.parseInt(args[1]), Integer.parseInt(args[2]), Integer.parseInt(args[3]));
            return true;
        }
        catch (Exception ex) {
            plugin.msg((CommandSender)player, lm.Select_Fail, new Object[0]);
            return true;
        }
    }

    @Override
    public void getLocale(ConfigReader c, String path) {
        c.get(String.valueOf(path) + "Description", "Selection Commands");
        c.get(String.valueOf(path) + "Info", Arrays.asList("This command selects areas for usage with residence.", "/res select [x] [y] [z] - selects a radius of blocks, with you in the middle."));
        path = String.valueOf(path) + "SubCommands.";
        c.get(String.valueOf(path) + "coords.Description", "Display selected coordinates");
        c.get(String.valueOf(path) + "coords.Info", Arrays.asList("&eUsage: &6/res select coords"));
        c.get(String.valueOf(path) + "size.Description", "Display selected size");
        c.get(String.valueOf(path) + "size.Info", Arrays.asList("&eUsage: &6/res select size"));
        c.get(String.valueOf(path) + "auto.Description", "Turns on auto selection tool");
        c.get(String.valueOf(path) + "auto.Info", Arrays.asList("&eUsage: &6/res select auto [playername]"));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "auto"), Arrays.asList("[playername]"));
        c.get(String.valueOf(path) + "cost.Description", "Display selection cost");
        c.get(String.valueOf(path) + "cost.Info", Arrays.asList("&eUsage: &6/res select cost"));
        c.get(String.valueOf(path) + "vert.Description", "Expand Selection Vertically");
        c.get(String.valueOf(path) + "vert.Info", Arrays.asList("&eUsage: &6/res select vert", "Will expand selection as high and as low as allowed."));
        c.get(String.valueOf(path) + "sky.Description", "Expand Selection to Sky");
        c.get(String.valueOf(path) + "sky.Info", Arrays.asList("&eUsage: &6/res select sky", "Expands as high as your allowed to go."));
        c.get(String.valueOf(path) + "bedrock.Description", "Expand Selection to Bedrock");
        c.get(String.valueOf(path) + "bedrock.Info", Arrays.asList("&eUsage: &6/res select bedrock", "Expands as low as your allowed to go."));
        c.get(String.valueOf(path) + "expand.Description", "Expand selection in a direction.");
        c.get(String.valueOf(path) + "expand.Info", Arrays.asList("&eUsage: &6/res select expand <amount>", "Expands <amount> in the direction your looking."));
        c.get(String.valueOf(path) + "shift.Description", "Shift selection in a direction");
        c.get(String.valueOf(path) + "shift.Info", Arrays.asList("&eUsage: &6/res select shift <amount>", "Pushes your selection by <amount> in the direction your looking."));
        c.get(String.valueOf(path) + "chunk.Description", "Select the chunk your currently in.");
        c.get(String.valueOf(path) + "chunk.Info", Arrays.asList("&eUsage: &6/res select chunk", "Selects the chunk your currently standing in."));
        c.get(String.valueOf(path) + "residence.Description", "Select a existing area in a residence.");
        c.get(String.valueOf(path) + "residence.Info", Arrays.asList("&eUsage: &6/res select residence <residence>", "Selects a existing area in a residence."));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "residence"), Arrays.asList("[residence]"));
        c.get(String.valueOf(path) + "worldedit.Description", "Set selection using the current WorldEdit selection.");
        c.get(String.valueOf(path) + "worldedit.Info", Arrays.asList("&eUsage: &6/res select worldedit", "Sets selection area using the current WorldEdit selection."));
    }
}

