/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.signsStuff;

import com.bekvon.bukkit.residence.CommentedYamlConfiguration;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.economy.rent.RentedLand;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.signsStuff.SignInfo;
import com.bekvon.bukkit.residence.signsStuff.Signs;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class SignUtil {
    private Residence plugin;
    public SignInfo Signs = new SignInfo();

    public SignUtil(Residence plugin) {
        this.plugin = plugin;
    }

    public SignInfo getSigns() {
        return this.Signs;
    }

    public int updateAllSigns() {
        ArrayList<Signs> temp = new ArrayList<Signs>();
        temp.addAll(this.Signs.GetAllSigns());
        for (Signs one : temp) {
            this.SignUpdate(one);
        }
        this.saveSigns();
        return temp.size();
    }

    public void LoadSigns() {
        this.Signs.GetAllSigns().clear();
        File file = new File(this.plugin.getDataFolder(), "Signs.yml");
        YamlConfiguration f = YamlConfiguration.loadConfiguration((File)file);
        if (!f.isConfigurationSection("Signs")) {
            return;
        }
        ConfigurationSection ConfCategory = f.getConfigurationSection("Signs");
        ArrayList categoriesList = new ArrayList(ConfCategory.getKeys(false));
        if (categoriesList.size() == 0) {
            return;
        }
        for (String category : categoriesList) {
            ConfigurationSection NameSection = ConfCategory.getConfigurationSection(category);
            Signs newTemp = new Signs();
            newTemp.setCategory(Integer.valueOf(category));
            ClaimedResidence res = Residence.getResidenceManager().getByName(NameSection.getString("Residence"));
            if (res == null) continue;
            newTemp.setResidence(res);
            World w = Bukkit.getWorld((String)NameSection.getString("World"));
            if (w == null) continue;
            double x = NameSection.getDouble("X");
            double y = NameSection.getDouble("Y");
            double z = NameSection.getDouble("Z");
            Location loc = new Location(w, x, y, z);
            newTemp.setLocation(loc);
            this.Signs.addSign(newTemp);
        }
    }

    public void saveSigns() {
        File f = new File(this.plugin.getDataFolder(), "Signs.yml");
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)f);
        CommentedYamlConfiguration writer = new CommentedYamlConfiguration();
        conf.options().copyDefaults(true);
        writer.addComment("Signs", "DO NOT EDIT THIS FILE BY HAND!");
        if (!conf.isConfigurationSection("Signs")) {
            conf.createSection("Signs");
        }
        for (Signs one : this.Signs.GetAllSigns()) {
            String path = "Signs." + String.valueOf(one.GetCategory());
            writer.set(String.valueOf(path) + ".Residence", one.GetResidence().getName());
            writer.set(String.valueOf(path) + ".World", one.GetLocation().getWorld().getName());
            writer.set(String.valueOf(path) + ".X", one.GetLocation().getBlockX());
            writer.set(String.valueOf(path) + ".Y", one.GetLocation().getBlockY());
            writer.set(String.valueOf(path) + ".Z", one.GetLocation().getBlockZ());
        }
        try {
            writer.save(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Signs getSignFromLoc(Location loc) {
        if (loc == null) {
            return null;
        }
        ArrayList<Signs> signList = new ArrayList<Signs>();
        signList.addAll(this.getSigns().GetAllSigns());
        for (Signs one : signList) {
            if (one == null || one.GetLocation() == null || one.GetLocation().getWorld() == null || !one.GetLocation().getWorld().getName().equalsIgnoreCase(loc.getWorld().getName()) || one.GetLocation().getBlockX() != loc.getBlockX() || one.GetLocation().getBlockY() != loc.getBlockY() || one.GetLocation().getBlockZ() != loc.getBlockZ()) continue;
            return one;
        }
        return null;
    }

    public void CheckSign(final ClaimedResidence res, int time) {
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                SignUtil.this.CheckSign(res);
            }
        }, (long)time * 1L);
    }

    public void CheckSign(ClaimedResidence res) {
        ArrayList<Signs> signList = new ArrayList<Signs>();
        signList.addAll(this.getSigns().GetAllSigns());
        for (Signs one : signList) {
            if (res != one.GetResidence()) continue;
            this.SignUpdate(one);
        }
        this.saveSigns();
    }

    public void removeSign(ClaimedResidence res) {
        if (res != null) {
            this.removeSign(res.getName());
        }
    }

    public void removeSign(String res) {
        ArrayList<Signs> signList = new ArrayList<Signs>();
        signList.addAll(this.getSigns().GetAllSigns());
        for (Signs one : signList) {
            if (!res.equals(one.GetResidence())) continue;
            this.SignUpdate(one);
        }
    }

    public void updateSignResName(ClaimedResidence res) {
        for (Signs one : this.getSigns().GetAllSigns()) {
            if (res != one.GetResidence()) continue;
            this.SignUpdate(one);
            this.saveSigns();
            break;
        }
    }

    public boolean SignUpdate(Signs Sign2) {
        ClaimedResidence res = Sign2.GetResidence();
        if (res == null) {
            return false;
        }
        boolean ForSale = res.isForSell();
        boolean ForRent = res.isForRent();
        Location nloc = Sign2.GetLocation();
        if (nloc == null) {
            this.Signs.removeSign(Sign2);
            return false;
        }
        Block block = nloc.getBlock();
        if (block.getType() == Material.AIR) {
            this.Signs.removeSign(Sign2);
            return false;
        }
        if (!(block.getState() instanceof Sign)) {
            return false;
        }
        Sign sign = (Sign)block.getState();
        if (!ForRent && !ForSale) {
            block.breakNaturally();
            this.Signs.removeSign(Sign2);
            return true;
        }
        String landName = res.getName();
        if (ForRent) {
            String timeString;
            boolean rented = res.isRented();
            RentedLand rentedPlace = res.getRentedLand();
            long time = 0L;
            if (rentedPlace != null) {
                time = rentedPlace.endTime;
            }
            SimpleDateFormat formatter = new SimpleDateFormat(Residence.getLM().getMessage("Sign.DateFormat"));
            formatter.setTimeZone(TimeZone.getTimeZone(Residence.getConfigManager().getTimeZone()));
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(time);
            String endDate = timeString = formatter.format(calendar.getTime());
            if (time == 0L) {
                endDate = "Unknown";
            }
            endDate = Residence.getRentManager().getRentedAutoRepeats(res) ? Residence.getLM().getMessage("Sign.RentedAutorenewTrue", endDate) : Residence.getLM().getMessage("Sign.RentedAutorenewFalse", endDate);
            String TopLine = rented ? endDate : Residence.getLM().getMessage("Sign.ForRentTopLine");
            sign.setLine(0, TopLine);
            String infoLine = Residence.getLM().getMessage("Sign.ForRentPriceLine", Residence.getRentManager().getCostOfRent(res), Residence.getRentManager().getRentDays(res), Residence.getRentManager().getRentableRepeatable(res));
            sign.setLine(1, infoLine);
            String shortName = this.fixResName(landName);
            sign.setLine(2, rented ? Residence.getLM().getMessage("Sign.RentedResName", shortName) : Residence.getLM().getMessage("Sign.RentedResName", shortName));
            sign.setLine(3, rented ? Residence.getLM().getMessage("Sign.RentedBottomLine", Residence.getRentManager().getRentingPlayer(landName)) : Residence.getLM().getMessage("Sign.ForRentBottomLine"));
            sign.update();
        }
        if (ForSale) {
            String shortName = this.fixResName(landName);
            String secondLine = null;
            if (shortName.contains("~")) {
                String[] lines = this.fixDoubleResName(landName);
                shortName = lines[0];
                secondLine = lines[1];
            }
            sign.setLine(0, Residence.getLM().getMessage("Sign.ForSaleTopLine"));
            String infoLine = Residence.getLM().getMessage("Sign.ForSalePriceLine", res.getSellPrice());
            sign.setLine(1, infoLine);
            sign.setLine(2, Residence.getLM().getMessage("Sign.RentedResName", shortName));
            if (secondLine != null) {
                sign.setLine(3, Residence.getLM().getMessage("Sign.RentedResName", secondLine));
            } else {
                sign.setLine(3, Residence.getLM().getMessage("Sign.ForSaleBottomLine"));
            }
            sign.update();
        }
        return true;
    }

    public void convertSigns(CommandSender sender) {
        File file = new File("plugins/ResidenceSigns/signs.yml");
        if (!file.exists()) {
            sender.sendMessage(ChatColor.GOLD + "Can't find ResidenceSign file");
            return;
        }
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)file);
        if (!conf.contains("signs")) {
            sender.sendMessage(ChatColor.GOLD + "Incorrect format of signs file");
            return;
        }
        Set sectionname = conf.getConfigurationSection("signs").getKeys(false);
        ConfigurationSection section = conf.getConfigurationSection("signs");
        int category = 1;
        if (this.getSigns().GetAllSigns().size() > 0) {
            category = this.getSigns().GetAllSigns().get(this.getSigns().GetAllSigns().size() - 1).GetCategory() + 1;
        }
        long time = System.currentTimeMillis();
        int i = 0;
        for (String one : sectionname) {
            Location nloc;
            Block block;
            World world;
            Signs signs = new Signs();
            String resname = section.getString(String.valueOf(one) + ".resName");
            signs.setCategory(category);
            ClaimedResidence res = Residence.getResidenceManager().getByName(resname);
            if (res == null) continue;
            signs.setResidence(res);
            List loc = section.getStringList(String.valueOf(one) + ".loc");
            if (loc.size() != 4 || (world = Bukkit.getWorld((String)((String)loc.get(0)))) == null) continue;
            int x = 0;
            int y = 0;
            int z = 0;
            try {
                x = Integer.parseInt((String)loc.get(1));
                y = Integer.parseInt((String)loc.get(2));
                z = Integer.parseInt((String)loc.get(3));
            }
            catch (Exception ex) {
                continue;
            }
            signs.setLocation(new Location(world, (double)x, (double)y, (double)z));
            boolean found = false;
            for (Signs onesigns : this.getSigns().GetAllSigns()) {
                if (!onesigns.GetLocation().getWorld().getName().equalsIgnoreCase(signs.GetLocation().getWorld().getName()) || onesigns.GetLocation().getBlockX() != signs.GetLocation().getBlockX() || onesigns.GetLocation().getBlockY() != signs.GetLocation().getBlockY() || onesigns.GetLocation().getBlockZ() != signs.GetLocation().getBlockZ()) continue;
                found = true;
            }
            if (found || !((block = (nloc = signs.GetLocation()).getBlock()).getState() instanceof Sign)) continue;
            this.getSigns().addSign(signs);
            this.SignUpdate(signs);
            ++category;
            ++i;
        }
        this.saveSigns();
        sender.sendMessage(ChatColor.GOLD + i + ChatColor.YELLOW + " signs have being converted to new format! It took " + ChatColor.GOLD + (System.currentTimeMillis() - time) + ChatColor.YELLOW + " ms!");
    }

    public String fixResName(String name) {
        if (name.length() > 15 && !name.contains(".")) {
            name = "~" + name.substring(name.length() - 14);
        } else if (name.length() > 15 && name.contains(".")) {
            String[] splited = name.split("\\.");
            name = "";
            int i = 0;
            while (i < splited.length) {
                String tempName = String.valueOf(name) + "." + splited[i];
                name = tempName.length() < 15 ? tempName : "~" + tempName.substring(tempName.length() - 14);
                ++i;
            }
        }
        return name;
    }

    public String[] fixDoubleResName(String name) {
        String SecondLine = name.substring(name.length() - 15);
        String FirstLine = name.replace(SecondLine, "");
        if (FirstLine.length() > 15 && !FirstLine.contains(".")) {
            FirstLine = "~" + FirstLine.substring(name.length() - 14);
        } else if (FirstLine.length() > 15 && FirstLine.contains(".")) {
            String[] splited = FirstLine.split("\\.");
            FirstLine = "";
            int i = 0;
            while (i < splited.length) {
                String tempName = String.valueOf(FirstLine) + "." + splited[i];
                FirstLine = tempName.length() < 15 ? tempName : "~" + tempName.substring(tempName.length() - 14);
                ++i;
            }
        }
        String[] lines = new String[]{FirstLine, SecondLine};
        return lines;
    }
}

