/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.itemlist;

import com.bekvon.bukkit.residence.itemlist.WorldItemList;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;

public class WorldItemManager {
    protected List<WorldItemList> lists = new ArrayList<WorldItemList>();

    public WorldItemManager(FileConfiguration config) {
        this.readLists(config);
    }

    public boolean isAllowed(Material mat, String group, String world) {
        for (WorldItemList list2 : this.lists) {
            if (list2.isAllowed(mat, world, group)) continue;
            return false;
        }
        return true;
    }

    public boolean isIgnored(Material mat, String group, String world) {
        for (WorldItemList list2 : this.lists) {
            if (!list2.isIgnored(mat, world, group)) continue;
            return true;
        }
        return false;
    }

    private void readLists(FileConfiguration config) {
        Set keys = config.getConfigurationSection("ItemList").getKeys(false);
        if (keys != null) {
            for (String key : keys) {
                try {
                    WorldItemList list2 = WorldItemList.readList(config.getConfigurationSection("ItemList." + key));
                    this.lists.add(list2);
                }
                catch (Exception ex) {
                    System.out.println("Failed to load item list:" + key);
                }
            }
        }
    }
}

