/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.gui;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.gui.FlagData;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SetFlag {
    private String residence;
    private Player player;
    private String targetPlayer = null;
    private Inventory inventory;
    private LinkedHashMap<String, Object> permMap = new LinkedHashMap();
    private LinkedHashMap<String, List<String>> description = new LinkedHashMap();
    private boolean admin = false;
    private int page = 1;
    private int pageCount = 1;

    public SetFlag(String residence, Player player, boolean admin) {
        this.residence = residence;
        this.player = player;
        this.admin = admin;
        this.fillFlagDescriptions();
    }

    public void setAdmin(boolean state) {
        this.admin = state;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setTargetPlayer(String player) {
        this.targetPlayer = player;
    }

    public String getResidence() {
        return this.residence;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void toggleFlag(int slot, ClickType click, InventoryAction action) {
        ItemStack item = this.inventory.getItem(slot);
        if (item == null) {
            return;
        }
        String command2 = "true";
        if (click.isLeftClick() && action != InventoryAction.MOVE_TO_OTHER_INVENTORY) {
            command2 = "true";
        } else if (click.isRightClick() && action != InventoryAction.MOVE_TO_OTHER_INVENTORY) {
            command2 = "false";
        } else if (click.isLeftClick() && action == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
            command2 = "remove";
        } else if (click.isRightClick() && action == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
            return;
        }
        if (slot == 53) {
            if (this.page < this.pageCount) {
                ++this.page;
            }
            this.recalculateInv();
            return;
        }
        if (slot == 45) {
            if (this.page > 1) {
                --this.page;
            }
            this.recalculateInv();
            return;
        }
        String flag = "";
        int i = 0;
        for (Map.Entry<String, Object> one : this.permMap.entrySet()) {
            flag = one.getKey();
            if (i == slot) break;
            ++i;
        }
        if (this.targetPlayer == null) {
            if (this.admin) {
                Bukkit.dispatchCommand((CommandSender)this.player, (String)("resadmin set " + this.residence + " " + flag + " " + command2));
            } else {
                Bukkit.dispatchCommand((CommandSender)this.player, (String)("res set " + this.residence + " " + flag + " " + command2));
            }
        } else if (this.admin) {
            Bukkit.dispatchCommand((CommandSender)this.player, (String)("resadmin pset " + this.residence + " " + this.targetPlayer + " " + flag + " " + command2));
        } else {
            Bukkit.dispatchCommand((CommandSender)this.player, (String)("res pset " + this.residence + " " + this.targetPlayer + " " + flag + " " + command2));
        }
    }

    public void recalculateInv() {
        if (this.targetPlayer == null) {
            this.recalculateResidence(Residence.getResidenceManager().getByName(this.residence));
        } else {
            this.recalculatePlayer(Residence.getResidenceManager().getByName(this.residence));
        }
    }

    private void fillFlagDescriptions() {
        Set<String> list2 = Residence.getLM().getKeyList("CommandHelp.SubCommands.res.SubCommands.flags.SubCommands");
        for (String onelist : list2) {
            String onelisttemp = Residence.getLM().getMessage("CommandHelp.SubCommands.res.SubCommands.flags.SubCommands." + onelist + ".Description");
            ArrayList<String> lore = new ArrayList<String>();
            int i = 0;
            String sentence = "";
            String[] stringArray = onelisttemp.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String oneWord = stringArray[n2];
                sentence = String.valueOf(sentence) + oneWord + " ";
                if (i > 4) {
                    lore.add(ChatColor.YELLOW + sentence);
                    sentence = "";
                    i = 0;
                }
                ++i;
                ++n2;
            }
            lore.add(ChatColor.YELLOW + sentence);
            this.description.put(onelist, lore);
        }
    }

    public void recalculateResidence(ClaimedResidence res) {
        List<String> flags2 = res.getPermissions().getPosibleFlags(this.player, true, this.admin);
        HashMap<String, Boolean> resFlags = new HashMap<String, Boolean>();
        LinkedHashMap TempPermMap = new LinkedHashMap();
        Map<String, Boolean> globalFlags = Residence.getPermissionManager().getAllFlags().getFlags();
        for (Map.Entry<String, Boolean> one : res.getPermissions().getFlags().entrySet()) {
            if (!flags2.contains(one.getKey())) continue;
            resFlags.put(one.getKey(), one.getValue());
        }
        for (Map.Entry<String, Boolean> one : globalFlags.entrySet()) {
            if (!flags2.contains(one.getKey())) continue;
            if (resFlags.containsKey(one.getKey())) {
                TempPermMap.put(one.getKey(), (Boolean)resFlags.get(one.getKey()) != false ? FlagPermissions.FlagState.TRUE : FlagPermissions.FlagState.FALSE);
                continue;
            }
            TempPermMap.put(one.getKey(), FlagPermissions.FlagState.NEITHER);
        }
        String title = "";
        title = this.targetPlayer == null ? Residence.getLM().getMessage("Gui.Set.Title", res.getName()) : Residence.getLM().getMessage("Gui.Pset.Title", this.targetPlayer, res.getName());
        if (title.length() > 32) {
            title = title.substring(0, Math.min(title.length(), 32));
        }
        Inventory GuiInv = Bukkit.createInventory(null, (int)54, (String)title);
        int i = 0;
        if (this.targetPlayer == null) {
            TempPermMap.remove("admin");
        }
        TempPermMap = (LinkedHashMap)Residence.getSortingManager().sortByKeyASC(TempPermMap);
        FlagData flagData = Residence.getFlagUtilManager().getFlagData();
        this.pageCount = (int)Math.ceil((double)TempPermMap.size() / 45.0);
        int start = this.page * 45 - 45;
        int end = this.page * 45;
        int count = -1;
        this.permMap.clear();
        for (Map.Entry entry : TempPermMap.entrySet()) {
            if (++count >= end) break;
            if (count < start) continue;
            this.permMap.put((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this.permMap.entrySet()) {
            ItemStack MiscInfo = Residence.getConfigManager().getGuiRemove();
            switch ((FlagPermissions.FlagState)((Object)entry.getValue())) {
                case FALSE: {
                    MiscInfo = Residence.getConfigManager().getGuiFalse();
                    break;
                }
                case TRUE: {
                    MiscInfo = Residence.getConfigManager().getGuiTrue();
                }
            }
            if (flagData.contains((String)entry.getKey())) {
                MiscInfo = flagData.getItem((String)entry.getKey());
            }
            if ((FlagPermissions.FlagState)((Object)entry.getValue()) == FlagPermissions.FlagState.TRUE) {
                ItemMeta im = MiscInfo.getItemMeta();
                im.addEnchant(Enchantment.LUCK, 1, true);
                MiscInfo.setItemMeta(im);
            } else {
                MiscInfo.removeEnchantment(Enchantment.LUCK);
            }
            ItemMeta MiscInfoMeta = MiscInfo.getItemMeta();
            MiscInfoMeta.setDisplayName(ChatColor.GREEN + (String)entry.getKey());
            ArrayList<String> lore = new ArrayList<String>();
            String variable = "";
            switch ((FlagPermissions.FlagState)((Object)entry.getValue())) {
                case FALSE: {
                    variable = Residence.getLM().getMessage("General.False");
                    break;
                }
                case TRUE: {
                    variable = Residence.getLM().getMessage("General.True");
                    break;
                }
                case NEITHER: {
                    variable = Residence.getLM().getMessage("General.Removed");
                }
            }
            lore.add(Residence.getLM().getMessage("General.FlagState", variable));
            if (this.description.containsKey(entry.getKey())) {
                lore.addAll((Collection)this.description.get(entry.getKey()));
            }
            lore.addAll(Residence.getLM().getMessageList("Gui.Actions"));
            MiscInfoMeta.setLore(lore);
            MiscInfo.setItemMeta(MiscInfoMeta);
            GuiInv.setItem(i, MiscInfo);
            if (++i > 53) break;
        }
        ItemStack itemStack = new ItemStack(Material.ARROW);
        ItemMeta meta = itemStack.getItemMeta();
        if (this.page > 1) {
            meta.setDisplayName(Residence.getLM().getMessage("General.PrevInfoPage"));
            itemStack.setItemMeta(meta);
            GuiInv.setItem(45, itemStack);
        }
        if (this.page < this.pageCount) {
            meta.setDisplayName(Residence.getLM().getMessage("General.NextInfoPage"));
            itemStack.setItemMeta(meta);
            GuiInv.setItem(53, itemStack);
        }
        this.inventory = GuiInv;
    }

    public void recalculatePlayer(ClaimedResidence res) {
        Map<String, Boolean> globalFlags = Residence.getPermissionManager().getAllFlags().getFlags();
        List<String> flags2 = res.getPermissions().getPosibleFlags(this.player, false, this.admin);
        HashMap<String, Boolean> resFlags = new HashMap<String, Boolean>();
        for (Map.Entry<String, Boolean> one : res.getPermissions().getFlags().entrySet()) {
            if (!flags2.contains(one.getKey())) continue;
            resFlags.put(one.getKey(), one.getValue());
        }
        if (this.targetPlayer != null) {
            Set<String> PosibleResPFlags = res.getPermissions().getposibleFlags();
            HashMap<String, Boolean> temp = new HashMap<String, Boolean>();
            for (String one : PosibleResPFlags) {
                if (!globalFlags.containsKey(one)) continue;
                temp.put(one, globalFlags.get(one));
            }
            globalFlags = temp;
            Map<String, Boolean> pFlags = res.getPermissions().getPlayerFlags(this.targetPlayer);
            if (pFlags != null) {
                for (Map.Entry one : pFlags.entrySet()) {
                    resFlags.put((String)one.getKey(), (Boolean)one.getValue());
                }
            }
        }
        LinkedHashMap TempPermMap = new LinkedHashMap();
        for (Map.Entry<String, Boolean> one : globalFlags.entrySet()) {
            if (!flags2.contains(one.getKey())) continue;
            if (resFlags.containsKey(one.getKey())) {
                TempPermMap.put(one.getKey(), (Boolean)resFlags.get(one.getKey()) != false ? FlagPermissions.FlagState.TRUE : FlagPermissions.FlagState.FALSE);
                continue;
            }
            TempPermMap.put(one.getKey(), FlagPermissions.FlagState.NEITHER);
        }
        String title = "";
        title = this.targetPlayer == null ? Residence.getLM().getMessage("Gui.Set.Title", res.getName()) : Residence.getLM().getMessage("Gui.Pset.Title", this.targetPlayer, res.getName());
        if (title.length() > 32) {
            title = title.substring(0, Math.min(title.length(), 32));
        }
        Inventory GuiInv = Bukkit.createInventory(null, (int)54, (String)title);
        int i = 0;
        TempPermMap = (LinkedHashMap)Residence.getSortingManager().sortByKeyASC(TempPermMap);
        FlagData flagData = Residence.getFlagUtilManager().getFlagData();
        this.pageCount = (int)Math.ceil((double)TempPermMap.size() / 45.0);
        int start = this.page * 45 - 45;
        int end = this.page * 45;
        int count = -1;
        this.permMap.clear();
        for (Map.Entry entry : TempPermMap.entrySet()) {
            if (++count >= end) break;
            if (count < start) continue;
            this.permMap.put((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this.permMap.entrySet()) {
            ItemStack MiscInfo = Residence.getConfigManager().getGuiRemove();
            switch ((FlagPermissions.FlagState)((Object)entry.getValue())) {
                case FALSE: {
                    MiscInfo = Residence.getConfigManager().getGuiFalse();
                    break;
                }
                case TRUE: {
                    MiscInfo = Residence.getConfigManager().getGuiTrue();
                }
            }
            if (flagData.contains((String)entry.getKey())) {
                MiscInfo = flagData.getItem((String)entry.getKey());
            }
            if ((FlagPermissions.FlagState)((Object)entry.getValue()) == FlagPermissions.FlagState.TRUE) {
                ItemMeta im = MiscInfo.getItemMeta();
                im.addEnchant(Enchantment.LUCK, 1, true);
                MiscInfo.setItemMeta(im);
            } else {
                MiscInfo.removeEnchantment(Enchantment.LUCK);
            }
            ItemMeta MiscInfoMeta = MiscInfo.getItemMeta();
            MiscInfoMeta.setDisplayName(ChatColor.GREEN + (String)entry.getKey());
            ArrayList<String> lore = new ArrayList<String>();
            String variable = "";
            switch ((FlagPermissions.FlagState)((Object)entry.getValue())) {
                case FALSE: {
                    variable = Residence.getLM().getMessage("General.False");
                    break;
                }
                case TRUE: {
                    variable = Residence.getLM().getMessage("General.True");
                    break;
                }
                case NEITHER: {
                    variable = Residence.getLM().getMessage("General.Removed");
                }
            }
            lore.add(Residence.getLM().getMessage("General.FlagState", variable));
            if (this.description.containsKey(entry.getKey())) {
                lore.addAll((Collection)this.description.get(entry.getKey()));
            }
            lore.addAll(Residence.getLM().getMessageList("Gui.Actions"));
            MiscInfoMeta.setLore(lore);
            MiscInfo.setItemMeta(MiscInfoMeta);
            GuiInv.setItem(i, MiscInfo);
            if (++i > 53) break;
        }
        ItemStack itemStack = new ItemStack(Material.ARROW);
        ItemMeta meta = itemStack.getItemMeta();
        if (this.page > 1) {
            meta.setDisplayName(Residence.getLM().getMessage("General.PrevInfoPage"));
            itemStack.setItemMeta(meta);
            GuiInv.setItem(45, itemStack);
        }
        if (this.page < this.pageCount) {
            meta.setDisplayName(Residence.getLM().getMessage("General.NextInfoPage"));
            itemStack.setItemMeta(meta);
            GuiInv.setItem(53, itemStack);
        }
        this.inventory = GuiInv;
    }
}

