/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.listeners;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.chat.ChatChannel;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.economy.rent.RentableLand;
import com.bekvon.bukkit.residence.economy.rent.RentedLand;
import com.bekvon.bukkit.residence.event.ResidenceChangedEvent;
import com.bekvon.bukkit.residence.event.ResidenceDeleteEvent;
import com.bekvon.bukkit.residence.event.ResidenceFlagChangeEvent;
import com.bekvon.bukkit.residence.event.ResidenceRenameEvent;
import com.bekvon.bukkit.residence.gui.SetFlag;
import com.bekvon.bukkit.residence.listeners.ResidenceEntityListener;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.signsStuff.Signs;
import com.bekvon.bukkit.residence.utils.GetTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.WeatherType;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ResidencePlayerListener
implements Listener {
    protected Map<String, String> currentRes;
    protected Map<String, Long> lastUpdate;
    protected Map<String, Location> lastOutsideLoc;
    protected int minUpdateTime;
    protected boolean chatenabled;
    protected List<String> playerToggleChat = new ArrayList<String>();
    public static Map<String, SetFlag> GUI = new HashMap<String, SetFlag>();
    private Residence plugin;

    public ResidencePlayerListener(Residence plugin) {
        this.currentRes = new HashMap<String, String>();
        this.lastUpdate = new HashMap<String, Long>();
        this.lastOutsideLoc = new HashMap<String, Location>();
        this.playerToggleChat.clear();
        this.minUpdateTime = Residence.getConfigManager().getMinMoveUpdateInterval();
        this.chatenabled = Residence.getConfigManager().chatEnabled();
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.lastUpdate.put(player.getName(), System.currentTimeMillis());
        }
        this.plugin = plugin;
    }

    public Map<String, SetFlag> getGUImap() {
        return GUI;
    }

    public void reload() {
        this.currentRes = new HashMap<String, String>();
        this.lastUpdate = new HashMap<String, Long>();
        this.lastOutsideLoc = new HashMap<String, Location>();
        this.playerToggleChat.clear();
        this.minUpdateTime = Residence.getConfigManager().getMinMoveUpdateInterval();
        this.chatenabled = Residence.getConfigManager().chatEnabled();
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.lastUpdate.put(player.getName(), System.currentTimeMillis());
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerGlobalChat(AsyncPlayerChatEvent event) {
        if (Residence.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (!Residence.getConfigManager().isGlobalChatEnabled()) {
            return;
        }
        if (!Residence.getConfigManager().isGlobalChatSelfModify()) {
            return;
        }
        Player player = event.getPlayer();
        ResidencePlayer rPlayer = Residence.getPlayerManager().getResidencePlayer(player);
        if (rPlayer == null) {
            return;
        }
        if (rPlayer.getResList().size() == 0) {
            return;
        }
        ClaimedResidence res = rPlayer.getMainResidence();
        if (res == null) {
            return;
        }
        String honorific = Residence.getConfigManager().getGlobalChatFormat().replace("%1", res.getTopParentName());
        String format = event.getFormat();
        format = format.replace("%1$s", String.valueOf(honorific) + "%1$s");
        event.setFormat(format);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerChatGlobalLow(AsyncPlayerChatEvent event) {
        String format;
        if (Residence.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (!Residence.getConfigManager().isGlobalChatEnabled()) {
            return;
        }
        if (Residence.getConfigManager().isGlobalChatSelfModify()) {
            return;
        }
        Player player = event.getPlayer();
        ResidencePlayer rPlayer = Residence.getPlayerManager().getResidencePlayer(player);
        if (rPlayer == null) {
            return;
        }
        if (rPlayer.getResList().size() == 0) {
            return;
        }
        ClaimedResidence res = rPlayer.getMainResidence();
        if (res == null) {
            return;
        }
        String honorific = Residence.getConfigManager().getGlobalChatFormat().replace("%1", res.getTopParentName());
        if (honorific.equalsIgnoreCase(" ")) {
            honorific = "";
        }
        if (!(format = event.getFormat()).contains("{residence}")) {
            return;
        }
        format = format.replace("{residence}", honorific);
        event.setFormat(format);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceBackup(ResidenceFlagChangeEvent event) {
        if (!event.getFlag().equalsIgnoreCase("backup")) {
            return;
        }
        Player player = event.getPlayer();
        if (!Residence.getConfigManager().RestoreAfterRentEnds) {
            return;
        }
        if (!Residence.getConfigManager().SchematicsSaveOnFlagChange) {
            return;
        }
        if (Residence.getSchematicManager() == null) {
            return;
        }
        if (player != null && !player.hasPermission("residence.backup")) {
            event.setCancelled(true);
        } else {
            Residence.getSchematicManager().save(event.getResidence());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceBackupRename(ResidenceRenameEvent event) {
        Residence.getSchematicManager().rename(event.getResidence(), event.getNewResidenceName());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceDelete(ResidenceDeleteEvent event) {
        Residence.getSchematicManager().delete(event.getResidence());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerLogin(PlayerLoginEvent event) {
        if (!Residence.getConfigManager().isRentInformOnEnding()) {
            return;
        }
        final Player player = event.getPlayer();
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (!player.isOnline()) {
                    return;
                }
                List<String> list2 = Residence.getRentManager().getRentedLandsList(player.getName());
                if (list2.isEmpty()) {
                    return;
                }
                for (String one : list2) {
                    RentedLand rentedland = Residence.getRentManager().getRentedLand(one);
                    if (rentedland == null || rentedland.AutoPay || rentedland.endTime - System.currentTimeMillis() >= (long)(Residence.getConfigManager().getRentInformBefore() * 60 * 24 * 7)) continue;
                    player.sendMessage(Residence.getLM().getMessage("Residence.EndingRent", one, GetTime.getTime(rentedland.endTime)));
                }
            }
        }, (long)Residence.getConfigManager().getRentInformDelay() * 20L);
    }

    @EventHandler
    public void onFishingRodUse(PlayerFishEvent event) {
        Player player = event.getPlayer();
        if (event.getCaught() instanceof ArmorStand || event.getCaught() instanceof Boat || event.getCaught() instanceof LivingEntity) {
            FlagPermissions perm = Residence.getPermsByLoc(event.getCaught().getLocation());
            ClaimedResidence res = Residence.getResidenceManager().getByLoc(event.getCaught().getLocation());
            if (!perm.has("hook", false) && res != null && !res.getPermissions().playerHas(player, "hook", true) || !perm.has("hook", false) && res != null && !res.getPermissions().playerHas(player, "hook", false)) {
                event.setCancelled(true);
                if (res != null) {
                    player.sendMessage(Residence.getLM().getMessage("Residence.FlagDeny", "hook", res.getName()));
                }
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeDayNight(ResidenceFlagChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getFlag().equalsIgnoreCase("day") && !event.getFlag().equalsIgnoreCase("night")) {
            return;
        }
        switch (event.getNewState()) {
            case FALSE: 
            case NEITHER: {
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.resetPlayerTime();
                }
                break;
            }
            case INVALID: {
                break;
            }
            case TRUE: {
                if (event.getFlag().equalsIgnoreCase("day")) {
                    for (Player one : event.getResidence().getPlayersInResidence()) {
                        one.setPlayerTime(6000L, false);
                    }
                }
                if (!event.getFlag().equalsIgnoreCase("night")) break;
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.setPlayerTime(14000L, false);
                }
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeSunRain(ResidenceFlagChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getFlag().equalsIgnoreCase("sun") && !event.getFlag().equalsIgnoreCase("rain")) {
            return;
        }
        switch (event.getNewState()) {
            case FALSE: 
            case NEITHER: {
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.resetPlayerWeather();
                }
                break;
            }
            case INVALID: {
                break;
            }
            case TRUE: {
                if (event.getFlag().equalsIgnoreCase("sun")) {
                    for (Player one : event.getResidence().getPlayersInResidence()) {
                        one.setPlayerWeather(WeatherType.CLEAR);
                    }
                }
                if (!event.getFlag().equalsIgnoreCase("rain")) break;
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.setPlayerWeather(WeatherType.DOWNFALL);
                }
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onCommand(PlayerCommandPreprocessEvent event) {
        if (Residence.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        String resname = Residence.getPlayerListener().getCurrentResidenceName(player.getName());
        if (resname == null) {
            return;
        }
        ClaimedResidence res = Residence.getResidenceManager().getByName(resname);
        if (res == null) {
            return;
        }
        if (res.getPermissions().playerHas(player.getName(), "command", true)) {
            return;
        }
        if (Residence.getPermissionManager().isResidenceAdmin((CommandSender)player)) {
            return;
        }
        if (player.hasPermission("residence.flag.command.bypass")) {
            return;
        }
        String msg = event.getMessage().replace(" ", "_");
        int white = 0;
        int black = 0;
        for (String oneWhite : res.getCmdWhiteList()) {
            if (!msg.startsWith("/" + oneWhite)) continue;
            if (oneWhite.contains("_") && oneWhite.split("_").length > white) {
                white = oneWhite.split("_").length;
                continue;
            }
            if (white != 0) continue;
            white = 1;
        }
        for (String oneBlack : res.getCmdBlackList()) {
            if (!msg.startsWith("/" + oneBlack)) continue;
            if (msg.contains("_")) {
                black = oneBlack.split("_").length;
                break;
            }
            black = 1;
            break;
        }
        if (black == 0) {
            for (String oneBlack : res.getCmdBlackList()) {
                if (!oneBlack.equalsIgnoreCase("*")) continue;
                if (!msg.contains("_")) break;
                black = msg.split("_").length;
                break;
            }
        }
        if (white != 0 && white >= black || black == 0) {
            return;
        }
        event.setCancelled(true);
        player.sendMessage(Residence.getLM().getMessage("Residence.FlagDeny", "command", res.getName()));
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onFlagGuiClick(InventoryClickEvent event) {
        if (this.getGUImap().size() == 0) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.getGUImap().containsKey(player.getName())) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        if (slot > 53 || slot < 0) {
            return;
        }
        SetFlag setFlag = this.getGUImap().get(player.getName());
        ClickType click = event.getClick();
        InventoryAction action = event.getAction();
        setFlag.toggleFlag(slot, click, action);
        setFlag.recalculateInv();
        player.getOpenInventory().getTopInventory().setContents(setFlag.getInventory().getContents());
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onFlagGuiClose(InventoryCloseEvent event) {
        if (this.getGUImap().isEmpty()) {
            return;
        }
        HumanEntity player = event.getPlayer();
        if (!this.getGUImap().containsKey(player.getName())) {
            return;
        }
        this.getGUImap().remove(player.getName());
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onSignInteract(PlayerInteractEvent event) {
        if (Residence.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        if (!(block.getState() instanceof Sign)) {
            return;
        }
        Player player = event.getPlayer();
        Location loc = block.getLocation();
        for (Signs one : Residence.getSignUtil().getSigns().GetAllSigns()) {
            if (!one.GetLocation().getWorld().getName().equalsIgnoreCase(loc.getWorld().getName()) || one.GetLocation().getBlockX() != loc.getBlockX() || one.GetLocation().getBlockY() != loc.getBlockY() || one.GetLocation().getBlockZ() != loc.getBlockZ()) continue;
            ClaimedResidence res = one.GetResidence();
            boolean ForSale = res.isForSell();
            boolean ForRent = res.isForRent();
            String landName = res.getName();
            if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                if (ForSale) {
                    Bukkit.dispatchCommand((CommandSender)player, (String)("res market buy " + landName));
                    break;
                }
                if (!ForRent) continue;
                if (res.isRented() && player.isSneaking()) {
                    Bukkit.dispatchCommand((CommandSender)player, (String)("res market release " + landName));
                    break;
                }
                boolean stage = true;
                if (player.isSneaking()) {
                    stage = false;
                }
                Bukkit.dispatchCommand((CommandSender)player, (String)("res market rent " + landName + " " + stage));
                break;
            }
            if (event.getAction() != Action.LEFT_CLICK_BLOCK || !ForRent || !res.isRented() || !Residence.getRentManager().getRentingPlayer(res).equals(player.getName())) continue;
            Residence.getRentManager().payRent(player, res, false);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onSignCreate(SignChangeEvent event) {
        if (Residence.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Block block = event.getBlock();
        if (!(block.getState() instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)block.getState();
        if (!ChatColor.stripColor((String)event.getLine(0)).equalsIgnoreCase(Residence.getLM().getMessage("Sign.TopLine"))) {
            return;
        }
        Signs signInfo = new Signs();
        Location loc = sign.getLocation();
        String landName = null;
        ClaimedResidence res = null;
        if (!event.getLine(1).equalsIgnoreCase("")) {
            String resname = event.getLine(1);
            if (!event.getLine(2).equalsIgnoreCase("")) {
                resname = String.valueOf(resname) + "." + event.getLine(2);
            }
            if (!event.getLine(3).equalsIgnoreCase("")) {
                resname = String.valueOf(resname) + "." + event.getLine(3);
            }
            if ((res = Residence.getResidenceManager().getByName(resname)) == null) {
                event.getPlayer().sendMessage(Residence.getLM().getMessage("Invalid.Residence"));
                return;
            }
            landName = res.getName();
        } else {
            res = Residence.getResidenceManager().getByLoc(loc);
            landName = Residence.getResidenceManager().getNameByLoc(loc);
        }
        if (res == null) {
            event.getPlayer().sendMessage(Residence.getLM().getMessage("Invalid.Residence"));
            return;
        }
        final ClaimedResidence residence = res;
        boolean ForSale = Residence.getTransactionManager().isForSale(landName);
        boolean ForRent = Residence.getRentManager().isForRent(landName);
        int category = 1;
        if (Residence.getSignUtil().getSigns().GetAllSigns().size() > 0) {
            category = Residence.getSignUtil().getSigns().GetAllSigns().get(Residence.getSignUtil().getSigns().GetAllSigns().size() - 1).GetCategory() + 1;
        }
        if (ForSale || ForRent) {
            signInfo.setCategory(category);
            signInfo.setResidence(res);
            signInfo.setLocation(loc);
            Residence.getSignUtil().getSigns().addSign(signInfo);
            Residence.getSignUtil().saveSigns();
        }
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                Residence.getSignUtil().CheckSign(residence);
            }
        }, 5L);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onSignDestroy(BlockBreakEvent event) {
        if (Residence.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        if (block == null) {
            return;
        }
        if (!(block.getState() instanceof Sign)) {
            return;
        }
        Location loc = block.getLocation();
        for (Signs one : Residence.getSignUtil().getSigns().GetAllSigns()) {
            if (!one.GetLocation().getWorld().getName().equalsIgnoreCase(loc.getWorld().getName()) || one.GetLocation().getBlockX() != loc.getBlockX() || one.GetLocation().getBlockY() != loc.getBlockY() || one.GetLocation().getBlockZ() != loc.getBlockZ()) continue;
            Residence.getSignUtil().getSigns().removeSign(one);
            Residence.getSignUtil().saveSigns();
            break;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        String pname = event.getPlayer().getName();
        this.currentRes.remove(pname);
        this.lastUpdate.remove(pname);
        this.lastOutsideLoc.remove(pname);
        Residence.getChatManager().removeFromChannel(pname);
        Residence.getPlayerListener().removePlayerResidenceChat(pname);
        Residence.getOfflinePlayerMap().put(pname, (OfflinePlayer)event.getPlayer());
        if (Residence.getAutoSelectionManager().getList().containsKey(pname.toLowerCase())) {
            Residence.getAutoSelectionManager().getList().remove(pname);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoin(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (Residence.getPermissionManager().isResidenceAdmin((CommandSender)player)) {
            Residence.turnResAdminOn(player);
        }
        Residence.getPermissionManager().updateGroupNameForPlayer(player, true);
        FlagPermissions perms = Residence.getPermsByLocForPlayer(player.getLocation(), player);
        if ((player.getAllowFlight() || player.isFlying()) && perms.has("nofly", false) && !Residence.isResAdminOn(player) && !player.hasPermission("residence.nofly.bypass")) {
            Location lc = player.getLocation();
            Location location = new Location(lc.getWorld(), lc.getX(), (double)lc.getBlockY(), lc.getZ());
            location.setPitch(lc.getPitch());
            location.setYaw(lc.getYaw());
            int from = location.getBlockY();
            int maxH = location.getWorld().getMaxHeight() - 1;
            int i = 0;
            while (i < maxH) {
                location.setY((double)(from - i));
                Block block = location.getBlock();
                if (!Residence.getNms().isEmptyBlock(block)) {
                    location.setY((double)(from - i + 1));
                    break;
                }
                if (location.getBlockY() <= 0) {
                    player.setFlying(false);
                    player.setAllowFlight(false);
                    player.sendMessage(Residence.getLM().getMessage("Residence.FlagDeny", "Fly", location.getWorld().getName()));
                    return;
                }
                ++i;
            }
            player.sendMessage(Residence.getLM().getMessage("Residence.FlagDeny", "Fly", location.getWorld().getName()));
            player.teleport(location);
            player.setFlying(false);
            player.setAllowFlight(false);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.lastUpdate.put(player.getName(), 0L);
        if (Residence.getPermissionManager().isResidenceAdmin((CommandSender)player)) {
            Residence.turnResAdminOn(player);
        }
        this.handleNewLocation(player, player.getLocation(), true);
        final Player p = player;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                Residence.getPlayerManager().playerJoin((OfflinePlayer)p);
                if (p != null) {
                    Residence.getPermissionManager().updateGroupNameForPlayer(p, true);
                }
            }
        });
        if (player.hasPermission("residence.versioncheck")) {
            Residence.getVersionChecker().VersionCheck(player);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerSpawn(PlayerRespawnEvent event) {
        if (Residence.isDisabledWorldListener(event.getRespawnLocation().getWorld())) {
            return;
        }
        Location loc = event.getRespawnLocation();
        Boolean bed = event.isBedSpawn();
        Player player = event.getPlayer();
        ClaimedResidence res = Residence.getResidenceManager().getByLoc(loc);
        if (res == null) {
            return;
        }
        if (res.getPermissions().playerHas(player.getName(), "move", true)) {
            return;
        }
        if (bed.booleanValue()) {
            loc = player.getWorld().getSpawnLocation();
        }
        if ((res = Residence.getResidenceManager().getByLoc(loc)) != null && !res.getPermissions().playerHas(player.getName(), "move", true)) {
            loc = res.getOutsideFreeLoc(loc, player);
        }
        player.sendMessage(Residence.getLM().getMessage("General.NoSpawn"));
        event.setRespawnLocation(loc);
    }

    private boolean isContainer(Material mat, Block block) {
        return FlagPermissions.getMaterialUseFlagList().containsKey(mat) && FlagPermissions.getMaterialUseFlagList().get(mat).equals("container") || Residence.getConfigManager().getCustomContainers().contains(block.getTypeId());
    }

    private boolean isCanUseEntity_RClickOnly(Material mat, Block block) {
        switch (mat) {
            case NOTE_BLOCK: 
            case BED_BLOCK: 
            case WORKBENCH: 
            case CAKE_BLOCK: 
            case DIODE_BLOCK_OFF: 
            case DIODE_BLOCK_ON: 
            case ENCHANTMENT_TABLE: 
            case BREWING_STAND: 
            case COMMAND: 
            case BEACON: 
            case FLOWER_POT: 
            case ANVIL: 
            case REDSTONE_COMPARATOR_OFF: 
            case REDSTONE_COMPARATOR_ON: 
            case DAYLIGHT_DETECTOR: 
            case DAYLIGHT_DETECTOR_INVERTED: 
            case DIODE: 
            case ITEM_FRAME: 
            case REDSTONE_COMPARATOR: {
                return true;
            }
        }
        return Residence.getConfigManager().getCustomRightClick().contains(block.getTypeId());
    }

    private boolean isCanUseEntity(Material mat, Block block) {
        return Residence.getNms().isCanUseEntity_BothClick(mat, block) || this.isCanUseEntity_RClickOnly(mat, block);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerFireInteract(PlayerInteractEvent event) {
        boolean hasplace;
        if (Residence.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Block relativeBlock = block.getRelative(event.getBlockFace());
        if (relativeBlock == null) {
            return;
        }
        Player player = event.getPlayer();
        FlagPermissions perms = Residence.getPermsByLocForPlayer(block.getLocation(), player);
        if (relativeBlock.getType() == Material.FIRE && !(hasplace = perms.playerHas(player.getName(), player.getWorld().getName(), "place", perms.playerHas(player.getName(), player.getWorld().getName(), "build", true)))) {
            event.setCancelled(true);
            player.sendMessage(Residence.getLM().getMessage("Flag.Deny", "build"));
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlatePress(PlayerInteractEvent event) {
        if (Residence.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getAction() != Action.PHYSICAL) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Material mat = block.getType();
        Player player = event.getPlayer();
        FlagPermissions perms = Residence.getPermsByLocForPlayer(block.getLocation(), player);
        String world = player.getWorld().getName();
        boolean resadmin2 = Residence.isResAdminOn(player);
        if (!resadmin2) {
            boolean hasuse = perms.playerHas(player.getName(), world, "use", true);
            boolean haspressure = perms.playerHas(player.getName(), world, "pressure", hasuse);
            if (!((hasuse || haspressure) && haspressure || mat != Material.STONE_PLATE && mat != Material.WOOD_PLATE && !Residence.getNms().isPlate(mat))) {
                event.setCancelled(true);
                return;
            }
        }
        if (!(perms.playerHas(player.getName(), world, "trample", perms.playerHas(player.getName(), world, "build", true)) || mat != Material.SOIL && mat != Material.SOUL_SAND)) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSelection(PlayerInteractEvent event) {
        if (Residence.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        int heldItemId = player.getItemInHand().getTypeId();
        if (heldItemId != Residence.getConfigManager().getSelectionTooldID()) {
            return;
        }
        if (Residence.wepid == Residence.getConfigManager().getSelectionTooldID()) {
            return;
        }
        if (player.getGameMode() == GameMode.CREATIVE) {
            event.setCancelled(true);
        }
        boolean resadmin2 = Residence.isResAdminOn(player);
        PermissionGroup group = Residence.getPermissionManager().getGroup(player);
        if (player.hasPermission("residence.select") || player.hasPermission("residence.create") && !player.isPermissionSet("residence.select") || group.canCreateResidences() && !player.isPermissionSet("residence.create") && !player.isPermissionSet("residence.select") || resadmin2) {
            Block block = event.getClickedBlock();
            if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
                Location loc = block.getLocation();
                Residence.getSelectionManager().placeLoc1(player, loc, true);
                player.sendMessage(Residence.getLM().getMessage("Select.PrimaryPoint", Residence.getLM().getMessage("General.CoordsTop", loc.getBlockX(), loc.getBlockY(), loc.getBlockZ())));
                event.setCancelled(true);
            } else if (event.getAction() == Action.RIGHT_CLICK_BLOCK && Residence.getNms().isMainHand(event)) {
                Location loc = block.getLocation();
                Residence.getSelectionManager().placeLoc2(player, loc, true);
                player.sendMessage(Residence.getLM().getMessage("Select.SecondaryPoint", Residence.getLM().getMessage("General.CoordsBottom", loc.getBlockX(), loc.getBlockY(), loc.getBlockZ())));
                event.setCancelled(true);
            }
            if (Residence.getSelectionManager().hasPlacedBoth(player.getName())) {
                Residence.getSelectionManager().showSelectionInfoInActionBar(player);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onInfoCheck(PlayerInteractEvent event) {
        if (Residence.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        int heldItemId = item.getTypeId();
        if (heldItemId != Residence.getConfigManager().getInfoToolID()) {
            return;
        }
        Location loc = block.getLocation();
        String res = Residence.getResidenceManager().getNameByLoc(loc);
        if (res != null) {
            Residence.getResidenceManager().printAreaInfo(res, (CommandSender)player, false);
        } else {
            player.sendMessage(Residence.getLM().getMessage("Residence.NoResHere"));
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (Residence.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack iih = Residence.getNms().itemInMainHand(player);
        Material heldItem = iih.getType();
        int heldItemId = iih.getTypeId();
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Material mat = block.getType();
        if (!(event.getAction() == Action.PHYSICAL || (this.isContainer(mat, block) || this.isCanUseEntity_RClickOnly(mat, block)) && event.getAction() == Action.RIGHT_CLICK_BLOCK || Residence.getNms().isCanUseEntity_BothClick(mat, block) || heldItemId == Residence.getConfigManager().getSelectionTooldID() || heldItemId == Residence.getConfigManager().getInfoToolID() || heldItem == Material.INK_SACK || Residence.getNms().isArmorStandMaterial(heldItem) || Residence.getNms().isBoat(heldItem))) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        String world = player.getWorld().getName();
        String permgroup = Residence.getPermissionManager().getGroupNameByPlayer(player);
        boolean resadmin2 = Residence.isResAdminOn(player);
        if (!resadmin2 && !Residence.getItemManager().isAllowed(heldItem, permgroup, world)) {
            player.sendMessage(Residence.getLM().getMessage("General.ItemBlacklisted"));
            event.setCancelled(true);
            return;
        }
        if (resadmin2) {
            return;
        }
        int blockId = block.getTypeId();
        FlagPermissions perms = Residence.getPermsByLocForPlayer(block.getLocation(), player);
        if (heldItem != null && event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            if (heldItem == Material.INK_SACK && (Residence.getNms().itemInMainHand(player).getData().getData() == 15 && block.getType() == Material.GRASS || iih.getData().getData() == 3 && blockId == 17 && (block.getData() == 3 || block.getData() == 7 || block.getData() == 11 || block.getData() == 15)) && !(perms = Residence.getPermsByLocForPlayer(block.getRelative(event.getBlockFace()).getLocation(), player)).playerHas(player.getName(), world, "build", true)) {
                player.sendMessage(Residence.getLM().getMessage("Flag.Deny", "build"));
                event.setCancelled(true);
                return;
            }
            if ((Residence.getNms().isArmorStandMaterial(heldItem) || Residence.getNms().isBoat(heldItem)) && !(perms = Residence.getPermsByLocForPlayer(block.getRelative(event.getBlockFace()).getLocation(), player)).playerHas(player.getName(), world, "build", true)) {
                player.sendMessage(Residence.getLM().getMessage("Flag.Deny", "build"));
                event.setCancelled(true);
                return;
            }
        }
        if (this.isContainer(mat, block) || this.isCanUseEntity(mat, block)) {
            boolean hasuse = perms.playerHas(player.getName(), world, "use", true);
            for (Map.Entry<Material, String> checkMat : FlagPermissions.getMaterialUseFlagList().entrySet()) {
                if (mat != checkMat.getKey() || perms.playerHas(player.getName(), world, checkMat.getValue(), hasuse)) continue;
                if (hasuse || checkMat.getValue().equals("container")) {
                    event.setCancelled(true);
                    player.sendMessage(Residence.getLM().getMessage("Flag.Deny", checkMat.getValue()));
                    return;
                }
                event.setCancelled(true);
                player.sendMessage(Residence.getLM().getMessage("Flag.Deny", "use"));
                return;
            }
            if (Residence.getConfigManager().getCustomContainers().contains(blockId) && !perms.playerHas(player.getName(), world, "container", hasuse)) {
                event.setCancelled(true);
                player.sendMessage(Residence.getLM().getMessage("Flag.Deny", "container"));
                return;
            }
            if (Residence.getConfigManager().getCustomBothClick().contains(blockId) && !hasuse) {
                event.setCancelled(true);
                player.sendMessage(Residence.getLM().getMessage("Flag.Deny", "use"));
                return;
            }
            if (Residence.getConfigManager().getCustomRightClick().contains(blockId) && event.getAction() == Action.RIGHT_CLICK_BLOCK && !hasuse) {
                event.setCancelled(true);
                player.sendMessage(Residence.getLM().getMessage("Flag.Deny", "use"));
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerTradeEntity(PlayerInteractEntityEvent event) {
        if (Residence.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (Residence.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (ent.getType() != EntityType.VILLAGER) {
            return;
        }
        ClaimedResidence res = Residence.getResidenceManager().getByLoc(ent.getLocation());
        if (res != null && !res.getPermissions().playerHas(player.getName(), "trade", true)) {
            player.sendMessage(Residence.getLM().getMessage("Residence.FlagDeny", "trade", res.getName()));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteractWithHorse(PlayerInteractEntityEvent event) {
        if (Residence.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (Residence.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (ent.getType() != EntityType.HORSE) {
            return;
        }
        ClaimedResidence res = Residence.getResidenceManager().getByLoc(ent.getLocation());
        if (res == null) {
            return;
        }
        if (!res.isOwner(player) && !res.getPermissions().playerHas(player.getName(), "container", true) && player.isSneaking()) {
            player.sendMessage(Residence.getLM().getMessage("Residence.FlagDeny", "container", res.getName()));
            event.setCancelled(true);
        } else if (!res.isOwner(player) && !res.getPermissions().playerHas(player.getName(), "riding", false)) {
            player.sendMessage(Residence.getLM().getMessage("Residence.FlagDeny", "riding", res.getName()));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteractWithMinecartStorage(PlayerInteractEntityEvent event) {
        if (Residence.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (Residence.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (ent.getType() != EntityType.MINECART_CHEST && ent.getType() != EntityType.MINECART_HOPPER) {
            return;
        }
        ClaimedResidence res = Residence.getResidenceManager().getByLoc(ent.getLocation());
        if (res == null) {
            return;
        }
        if (!res.isOwner(player) && !res.getPermissions().playerHas(player.getName(), "container", true)) {
            player.sendMessage(Residence.getLM().getMessage("Residence.FlagDeny", "container", res.getName()));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteractWithMinecart(PlayerInteractEntityEvent event) {
        if (Residence.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (Residence.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (ent.getType() != EntityType.MINECART && ent.getType() != EntityType.BOAT) {
            return;
        }
        ClaimedResidence res = Residence.getResidenceManager().getByLoc(ent.getLocation());
        if (res == null) {
            return;
        }
        if (!res.isOwner(player) && !res.getPermissions().playerHas(player.getName(), "riding", false)) {
            player.sendMessage(Residence.getLM().getMessage("Residence.FlagDeny", "riding", res.getName()));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerDyeSheep(PlayerInteractEntityEvent event) {
        if (Residence.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (Residence.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (ent.getType() != EntityType.SHEEP) {
            return;
        }
        ClaimedResidence res = Residence.getResidenceManager().getByLoc(ent.getLocation());
        if (res == null) {
            return;
        }
        if (!res.isOwner(player) && !res.getPermissions().playerHas(player.getName(), "dye", true)) {
            player.sendMessage(Residence.getLM().getMessage("Residence.FlagDeny", "dye", res.getName()));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerShearEntity(PlayerShearEntityEvent event) {
        if (Residence.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (Residence.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getEntity();
        ClaimedResidence res = Residence.getResidenceManager().getByLoc(ent.getLocation());
        if (res == null) {
            return;
        }
        if (!res.isOwner(player) && !res.getPermissions().playerHas(player.getName(), "shear", true)) {
            player.sendMessage(Residence.getLM().getMessage("Residence.FlagDeny", "Shear", res.getName()));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerItemFrameInteract(PlayerInteractEntityEvent event) {
        if (Residence.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (Residence.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (!(ent instanceof Hanging)) {
            return;
        }
        Hanging hanging = (Hanging)ent;
        if (hanging.getType() != EntityType.ITEM_FRAME) {
            return;
        }
        Material heldItem = Residence.getNms().itemInMainHand(player).getType();
        FlagPermissions perms = Residence.getPermsByLocForPlayer(ent.getLocation(), player);
        String world = player.getWorld().getName();
        String permgroup = Residence.getPermissionManager().getGroupNameByPlayer(player);
        if (!Residence.getItemManager().isAllowed(heldItem, permgroup, world)) {
            player.sendMessage(Residence.getLM().getMessage("General.ItemBlacklisted"));
            event.setCancelled(true);
            return;
        }
        if (!perms.playerHas(player.getName(), world, "container", perms.playerHas(player.getName(), world, "use", true))) {
            event.setCancelled(true);
            player.sendMessage(Residence.getLM().getMessage("Flag.Deny", "container"));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        if (Residence.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (Residence.isResAdminOn(player)) {
            return;
        }
        Location loc = event.getBlockClicked().getLocation();
        ClaimedResidence res = Residence.getResidenceManager().getByLoc(loc);
        if (res != null) {
            if (Residence.getConfigManager().preventRentModify() && Residence.getConfigManager().enabledRentSystem() && Residence.getRentManager().isRented(res.getName())) {
                player.sendMessage(Residence.getLM().getMessage("Rent.ModifyDeny"));
                event.setCancelled(true);
                return;
            }
            Material mat = event.getBucket();
            if (!res.getPermissions().playerHas(player.getName(), "bucket", true) && !res.getPermissions().playerHas(player.getName(), "bucketempty", true) && Residence.getConfigManager().getNoPlaceWorlds().contains(loc.getWorld().getName())) {
                if (mat == Material.LAVA_BUCKET) {
                    event.setCancelled(true);
                    return;
                }
                if (mat == Material.WATER_BUCKET) {
                    event.setCancelled(true);
                    return;
                }
            }
        }
        String pname = player.getName();
        FlagPermissions perms = Residence.getPermsByLocForPlayer(loc, player);
        if (!perms.playerHas(pname, player.getWorld().getName(), "bucket", perms.playerHas(pname, player.getWorld().getName(), "build", true)) && !perms.playerHas(pname, player.getWorld().getName(), "bucketempty", perms.playerHas(pname, player.getWorld().getName(), "build", true))) {
            player.sendMessage(Residence.getLM().getMessage("Flag.Deny", "bucket"));
            event.setCancelled(true);
            return;
        }
        Material mat = event.getBucket();
        int level = Residence.getConfigManager().getPlaceLevel();
        if (res == null && Residence.getConfigManager().isNoLavaPlace() && loc.getBlockY() >= level - 1 && Residence.getConfigManager().getNoPlaceWorlds().contains(loc.getWorld().getName()) && mat == Material.LAVA_BUCKET) {
            if (!Residence.getLM().getMessage("General.CantPlaceLava").equalsIgnoreCase("")) {
                player.sendMessage(Residence.getLM().getMessage("General.CantPlaceLava", level));
            }
            event.setCancelled(true);
            return;
        }
        if (res == null && Residence.getConfigManager().isNoWaterPlace() && loc.getBlockY() >= level - 1 && Residence.getConfigManager().getNoPlaceWorlds().contains(loc.getWorld().getName()) && mat == Material.WATER_BUCKET) {
            if (!Residence.getLM().getMessage("General.CantPlaceWater").equalsIgnoreCase("")) {
                player.sendMessage(Residence.getLM().getMessage("General.CantPlaceWater", level));
            }
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerBucketFill(PlayerBucketFillEvent event) {
        if (Residence.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (Residence.isResAdminOn(player)) {
            return;
        }
        ClaimedResidence res = Residence.getResidenceManager().getByLoc(event.getBlockClicked().getLocation());
        if (res != null && Residence.getConfigManager().preventRentModify() && Residence.getConfigManager().enabledRentSystem() && Residence.getRentManager().isRented(res.getName())) {
            player.sendMessage(Residence.getLM().getMessage("Rent.ModifyDeny"));
            event.setCancelled(true);
            return;
        }
        String pname = player.getName();
        FlagPermissions perms = Residence.getPermsByLocForPlayer(event.getBlockClicked().getLocation(), player);
        boolean hasbucket = perms.playerHas(pname, player.getWorld().getName(), "bucket", perms.playerHas(pname, player.getWorld().getName(), "build", true));
        boolean hasbucketfill = perms.playerHas(pname, player.getWorld().getName(), "bucketfill", perms.playerHas(pname, player.getWorld().getName(), "build", true));
        if (!hasbucket && !hasbucketfill) {
            player.sendMessage(Residence.getLM().getMessage("Flag.Deny", "bucket"));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (Residence.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        Location loc = event.getTo();
        if (Residence.isResAdminOn(player)) {
            this.handleNewLocation(player, loc, false);
            return;
        }
        ClaimedResidence res = Residence.getResidenceManager().getByLoc(loc);
        if (res != null) {
            String areaname;
            if (event.getCause() == PlayerTeleportEvent.TeleportCause.COMMAND || event.getCause() == PlayerTeleportEvent.TeleportCause.NETHER_PORTAL || event.getCause() == PlayerTeleportEvent.TeleportCause.PLUGIN) {
                areaname = res.getName();
                if (!res.getPermissions().playerHas(player.getName(), "move", true) && !res.isOwner(player)) {
                    event.setCancelled(true);
                    player.sendMessage(Residence.getLM().getMessage("Residence.MoveDeny", areaname));
                    return;
                }
            } else if (event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
                areaname = res.getName();
                if (!res.getPermissions().playerHas(player.getName(), "enderpearl", true)) {
                    event.setCancelled(true);
                    player.sendMessage(Residence.getLM().getMessage("Residence.FlagDeny", "EnderPearl", areaname));
                    return;
                }
            }
            if (!(event.getCause() != PlayerTeleportEvent.TeleportCause.PLUGIN && event.getCause() != PlayerTeleportEvent.TeleportCause.COMMAND || !Residence.getConfigManager().isBlockAnyTeleportation() || res.isOwner(player) || res.getPermissions().playerHas(player.getName(), "tp", true) || player.hasPermission("residence.admin.tp"))) {
                areaname = res.getName();
                event.setCancelled(true);
                player.sendMessage(Residence.getLM().getMessage("General.TeleportDeny", areaname));
                return;
            }
            if (Residence.getNms().isChorusTeleport(event.getCause()) && !res.isOwner(player) && !res.getPermissions().playerHas(player.getName(), "chorustp", true) && !player.hasPermission("residence.admin.tp")) {
                areaname = res.getName();
                event.setCancelled(true);
                player.sendMessage(Residence.getLM().getMessage("Residence.FlagDeny", "ChorusTp", areaname));
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerDeath(final PlayerDeathEvent event) {
        if (Residence.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        Location loc = player.getLocation();
        ClaimedResidence res = Residence.getResidenceManager().getByLoc(loc);
        if (res == null) {
            return;
        }
        if (res.getPermissions().has("keepinv", false)) {
            event.setKeepInventory(true);
        }
        if (res.getPermissions().has("keepexp", false)) {
            event.setKeepLevel(true);
            event.setDroppedExp(0);
        }
        if (res.getPermissions().has("respawn", false) && Bukkit.getVersion().toString().contains("Spigot")) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    try {
                        event.getEntity().spigot().respawn();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, 1L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (Residence.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        Location locfrom = event.getFrom();
        Location locto = event.getTo();
        if (locfrom.getX() == locto.getX() && locfrom.getY() == locto.getY() && locfrom.getZ() == locto.getZ()) {
            return;
        }
        String name = player.getName();
        if (name == null) {
            return;
        }
        long last = this.lastUpdate.get(name);
        long now = System.currentTimeMillis();
        if (now - last < (long)Residence.getConfigManager().getMinMoveUpdateInterval()) {
            return;
        }
        this.lastUpdate.put(name, now);
        this.handleNewLocation(player, locto, true);
        if (!Residence.getTeleportDelayMap().isEmpty() && Residence.getConfigManager().getTeleportDelay() > 0 && Residence.getTeleportDelayMap().contains(player.getName())) {
            Residence.getTeleportDelayMap().remove(player.getName());
            player.sendMessage(Residence.getLM().getMessage("General.TeleportCanceled"));
        }
    }

    public void handleNewLocation(final Player player, Location loc, boolean move) {
        ClaimedResidence res;
        String pname = player.getName();
        ClaimedResidence orres = res = Residence.getResidenceManager().getByLoc(loc);
        String areaname = null;
        String subzone2 = null;
        if (res != null) {
            areaname = res.getName();
            while (res.getSubzoneByLoc(loc) != null) {
                res = res.getSubzoneByLoc(player.getLocation());
                subzone2 = res.getName();
                areaname = String.valueOf(areaname) + "." + subzone2;
            }
        }
        ClaimedResidence ResOld = null;
        if (this.currentRes.containsKey(pname)) {
            ResOld = Residence.getResidenceManager().getByName(this.currentRes.get(pname));
            if (ResOld == null) {
                this.currentRes.remove(pname);
            } else if (res != null && ResOld.getName().equals(res.getName())) {
                if (player.isFlying() && res.getPermissions().playerHas(pname, "nofly", false) && !Residence.isResAdminOn(player) && !player.hasPermission("residence.nofly.bypass")) {
                    Location lc = player.getLocation();
                    Location location = new Location(lc.getWorld(), lc.getX(), (double)lc.getBlockY(), lc.getZ());
                    location.setPitch(lc.getPitch());
                    location.setYaw(lc.getYaw());
                    int from = location.getBlockY();
                    int maxH = location.getWorld().getMaxHeight() - 1;
                    int i = 0;
                    while (i < maxH) {
                        location.setY((double)(from - i));
                        Block block = location.getBlock();
                        if (!Residence.getNms().isEmptyBlock(block)) {
                            location.setY((double)(from - i + 1));
                            break;
                        }
                        if (location.getBlockY() <= 0) {
                            Location lastLoc = this.lastOutsideLoc.get(pname);
                            if (lastLoc != null) {
                                player.teleport(lastLoc);
                            } else {
                                player.teleport(res.getOutsideFreeLoc(loc, player));
                            }
                            player.sendMessage(Residence.getLM().getMessage("Residence.FlagDeny", "Fly", orres.getName()));
                            return;
                        }
                        ++i;
                    }
                    player.sendMessage(Residence.getLM().getMessage("Residence.FlagDeny", "Fly", orres.getName()));
                    player.teleport(location);
                    player.setFlying(false);
                    player.setAllowFlight(false);
                }
                this.lastOutsideLoc.put(pname, loc);
                return;
            }
        }
        if (!Residence.getAutoSelectionManager().getList().isEmpty()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    Residence.getAutoSelectionManager().UpdateSelection(player);
                }
            });
        }
        if (res == null) {
            this.lastOutsideLoc.put(pname, loc);
            if (ResOld != null) {
                String leave = ResOld.getLeaveMessage();
                ResidenceChangedEvent chgEvent = new ResidenceChangedEvent(ResOld, null, player);
                Residence.getServ().getPluginManager().callEvent((Event)chgEvent);
                if (ResOld.getPermissions().has("night", true) || ResOld.getPermissions().has("day", true)) {
                    player.resetPlayerTime();
                }
                if (ResOld.getPermissions().has("sun", true) || ResOld.getPermissions().has("rain", true)) {
                    player.resetPlayerWeather();
                }
                if (leave != null && !leave.equals("")) {
                    if (Residence.getConfigManager().useActionBar()) {
                        Residence.getAB().send(player, ChatColor.YELLOW + this.insertMessages(player, ResOld.getName(), ResOld, leave));
                    } else {
                        player.sendMessage(ChatColor.YELLOW + this.insertMessages(player, ResOld.getName(), ResOld, leave));
                    }
                }
                this.currentRes.remove(pname);
            }
            return;
        }
        if (move) {
            if (!(res.getPermissions().playerHas(pname, "move", true) || Residence.isResAdminOn(player) || res.isOwner(player))) {
                ClaimedResidence preRes;
                Location lastLoc = this.lastOutsideLoc.get(pname);
                if (Residence.getConfigManager().BounceAnimation()) {
                    Residence.getSelectionManager().MakeBorders(player, res.getAreaArray()[0].getLowLoc(), res.getAreaArray()[0].getHighLoc(), true);
                }
                if ((preRes = Residence.getResidenceManager().getByLoc(lastLoc)) != null && !preRes.getPermissions().playerHas(pname, "tp", true) && !player.hasPermission("residence.admin.tp")) {
                    Location newLoc = res.getOutsideFreeLoc(loc, player);
                    player.teleport(newLoc);
                } else if (lastLoc != null) {
                    player.teleport(lastLoc);
                }
                if (Residence.getConfigManager().useActionBar()) {
                    Residence.getAB().send(player, Residence.getLM().getMessage("Residence.MoveDeny", orres.getName()));
                } else {
                    player.sendMessage(Residence.getLM().getMessage("Residence.MoveDeny", orres.getName()));
                }
                return;
            }
            if (player.isFlying() && res.getPermissions().playerHas(pname, "nofly", false) && !Residence.isResAdminOn(player) && !player.hasPermission("residence.nofly.bypass")) {
                Location lc = player.getLocation();
                Location location = new Location(lc.getWorld(), lc.getX(), (double)lc.getBlockY(), lc.getZ());
                location.setPitch(lc.getPitch());
                location.setYaw(lc.getYaw());
                int from = location.getBlockY();
                int maxH = location.getWorld().getMaxHeight() - 1;
                int i = 0;
                while (i < maxH) {
                    location.setY((double)(from - i));
                    Block block = location.getBlock();
                    if (!Residence.getNms().isEmptyBlock(block)) {
                        location.setY((double)(from - i + 1));
                        break;
                    }
                    if (location.getBlockY() <= 0) {
                        Location lastLoc = this.lastOutsideLoc.get(pname);
                        if (lastLoc != null) {
                            player.teleport(lastLoc);
                        } else {
                            player.teleport(res.getOutsideFreeLoc(loc, player));
                        }
                        player.sendMessage(Residence.getLM().getMessage("Residence.FlagDeny", "Fly", orres.getName()));
                        return;
                    }
                    ++i;
                }
                player.sendMessage(Residence.getLM().getMessage("Residence.FlagDeny", "Fly", orres.getName()));
                player.teleport(location);
                player.setFlying(false);
                player.setAllowFlight(false);
            }
            if (res.getPermissions().has("day", false)) {
                player.setPlayerTime(6000L, false);
            } else if (res.getPermissions().has("night", false)) {
                player.setPlayerTime(14000L, false);
            }
            if (res.getPermissions().has("sun", false)) {
                player.setPlayerWeather(WeatherType.CLEAR);
            } else if (res.getPermissions().has("rain", false)) {
                player.setPlayerWeather(WeatherType.DOWNFALL);
            }
        }
        this.lastOutsideLoc.put(pname, loc);
        if (!this.currentRes.containsKey(pname) || ResOld != res) {
            this.currentRes.put(pname, areaname);
            ClaimedResidence chgFrom = null;
            if (ResOld != res && ResOld != null) {
                String leave = ResOld.getLeaveMessage();
                chgFrom = ResOld;
                if (ResOld.getPermissions().has("night", false) || ResOld.getPermissions().has("day", false)) {
                    player.resetPlayerTime();
                }
                if (ResOld.getPermissions().has("sun", false) || ResOld.getPermissions().has("rain", false)) {
                    player.resetPlayerWeather();
                }
                if (leave != null && !leave.equals("") && ResOld != res.getParent()) {
                    if (Residence.getConfigManager().useActionBar()) {
                        Residence.getAB().send(player, ChatColor.YELLOW + this.insertMessages(player, ResOld.getName(), ResOld, leave));
                    } else {
                        player.sendMessage(ChatColor.YELLOW + this.insertMessages(player, ResOld.getName(), ResOld, leave));
                    }
                }
            }
            String enterMessage = res.getEnterMessage();
            ResidenceChangedEvent chgEvent = new ResidenceChangedEvent(chgFrom, res, player);
            Residence.getServ().getPluginManager().callEvent((Event)chgEvent);
            if (ResOld == null || res != ResOld.getParent()) {
                if (Residence.getConfigManager().isExtraEnterMessage() && !res.isOwner(player) && (Residence.getRentManager().isForRent(areaname) || Residence.getTransactionManager().isForSale(areaname))) {
                    if (Residence.getRentManager().isForRent(areaname) && !Residence.getRentManager().isRented(areaname)) {
                        RentableLand rentable = Residence.getRentManager().getRentableLand(areaname);
                        if (rentable != null) {
                            Residence.getAB().send(player, Residence.getLM().getMessage("Residence.CanBeRented", areaname, rentable.cost, rentable.days));
                        }
                    } else if (Residence.getTransactionManager().isForSale(areaname) && !res.isOwner(player)) {
                        int sale = Residence.getTransactionManager().getSaleAmount(areaname);
                        Residence.getAB().send(player, Residence.getLM().getMessage("Residence.CanBeBought", areaname, sale));
                    }
                } else if (enterMessage != null && !enterMessage.equals("")) {
                    if (Residence.getConfigManager().useActionBar()) {
                        Residence.getAB().send(player, ChatColor.YELLOW + this.insertMessages(player, areaname, res, enterMessage));
                    } else {
                        player.sendMessage(ChatColor.YELLOW + this.insertMessages(player, areaname, res, enterMessage));
                    }
                }
            }
        }
    }

    public String insertMessages(Player player, String areaname, ClaimedResidence res, String message2) {
        try {
            message2 = message2.replaceAll("%player", player.getName());
            message2 = message2.replaceAll("%owner", res.getPermissions().getOwner());
            message2 = message2.replaceAll("%residence", areaname);
        }
        catch (Exception ex) {
            return "";
        }
        return message2;
    }

    public void doHeals() {
        try {
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                Player damage;
                double health;
                String resname = Residence.getPlayerListener().getCurrentResidenceName(player.getName());
                ClaimedResidence res = null;
                if (resname == null || !(res = Residence.getResidenceManager().getByName(resname)).getPermissions().has("healing", false) || !((health = (damage = player).getHealth()) < damage.getMaxHealth()) || player.isDead()) continue;
                player.setHealth(health + 1.0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void feed() {
        try {
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                int food;
                ClaimedResidence res;
                String resname = Residence.getPlayerListener().getCurrentResidenceName(player.getName());
                if (resname == null || !(res = Residence.getResidenceManager().getByName(resname)).getPermissions().has("feed", false) || (food = player.getFoodLevel()) >= 20 || player.isDead()) continue;
                player.setFoodLevel(food + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void DespawnMobs() {
        try {
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                String resname = Residence.getPlayerListener().getCurrentResidenceName(player.getName());
                if (resname == null) continue;
                ClaimedResidence res = null;
                res = Residence.getResidenceManager().getByName(resname);
                if (!res.getPermissions().has("nomobs", false)) continue;
                List entities = Bukkit.getServer().getWorld(res.getWorld()).getEntities();
                for (Entity ent : entities) {
                    if (!ResidenceEntityListener.isMonster(ent) || !res.containsLoc(ent.getLocation())) continue;
                    ent.remove();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (Residence.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        String pname = event.getPlayer().getName();
        if (!this.chatenabled || !this.playerToggleChat.contains(pname)) {
            return;
        }
        ChatChannel channel = Residence.getChatManager().getPlayerChannel(pname);
        if (channel != null) {
            channel.chat(pname, event.getMessage());
        }
        event.setCancelled(true);
    }

    public void tooglePlayerResidenceChat(Player player, String residence) {
        String pname = player.getName();
        this.playerToggleChat.add(pname);
        player.sendMessage(Residence.getLM().getMessage("Chat.ChatChannelChange", residence));
    }

    public void removePlayerResidenceChat(String pname) {
        this.playerToggleChat.remove(pname);
        Player player = Bukkit.getPlayer((String)pname);
        if (player != null) {
            player.sendMessage(Residence.getLM().getMessage("Chat.ChatChannelLeave"));
        }
    }

    public void removePlayerResidenceChat(Player player) {
        String pname = player.getName();
        this.playerToggleChat.remove(pname);
        player.sendMessage(Residence.getLM().getMessage("Chat.ChatChannelLeave"));
    }

    public String getCurrentResidenceName(String player) {
        return this.currentRes.get(player);
    }
}

