/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.protection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.api.ResidenceInterface;
import com.bekvon.bukkit.residence.economy.TransactionManager;
import com.bekvon.bukkit.residence.economy.rent.RentableLand;
import com.bekvon.bukkit.residence.economy.rent.RentedLand;
import com.bekvon.bukkit.residence.event.ResidenceCreationEvent;
import com.bekvon.bukkit.residence.event.ResidenceDeleteEvent;
import com.bekvon.bukkit.residence.event.ResidenceRenameEvent;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.protection.ResidencePermissions;
import com.bekvon.bukkit.residence.text.Language;
import com.bekvon.bukkit.residence.text.help.InformationPager;
import com.bekvon.bukkit.residence.utils.GetTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ResidenceManager
implements ResidenceInterface {
    protected SortedMap<String, ClaimedResidence> residences;
    protected Map<String, Map<ChunkRef, List<String>>> chunkResidences;
    protected List<String> shops = new ArrayList<String>();
    private Residence plugin;

    public ResidenceManager(Residence plugin) {
        this.residences = new TreeMap<String, ClaimedResidence>();
        this.chunkResidences = new HashMap<String, Map<ChunkRef, List<String>>>();
        this.plugin = plugin;
    }

    public boolean isOwnerOfLocation(Player player, Location loc) {
        ClaimedResidence res = this.getByLoc(loc);
        return res != null && res.isOwner(player);
    }

    @Override
    public ClaimedResidence getByLoc(Location loc) {
        if (loc == null) {
            return null;
        }
        ClaimedResidence res = null;
        String world = loc.getWorld().getName();
        ChunkRef chunk = new ChunkRef(loc);
        if (!this.chunkResidences.containsKey(world)) {
            return null;
        }
        Map<ChunkRef, List<String>> ChunkMap = this.chunkResidences.get(world);
        if (ChunkMap.containsKey(chunk)) {
            for (String key : ChunkMap.get(chunk)) {
                ClaimedResidence entry = (ClaimedResidence)this.residences.get(key);
                if (entry == null || !entry.containsLoc(loc)) continue;
                res = entry;
                break;
            }
        }
        if (res == null) {
            return null;
        }
        ClaimedResidence subres = res.getSubzoneByLoc(loc);
        if (subres == null) {
            return res;
        }
        return subres;
    }

    @Override
    public ClaimedResidence getByName(String name) {
        return this.getByName(name, false);
    }

    public ClaimedResidence getByName(String name, boolean tp2) {
        if (name == null) {
            return null;
        }
        String[] split = name.split("\\.");
        if (Residence.getConfigManager().isResCreateCaseSensitive() && !tp2 || tp2 && Residence.getConfigManager().isResTpCaseSensitive()) {
            if (split.length == 1) {
                return (ClaimedResidence)this.residences.get(name);
            }
            ClaimedResidence res = (ClaimedResidence)this.residences.get(split[0]);
            int i = 1;
            while (i < split.length) {
                if (res == null) {
                    return null;
                }
                res = res.getSubzone(split[i]);
                ++i;
            }
            return res;
        }
        if (split.length == 1) {
            return (ClaimedResidence)this.residences.get(name.toLowerCase());
        }
        ClaimedResidence res = (ClaimedResidence)this.residences.get(split[0].toLowerCase());
        int i = 1;
        while (i < split.length) {
            if (res == null) {
                return null;
            }
            res = res.getSubzone(split[i].toLowerCase());
            ++i;
        }
        return res;
    }

    @Override
    public String getNameByLoc(Location loc) {
        ClaimedResidence res = this.getByLoc(loc);
        if (res == null) {
            return null;
        }
        String name = res.getName();
        if (name == null) {
            return null;
        }
        String szname = res.getSubzoneNameByLoc(loc);
        if (szname != null) {
            return String.valueOf(name) + "." + szname;
        }
        return name;
    }

    @Override
    public String getNameByRes(ClaimedResidence res) {
        Set<Map.Entry<String, ClaimedResidence>> set2 = this.residences.entrySet();
        for (Map.Entry<String, ClaimedResidence> check2 : set2) {
            if (check2.getValue() == res) {
                return check2.getValue().getResidenceName();
            }
            String n = check2.getValue().getSubzoneNameByRes(res);
            if (n == null) continue;
            return String.valueOf(check2.getValue().getResidenceName()) + "." + n;
        }
        return null;
    }

    @Override
    public String getSubzoneNameByRes(ClaimedResidence res) {
        Set<Map.Entry<String, ClaimedResidence>> set2 = this.residences.entrySet();
        for (Map.Entry<String, ClaimedResidence> check2 : set2) {
            if (check2.getValue() == res) {
                return check2.getKey();
            }
            String n = check2.getValue().getSubzoneNameByRes(res);
            if (n == null) continue;
            return n;
        }
        return null;
    }

    @Override
    public void addShop(String res) {
        this.shops.add(res);
    }

    @Override
    public void removeShop(ClaimedResidence res) {
        this.removeShop(res.getName());
    }

    @Override
    public void removeShop(String resName) {
        this.shops.remove(resName);
    }

    @Override
    public List<String> getShops() {
        return this.shops;
    }

    @Override
    public boolean addResidence(String name, Location loc1, Location loc2) {
        return this.addResidence(name, Residence.getServerLandname(), loc1, loc2);
    }

    @Override
    public boolean addResidence(String name, String owner, Location loc1, Location loc2) {
        return this.addResidence(null, owner, name, loc1, loc2, true);
    }

    @Override
    public boolean addResidence(Player player, String name, Location loc1, Location loc2, boolean resadmin2) {
        return this.addResidence(player, player.getName(), name, loc1, loc2, resadmin2);
    }

    public boolean addResidence(Player player, String owner, String name, Location loc1, Location loc2, boolean resadmin2) {
        int chargeamount;
        boolean createpermission;
        if (!Residence.validName(name)) {
            if (player != null) {
                player.sendMessage(Residence.getLM().getMessage("Invalid.NameCharacters"));
            }
            return false;
        }
        if (loc1 == null || loc2 == null || !loc1.getWorld().getName().equals(loc2.getWorld().getName())) {
            if (player != null) {
                player.sendMessage(Residence.getLM().getMessage("Select.Points"));
            }
            return false;
        }
        PermissionGroup group = Residence.getPermissionManager().getGroup(owner, loc1.getWorld().getName());
        boolean bl = createpermission = group.canCreateResidences() || player == null || player.hasPermission("residence.create");
        if (!createpermission && !resadmin2) {
            if (player != null) {
                player.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
            }
            return false;
        }
        if (player != null && !this.hasMaxZones(player.getName(), group.getMaxZones(player.getName())) && !resadmin2) {
            player.sendMessage(Residence.getLM().getMessage("Residence.TooMany"));
            return false;
        }
        CuboidArea newArea = new CuboidArea(loc1, loc2);
        ClaimedResidence newRes = new ClaimedResidence(owner, loc1.getWorld().getName(), this.plugin);
        newRes.getPermissions().applyDefaultFlags();
        newRes.setEnterMessage(group.getDefaultEnterMessage());
        newRes.setLeaveMessage(group.getDefaultLeaveMessage());
        newRes.setName(name);
        if (Residence.getConfigManager().isResCreateCaseSensitive()) {
            if (this.residences.containsKey(name)) {
                if (player != null) {
                    player.sendMessage(Residence.getLM().getMessage("Residence.AlreadyExists", name));
                }
                return false;
            }
        } else if (this.residences.containsKey(name.toLowerCase())) {
            if (player != null) {
                player.sendMessage(Residence.getLM().getMessage("Residence.AlreadyExists", name));
            }
            return false;
        }
        newRes.BlockSellPrice = group.getSellPerBlock();
        if (!newRes.addArea(player, newArea, "main", resadmin2, false)) {
            return false;
        }
        ResidenceCreationEvent resevent = new ResidenceCreationEvent(player, name, newRes, newArea);
        Residence.getServ().getPluginManager().callEvent((Event)resevent);
        if (resevent.isCancelled()) {
            return false;
        }
        if (!newRes.isSubzone() && Residence.getConfigManager().enableEconomy() && !resadmin2 && !TransactionManager.chargeEconomyMoney(player, chargeamount = (int)Math.ceil((double)newArea.getSize() * group.getCostPerBlock()))) {
            return false;
        }
        if (Residence.getConfigManager().isResCreateCaseSensitive()) {
            this.residences.put(name, newRes);
        } else {
            this.residences.put(name.toLowerCase(), newRes);
        }
        this.calculateChunks(name);
        Residence.getLeaseManager().removeExpireTime(name);
        Residence.getPlayerManager().addResidence(newRes.getOwner(), newRes);
        if (player != null) {
            Residence.getSelectionManager().NewMakeBorders(player, newArea.getHighLoc(), newArea.getLowLoc(), false);
            Residence.getAutoSelectionManager().getList().remove(player.getName().toLowerCase());
            player.sendMessage(Residence.getLM().getMessage("Area.Create", "main"));
            player.sendMessage(Residence.getLM().getMessage("Residence.Create", name));
        }
        if (Residence.getConfigManager().useLeases()) {
            if (player != null) {
                Residence.getLeaseManager().setExpireTime(player, name, group.getLeaseGiveTime());
            } else {
                Residence.getLeaseManager().setExpireTime(name, group.getLeaseGiveTime());
            }
        }
        return true;
    }

    public void listResidences(CommandSender sender) {
        this.listResidences(sender, sender.getName(), 1);
    }

    public void listResidences(CommandSender sender, int page) {
        this.listResidences(sender, sender.getName(), page);
    }

    public void listResidences(CommandSender sender, String targetplayer, boolean showhidden) {
        this.listResidences(sender, targetplayer, 1, showhidden, false);
    }

    public void listResidences(CommandSender sender, String targetplayer, int page) {
        this.listResidences(sender, targetplayer, page, false, false);
    }

    public void listResidences(CommandSender sender, int page, boolean showhidden) {
        this.listResidences(sender, sender.getName(), page, showhidden, false);
    }

    public void listResidences(CommandSender sender, int page, boolean showhidden, boolean onlyHidden) {
        this.listResidences(sender, sender.getName(), page, showhidden, onlyHidden);
    }

    public void listResidences(CommandSender sender, String string, int page, boolean showhidden) {
        this.listResidences(sender, string, page, showhidden, false);
    }

    public void listResidences(CommandSender sender, String targetplayer, int page, boolean showhidden, boolean onlyHidden) {
        if (showhidden && !Residence.isResAdminOn(sender) && !sender.getName().equalsIgnoreCase(targetplayer)) {
            showhidden = false;
        } else if (sender.getName().equalsIgnoreCase(targetplayer)) {
            showhidden = true;
        }
        boolean hidden = showhidden;
        ArrayList<ClaimedResidence> ownedResidences = Residence.getPlayerManager().getResidences(targetplayer, hidden, onlyHidden);
        ownedResidences.addAll(Residence.getRentManager().getRents(targetplayer, onlyHidden));
        InformationPager.printListInfo(sender, targetplayer, ownedResidences, page, showhidden);
    }

    public void listAllResidences(CommandSender sender, int page) {
        this.listAllResidences(sender, page, false);
    }

    public void listAllResidences(CommandSender sender, int page, boolean showhidden) {
        this.listAllResidences(sender, page, showhidden, false, false);
    }

    public void listAllResidences(CommandSender sender, int page, boolean showhidden, boolean showsubzones, boolean onlyHidden) {
        int perPage = 20;
        if (sender instanceof Player) {
            perPage = 6;
        }
        int start = (page - 1) * perPage;
        int end = start + perPage;
        ArrayList<ClaimedResidence> list2 = this.getFromAllResidences(showhidden, onlyHidden, start, end);
        InformationPager.printListInfo(sender, null, list2, page, showhidden);
    }

    public String[] getResidenceList() {
        return this.getResidenceList(true, true).toArray(new String[0]);
    }

    public Map<String, ClaimedResidence> getResidenceMapList(String targetplayer, boolean showhidden) {
        HashMap<String, ClaimedResidence> temp = new HashMap<String, ClaimedResidence>();
        for (Map.Entry<String, ClaimedResidence> res : this.residences.entrySet()) {
            if (!res.getValue().isOwner(targetplayer)) continue;
            boolean hidden = res.getValue().getPermissions().has("hidden", false);
            if (!showhidden && (showhidden || hidden)) continue;
            temp.put(res.getValue().getName(), res.getValue());
        }
        return temp;
    }

    public ArrayList<String> getResidenceList(boolean showhidden, boolean showsubzones) {
        return this.getResidenceList(null, showhidden, showsubzones, false);
    }

    public ArrayList<String> getResidenceList(String targetplayer, boolean showhidden, boolean showsubzones) {
        return this.getResidenceList(targetplayer, showhidden, showsubzones, false, false);
    }

    public ArrayList<String> getResidenceList(String targetplayer, boolean showhidden, boolean showsubzones, boolean onlyHidden) {
        return this.getResidenceList(targetplayer, showhidden, showsubzones, false, onlyHidden);
    }

    public ArrayList<String> getResidenceList(String targetplayer, boolean showhidden, boolean showsubzones, boolean formattedOutput, boolean onlyHidden) {
        ArrayList<String> list2 = new ArrayList<String>();
        for (Map.Entry<String, ClaimedResidence> res : this.residences.entrySet()) {
            this.getResidenceList(targetplayer, showhidden, showsubzones, "", res.getKey(), res.getValue(), list2, formattedOutput, onlyHidden);
        }
        return list2;
    }

    public ArrayList<ClaimedResidence> getFromAllResidences(boolean showhidden, boolean onlyHidden, int start, int end) {
        ArrayList<ClaimedResidence> list2 = new ArrayList<ClaimedResidence>();
        for (Map.Entry<String, ClaimedResidence> res : this.residences.entrySet()) {
            boolean hidden = res.getValue().getPermissions().has("hidden", false);
            if (onlyHidden && !hidden || !showhidden && (showhidden || hidden)) continue;
            list2.add(res.getValue());
        }
        return list2;
    }

    private void getResidenceList(String targetplayer, boolean showhidden, boolean showsubzones, String parentzone, String resname, ClaimedResidence res, ArrayList<String> list2, boolean formattedOutput, boolean onlyHidden) {
        boolean hidden = res.getPermissions().has("hidden", false);
        if (onlyHidden && !hidden) {
            return;
        }
        if (showhidden || !showhidden && !hidden) {
            if (targetplayer == null || res.getPermissions().getOwner().equals(targetplayer)) {
                if (formattedOutput) {
                    list2.add(String.valueOf(Residence.getLM().getMessage("Residence.List", parentzone, resname, res.getWorld())) + (hidden ? Residence.getLM().getMessage("Residence.Hidden") : ""));
                } else {
                    list2.add(String.valueOf(parentzone) + resname);
                }
            }
            if (showsubzones) {
                for (Map.Entry<String, ClaimedResidence> sz : res.subzones.entrySet()) {
                    this.getResidenceList(targetplayer, showhidden, showsubzones, String.valueOf(parentzone) + resname + ".", sz.getKey(), sz.getValue(), list2, formattedOutput, onlyHidden);
                }
            }
        }
    }

    public String checkAreaCollision(CuboidArea newarea, ClaimedResidence parentResidence) {
        Set<Map.Entry<String, ClaimedResidence>> set2 = this.residences.entrySet();
        for (Map.Entry<String, ClaimedResidence> entry : set2) {
            ClaimedResidence check2 = entry.getValue();
            if (check2 == parentResidence || !check2.checkCollision(newarea)) continue;
            return entry.getKey();
        }
        return null;
    }

    public void removeResidence(String name) {
        this.removeResidence((Player)null, name, true);
    }

    public void removeResidence(CommandSender sender, String name, boolean resadmin2) {
        if (sender instanceof Player) {
            this.removeResidence((Player)sender, name, resadmin2);
        } else {
            this.removeResidence((Player)null, name, true);
        }
    }

    public void removeResidence(Player player, String name, boolean resadmin2) {
        ClaimedResidence res = this.getByName(name);
        if (res == null) {
            if (player != null) {
                player.sendMessage(Residence.getLM().getMessage("Invalid.Residence"));
            }
            return;
        }
        name = res.getName();
        if (!(player == null || resadmin2 || res.getPermissions().hasResidencePermission((CommandSender)player, true) || resadmin2)) {
            player.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
            return;
        }
        ResidenceDeleteEvent resevent = new ResidenceDeleteEvent(player, res, player == null ? ResidenceDeleteEvent.DeleteCause.OTHER : ResidenceDeleteEvent.DeleteCause.PLAYER_DELETE);
        Residence.getServ().getPluginManager().callEvent((Event)resevent);
        if (resevent.isCancelled()) {
            return;
        }
        ClaimedResidence parent = res.getParent();
        if (parent == null) {
            this.removeChunkList(name);
            if (Residence.getConfigManager().isResCreateCaseSensitive()) {
                this.residences.remove(name);
            } else {
                this.residences.remove(name.toLowerCase());
            }
            if (Residence.getConfigManager().isUseClean() && Residence.getConfigManager().getCleanWorlds().contains(res.getWorld())) {
                CuboidArea area2 = res.getAreaArray()[0];
                Location low = area2.getLowLoc();
                Location high = area2.getHighLoc();
                if (high.getBlockY() > Residence.getConfigManager().getCleanLevel()) {
                    if (low.getBlockY() < Residence.getConfigManager().getCleanLevel()) {
                        low.setY((double)Residence.getConfigManager().getCleanLevel());
                    }
                    World world = low.getWorld();
                    Location temploc = new Location(world, (double)low.getBlockX(), (double)low.getBlockY(), (double)low.getBlockZ());
                    int x = low.getBlockX();
                    while (x <= high.getBlockX()) {
                        temploc.setX((double)x);
                        int y = low.getBlockY();
                        while (y <= high.getBlockY()) {
                            temploc.setY((double)y);
                            int z = low.getBlockZ();
                            while (z <= high.getBlockZ()) {
                                temploc.setZ((double)z);
                                if (Residence.getConfigManager().getCleanBlocks().contains(temploc.getBlock().getTypeId())) {
                                    temploc.getBlock().setTypeId(0);
                                }
                                ++z;
                            }
                            ++y;
                        }
                        ++x;
                    }
                }
            }
            if (player != null) {
                player.sendMessage(Residence.getLM().getMessage("Residence.Remove", name));
            }
        } else {
            String[] split = name.split("\\.");
            if (player != null) {
                parent.removeSubzone(player, split[split.length - 1], true);
            } else {
                parent.removeSubzone(split[split.length - 1]);
            }
        }
        String[] stringArray = res.getSubzoneList();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String oneSub = stringArray[n2];
            Residence.getPlayerManager().removeResFromPlayer(res.getOwner(), String.valueOf(name) + "." + oneSub);
            Residence.getRentManager().removeRentable(String.valueOf(name) + "." + oneSub);
            Residence.getTransactionManager().removeFromSale(String.valueOf(name) + "." + oneSub);
            ++n2;
        }
        Residence.getPlayerManager().removeResFromPlayer(res.getOwner(), name);
        Residence.getRentManager().removeRentable(name);
        Residence.getTransactionManager().removeFromSale(name);
        if (parent == null && Residence.getConfigManager().enableEconomy() && Residence.getConfigManager().useResMoneyBack()) {
            int chargeamount = (int)Math.ceil((double)res.getAreaArray()[0].getSize() * res.getBlockSellPrice());
            TransactionManager.giveEconomyMoney(player, chargeamount);
        }
    }

    public void removeAllByOwner(String owner) {
        this.removeAllByOwner(null, owner, this.residences);
    }

    public void removeAllByOwner(CommandSender sender, String owner) {
        this.removeAllByOwner(sender, owner, this.residences);
    }

    private void removeAllByOwner(CommandSender sender, String owner, Map<String, ClaimedResidence> resholder) {
        ArrayList<String> list2 = Residence.getPlayerManager().getResidenceList(owner);
        for (String oneRes : list2) {
            this.removeResidence((Player)null, oneRes, true);
        }
    }

    public int getOwnedZoneCount(String player) {
        return Residence.getPlayerManager().getResidenceList(player).size();
    }

    public boolean hasMaxZones(String player, int target) {
        int count = this.getOwnedZoneCount(player);
        return count < target;
    }

    public void printAreaInfo(String areaname, CommandSender sender) {
        this.printAreaInfo(areaname, sender, false);
    }

    public void printAreaInfo(String areaname, CommandSender sender, boolean resadmin2) {
        String time;
        ClaimedResidence res = this.getByName(areaname);
        if (res == null) {
            sender.sendMessage(Residence.getLM().getMessage("Invalid.Residence"));
            return;
        }
        areaname = res.getName();
        sender.sendMessage(Residence.getLM().getMessage("General.Separator"));
        ResidencePermissions perms = res.getPermissions();
        Language lm = Residence.getLM();
        String resNameOwner = "&e" + lm.getMessage("Residence.Line", areaname);
        resNameOwner = String.valueOf(resNameOwner) + lm.getMessage("General.Owner", perms.getOwner());
        if (Residence.getConfigManager().enableEconomy() && (res.isOwner(sender.getName()) || !(sender instanceof Player) || resadmin2)) {
            resNameOwner = String.valueOf(resNameOwner) + lm.getMessage("Bank.Name", res.getBank().getStoredMoney());
        }
        resNameOwner = ChatColor.translateAlternateColorCodes((char)'&', (String)resNameOwner);
        String worldInfo = lm.getMessage("General.World", perms.getWorld());
        if (res.getPermissions().has("hidden", FlagPermissions.FlagCombo.FalseOrNone) && res.getPermissions().has("coords", FlagPermissions.FlagCombo.TrueOrNone) || resadmin2) {
            worldInfo = String.valueOf(worldInfo) + "&6 (&3";
            CuboidArea area2 = res.getAreaArray()[0];
            worldInfo = String.valueOf(worldInfo) + lm.getMessage("General.CoordsTop", area2.getHighLoc().getBlockX(), area2.getHighLoc().getBlockY(), area2.getHighLoc().getBlockZ());
            worldInfo = String.valueOf(worldInfo) + "&6; &3";
            worldInfo = String.valueOf(worldInfo) + lm.getMessage("General.CoordsBottom", area2.getLowLoc().getBlockX(), area2.getLowLoc().getBlockY(), area2.getLowLoc().getBlockZ());
            worldInfo = String.valueOf(worldInfo) + "&6)";
            worldInfo = ChatColor.translateAlternateColorCodes((char)'&', (String)worldInfo);
        }
        worldInfo = String.valueOf(worldInfo) + "\n" + Residence.getLM().getMessage("General.CreatedOn", GetTime.getTime(res.createTime));
        String ResFlagList = perms.listFlags(5);
        if (!(sender instanceof Player)) {
            ResFlagList = perms.listFlags();
        }
        String ResFlagMsg = lm.getMessage("General.ResidenceFlags", ResFlagList);
        if (perms.getFlags().size() > 2 && sender instanceof Player) {
            ResFlagMsg = String.valueOf(lm.getMessage("General.ResidenceFlags", perms.listFlags(5, 3))) + "...";
        }
        if (sender instanceof Player) {
            String raw = this.convertToRaw(null, resNameOwner, worldInfo);
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + sender.getName() + " " + raw));
            raw = this.convertToRaw(null, ResFlagMsg, ResFlagList);
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + sender.getName() + " " + raw));
        } else {
            sender.sendMessage(resNameOwner);
            sender.sendMessage(worldInfo);
            sender.sendMessage(ResFlagMsg);
        }
        if (!Residence.getConfigManager().isShortInfoUse() || !(sender instanceof Player)) {
            sender.sendMessage(lm.getMessage("General.PlayersFlags", perms.listPlayersFlags()));
        } else if (Residence.getConfigManager().isShortInfoUse() || sender instanceof Player) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + sender.getName() + " " + perms.listPlayersFlagsRaw(sender.getName(), lm.getMessage("General.PlayersFlags"))));
        }
        String groupFlags = perms.listGroupFlags();
        if (groupFlags.length() > 0) {
            sender.sendMessage(lm.getMessage("General.GroupFlags", groupFlags));
        }
        String msg = "";
        msg = String.valueOf(msg) + lm.getMessage("General.TotalSize", res.getTotalSize());
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
        if (Residence.getEconomyManager() != null) {
            PermissionGroup group = Residence.getPermissionManager().getGroup(res.getOwner(), res.getWorld());
            sender.sendMessage(lm.getMessage("General.TotalWorth", (double)((int)((double)res.getTotalSize() * group.getCostPerBlock() * 100.0)) / 100.0, (double)((int)((double)res.getTotalSize() * res.getBlockSellPrice() * 100.0)) / 100.0));
        }
        if (Residence.getConfigManager().useLeases() && Residence.getLeaseManager().leaseExpires(areaname) && (time = Residence.getLeaseManager().getExpireTime(areaname)) != null) {
            sender.sendMessage(lm.getMessage("Economy.LeaseExpire", time));
        }
        if (Residence.getConfigManager().enabledRentSystem() && Residence.getRentManager().isForRent(areaname) && !Residence.getRentManager().isRented(areaname)) {
            String forRentMsg = lm.getMessage("Rent.isForRent");
            RentableLand rentable = Residence.getRentManager().getRentableLand(areaname);
            StringBuilder rentableString = new StringBuilder();
            if (rentable != null) {
                rentableString.append(String.valueOf(Residence.getLM().getMessage("General.Cost", rentable.cost, rentable.days)) + "\n");
                rentableString.append(String.valueOf(Residence.getLM().getMessage("Rentable.AllowRenewing", rentable.AllowRenewing)) + "\n");
                rentableString.append(String.valueOf(Residence.getLM().getMessage("Rentable.StayInMarket", rentable.StayInMarket)) + "\n");
                rentableString.append(Residence.getLM().getMessage("Rentable.AllowAutoPay", rentable.AllowAutoPay));
            }
            if (sender instanceof Player) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + sender.getName() + " " + this.convertToRaw(null, forRentMsg, rentableString.toString())));
            } else {
                sender.sendMessage(forRentMsg);
            }
        } else if (Residence.getConfigManager().enabledRentSystem() && Residence.getRentManager().isRented(areaname)) {
            String RentedMsg = lm.getMessage("Residence.RentedBy", Residence.getRentManager().getRentingPlayer(areaname));
            RentableLand rentable = Residence.getRentManager().getRentableLand(areaname);
            RentedLand rented = Residence.getRentManager().getRentedLand(areaname);
            StringBuilder rentableString = new StringBuilder();
            if (rented != null) {
                rentableString.append(String.valueOf(Residence.getLM().getMessage("Rent.Expire", GetTime.getTime(rented.endTime))) + "\n");
                if (rented.player.equals(sender.getName()) || resadmin2 || res.isOwner(sender.getName())) {
                    rentableString.append(String.valueOf(rented.AutoPay ? Residence.getLM().getMessage("Rent.AutoPayTurnedOn") : Residence.getLM().getMessage("Rent.AutoPayTurnedOff")) + "\n");
                }
            }
            if (rentable != null) {
                rentableString.append(String.valueOf(Residence.getLM().getMessage("General.Cost", rentable.cost, rentable.days)) + "\n");
                rentableString.append(String.valueOf(Residence.getLM().getMessage("Rentable.AllowRenewing", rentable.AllowRenewing)) + "\n");
                rentableString.append(String.valueOf(Residence.getLM().getMessage("Rentable.StayInMarket", rentable.StayInMarket)) + "\n");
                rentableString.append(Residence.getLM().getMessage("Rentable.AllowAutoPay", rentable.AllowAutoPay));
            }
            if (sender instanceof Player) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + sender.getName() + " " + this.convertToRaw(null, RentedMsg, rentableString.toString())));
            } else {
                sender.sendMessage(RentedMsg);
            }
        } else if (Residence.getTransactionManager().isForSale(areaname)) {
            int amount = Residence.getTransactionManager().getSaleAmount(areaname);
            String SellMsg = String.valueOf(lm.getMessage("Economy.LandForSale")) + " " + amount;
            sender.sendMessage(SellMsg);
        }
        sender.sendMessage(Residence.getLM().getMessage("General.Separator"));
    }

    public String convertToRaw(String preText, String text, String hover) {
        return this.convertToRaw(preText, text, hover, null);
    }

    public String convertToRaw(String preText, String text, String hover, String command2) {
        StringBuilder msg = new StringBuilder();
        String cmd2 = "";
        if (command2 != null) {
            cmd2 = ",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/" + command2 + "\"}";
        }
        msg.append("[\"\",");
        if (preText != null) {
            msg.append("{\"text\":\"" + preText + "\"}");
        }
        msg.append("{\"text\":\"" + text + "\"" + cmd2 + ",\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[{\"text\":\"" + hover + "\"}]}}}");
        msg.append("]");
        return msg.toString();
    }

    public void mirrorPerms(Player reqPlayer, String targetArea, String sourceArea, boolean resadmin2) {
        ClaimedResidence reciever = this.getByName(targetArea);
        ClaimedResidence source = this.getByName(sourceArea);
        if (source == null || reciever == null) {
            reqPlayer.sendMessage(Residence.getLM().getMessage("Invalid.Residence"));
            return;
        }
        if (!(resadmin2 || reciever.getPermissions().hasResidencePermission((CommandSender)reqPlayer, true) && source.getPermissions().hasResidencePermission((CommandSender)reqPlayer, true))) {
            reqPlayer.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
            return;
        }
        reciever.getPermissions().applyTemplate(reqPlayer, source.getPermissions(), resadmin2);
    }

    public Map<String, Object> save() {
        LinkedHashMap<String, Object> worldmap = new LinkedHashMap<String, Object>();
        for (World world : Residence.getServ().getWorlds()) {
            LinkedHashMap<String, Map<String, Object>> resmap = new LinkedHashMap<String, Map<String, Object>>();
            for (Map.Entry<String, ClaimedResidence> res : this.residences.entrySet()) {
                if (!res.getValue().getWorld().equals(world.getName())) continue;
                try {
                    resmap.put(res.getValue().getShortName(), res.getValue().save());
                }
                catch (Exception ex) {
                    Bukkit.getConsoleSender().sendMessage(String.valueOf(Residence.prefix) + ChatColor.RED + " Failed to save residence (" + res.getKey() + ")!");
                    Logger.getLogger(ResidenceManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            worldmap.put(world.getName(), resmap);
        }
        return worldmap;
    }

    public ResidenceManager load(Map<String, Object> root) throws Exception {
        ResidenceManager resm = new ResidenceManager(this.plugin);
        if (root == null) {
            return resm;
        }
        for (World world : Residence.getServ().getWorlds()) {
            long pass;
            long time;
            block5: {
                time = System.currentTimeMillis();
                Map reslist = (Map)root.get(world.getName());
                Bukkit.getConsoleSender().sendMessage(String.valueOf(Residence.prefix) + " Loading " + world.getName() + " data into memory...");
                if (reslist != null) {
                    try {
                        resm.chunkResidences.put(world.getName(), this.loadMap(world.getName(), reslist, resm));
                    }
                    catch (Exception ex) {
                        Bukkit.getConsoleSender().sendMessage(String.valueOf(Residence.prefix) + ChatColor.RED + "Error in loading save file for world: " + world.getName());
                        if (!Residence.getConfigManager().stopOnSaveError()) break block5;
                        throw ex;
                    }
                }
            }
            String PastTime = (pass = System.currentTimeMillis() - time) > 1000L ? String.valueOf(String.format("%.2f", Float.valueOf((float)pass / 1000.0f))) + " sec" : String.valueOf(pass) + " ms";
            Bukkit.getConsoleSender().sendMessage(String.valueOf(Residence.prefix) + " Loaded " + world.getName() + " data into memory. (" + PastTime + ")");
        }
        return resm;
    }

    public Map<ChunkRef, List<String>> loadMap(String worldName, Map<String, Object> root, ResidenceManager resm) throws Exception {
        HashMap<ChunkRef, List<String>> retRes = new HashMap<ChunkRef, List<String>>();
        if (root == null) {
            return retRes;
        }
        int i = 0;
        int y = 0;
        for (Map.Entry<String, Object> res : root.entrySet()) {
            if (i == 100 & Residence.getConfigManager().isUUIDConvertion()) {
                Bukkit.getConsoleSender().sendMessage(String.valueOf(Residence.prefix) + " " + worldName + " UUID conversion done: " + y + " of " + root.size());
            }
            if (i >= 100) {
                i = 0;
            }
            ++i;
            ++y;
            try {
                ClaimedResidence residence = ClaimedResidence.load((Map)res.getValue(), null, this.plugin);
                if (residence == null || residence.getPermissions().getOwnerUUID().toString().equals(Residence.getServerLandUUID()) && !residence.getOwner().equalsIgnoreCase("Server land") && !residence.getOwner().equalsIgnoreCase(Residence.getServerLandname())) continue;
                if (residence.getOwner().equalsIgnoreCase("Server land")) {
                    residence.getPermissions().setOwner(Residence.getServerLandname(), false);
                }
                String resName = res.getKey();
                if (residence.getResidenceName() == null) {
                    residence.setName(res.getKey());
                }
                if (!Residence.getConfigManager().isResCreateCaseSensitive()) {
                    resName = resName.toLowerCase();
                }
                for (ChunkRef chunk : ResidenceManager.getChunks(residence)) {
                    ArrayList<String> ress = new ArrayList<String>();
                    if (retRes.containsKey(chunk)) {
                        ress.addAll((Collection)retRes.get(chunk));
                    }
                    ress.add(resName);
                    retRes.put(chunk, ress);
                }
                resm.residences.put(resName, residence);
            }
            catch (Exception ex) {
                Bukkit.getConsoleSender().sendMessage(String.valueOf(Residence.prefix) + ChatColor.RED + " Failed to load residence (" + res.getKey() + ")! Reason:" + ex.getMessage() + " Error Log:");
                Logger.getLogger(ResidenceManager.class.getName()).log(Level.SEVERE, null, ex);
                if (!Residence.getConfigManager().stopOnSaveError()) continue;
                throw ex;
            }
        }
        return retRes;
    }

    private static List<ChunkRef> getChunks(ClaimedResidence res) {
        ArrayList<ChunkRef> chunks = new ArrayList<ChunkRef>();
        CuboidArea[] cuboidAreaArray = res.getAreaArray();
        int n = cuboidAreaArray.length;
        int n2 = 0;
        while (n2 < n) {
            CuboidArea area2 = cuboidAreaArray[n2];
            chunks.addAll(area2.getChunks());
            ++n2;
        }
        return chunks;
    }

    public boolean renameResidence(String oldName, String newName) {
        return this.renameResidence(null, oldName, newName, true);
    }

    public boolean renameResidence(Player player, String oldName, String newName, boolean resadmin2) {
        if (!player.hasPermission("residence.rename")) {
            player.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
            return false;
        }
        if (!Residence.validName(newName)) {
            player.sendMessage(Residence.getLM().getMessage("Invalid.NameCharacters"));
            return false;
        }
        ClaimedResidence res = this.getByName(oldName);
        if (res == null) {
            if (player != null) {
                player.sendMessage(Residence.getLM().getMessage("Invalid.Residence"));
            }
            return false;
        }
        oldName = res.getName();
        if (res.getPermissions().hasResidencePermission((CommandSender)player, true) || resadmin2) {
            if (res.getParent() == null) {
                if (Residence.getConfigManager().isResCreateCaseSensitive()) {
                    if (this.residences.containsKey(newName)) {
                        if (player != null) {
                            player.sendMessage(Residence.getLM().getMessage("Residence.AlreadyExists", newName));
                        }
                        return false;
                    }
                } else if (this.residences.containsKey(newName.toLowerCase())) {
                    if (player != null) {
                        player.sendMessage(Residence.getLM().getMessage("Residence.AlreadyExists", newName));
                    }
                    return false;
                }
                ResidenceRenameEvent resevent = new ResidenceRenameEvent(res, newName, oldName);
                Residence.getServ().getPluginManager().callEvent((Event)resevent);
                this.removeChunkList(oldName);
                res.setName(newName);
                if (Residence.getConfigManager().isResCreateCaseSensitive()) {
                    this.residences.put(newName, res);
                } else {
                    this.residences.put(newName.toLowerCase(), res);
                }
                this.residences.remove(oldName);
                Residence.getPlayerManager().renameResidence(player.getName(), res.getName(), newName);
                this.calculateChunks(newName);
                if (Residence.getConfigManager().useLeases()) {
                    Residence.getLeaseManager().updateLeaseName(oldName, newName);
                }
                Residence.getSignUtil().updateSignResName(res);
                if (player != null) {
                    player.sendMessage(Residence.getLM().getMessage("Residence.Rename", oldName, newName));
                }
                return true;
            }
            String[] oldname = oldName.split("\\.");
            ClaimedResidence parent = res.getParent();
            boolean feed = parent.renameSubzone(player, oldname[oldname.length - 1], newName, resadmin2);
            Residence.getSignUtil().updateSignResName(res);
            return feed;
        }
        if (player != null) {
            player.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
        }
        return false;
    }

    public void giveResidence(Player reqPlayer, String targPlayer, String residence, boolean resadmin2) {
        PermissionGroup g;
        ClaimedResidence res = this.getByName(residence);
        if (res == null) {
            reqPlayer.sendMessage(Residence.getLM().getMessage("Invalid.Residence"));
            return;
        }
        residence = res.getName();
        if (!res.getPermissions().hasResidencePermission((CommandSender)reqPlayer, true) && !resadmin2) {
            reqPlayer.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
            return;
        }
        Player giveplayer = Residence.getServ().getPlayer(targPlayer);
        if (giveplayer == null || !giveplayer.isOnline()) {
            reqPlayer.sendMessage(Residence.getLM().getMessage("General.NotOnline"));
            return;
        }
        CuboidArea[] areas = res.getAreaArray();
        if (areas.length > (g = Residence.getPermissionManager().getGroup(giveplayer)).getMaxPhysicalPerResidence() && !resadmin2) {
            reqPlayer.sendMessage(Residence.getLM().getMessage("Residence.GiveLimits"));
            return;
        }
        if (!this.hasMaxZones(giveplayer.getName(), g.getMaxZones(giveplayer.getName())) && !resadmin2) {
            reqPlayer.sendMessage(Residence.getLM().getMessage("Residence.GiveLimits"));
            return;
        }
        if (!resadmin2) {
            CuboidArea[] cuboidAreaArray = areas;
            int n = areas.length;
            int n2 = 0;
            while (n2 < n) {
                CuboidArea area2 = cuboidAreaArray[n2];
                if (!g.inLimits(area2)) {
                    reqPlayer.sendMessage(Residence.getLM().getMessage("Residence.GiveLimits"));
                    return;
                }
                ++n2;
            }
        }
        Residence.getPlayerManager().removeResFromPlayer(reqPlayer, residence);
        Residence.getPlayerManager().addResidence(targPlayer, res);
        res.getPermissions().setOwner(giveplayer.getName(), true);
        reqPlayer.sendMessage(Residence.getLM().getMessage("Residence.Give", residence, giveplayer.getName()));
        giveplayer.sendMessage(Residence.getLM().getMessage("Residence.Recieve", residence, reqPlayer.getName()));
    }

    public void removeAllFromWorld(CommandSender sender, String world) {
        int count = 0;
        Iterator<ClaimedResidence> it = this.residences.values().iterator();
        while (it.hasNext()) {
            ClaimedResidence next = it.next();
            if (!next.getWorld().equals(world)) continue;
            it.remove();
            ++count;
        }
        this.chunkResidences.remove(world);
        this.chunkResidences.put(world, new HashMap());
        if (count == 0) {
            sender.sendMessage(ChatColor.RED + "No residences found in world: " + ChatColor.YELLOW + world);
        } else {
            sender.sendMessage(ChatColor.RED + "Removed " + ChatColor.YELLOW + count + ChatColor.RED + " residences in world: " + ChatColor.YELLOW + world);
        }
        Residence.getPlayerManager().fillList();
    }

    public int getResidenceCount() {
        return this.residences.size();
    }

    public Map<String, ClaimedResidence> getResidences() {
        return this.residences;
    }

    public void removeChunkList(String name) {
        String world;
        ClaimedResidence res;
        if (name == null) {
            return;
        }
        if (!Residence.getConfigManager().isResCreateCaseSensitive()) {
            name = name.toLowerCase();
        }
        if ((res = (ClaimedResidence)this.residences.get(name)) != null && this.chunkResidences.get(world = res.getWorld()) != null) {
            for (ChunkRef chunk : ResidenceManager.getChunks(res)) {
                ArrayList ress = new ArrayList();
                if (this.chunkResidences.get(world).containsKey(chunk)) {
                    ress.addAll(this.chunkResidences.get(world).get(chunk));
                }
                ress.remove(name);
                this.chunkResidences.get(world).put(chunk, ress);
            }
        }
    }

    public void calculateChunks(String name) {
        ClaimedResidence res = null;
        if (name == null) {
            return;
        }
        if (!Residence.getConfigManager().isResCreateCaseSensitive()) {
            name = name.toLowerCase();
        }
        if ((res = (ClaimedResidence)this.residences.get(name)) != null) {
            String world = res.getWorld();
            if (this.chunkResidences.get(world) == null) {
                this.chunkResidences.put(world, new HashMap());
            }
            for (ChunkRef chunk : ResidenceManager.getChunks(res)) {
                ArrayList<String> ress = new ArrayList<String>();
                if (this.chunkResidences.get(world).containsKey(chunk)) {
                    ress.addAll((Collection)this.chunkResidences.get(world).get(chunk));
                }
                ress.add(name);
                this.chunkResidences.get(world).put(chunk, ress);
            }
        }
    }

    public static final class ChunkRef {
        private final int z;
        private final int x;

        public static int getChunkCoord(int val) {
            return val >> 4;
        }

        public ChunkRef(Location loc) {
            this.x = ChunkRef.getChunkCoord(loc.getBlockX());
            this.z = ChunkRef.getChunkCoord(loc.getBlockZ());
        }

        public ChunkRef(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChunkRef other = (ChunkRef)obj;
            return this.x == other.x && this.z == other.z;
        }

        public int hashCode() {
            return this.x ^ this.z;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ x: ").append(this.x).append(", z: ").append(this.z).append(" }");
            return sb.toString();
        }
    }
}

