/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.permissions;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;

public class PermissionGroup {
    protected int xmax;
    protected int ymax;
    protected int zmax;
    protected int resmax;
    protected double costperarea;
    protected double sellperarea = 0.0;
    protected boolean tpaccess;
    protected int subzonedepth;
    protected FlagPermissions flagPerms = new FlagPermissions();
    protected Map<String, Boolean> creatorDefaultFlags = new HashMap<String, Boolean>();
    protected Map<String, Map<String, Boolean>> groupDefaultFlags;
    protected Map<String, Boolean> residenceDefaultFlags = new HashMap<String, Boolean>();
    protected boolean messageperms;
    protected String defaultEnterMessage;
    protected String defaultLeaveMessage;
    protected int maxLeaseTime;
    protected int leaseGiveTime;
    protected double renewcostperarea;
    protected boolean canBuy;
    protected boolean canSell;
    protected boolean buyIgnoreLimits;
    protected boolean cancreate;
    protected String groupname;
    protected int maxPhysical;
    protected boolean unstuck;
    protected boolean kick;
    protected int minHeight;
    protected int maxHeight;
    protected int maxRents;
    protected int MaxRentDays = -1;
    protected int maxRentables;
    protected boolean selectCommandAccess;
    protected boolean itemListAccess;
    protected int priority = 0;

    public PermissionGroup(String name) {
        this.groupDefaultFlags = new HashMap<String, Map<String, Boolean>>();
        this.groupname = name;
    }

    public void setPriority(int number) {
        this.priority = number;
    }

    public int getPriority() {
        return this.priority;
    }

    public PermissionGroup(String name, ConfigurationSection node) {
        this(name);
        this.parseGroup(node);
    }

    public PermissionGroup(String name, ConfigurationSection node, FlagPermissions parentFlagPerms) {
        this(name, node);
        this.flagPerms.setParent(parentFlagPerms);
    }

    public PermissionGroup(String name, ConfigurationSection node, FlagPermissions parentFlagPerms, int priority) {
        this(name, node);
        this.flagPerms.setParent(parentFlagPerms);
        this.priority = priority;
    }

    private void parseGroup(ConfigurationSection limits2) {
        boolean access;
        if (limits2 == null) {
            return;
        }
        this.cancreate = limits2.getBoolean("Residence.CanCreate", false);
        this.resmax = limits2.getInt("Residence.MaxResidences", 0);
        this.maxPhysical = limits2.getInt("Residence.MaxAreasPerResidence", 2);
        this.xmax = limits2.getInt("Residence.MaxEastWest", 0);
        this.ymax = limits2.getInt("Residence.MaxUpDown", 0);
        this.zmax = limits2.getInt("Residence.MaxNorthSouth", 0);
        this.minHeight = limits2.getInt("Residence.MinHeight", 0);
        this.maxHeight = limits2.getInt("Residence.MaxHeight", 255);
        this.tpaccess = limits2.getBoolean("Residence.CanTeleport", false);
        this.subzonedepth = limits2.getInt("Residence.SubzoneDepth", 0);
        this.messageperms = limits2.getBoolean("Messaging.CanChange", false);
        this.defaultEnterMessage = limits2.getString("Messaging.DefaultEnter", null);
        this.defaultLeaveMessage = limits2.getString("Messaging.DefaultLeave", null);
        this.maxLeaseTime = limits2.getInt("Lease.MaxDays", 16);
        this.leaseGiveTime = limits2.getInt("Lease.RenewIncrement", 14);
        this.maxRents = limits2.getInt("Rent.MaxRents", 0);
        if (limits2.contains("Rent.MaxRentDays")) {
            this.MaxRentDays = limits2.getInt("Rent.MaxRentDays", -1);
        }
        this.maxRentables = limits2.getInt("Rent.MaxRentables", 0);
        this.renewcostperarea = limits2.getDouble("Economy.RenewCost", 0.02);
        this.canBuy = limits2.getBoolean("Economy.CanBuy", false);
        this.canSell = limits2.getBoolean("Economy.CanSell", false);
        this.buyIgnoreLimits = limits2.getBoolean("Economy.IgnoreLimits", false);
        this.costperarea = limits2.getDouble("Economy.BuyCost", 0.0);
        if (limits2.contains("Economy.SellCost")) {
            this.sellperarea = limits2.getDouble("Economy.SellCost", 0.0);
        }
        this.unstuck = limits2.getBoolean("Residence.Unstuck", false);
        this.kick = limits2.getBoolean("Residence.Kick", false);
        this.selectCommandAccess = limits2.getBoolean("Residence.SelectCommandAccess", true);
        this.itemListAccess = limits2.getBoolean("Residence.ItemListAccess", true);
        ConfigurationSection node = limits2.getConfigurationSection("Flags.Permission");
        Set flags2 = null;
        if (node != null) {
            flags2 = node.getKeys(false);
        }
        if (flags2 != null) {
            Iterator flagit = flags2.iterator();
            while (flagit.hasNext()) {
                String flagname;
                access = limits2.getBoolean("Flags.Permission." + (flagname = (String)flagit.next()), false);
                this.flagPerms.setFlag(flagname, access ? FlagPermissions.FlagState.TRUE : FlagPermissions.FlagState.FALSE);
            }
        }
        if ((node = limits2.getConfigurationSection("Flags.CreatorDefault")) != null) {
            flags2 = node.getKeys(false);
        }
        if (flags2 != null) {
            for (String flagname : flags2) {
                access = limits2.getBoolean("Flags.CreatorDefault." + flagname, false);
                this.creatorDefaultFlags.put(flagname, access);
            }
        }
        if ((node = limits2.getConfigurationSection("Flags.Default")) != null) {
            flags2 = node.getKeys(false);
        }
        if (flags2 != null) {
            for (String flagname : flags2) {
                access = limits2.getBoolean("Flags.Default." + flagname, false);
                this.residenceDefaultFlags.put(flagname, access);
            }
        }
        node = limits2.getConfigurationSection("Flags.GroupDefault");
        Set groupDef = null;
        if (node != null) {
            groupDef = node.getKeys(false);
        }
        if (groupDef != null) {
            for (String name : groupDef) {
                HashMap<String, Boolean> gflags = new HashMap<String, Boolean>();
                flags2 = limits2.getConfigurationSection("Flags.GroupDefault." + name).getKeys(false);
                for (String flagname : flags2) {
                    boolean access2 = limits2.getBoolean("Flags.GroupDefault." + name + "." + flagname, false);
                    gflags.put(flagname, access2);
                }
                this.groupDefaultFlags.put(name, gflags);
            }
        }
    }

    public String getGroupName() {
        return this.groupname;
    }

    public int getMaxX() {
        return this.xmax;
    }

    public int getMaxY() {
        return this.ymax;
    }

    public int getMaxZ() {
        return this.zmax;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getMaxZones() {
        return this.resmax;
    }

    public int getMaxZones(String player) {
        int max = Residence.getPlayerManager().getMaxResidences(player);
        if (max != -1) {
            return max;
        }
        return this.resmax;
    }

    public double getCostPerBlock() {
        return this.costperarea;
    }

    public double getSellPerBlock() {
        return this.sellperarea;
    }

    public boolean hasTpAccess() {
        return this.tpaccess;
    }

    public int getMaxSubzoneDepth(String player) {
        int max = Residence.getPlayerManager().getMaxSubzones(player);
        if (max != -1) {
            return max;
        }
        return this.subzonedepth;
    }

    public boolean canSetEnterLeaveMessages() {
        return this.messageperms;
    }

    public String getDefaultEnterMessage() {
        return this.defaultEnterMessage;
    }

    public String getDefaultLeaveMessage() {
        return this.defaultLeaveMessage;
    }

    public int getMaxLeaseTime() {
        return this.maxLeaseTime;
    }

    public int getLeaseGiveTime() {
        return this.leaseGiveTime;
    }

    public double getLeaseRenewCost() {
        return this.renewcostperarea;
    }

    public boolean canBuyLand() {
        return this.canBuy;
    }

    public boolean canSellLand() {
        return this.canSell;
    }

    public int getMaxRents(String player) {
        int max = Residence.getPlayerManager().getMaxRents(player);
        if (max != -1) {
            return max;
        }
        return this.maxRents;
    }

    public int getMaxRentDays() {
        return this.MaxRentDays;
    }

    public int getMaxRentables() {
        return this.maxRentables;
    }

    public boolean buyLandIgnoreLimits() {
        return this.buyIgnoreLimits;
    }

    public boolean hasUnstuckAccess() {
        return this.unstuck;
    }

    public boolean hasKickAccess() {
        return this.kick;
    }

    public int getMaxPhysicalPerResidence() {
        return this.maxPhysical;
    }

    public Set<Map.Entry<String, Boolean>> getDefaultResidenceFlags() {
        return this.residenceDefaultFlags.entrySet();
    }

    public Set<Map.Entry<String, Boolean>> getDefaultCreatorFlags() {
        return this.creatorDefaultFlags.entrySet();
    }

    public Set<Map.Entry<String, Map<String, Boolean>>> getDefaultGroupFlags() {
        return this.groupDefaultFlags.entrySet();
    }

    public boolean canCreateResidences() {
        return this.cancreate;
    }

    public boolean hasFlagAccess(String flag) {
        return this.flagPerms.has(flag, false);
    }

    public boolean inLimits(CuboidArea area2) {
        return area2.getXSize() <= this.xmax && area2.getYSize() <= this.ymax && area2.getZSize() <= this.zmax;
    }

    public boolean selectCommandAccess() {
        return this.selectCommandAccess;
    }

    public boolean itemListAccess() {
        return this.itemListAccess;
    }

    public void printLimits(CommandSender player, OfflinePlayer target, boolean resadmin2) {
        player.sendMessage(Residence.getLM().getMessage("General.Separator"));
        player.sendMessage(Residence.getLM().getMessage("Limits.PGroup", Residence.getPermissionManager().getPermissionsGroup(target.getName(), Residence.getConfigManager().getDefaultWorld())));
        player.sendMessage(Residence.getLM().getMessage("Limits.RGroup", this.groupname));
        if (target.isOnline() && resadmin2) {
            player.sendMessage(Residence.getLM().getMessage("Limits.Admin", Residence.getPermissionManager().isResidenceAdmin(player)));
        }
        player.sendMessage(Residence.getLM().getMessage("Limits.CanCreate", this.cancreate));
        player.sendMessage(Residence.getLM().getMessage("Limits.MaxRes", this.getMaxZones(target.getName())));
        player.sendMessage(Residence.getLM().getMessage("Limits.MaxEW", this.xmax));
        player.sendMessage(Residence.getLM().getMessage("Limits.MaxNS", this.zmax));
        player.sendMessage(Residence.getLM().getMessage("Limits.MaxUD", this.ymax));
        player.sendMessage(Residence.getLM().getMessage("Limits.MinMax", this.minHeight, this.maxHeight));
        player.sendMessage(Residence.getLM().getMessage("Limits.MaxSub", this.getMaxSubzoneDepth(target.getName())));
        player.sendMessage(String.valueOf(Residence.getLM().getMessage("Limits.MaxRents", this.getMaxRents(target.getName()))) + (this.getMaxRentDays() != -1 ? Residence.getLM().getMessage("Limits.MaxRentDays", this.getMaxRentDays()) : ""));
        player.sendMessage(Residence.getLM().getMessage("Limits.EnterLeave", this.messageperms));
        player.sendMessage(Residence.getLM().getMessage("Limits.NumberOwn", Residence.getResidenceManager().getOwnedZoneCount(target.getName())));
        if (Residence.getEconomyManager() != null) {
            player.sendMessage(Residence.getLM().getMessage("Limits.Cost", this.costperarea));
            player.sendMessage(Residence.getLM().getMessage("Limits.Sell", this.sellperarea));
        }
        player.sendMessage(Residence.getLM().getMessage("Limits.Flag", this.flagPerms.listFlags()));
        if (Residence.getConfigManager().useLeases()) {
            player.sendMessage(Residence.getLM().getMessage("Limits.Flag", this.maxLeaseTime));
            player.sendMessage(Residence.getLM().getMessage("Limits.Flag", this.leaseGiveTime));
            player.sendMessage(Residence.getLM().getMessage("Limits.Flag", this.renewcostperarea));
        }
        player.sendMessage(Residence.getLM().getMessage("General.Separator"));
    }
}

