/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.containers;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.vaultinterface.ResidenceVaultAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public class PlayerGroup {
    String playerName = null;
    Player player = null;
    long lastCheck = 0L;
    HashMap<String, String> groups = new HashMap();

    public PlayerGroup(String playerName) {
        this.playerName = playerName;
        this.player = Bukkit.getPlayer((String)playerName);
    }

    public PlayerGroup(Player player) {
        this.playerName = player.getName();
        this.player = player;
    }

    public void setLastCkeck(Long time) {
        this.lastCheck = time;
    }

    public void addGroup(String world, String group) {
        this.groups.put(world, group);
    }

    public String getGroup(String world) {
        this.updateGroup(world, false);
        return this.groups.get(world);
    }

    public void updateGroup(String world, boolean force) {
        PermissionGroup g;
        String group;
        if (!force && this.lastCheck != 0L && System.currentTimeMillis() - this.lastCheck < 60000L) {
            return;
        }
        this.lastCheck = System.currentTimeMillis();
        ArrayList<PermissionGroup> posibleGroups = new ArrayList<PermissionGroup>();
        if (Residence.getPermissionManager().getPlayersGroups().containsKey(this.playerName.toLowerCase()) && (group = Residence.getPermissionManager().getPlayersGroups().get(this.playerName.toLowerCase())) != null && (group = group.toLowerCase()) != null && Residence.getPermissionManager().getGroups().containsKey(group)) {
            g = Residence.getPermissionManager().getGroups().get(group);
            posibleGroups.add(g);
            this.groups.put(world, group);
        }
        posibleGroups.add(this.getPermissionGroup());
        group = Residence.getPermissionManager().getPermissionsGroup(this.playerName.toLowerCase(), world);
        g = Residence.getPermissionManager().getGroupByName(group);
        if (g != null) {
            posibleGroups.add(g);
        }
        PermissionGroup finalGroup = null;
        if (posibleGroups.size() == 1) {
            finalGroup = (PermissionGroup)posibleGroups.get(0);
        }
        int i = 0;
        while (i < posibleGroups.size()) {
            if (finalGroup == null) {
                finalGroup = (PermissionGroup)posibleGroups.get(i);
            } else if (finalGroup.getPriority() < ((PermissionGroup)posibleGroups.get(i)).getPriority()) {
                finalGroup = (PermissionGroup)posibleGroups.get(i);
            }
            ++i;
        }
        if (finalGroup == null || !Residence.getPermissionManager().getGroups().containsValue(finalGroup)) {
            this.groups.put(world, Residence.getConfigManager().getDefaultGroup().toLowerCase());
        } else {
            this.groups.put(world, finalGroup.getGroupName());
        }
    }

    private PermissionGroup getPermissionGroup() {
        PermissionGroup group = null;
        for (Map.Entry<String, PermissionGroup> one : Residence.getPermissionManager().getGroups().entrySet()) {
            if (this.player != null) {
                Permission p = new Permission("residence.group." + one.getKey(), PermissionDefault.FALSE);
                if (!this.player.hasPermission(p)) continue;
                group = one.getValue();
                continue;
            }
            OfflinePlayer offlineP = Residence.getOfflinePlayer(this.playerName);
            if (offlineP == null || !ResidenceVaultAdapter.hasPermission(offlineP, "residence.group." + one.getKey(), Residence.getConfigManager().getDefaultWorld())) continue;
            group = one.getValue();
        }
        return group;
    }
}

