/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.util.ArrayList;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.PlayerData;
import me.ryanhamshire.GriefPrevention.VisualizationApplicationTask;
import me.ryanhamshire.GriefPrevention.VisualizationElement;
import me.ryanhamshire.GriefPrevention.VisualizationType;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Visualization {
    public ArrayList<VisualizationElement> elements = new ArrayList();

    public static void Apply(Player player, Visualization visualization) {
        PlayerData playerData = GriefPrevention.instance.dataStore.getPlayerData(player.getUniqueId());
        if (playerData.currentVisualization != null) {
            Visualization.Revert(player);
        }
        if (player.isOnline() && visualization.elements.size() > 0 && visualization.elements.get((int)0).location.getWorld().equals(player.getWorld())) {
            GriefPrevention.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)GriefPrevention.instance, (Runnable)new VisualizationApplicationTask(player, playerData, visualization), 1L);
        }
    }

    public static void Revert(Player player) {
        if (!player.isOnline()) {
            return;
        }
        PlayerData playerData = GriefPrevention.instance.dataStore.getPlayerData(player.getUniqueId());
        Visualization visualization = playerData.currentVisualization;
        if (playerData.currentVisualization != null) {
            int minx = player.getLocation().getBlockX() - 100;
            int minz = player.getLocation().getBlockZ() - 100;
            int maxx = player.getLocation().getBlockX() + 100;
            int maxz = player.getLocation().getBlockZ() + 100;
            visualization.removeElementsOutOfRange(visualization.elements, minx, minz, maxx, maxz);
            int i = 0;
            while (i < visualization.elements.size()) {
                VisualizationElement element = visualization.elements.get(i);
                if (i == 0 && !player.getWorld().equals(element.location.getWorld())) {
                    return;
                }
                player.sendBlockChange(element.location, element.realMaterial, element.realData);
                ++i;
            }
            playerData.currentVisualization = null;
        }
    }

    public static Visualization FromClaim(Claim claim, int height, VisualizationType visualizationType, Location locality) {
        if (claim.parent != null) {
            return Visualization.FromClaim(claim.parent, height, visualizationType, locality);
        }
        Visualization visualization = new Visualization();
        int i = 0;
        while (i < claim.children.size()) {
            Claim child = claim.children.get(i);
            if (child.inDataStore) {
                visualization.addClaimElements(child, height, VisualizationType.Subdivision, locality);
            }
            ++i;
        }
        if (claim.isAdminClaim() && visualizationType == VisualizationType.Claim) {
            visualizationType = VisualizationType.AdminClaim;
        }
        visualization.addClaimElements(claim, height, visualizationType, locality);
        return visualization;
    }

    private void addClaimElements(Claim claim, int height, VisualizationType visualizationType, Location locality) {
        Material accentMaterial;
        Material cornerMaterial;
        Location smallXsmallZ = claim.getLesserBoundaryCorner();
        Location bigXbigZ = claim.getGreaterBoundaryCorner();
        World world = smallXsmallZ.getWorld();
        boolean waterIsTransparent = locality.getBlock().getType() == Material.STATIONARY_WATER;
        int smallx = smallXsmallZ.getBlockX();
        int smallz = smallXsmallZ.getBlockZ();
        int bigx = bigXbigZ.getBlockX();
        int bigz = bigXbigZ.getBlockZ();
        ArrayList<VisualizationElement> newElements = new ArrayList<VisualizationElement>();
        if (visualizationType == VisualizationType.Claim) {
            cornerMaterial = Material.GLOWSTONE;
            accentMaterial = Material.GOLD_BLOCK;
        } else if (visualizationType == VisualizationType.AdminClaim) {
            cornerMaterial = Material.GLOWSTONE;
            accentMaterial = Material.PUMPKIN;
        } else if (visualizationType == VisualizationType.Subdivision) {
            cornerMaterial = Material.IRON_BLOCK;
            accentMaterial = Material.WOOL;
        } else if (visualizationType == VisualizationType.RestoreNature) {
            cornerMaterial = Material.DIAMOND_BLOCK;
            accentMaterial = Material.DIAMOND_BLOCK;
        } else {
            cornerMaterial = Material.GLOWING_REDSTONE_ORE;
            accentMaterial = Material.NETHERRACK;
        }
        int minx = locality.getBlockX() - 75;
        int minz = locality.getBlockZ() - 75;
        int maxx = locality.getBlockX() + 75;
        int maxz = locality.getBlockZ() + 75;
        int STEP = 10;
        newElements.add(new VisualizationElement(new Location(world, (double)smallx, 0.0, (double)bigz), cornerMaterial, 0, Material.AIR, 0));
        newElements.add(new VisualizationElement(new Location(world, (double)(smallx + 1), 0.0, (double)bigz), accentMaterial, 0, Material.AIR, 0));
        int x = smallx + 10;
        while (x < bigx - 5) {
            if (x > minx && x < maxx) {
                newElements.add(new VisualizationElement(new Location(world, (double)x, 0.0, (double)bigz), accentMaterial, 0, Material.AIR, 0));
            }
            x += 10;
        }
        newElements.add(new VisualizationElement(new Location(world, (double)(bigx - 1), 0.0, (double)bigz), accentMaterial, 0, Material.AIR, 0));
        newElements.add(new VisualizationElement(new Location(world, (double)(smallx + 1), 0.0, (double)smallz), accentMaterial, 0, Material.AIR, 0));
        x = smallx + 10;
        while (x < bigx - 5) {
            if (x > minx && x < maxx) {
                newElements.add(new VisualizationElement(new Location(world, (double)x, 0.0, (double)smallz), accentMaterial, 0, Material.AIR, 0));
            }
            x += 10;
        }
        newElements.add(new VisualizationElement(new Location(world, (double)(bigx - 1), 0.0, (double)smallz), accentMaterial, 0, Material.AIR, 0));
        newElements.add(new VisualizationElement(new Location(world, (double)smallx, 0.0, (double)smallz), cornerMaterial, 0, Material.AIR, 0));
        newElements.add(new VisualizationElement(new Location(world, (double)smallx, 0.0, (double)(smallz + 1)), accentMaterial, 0, Material.AIR, 0));
        int z = smallz + 10;
        while (z < bigz - 5) {
            if (z > minz && z < maxz) {
                newElements.add(new VisualizationElement(new Location(world, (double)smallx, 0.0, (double)z), accentMaterial, 0, Material.AIR, 0));
            }
            z += 10;
        }
        newElements.add(new VisualizationElement(new Location(world, (double)smallx, 0.0, (double)(bigz - 1)), accentMaterial, 0, Material.AIR, 0));
        newElements.add(new VisualizationElement(new Location(world, (double)bigx, 0.0, (double)smallz), cornerMaterial, 0, Material.AIR, 0));
        newElements.add(new VisualizationElement(new Location(world, (double)bigx, 0.0, (double)(smallz + 1)), accentMaterial, 0, Material.AIR, 0));
        z = smallz + 10;
        while (z < bigz - 5) {
            if (z > minz && z < maxz) {
                newElements.add(new VisualizationElement(new Location(world, (double)bigx, 0.0, (double)z), accentMaterial, 0, Material.AIR, 0));
            }
            z += 10;
        }
        newElements.add(new VisualizationElement(new Location(world, (double)bigx, 0.0, (double)(bigz - 1)), accentMaterial, 0, Material.AIR, 0));
        newElements.add(new VisualizationElement(new Location(world, (double)bigx, 0.0, (double)bigz), cornerMaterial, 0, Material.AIR, 0));
        this.removeElementsOutOfRange(newElements, minx, minz, maxx, maxz);
        int i = 0;
        while (i < newElements.size()) {
            VisualizationElement element = newElements.get(i);
            if (!claim.contains(element.location, true, false)) {
                newElements.remove(i--);
            }
            ++i;
        }
        for (VisualizationElement element : newElements) {
            Location tempLocation = element.location;
            element.location = Visualization.getVisibleLocation(tempLocation.getWorld(), tempLocation.getBlockX(), height, tempLocation.getBlockZ(), waterIsTransparent);
            height = element.location.getBlockY();
            element.realMaterial = element.location.getBlock().getType();
            element.realData = element.location.getBlock().getData();
        }
        this.elements.addAll(newElements);
    }

    private void removeElementsOutOfRange(ArrayList<VisualizationElement> elements, int minx, int minz, int maxx, int maxz) {
        int i = 0;
        while (i < elements.size()) {
            Location location = elements.get((int)i).location;
            if (location.getX() < (double)minx || location.getX() > (double)maxx || location.getZ() < (double)minz || location.getZ() > (double)maxz) {
                elements.remove(i--);
            }
            ++i;
        }
    }

    private static Location getVisibleLocation(World world, int x, int y, int z, boolean waterIsTransparent) {
        Block block = world.getBlockAt(x, y, z);
        BlockFace direction = Visualization.isTransparent(block, waterIsTransparent) ? BlockFace.DOWN : BlockFace.UP;
        while (block.getY() >= 1 && block.getY() < world.getMaxHeight() - 1 && (!Visualization.isTransparent(block.getRelative(BlockFace.UP), waterIsTransparent) || Visualization.isTransparent(block, waterIsTransparent))) {
            block = block.getRelative(direction);
        }
        return block.getLocation();
    }

    private static boolean isTransparent(Block block, boolean waterIsTransparent) {
        return block.getType() != Material.SNOW && (block.getType() == Material.AIR || block.getType() == Material.FENCE || block.getType() == Material.ACACIA_FENCE || block.getType() == Material.BIRCH_FENCE || block.getType() == Material.DARK_OAK_FENCE || block.getType() == Material.JUNGLE_FENCE || block.getType() == Material.NETHER_FENCE || block.getType() == Material.SPRUCE_FENCE || block.getType() == Material.FENCE_GATE || block.getType() == Material.ACACIA_FENCE_GATE || block.getType() == Material.BIRCH_FENCE_GATE || block.getType() == Material.DARK_OAK_FENCE_GATE || block.getType() == Material.SPRUCE_FENCE_GATE || block.getType() == Material.JUNGLE_FENCE_GATE || block.getType() == Material.SIGN || block.getType() == Material.SIGN_POST || block.getType() == Material.WALL_SIGN || waterIsTransparent && block.getType() == Material.STATIONARY_WATER || block.getType().isTransparent());
    }

    public static Visualization fromClaims(Iterable<Claim> claims, int height, VisualizationType type, Location locality) {
        Visualization visualization = new Visualization();
        for (Claim claim : claims) {
            visualization.addClaimElements(claim, height, type, locality);
        }
        return visualization;
    }
}

