/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.economy;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.api.MarketBuyInterface;
import com.bekvon.bukkit.residence.economy.EconomyInterface;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.protection.ResidenceManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TransactionManager
implements MarketBuyInterface {
    ResidenceManager manager5;
    private Set<ClaimedResidence> sellAmount = new HashSet<ClaimedResidence>();
    PermissionManager gm5;

    public static boolean chargeEconomyMoney(Player player, int amount) {
        EconomyInterface econ = Residence.getEconomyManager();
        if (econ == null) {
            player.sendMessage(Residence.getLM().getMessage("Economy.MarketDisabled"));
            return false;
        }
        if (!econ.canAfford(player.getName(), amount)) {
            player.sendMessage(Residence.getLM().getMessage("Economy.NotEnoughMoney"));
            return false;
        }
        econ.subtract(player.getName(), amount);
        player.sendMessage(Residence.getLM().getMessage("Economy.MoneyCharged", String.format("%d", amount), econ.getName()));
        return true;
    }

    public static boolean giveEconomyMoney(Player player, int amount) {
        if (player == null) {
            return false;
        }
        if (amount == 0) {
            return true;
        }
        EconomyInterface econ = Residence.getEconomyManager();
        if (econ == null) {
            player.sendMessage(Residence.getLM().getMessage("Economy.MarketDisabled"));
            return false;
        }
        econ.add(player.getName(), amount);
        player.sendMessage(Residence.getLM().getMessage("Economy.MoneyAdded", String.format("%d", amount), econ.getName()));
        return true;
    }

    public void putForSale(String areaname, Player player, int amount, boolean resadmin2) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(areaname);
        this.putForSale(res, player, amount, resadmin2);
    }

    public void putForSale(ClaimedResidence res, Player player, int amount, boolean resadmin2) {
        if (res == null) {
            player.sendMessage(Residence.getLM().getMessage("Invalid.Residence"));
            return;
        }
        if (Residence.getConfigManager().enabledRentSystem() && res.isForRent()) {
            player.sendMessage(Residence.getLM().getMessage("Economy.RentSellFail"));
            return;
        }
        if (!resadmin2) {
            boolean cansell;
            if (!Residence.getConfigManager().enableEconomy() || Residence.getEconomyManager() == null) {
                player.sendMessage(Residence.getLM().getMessage("Economy.MarketDisabled"));
                return;
            }
            boolean bl = cansell = Residence.getPermissionManager().getGroup(player).canSellLand() || player.hasPermission("residence.sell");
            if (!cansell && !resadmin2) {
                player.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
                return;
            }
            if (amount <= 0) {
                player.sendMessage(Residence.getLM().getMessage("Invalid.Amount"));
                return;
            }
        }
        if (!res.isOwner(player) && !resadmin2) {
            player.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
            return;
        }
        if (this.sellAmount.contains(res)) {
            player.sendMessage(Residence.getLM().getMessage("Economy.AlreadySellFail"));
            return;
        }
        res.setSellPrice(amount);
        this.sellAmount.add(res);
        Residence.getSignUtil().CheckSign(res);
        player.sendMessage(Residence.getLM().getMessage("Residence.ForSale", res.getName(), amount));
    }

    @Override
    public boolean putForSale(String areaname, int amount) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(areaname);
        return this.putForSale(res, amount);
    }

    public boolean putForSale(ClaimedResidence res, int amount) {
        if (res == null) {
            return false;
        }
        if (Residence.getConfigManager().enabledRentSystem() && res.isForRent()) {
            return false;
        }
        if (this.sellAmount.contains(res)) {
            return false;
        }
        res.setSellPrice(amount);
        this.sellAmount.add(res);
        return true;
    }

    @Override
    public void buyPlot(String areaname, Player player, boolean resadmin2) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(areaname);
        this.buyPlot(res, player, resadmin2);
    }

    public void buyPlot(ClaimedResidence res, Player player, boolean resadmin2) {
        EconomyInterface econ;
        if (res == null || !res.isForSell()) {
            player.sendMessage(Residence.getLM().getMessage("Invalid.Residence"));
            return;
        }
        PermissionGroup group = Residence.getPermissionManager().getGroup(player);
        if (!resadmin2) {
            boolean canbuy;
            if (!Residence.getConfigManager().enableEconomy() || Residence.getEconomyManager() == null) {
                player.sendMessage(Residence.getLM().getMessage("Economy.MarketDisabled"));
                return;
            }
            boolean bl = canbuy = group.canBuyLand() || player.hasPermission("residence.buy");
            if (!canbuy && !resadmin2) {
                player.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
                return;
            }
        }
        if (res.getPermissions().getOwner().equals(player.getName())) {
            player.sendMessage(Residence.getLM().getMessage("Economy.OwnerBuyFail"));
            return;
        }
        if (Residence.getResidenceManager().getOwnedZoneCount(player.getName()) >= group.getMaxZones(player.getName()) && !resadmin2) {
            player.sendMessage(Residence.getLM().getMessage("Residence.TooMany"));
            return;
        }
        Server serv = Residence.getServ();
        int amount = res.getSellPrice();
        if (!resadmin2 && !group.buyLandIgnoreLimits()) {
            CuboidArea[] areas;
            CuboidArea[] cuboidAreaArray = areas = res.getAreaArray();
            int n = areas.length;
            int n2 = 0;
            while (n2 < n) {
                CuboidArea thisarea = cuboidAreaArray[n2];
                if (!group.inLimits(thisarea)) {
                    player.sendMessage(Residence.getLM().getMessage("Residence.BuyTooBig"));
                    return;
                }
                ++n2;
            }
        }
        if ((econ = Residence.getEconomyManager()) == null) {
            player.sendMessage(Residence.getLM().getMessage("Economy.MarketDisabled"));
            return;
        }
        String buyerName = player.getName();
        String sellerName = res.getPermissions().getOwner();
        Player sellerNameFix = Residence.getServ().getPlayer(sellerName);
        if (sellerNameFix != null) {
            sellerName = sellerNameFix.getName();
        }
        if (econ.canAfford(buyerName, amount)) {
            if (!econ.transfer(buyerName, sellerName, amount)) {
                player.sendMessage(ChatColor.RED + "Error, could not transfer " + amount + " from " + buyerName + " to " + sellerName);
                return;
            }
            res.getPermissions().setOwner(player.getName(), true);
            res.getPermissions().applyDefaultFlags();
            this.removeFromSale(res);
            Residence.getSignUtil().CheckSign(res);
            CuboidArea area2 = res.getAreaArray()[0];
            Residence.getSelectionManager().NewMakeBorders(player, area2.getHighLoc(), area2.getLowLoc(), false);
            player.sendMessage(Residence.getLM().getMessage("Economy.MoneyCharged", String.format("%d", amount), econ.getName()));
            player.sendMessage(Residence.getLM().getMessage("Residence.Bought", res.getShortName()));
            Player seller = serv.getPlayer(sellerName);
            if (seller != null && seller.isOnline()) {
                seller.sendMessage(Residence.getLM().getMessage("Residence.Buy", player.getName(), res.getShortName()));
                seller.sendMessage(Residence.getLM().getMessage("Economy.MoneyCredit", String.format("%d", amount), econ.getName()));
            }
        } else {
            player.sendMessage(Residence.getLM().getMessage("Economy.NotEnoughMoney"));
        }
    }

    public void removeFromSale(Player player, String areaname, boolean resadmin2) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(areaname);
        this.removeFromSale(player, res, resadmin2);
    }

    public void removeFromSale(Player player, ClaimedResidence res, boolean resadmin2) {
        if (res == null) {
            player.sendMessage(Residence.getLM().getMessage("Invalid.Area"));
            return;
        }
        if (!res.isForSell()) {
            player.sendMessage(Residence.getLM().getMessage("Residence.NotForSale"));
            return;
        }
        if (res.isOwner(player) || resadmin2) {
            this.removeFromSale(res);
            Residence.getSignUtil().CheckSign(res);
            player.sendMessage(Residence.getLM().getMessage("Residence.StopSelling"));
        } else {
            player.sendMessage(Residence.getLM().getMessage("General.NoPermission"));
        }
    }

    @Override
    public void removeFromSale(String areaname) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(areaname);
        this.removeFromSale(res);
    }

    public void removeFromSale(ClaimedResidence res) {
        if (res == null) {
            return;
        }
        this.sellAmount.remove(res);
        Residence.getSignUtil().removeSign(res);
    }

    @Override
    public boolean isForSale(String areaname) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(areaname);
        return this.isForSale(res);
    }

    public boolean isForSale(ClaimedResidence res) {
        if (res == null) {
            return false;
        }
        return this.sellAmount.contains(res);
    }

    public boolean viewSaleInfo(String areaname, Player player) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(areaname);
        return this.viewSaleInfo(res, player);
    }

    public boolean viewSaleInfo(ClaimedResidence res, Player player) {
        String etime;
        if (res == null || !res.isForSell()) {
            return false;
        }
        if (!this.sellAmount.contains(res)) {
            return false;
        }
        player.sendMessage(Residence.getLM().getMessage("General.Separator"));
        player.sendMessage(Residence.getLM().getMessage("Area.Name", res.getName()));
        player.sendMessage(Residence.getLM().getMessage("Economy.SellAmount", res.getSellPrice()));
        if (Residence.getConfigManager().useLeases() && (etime = Residence.getLeaseManager().getExpireTime(res.getName())) != null) {
            player.sendMessage(Residence.getLM().getMessage("Economy.LeaseExpire", etime));
        }
        player.sendMessage(Residence.getLM().getMessage("General.Separator"));
        return true;
    }

    public void printForSaleResidences(Player player, int page) {
        ArrayList<ClaimedResidence> toRemove = new ArrayList<ClaimedResidence>();
        player.sendMessage(Residence.getLM().getMessage("Economy.LandForSale"));
        StringBuilder sbuild = new StringBuilder();
        sbuild.append(ChatColor.GREEN);
        int perpage = 10;
        int pagecount = (int)Math.ceil((double)this.sellAmount.size() / (double)perpage);
        if (page < 1) {
            page = 1;
        }
        int z = 0;
        for (ClaimedResidence res : this.sellAmount) {
            if (++z <= (page - 1) * perpage) continue;
            if (z > (page - 1) * perpage + perpage) break;
            if (res == null) {
                --z;
                toRemove.add(res);
                continue;
            }
            player.sendMessage(Residence.getLM().getMessage("Economy.SellList", z, res.getName(), res.getSellPrice(), res.getOwner()));
        }
        for (ClaimedResidence one : toRemove) {
            this.sellAmount.remove(one);
        }
        String separator = "" + ChatColor.GOLD;
        String simbol = "\u25ac";
        int i = 0;
        while (i < 10) {
            separator = String.valueOf(separator) + simbol;
            ++i;
        }
        if (pagecount == 1) {
            return;
        }
        int NextPage = page + 1;
        NextPage = page < pagecount ? NextPage : page;
        int Prevpage = page - 1;
        Prevpage = page > 1 ? Prevpage : page;
        String prevCmd = "/res market list sell " + Prevpage;
        String prev = "[\"\",{\"text\":\"" + separator + " " + Residence.getLM().getMessage("General.PrevInfoPage") + "\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"" + prevCmd + "\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[{\"text\":\"" + "<<<" + "\"}]}}}";
        String nextCmd = "/res market list sell " + NextPage;
        String next = " {\"text\":\"" + Residence.getLM().getMessage("General.NextInfoPage") + " " + separator + "\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"" + nextCmd + "\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[{\"text\":\"" + ">>>" + "\"}]}}}]";
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + player.getName() + " " + prev + "," + next));
    }

    public void clearSales() {
        for (ClaimedResidence res : this.sellAmount) {
            if (res == null) continue;
            res.setSellPrice(-1);
        }
        this.sellAmount.clear();
        System.out.println("[Residence] - ReInit land selling.");
    }

    @Override
    public int getSaleAmount(String areaname) {
        ClaimedResidence res = Residence.getResidenceManager().getByName(areaname);
        return this.getSaleAmount(res);
    }

    public int getSaleAmount(ClaimedResidence res) {
        if (res == null) {
            return -1;
        }
        return res.getSellPrice();
    }

    public void load(Map<String, Integer> root) {
        if (root == null) {
            return;
        }
        for (Map.Entry<String, Integer> one : root.entrySet()) {
            ClaimedResidence res = Residence.getResidenceManager().getByName(one.getKey());
            if (res == null) continue;
            res.setSellPrice(one.getValue());
            this.sellAmount.add(res);
        }
    }

    @Override
    public Map<String, Integer> getBuyableResidences() {
        HashMap<String, Integer> list2 = new HashMap<String, Integer>();
        for (ClaimedResidence res : this.sellAmount) {
            if (res == null) continue;
            list2.put(res.getName(), res.getSellPrice());
        }
        return list2;
    }

    public Map<String, Integer> save() {
        return this.getBuyableResidences();
    }
}

