/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.function;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.config.Node;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.function.Function;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class FunctionReference<T> {
    final String functionName;
    private Function<? extends T> function;
    private boolean singleUberParam;
    private final Expression<?>[] parameters;
    private boolean single;
    @Nullable
    private final Class<? extends T>[] returnTypes;
    @Nullable
    private final Node node;
    @Nullable
    public final File script;

    public FunctionReference(String functionName, @Nullable Node node, @Nullable File script, @Nullable Class<? extends T>[] returnTypes, Expression<?>[] params) {
        this.functionName = functionName;
        this.node = node;
        this.script = script;
        this.returnTypes = returnTypes;
        this.parameters = params;
    }

    public boolean validateFunction(boolean first) {
        Function<?> newFunc = Functions.getFunction(this.functionName);
        SkriptLogger.setNode(this.node);
        if (newFunc == null) {
            if (first) {
                Skript.error("The function '" + this.functionName + "' does not exist.");
            } else {
                Skript.error("The function '" + this.functionName + "' was deleted or renamed, but is still used in other script(s)." + " These will continue to use the old version of the function until Skript restarts.");
            }
            return false;
        }
        if (newFunc == this.function) {
            return true;
        }
        Class<? extends T>[] returnTypes = this.returnTypes;
        if (returnTypes != null) {
            ClassInfo rt = newFunc.returnType;
            if (rt == null) {
                if (first) {
                    Skript.error("The function '" + this.functionName + "' doesn't return any value.");
                } else {
                    Skript.error("The function '" + this.functionName + "' was redefined with no return value, but is still used in other script(s)." + " These will continue to use the old version of the function until Skript restarts.");
                }
                return false;
            }
            if (!CollectionUtils.containsAnySuperclass(returnTypes, rt.getC())) {
                if (first) {
                    Skript.error("The returned value of the function '" + this.functionName + "', " + newFunc.returnType + ", is " + SkriptParser.notOfType(returnTypes) + ".");
                } else {
                    Skript.error("The function '" + this.functionName + "' was redefined with a different, incompatible return type, but is still used in other script(s)." + " These will continue to use the old version of the function until Skript restarts.");
                }
                return false;
            }
            if (first) {
                this.single = newFunc.single;
            } else if (this.single && !newFunc.single) {
                Skript.error("The function '" + this.functionName + "' was redefined with a different, incompatible return type, but is still used in other script(s)." + " These will continue to use the old version of the function until Skript restarts.");
                return false;
            }
        }
        boolean bl = this.singleUberParam = newFunc.getMaxParameters() == 1 && !newFunc.parameters[0].single;
        if (!this.singleUberParam && this.parameters.length > newFunc.getMaxParameters()) {
            if (first) {
                if (newFunc.getMaxParameters() == 0) {
                    Skript.error("The function '" + this.functionName + "' has no arguments, but " + this.parameters.length + " are given." + " To call a function without parameters, just write the function name followed by '()', e.g. 'func()'.");
                } else {
                    Skript.error("The function '" + this.functionName + "' has only " + newFunc.getMaxParameters() + " argument" + (newFunc.getMaxParameters() == 1 ? "" : "s") + "," + " but " + this.parameters.length + " are given." + " If you want to use lists in function calls, you have to use additional parentheses, e.g. 'give(player, (iron ore and gold ore))'");
                }
            } else {
                Skript.error("The function '" + this.functionName + "' was redefined with a different, incompatible amount of arguments, but is still used in other script(s)." + " These will continue to use the old version of the function until Skript restarts.");
            }
            return false;
        }
        if (this.parameters.length < newFunc.getMinParameters()) {
            if (first) {
                Skript.error("The function '" + this.functionName + "' requires at least " + newFunc.getMinParameters() + " argument" + (newFunc.getMinParameters() == 1 ? "" : "s") + "," + " but only " + this.parameters.length + " " + (this.parameters.length == 1 ? "is" : "are") + " given.");
            } else {
                Skript.error("The function '" + this.functionName + "' was redefined with a different, incompatible amount of arguments, but is still used in other script(s)." + " These will continue to use the old version of the function until Skript restarts.");
            }
            return false;
        }
        int i = 0;
        while (i < this.parameters.length) {
            Parameter<?> p = newFunc.parameters[this.singleUberParam ? 0 : i];
            RetainingLogHandler log = SkriptLogger.startRetainingLog();
            try {
                Expression e = this.parameters[i].getConvertedExpression(p.type.getC());
                if (e == null) {
                    if (first) {
                        Skript.error("The " + StringUtils.fancyOrderNumber(i + 1) + " argument given to the function '" + this.functionName + "' is not of the required type " + p.type + "." + " Check the correct order of the arguments and put lists into parentheses if appropriate (e.g. 'give(player, (iron ore and gold ore))')." + " Please note that storing the value in a variable and then using that variable as parameter will suppress this error, but it still won't work.");
                    } else {
                        Skript.error("The function '" + this.functionName + "' was redefined with different, incompatible arguments, but is still used in other script(s)." + " These will continue to use the old version of the function until Skript restarts.");
                    }
                    return false;
                }
                this.parameters[i] = e;
            }
            finally {
                log.printLog();
            }
            ++i;
        }
        this.function = newFunc;
        Functions.registerCaller(this);
        return true;
    }

    @Nullable
    protected T[] execute(Event e) {
        Object[][] params = new Object[this.singleUberParam ? 1 : this.parameters.length][];
        if (this.singleUberParam && this.parameters.length > 1) {
            ArrayList l = new ArrayList();
            int i = 0;
            while (i < params.length) {
                l.addAll(Arrays.asList(this.parameters[i].getArray(e)));
                ++i;
            }
            params[0] = l.toArray();
        } else {
            int i = 0;
            while (i < params.length) {
                params[i] = this.parameters[i].getArray(e);
                ++i;
            }
        }
        return this.function.execute(params);
    }

    public boolean isSingle() {
        return this.single;
    }

    public Class<? extends T> getReturnType() {
        return this.function.returnType.getC();
    }

    public String toString(@Nullable Event e, boolean debug) {
        StringBuilder b = new StringBuilder(String.valueOf(this.functionName) + "(");
        int i = 0;
        while (i < this.parameters.length) {
            if (i != 0) {
                b.append(", ");
            }
            b.append(this.parameters[i].toString(e, debug));
            ++i;
        }
        return "" + b.append(")");
    }
}

