/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.yggdrasil.Fields;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Boat;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Giant;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Painting;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Slime;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Squid;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.Zombie;
import org.eclipse.jdt.annotation.Nullable;

public class SimpleEntityData
extends EntityData<Entity> {
    private static final List<SimpleEntityDataInfo> types = new ArrayList<SimpleEntityDataInfo>();
    private transient SimpleEntityDataInfo info;

    static {
        types.add(new SimpleEntityDataInfo("arrow", Arrow.class));
        types.add(new SimpleEntityDataInfo("boat", Boat.class));
        types.add(new SimpleEntityDataInfo("blaze", Blaze.class));
        types.add(new SimpleEntityDataInfo("chicken", Chicken.class));
        types.add(new SimpleEntityDataInfo("mooshroom", MushroomCow.class));
        types.add(new SimpleEntityDataInfo("cow", Cow.class));
        types.add(new SimpleEntityDataInfo("cave spider", CaveSpider.class));
        types.add(new SimpleEntityDataInfo("egg", Egg.class));
        types.add(new SimpleEntityDataInfo("ender crystal", EnderCrystal.class));
        types.add(new SimpleEntityDataInfo("ender dragon", EnderDragon.class));
        types.add(new SimpleEntityDataInfo("ender pearl", EnderPearl.class));
        types.add(new SimpleEntityDataInfo("small fireball", SmallFireball.class));
        types.add(new SimpleEntityDataInfo("fireball", Fireball.class));
        types.add(new SimpleEntityDataInfo("ghast", Ghast.class));
        types.add(new SimpleEntityDataInfo("giant", Giant.class));
        types.add(new SimpleEntityDataInfo("iron golem", IronGolem.class));
        types.add(new SimpleEntityDataInfo("magma cube", MagmaCube.class));
        types.add(new SimpleEntityDataInfo("slime", Slime.class));
        types.add(new SimpleEntityDataInfo("painting", Painting.class));
        types.add(new SimpleEntityDataInfo("zombie pigman", PigZombie.class));
        types.add(new SimpleEntityDataInfo("silverfish", Silverfish.class));
        types.add(new SimpleEntityDataInfo("snowball", Snowball.class));
        types.add(new SimpleEntityDataInfo("snow golem", Snowman.class));
        types.add(new SimpleEntityDataInfo("spider", Spider.class));
        types.add(new SimpleEntityDataInfo("squid", Squid.class));
        types.add(new SimpleEntityDataInfo("bottle of enchanting", ThrownExpBottle.class));
        types.add(new SimpleEntityDataInfo("tnt", TNTPrimed.class));
        types.add(new SimpleEntityDataInfo("zombie", Zombie.class));
        if (Skript.classExists("org.bukkit.entity.ItemFrame")) {
            types.add(new SimpleEntityDataInfo("item frame", ItemFrame.class));
            types.add(new SimpleEntityDataInfo("bat", Bat.class));
            types.add(new SimpleEntityDataInfo("witch", Witch.class));
            types.add(new SimpleEntityDataInfo("wither", Wither.class));
            types.add(new SimpleEntityDataInfo("wither skull", WitherSkull.class));
        }
        if (Skript.classExists("org.bukkit.entity.Firework")) {
            types.add(new SimpleEntityDataInfo("firework", Firework.class));
        }
        if (Skript.classExists("org.bukkit.entity.ArmorStand")) {
            types.add(new SimpleEntityDataInfo("endermite", Endermite.class));
            types.add(new SimpleEntityDataInfo("armor stand", ArmorStand.class));
        }
        types.add(new SimpleEntityDataInfo("human", HumanEntity.class, true));
        types.add(new SimpleEntityDataInfo("creature", Creature.class, true));
        types.add(new SimpleEntityDataInfo("projectile", Projectile.class, true));
        types.add(new SimpleEntityDataInfo("living entity", LivingEntity.class, true));
        types.add(new SimpleEntityDataInfo("entity", Entity.class, true));
        types.add(new SimpleEntityDataInfo("any fireball", Fireball.class, true));
        String[] codeNames = new String[types.size()];
        int i = 0;
        for (SimpleEntityDataInfo info : types) {
            codeNames[i++] = info.codeName;
        }
        EntityData.register(SimpleEntityData.class, "simple", Entity.class, 0, codeNames);
    }

    public SimpleEntityData() {
        this(Entity.class);
    }

    private SimpleEntityData(SimpleEntityDataInfo info) {
        assert (info != null);
        this.info = info;
        this.matchedPattern = types.indexOf(info);
    }

    public SimpleEntityData(Class<? extends Entity> c) {
        assert (c != null && c.isInterface()) : c;
        int i = 0;
        for (SimpleEntityDataInfo info : types) {
            if (info.c.isAssignableFrom(c)) {
                this.info = info;
                this.matchedPattern = i;
                return;
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    public SimpleEntityData(Entity e) {
        int i = 0;
        for (SimpleEntityDataInfo info : types) {
            if (info.c.isInstance(e)) {
                this.info = info;
                this.matchedPattern = i;
                return;
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.info = types.get(matchedPattern);
        assert (this.info != null) : matchedPattern;
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Entity> c, @Nullable Entity e) {
        assert (false);
        return false;
    }

    @Override
    public void set(Entity entity) {
    }

    @Override
    public boolean match(Entity e) {
        if (this.info.isSupertype) {
            return this.info.c.isInstance(e);
        }
        for (SimpleEntityDataInfo info : types) {
            if (!info.c.isInstance(e)) continue;
            return this.info.c == info.c;
        }
        assert (false);
        return false;
    }

    @Override
    public Class<? extends Entity> getType() {
        return this.info.c;
    }

    @Override
    protected int hashCode_i() {
        return this.info.hashCode();
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof SimpleEntityData)) {
            return false;
        }
        SimpleEntityData other = (SimpleEntityData)obj;
        return this.info.equals(other.info);
    }

    @Override
    public Fields serialize() throws NotSerializableException {
        Fields f = super.serialize();
        f.putObject("info.codeName", this.info.codeName);
        return f;
    }

    @Override
    public void deserialize(Fields fields) throws StreamCorruptedException, NotSerializableException {
        String codeName = fields.getAndRemoveObject("info.codeName", String.class);
        for (SimpleEntityDataInfo i : types) {
            if (!i.codeName.equals(codeName)) continue;
            this.info = i;
            super.deserialize(fields);
            return;
        }
        throw new StreamCorruptedException("Invalid SimpleEntityDataInfo code name " + codeName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Deprecated
    protected boolean deserialize(String s) {
        try {
            SimpleEntityDataInfo i;
            Class<?> c = Class.forName(s);
            Iterator<SimpleEntityDataInfo> iterator = types.iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                i = iterator.next();
            } while (i.c != c);
            this.info = i;
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        return this.info.c == e.getType() || this.info.isSupertype && this.info.c.isAssignableFrom(e.getType());
    }

    @Override
    public EntityData getSuperType() {
        return new SimpleEntityData(this.info);
    }

    public static final class SimpleEntityDataInfo {
        final String codeName;
        final Class<? extends Entity> c;
        final boolean isSupertype;

        SimpleEntityDataInfo(String codeName, Class<? extends Entity> c) {
            this(codeName, c, false);
        }

        SimpleEntityDataInfo(String codeName, Class<? extends Entity> c, boolean isSupertype) {
            this.codeName = codeName;
            this.c = c;
            this.isSupertype = isSupertype;
        }

        public int hashCode() {
            return this.c.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SimpleEntityDataInfo)) {
                return false;
            }
            SimpleEntityDataInfo other = (SimpleEntityDataInfo)obj;
            if (this.c != other.c) {
                return false;
            }
            assert (this.codeName.equals(other.codeName));
            assert (this.isSupertype == other.isSupertype);
            return true;
        }
    }
}

