/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.localization.Adjective;
import ch.njol.skript.localization.Noun;
import ch.njol.skript.util.Color;
import ch.njol.util.Checker;
import ch.njol.util.coll.CollectionUtils;
import java.util.Arrays;
import org.bukkit.entity.Sheep;
import org.eclipse.jdt.annotation.Nullable;

public class SheepData
extends EntityData<Sheep> {
    @Nullable
    private Color[] colors = null;
    private int sheared = 0;
    @Nullable
    private Adjective[] adjectives = null;

    static {
        EntityData.register(SheepData.class, "sheep", Sheep.class, 1, "unsheared sheep", "sheep", "sheared sheep");
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.sheared = matchedPattern - 1;
        if (exprs[0] != null) {
            this.colors = (Color[])exprs[0].getAll();
        }
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Sheep> c, @Nullable Sheep e) {
        Color[] colorArray;
        int n = e == null ? 0 : (this.sheared = e.isSheared() ? 1 : -1);
        if (e == null) {
            colorArray = null;
        } else {
            Color[] colorArray2 = new Color[1];
            colorArray = colorArray2;
            colorArray2[0] = Color.byWoolColor(e.getColor());
        }
        this.colors = colorArray;
        return true;
    }

    @Override
    public void set(Sheep entity) {
        if (this.colors != null) {
            Color c = CollectionUtils.getRandom(this.colors);
            assert (c != null);
            entity.setColor(c.getWoolColor());
        }
    }

    @Override
    public boolean match(final Sheep entity) {
        return !(this.sheared != 0 && entity.isSheared() != (this.sheared == 1) || this.colors != null && !SimpleExpression.check(this.colors, new Checker<Color>(){

            @Override
            public boolean check(@Nullable Color c) {
                return c != null && entity.getColor() == c.getWoolColor();
            }
        }, false, false));
    }

    @Override
    public Class<Sheep> getType() {
        return Sheep.class;
    }

    @Override
    public String toString(int flags) {
        Color[] colors = this.colors;
        if (colors == null) {
            return super.toString(flags);
        }
        Adjective[] adjectives = this.adjectives;
        if (adjectives == null) {
            adjectives = new Adjective[colors.length];
            this.adjectives = adjectives;
            int i = 0;
            while (i < colors.length) {
                adjectives[i] = colors[i].getAdjective();
                ++i;
            }
        }
        Noun name = this.getName();
        Adjective age = this.getAgeAdjective();
        return String.valueOf(name.getArticleWithSpace(flags)) + (age == null ? "" : String.valueOf(age.toString(name.getGender(), flags)) + " ") + Adjective.toString(adjectives, name.getGender(), flags, false) + " " + name.toString(flags & 0xFFFFFFF9);
    }

    @Override
    protected int hashCode_i() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.colors);
        result = 31 * result + this.sheared;
        return result;
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof SheepData)) {
            return false;
        }
        SheepData other = (SheepData)obj;
        if (!Arrays.equals(this.colors, other.colors)) {
            return false;
        }
        return this.sheared == other.sheared;
    }

    @Override
    protected boolean deserialize(String s) {
        String sh;
        String[] split = s.split("\\|");
        if (split.length == 1) {
            sh = s;
        } else if (split.length == 2) {
            sh = split[0];
            String[] cs = split[1].split(",");
            this.colors = new Color[cs.length];
            int i = 0;
            while (i < cs.length) {
                try {
                    String c = cs[i];
                    assert (c != null);
                    this.colors[i] = Color.valueOf(c);
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
                ++i;
            }
        } else {
            return false;
        }
        try {
            this.sheared = Integer.parseInt(sh);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        if (e instanceof SheepData) {
            return this.colors == null || CollectionUtils.isSubset(this.colors, ((SheepData)e).colors);
        }
        return false;
    }

    @Override
    public EntityData getSuperType() {
        return new SheepData();
    }
}

