/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Delay")
@Description(value={"Delays the script's execution by a given timespan. Please note that delays are not persistent, e.g. trying to create a tempban script with <code>ban player \u2192 wait 7 days \u2192 unban player</code> will not work if you restart your server anytime within these 7 days. You also have to be careful even when using small delays!"})
@Examples(value={"wait 2 minutes", "halt for 5 minecraft hours", "wait a tick"})
@Since(value="1.4")
public class Delay
extends Effect {
    private Expression<Timespan> duration;
    protected static final Set<Event> delayed;

    static {
        Skript.registerEffect(Delay.class, "(wait|halt) [for] %timespan%");
        delayed = Collections.newSetFromMap(new WeakHashMap());
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.duration = exprs[0];
        return true;
    }

    @Override
    @Nullable
    protected TriggerItem walk(final Event e) {
        this.debug(e, true);
        final long start = Skript.debug() ? System.nanoTime() : 0L;
        final TriggerItem next = this.getNext();
        if (next != null) {
            delayed.add(e);
            Timespan d = this.duration.getSingle(e);
            if (d == null) {
                return null;
            }
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

                @Override
                public void run() {
                    if (Skript.debug()) {
                        Skript.info(String.valueOf(Delay.this.getIndentation()) + "... continuing after " + (double)(System.nanoTime() - start) / 1.0E9 + "s");
                    }
                    TriggerItem.walk(next, e);
                }
            }, d.getTicks_i());
        }
        return null;
    }

    public static final boolean isDelayed(Event e) {
        return delayed.contains(e);
    }

    @Override
    protected void execute(Event e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "wait for " + this.duration.toString(e, debug) + (e == null ? "" : "...");
    }
}

