/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Is Riding")
@Description(value={"Tests whether an entity is riding another or is in a vehicle."})
@Examples(value={"player is riding a saddled pig"})
@Since(value="2.0")
public class CondIsRiding
extends Condition {
    private Expression<Entity> entities;
    Expression<EntityData<?>> types;

    static {
        Skript.registerCondition(CondIsRiding.class, "%entities% (is|are) riding [%entitydatas%]", "%entities% (isn't|is not|aren't|are not) riding [%entitydatas%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        this.types = exprs[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(final Event e) {
        return this.entities.check(e, new Checker<Entity>(){

            @Override
            public boolean check(final Entity en) {
                return CondIsRiding.this.types.check(e, new Checker<EntityData<?>>(){

                    @Override
                    public boolean check(EntityData<?> d) {
                        return d.isInstance(en.getVehicle());
                    }
                }, CondIsRiding.this.isNegated());
            }
        });
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.entities.toString(e, debug)) + (this.isNegated() ? " is" : " isn't") + " riding" + this.types.toString(e, debug);
    }
}

