package com.github.theholywaffle.teamspeak3.api.wrapper;

/*
 * #%L
 * TeamSpeak 3 Java API
 * %%
 * Copyright (C) 2014 Bert De Geyter
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

import java.util.Map;

import com.github.theholywaffle.teamspeak3.api.PermissionGroupDatabaseType;

public class ServerGroup extends Wrapper {

	public ServerGroup(Map<String, String> map) {
		super(map);
	}

	public int getId() {
		return getInt("sgid");
	}

	public String getName() {
		return get("name");
	}

	public PermissionGroupDatabaseType getType() {
		final int type = getInt("type");
		for (final PermissionGroupDatabaseType p : PermissionGroupDatabaseType.values()) {
			if (p.getIndex() == type) {
				return p;
			}
		}
		return null;
	}

	public int getIconId() {
		return getInt("iconid");
	}

	public int getSaveDb() {
		return getInt("savedb");
	}

	public int getSortId() {
		return getInt("sortid");
	}

	public int getNameMode() {
		return getInt("namemode");
	}

	public int getModifyPower() {
		return getInt("n_modifyp");
	}

	public int getMemberAddPower() {
		return getInt("n_member_addp");
	}

	public int getMemberRemovePower() {
		return getInt("n_member_removep");
	}

}
