package com.github.theholywaffle.teamspeak3.api;

/*
 * #%L
 * TeamSpeak 3 Java API
 * %%
 * Copyright (C) 2014 Bert De Geyter
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

import java.util.Locale;

public enum VirtualServerProperty implements Property {

	CONNECTION_BANDWIDTH_RECEIVED_LAST_MINUTE_TOTAL(false),
	CONNECTION_BANDWIDTH_RECEIVED_LAST_SECOND_TOTAL(false),
	CONNECTION_BANDWIDTH_SENT_LAST_MINUTE_TOTAL(false),
	CONNECTION_BANDWIDTH_SENT_LAST_SECOND_TOTAL(false),
	CONNECTION_BYTES_RECEIVED_CONTROL(false),
	CONNECTION_BYTES_RECEIVED_KEEPALIVE(false),
	CONNECTION_BYTES_RECEIVED_SPEECH(false),
	CONNECTION_BYTES_RECEIVED_TOTAL(false),
	CONNECTION_BYTES_SENT_CONTROL(false),
	CONNECTION_BYTES_SENT_KEEPALIVE(false),
	CONNECTION_BYTES_SENT_SPEECH(false),
	CONNECTION_BYTES_SENT_TOTAL(false),
	CONNECTION_FILETRANSFER_BANDWIDTH_RECEIVED(false),
	CONNECTION_FILETRANSFER_BANDWIDTH_SENT(false),
	CONNECTION_FILETRANSFER_BYTES_RECEIVED_TOTAL(false),
	CONNECTION_FILETRANSFER_BYTES_SENT_TOTAL(false),
	CONNECTION_PACKETS_RECEIVED_CONTROL(false),
	CONNECTION_PACKETS_RECEIVED_KEEPALIVE(false),
	CONNECTION_PACKETS_RECEIVED_SPEECH(false),
	CONNECTION_PACKETS_RECEIVED_TOTAL(false),
	CONNECTION_PACKETS_SENT_CONTROL(false),
	CONNECTION_PACKETS_SENT_KEEPALIVE(false),
	CONNECTION_PACKETS_SENT_SPEECH(false),
	CONNECTION_PACKETS_SENT_TOTAL(false),
	VIRTUALSERVER_ANTIFLOOD_POINTS_NEEDED_COMMAND_BLOCK(true),
	VIRTUALSERVER_ANTIFLOOD_POINTS_NEEDED_IP_BLOCK(true),
	VIRTUALSERVER_ANTIFLOOD_POINTS_TICK_REDUCE(true),
	VIRTUALSERVER_ASK_FOR_PRIVILEGEKEY(false),
	VIRTUALSERVER_AUTOSTART(true),
	VIRTUALSERVER_CHANNELSONLINE(false),
	VIRTUALSERVER_CLIENT_CONNECTIONS(false),
	VIRTUALSERVER_CLIENTSONLINE(false),
	VIRTUALSERVER_CODEC_ENCRYPTION_MODE(true),
	VIRTUALSERVER_COMPLAIN_AUTOBAN_COUNT(true),
	VIRTUALSERVER_COMPLAIN_AUTOBAN_TIME(true),
	VIRTUALSERVER_COMPLAIN_REMOVE_TIME(true),
	VIRTUALSERVER_CREATED(false),
	VIRTUALSERVER_DEFAULT_CHANNEL_ADMIN_GROUP(true),
	VIRTUALSERVER_DEFAULT_CHANNEL_GROUP(true),
	VIRTUALSERVER_DEFAULT_SERVER_GROUP(true),
	VIRTUALSERVER_DOWNLOAD_QUOTA(true),
	VIRTUALSERVER_FILEBASE(false),
	VIRTUALSERVER_FLAG_PASSWORD(false),
	VIRTUALSERVER_HOSTBANNER_GFX_INTERVAL(true),
	VIRTUALSERVER_HOSTBANNER_GFX_URL(true),
	VIRTUALSERVER_HOSTBANNER_MODE(true),
	VIRTUALSERVER_HOSTBANNER_URL(true),
	VIRTUALSERVER_HOSTBUTTON_GFX_URL(true),
	VIRTUALSERVER_HOSTBUTTON_TOOLTIP(true),
	VIRTUALSERVER_HOSTBUTTON_URL(true),
	VIRTUALSERVER_HOSTMESSAGE(true),
	VIRTUALSERVER_HOSTMESSAGE_MODE(true),
	VIRTUALSERVER_ICON_ID(true),
	VIRTUALSERVER_ID(false),
	VIRTUALSERVER_IP(false),
	VIRTUALSERVER_LOG_CHANNEL(true),
	VIRTUALSERVER_LOG_CLIENT(true),
	VIRTUALSERVER_LOG_FILETRANSFER(true),
	VIRTUALSERVER_LOG_PERMISSIONS(true),
	VIRTUALSERVER_LOG_QUERY(true),
	VIRTUALSERVER_LOG_SERVER(true),
	VIRTUALSERVER_MACHINE_ID(true),
	VIRTUALSERVER_MAX_DOWNLOAD_TOTAL_BANDWIDTH(true),
	VIRTUALSERVER_MAX_UPLOAD_TOTAL_BANDWIDTH(true),
	VIRTUALSERVER_MAXCLIENTS(true),
	VIRTUALSERVER_MIN_CLIENT_VERSION(true),
	VIRTUALSERVER_MIN_CLIENTS_IN_CHANNEL_BEFORE_FORCED_SILENCE(true),
	VIRTUALSERVER_MONTH_BYTES_DOWNLOADED(false),
	VIRTUALSERVER_MONTH_BYTES_UPLOADED(false),
	VIRTUALSERVER_NAME(true),
	VIRTUALSERVER_NAME_PHONETIC(true),
	VIRTUALSERVER_NEEDED_IDENTITY_SECURITY_LEVEL(true),
	VIRTUALSERVER_PASSWORD(true),
	VIRTUALSERVER_PLATFORM(false),
	VIRTUALSERVER_PORT(true),
	VIRTUALSERVER_PRIORITY_SPEAKER_DIMM_MODIFICATOR(true),
	VIRTUALSERVER_QUERY_CLIENT_CONNECTIONS(false),
	VIRTUALSERVER_QUERYCLIENTSONLINE(false),
	VIRTUALSERVER_RESERVED_SLOTS(true),
	VIRTUALSERVER_STATUS(true),
	VIRTUALSERVER_TOTAL_BYTES_DOWNLOADED(false),
	VIRTUALSERVER_TOTAL_BYTES_UPLOADED(false),
	VIRTUALSERVER_TOTAL_PACKETLOSS_CONTROL(false),
	VIRTUALSERVER_TOTAL_PACKETLOSS_KEEPALIVE(false),
	VIRTUALSERVER_TOTAL_PACKETLOSS_SPEECH(false),
	VIRTUALSERVER_TOTAL_PACKETLOSS_TOTAL(false),
	VIRTUALSERVER_TOTAL_PING(false),
	VIRTUALSERVER_UNIQUE_IDENTIFIER(false),
	VIRTUALSERVER_UPLOAD_QUOTA(true),
	VIRTUALSERVER_UPTIME(false),
	VIRTUALSERVER_VERSION(false),
	VIRTUALSERVER_WEBLIST_ENABLED(true),
	VIRTUALSERVER_WELCOMEMESSAGE(true);

	private final boolean changeable;

	VirtualServerProperty(boolean changeable) {
		this.changeable = changeable;
	}

	@Override
	public String getName() {
		return name().toLowerCase(Locale.ROOT);
	}

	public boolean isChangeable() {
		return changeable;
	}

}
