package me.iblitzkriegi.vixio.expressions.member;

import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Date;
import ch.njol.util.Kleenean;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.util.Util;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.User;

public class ExprJoinDate extends SimplePropertyExpression<Object, Date> {
    static {
        Vixio.getInstance().registerPropertyExpression(ExprJoinDate.class, Date.class, "[<discord>] join date", "members/users")
                .setName("Join Date")
                .setDesc("Get the date a member joined a guild. If you append discord then it gets the date they joined discord, otherwise its the date they joined the guild if the input is a member and the discord join date for users.")
                .setExample("reply with \"%discord join date of event-user%\"");
    }

    private boolean discord;

    @Override
    protected String getPropertyName() {
        return "join date";
    }

    @Override
    public Date convert(Object object) {
        if (object instanceof Member) {
            Member member = (Member) object;
            return discord ? Util.getDate(member.getTimeJoined()) : Util.getDate(member.getUser().getTimeCreated());
        } else if (object instanceof User) {
            return discord ? null : Util.getDate(((User) object).getTimeCreated());
        }
        return null;
    }

    @Override
    public Class<? extends Date> getReturnType() {
        return Date.class;
    }

    @Override
    public boolean init(final Expression<?>[] exprs, final int matchedPattern, final Kleenean isDelayed, final SkriptParser.ParseResult parseResult) {
        setExpr(exprs[0]);
        discord = parseResult.regexes.size() == 0;
        return true;
    }

}
