package me.iblitzkriegi.vixio.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.vdurmont.emoji.EmojiParser;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.changers.ChangeableSimpleExpression;
import me.iblitzkriegi.vixio.changers.EffChange;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import me.iblitzkriegi.vixio.util.wrapper.Emote;
import net.dv8tion.jda.api.entities.*;
import net.dv8tion.jda.api.exceptions.PermissionException;
import org.bukkit.event.Event;

/**
 * Created by Blitz on 7/25/2017.
 */
public class ExprName extends ChangeableSimpleExpression<String> {
    static {
        Vixio.getInstance().registerPropertyExpression(ExprName.class, String.class,
                "discord name", "channel/guild/bot/user/role/track/category/emote/field/attachment")
                .setName("Name of")
                .setDesc("Get the name of any discord entity. You can set the name of channels, guilds, bots, categories, and channel builders.")
                .setExample("broadcast \"%name of event-user%\"");
    }

    private Expression<Object> object;

    @Override
    protected String[] get(Event e) {
        Object o = this.object.getSingle(e);

        if (o instanceof User) {
            return new String[]{((User) o).getName()};
        } else if (o instanceof Guild) {
            return new String[]{((Guild) o).getName()};
        } else if (o instanceof GuildChannel) {
            return new String[]{((GuildChannel) o).getName()};
        } else if (o instanceof Bot) {
            return new String[]{((Bot) o).getName()};
        } else if (o instanceof Role) {
            return new String[]{((Role) o).getName()};
        } else if (o instanceof AudioTrack) {
            return new String[]{((AudioTrack) o).getInfo().title};
        } else if (o instanceof Emote) {
            if (((Emote) o).isEmote()) {
                return new String[]{((Emote) o).getName()};
            } else {
                if (EmojiParser.parseToAliases(((Emote) o).getName()) != null) {
                    return new String[]{EmojiParser.parseToAliases(((Emote) o).getName()).replaceAll(":", "")};
                }
            }
            return null;
        } else if (o instanceof MessageEmbed.Field) {
            return new String[]{((MessageEmbed.Field) o).getName()};
        } else if (o instanceof Message.Attachment) {
            return new String[]{((Message.Attachment) o).getFileName()};
        }
        return null;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "discord name of " + object.toString(e, debug);
    }

    @SuppressWarnings("unchecked")
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        object = (Expression<Object>) exprs[0];
        return true;
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode, boolean vixioChanger) {
        if ((mode == Changer.ChangeMode.SET && object.isSingle())) {
            return new Class[]{String.class};
        }
        return null;
    }

    @Override
    public boolean shouldError() {
        return false;
    }

    @Override
    public void change(Event e, Object[] delta, Bot bot, Changer.ChangeMode mode) {
        Object object = this.object.getSingle(e);

        String name = (String) delta[0];
        switch (mode) {
            case SET:
                if (object instanceof Bot) {
                    bot.getSelfUser().getManager().setName(name).queue();
                } else if (object instanceof GuildChannel) {
                    GuildChannel channel = Util.bindChannel(bot, (GuildChannel) object);

                    try {
                        if (channel.getType() == ChannelType.TEXT) {
                            channel.getManager().setName(name.replaceAll(" ", "-")).queue();
                        } else {
                            channel.getManager().setName(name).queue();
                        }
                    } catch (PermissionException x) {
                        Vixio.getErrorHandler().needsPerm(bot, EffChange.format(mode, "name of", this.object, bot),
                                x.getPermission().getName());
                    }
                } else if (object instanceof Guild) {
                    Guild guild = Util.bindGuild(bot, (Guild) object);
                    if (guild == null) {
                        return;
                    }

                    try {
                        guild.getManager().setName(name).queue();
                    } catch (PermissionException x) {
                        Vixio.getErrorHandler().needsPerm(bot, EffChange.format(mode, "name of", this.object, bot),
                                x.getPermission().getName());
                    }
                }
        }
    }
}

