/*
 * Decompiled with CFR 0.152.
 */
package com.jcdesimp.landlord.persistantData;

import com.jcdesimp.landlord.Landlord;
import com.jcdesimp.landlord.landManagement.Landflag;
import com.jcdesimp.landlord.persistantData.Friend;
import com.jcdesimp.landlord.persistantData.OwnedLand;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class LowOwnedLand {
    private static TreeMap<LowChunk, LowOwnedLand> chargedLands = new TreeMap(new Comparator<LowChunk>(){

        @Override
        public int compare(LowChunk c1, LowChunk c2) {
            return c1.compareTo(c2);
        }
    });
    private static String[][] defaultPerms;
    private int id;
    private String ownerName;
    private int x;
    private int z;
    private String worldName;
    List<Friend> friends;
    private String permissions;

    public static void load() {
        ArrayList<String> guestPerms = new ArrayList<String>();
        ArrayList<String> friendsPerms = new ArrayList<String>();
        guestPerms.add("1");
        friendsPerms.add("1");
        int i = 0;
        while (i < Landlord.getInstance().getFlagManager().numStoredPerms()) {
            guestPerms.add("0");
            friendsPerms.add("1");
            ++i;
        }
        defaultPerms = new String[][]{guestPerms.toArray(new String[guestPerms.size()]), friendsPerms.toArray(new String[friendsPerms.size()])};
    }

    public static LowOwnedLand landFromProperties(Player owner, Chunk c) {
        LowChunk lc = new LowChunk(c.getWorld().getName(), c.getX(), c.getZ());
        if (!chargedLands.containsKey(lc)) {
            LowOwnedLand lnd = new LowOwnedLand();
            try {
                lnd.setProperties(owner.getName(), c);
            }
            catch (NullPointerException e) {
                lnd.setX(c.getX());
                lnd.setZ(c.getZ());
                lnd.setWorldName(c.getWorld().getName());
                lnd.setOwnerName("");
            }
            return lnd;
        }
        return chargedLands.get(lc);
    }

    public static LowOwnedLand getLandFromDatabase(int x, int z, String worldName) {
        LowChunk lc = new LowChunk(worldName, x, z);
        if (!chargedLands.containsKey(lc)) {
            OwnedLand oLand = (OwnedLand)Landlord.getInstance().getDatabase().find(OwnedLand.class).where().eq("x", (Object)x).eq("z", (Object)z).eq("worldName", (Object)worldName).findUnique();
            if (oLand != null) {
                return oLand.getLowLand(false);
            }
            return null;
        }
        return chargedLands.get(lc);
    }

    public static LowOwnedLand getLandFromDatabase(OwnedLand ownedLand, boolean search) {
        LowChunk lc = new LowChunk(ownedLand.getOwnerName(), ownedLand.getX(), ownedLand.getZ());
        if (search) {
            if (!chargedLands.containsKey(lc)) {
                LowOwnedLand land = null;
                if (ownedLand != null) {
                    land = new LowOwnedLand(ownedLand.getId(), ownedLand.getOwnerName(), ownedLand.getX(), ownedLand.getZ(), ownedLand.getWorldName(), ownedLand.getFriends(), ownedLand.getPermissions());
                }
                chargedLands.put(lc, land);
                return land;
            }
            return chargedLands.get(lc);
        }
        LowOwnedLand land = null;
        if (ownedLand != null) {
            land = new LowOwnedLand(ownedLand.getId(), ownedLand.getOwnerName(), ownedLand.getX(), ownedLand.getZ(), ownedLand.getWorldName(), ownedLand.getFriends(), ownedLand.getPermissions());
        }
        chargedLands.put(lc, land);
        return land;
    }

    public static LowOwnedLand getApplicableLand(Location l) {
        Chunk c = l.getChunk();
        return LowOwnedLand.getLandFromDatabase(c.getX(), c.getZ(), c.getWorld().getName());
    }

    public static void removeFromRAM(Chunk c) {
        chargedLands.remove(new LowChunk(c.getWorld().getName(), c.getX(), c.getZ()));
    }

    public static int getChargedLands() {
        return chargedLands.size();
    }

    public static boolean stringToBool(String s) {
        if (s.equals("1")) {
            return true;
        }
        if (s.equals("0")) {
            return false;
        }
        throw new IllegalArgumentException(String.valueOf(s) + " is not a bool. Only 1 and 0 are.");
    }

    public LowOwnedLand(int id, String ownerName, int x, int z, String worldName, List<Friend> friends, String permissions) {
        this.id = id;
        this.ownerName = ownerName;
        this.x = x;
        this.z = z;
        this.worldName = worldName;
        this.friends = friends;
        this.permissions = permissions;
    }

    public LowOwnedLand() {
    }

    public void save() {
        OwnedLand land = (OwnedLand)Landlord.getInstance().getDatabase().find(OwnedLand.class).where().eq("id", (Object)this.id).findUnique();
        if (land != null) {
            land.setOwnerName(this.ownerName);
            land.setFriends(this.friends);
            if (this.permissions == null) {
                land.setPermissions(null);
            } else if (land.getPermissions() != null && !land.getPermissions().equals(this.permissions) || land.getPermissions() == null && this.permissions != null) {
                land.setPermissions(this.permissions);
            }
        } else {
            land = new OwnedLand();
            land.setProperties(this.ownerName, this.getChunk());
            land.setFriends(this.friends);
            land.setPermissions(this.permissions);
            this.id = land.getId();
        }
        Landlord.getInstance().getDatabase().save((Object)land);
    }

    public void setProperties(String playerName, Chunk c) {
        this.setOwnerName(playerName);
        this.setX(c.getX());
        this.setZ(c.getZ());
        this.setWorldName(c.getWorld().getName());
    }

    public String[][] getLandPerms(boolean clone) {
        String perms = this.getPermissions();
        if (perms == null) {
            if (clone) {
                return (String[][])defaultPerms.clone();
            }
            return defaultPerms;
        }
        String[] permString = perms.split("\\|");
        ArrayList<String> newPermString = new ArrayList<String>();
        String[] stringArray = permString;
        int n = permString.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            newPermString.add(Integer.toBinaryString(Integer.parseInt(s)));
            ++n2;
        }
        String ePerms = (String)newPermString.get(0);
        while (ePerms.length() < Landlord.getInstance().getFlagManager().numStoredPerms() + 1) {
            ePerms = String.valueOf(ePerms) + "0";
        }
        newPermString.set(0, ePerms);
        String fPerms = (String)newPermString.get(1);
        while (fPerms.length() < Landlord.getInstance().getFlagManager().numStoredPerms() + 1) {
            fPerms = String.valueOf(fPerms) + "1";
        }
        newPermString.set(1, fPerms);
        String[][] permArray = new String[newPermString.size()][];
        int i = 0;
        while (i < newPermString.size()) {
            permArray[i] = ((String)newPermString.get(i)).split("(?!^)");
            ++i;
        }
        return permArray;
    }

    public boolean hasPermTo(Player player, Landflag lf) {
        if (player.hasPermission("landlord.admin.bypass") || player.getName().equalsIgnoreCase(this.ownerName)) {
            return true;
        }
        String[][] perms = this.getLandPerms(false);
        int applicablePermSlot = Landlord.getInstance().getFlagManager().getRegisteredFlags().get(lf.getClass().getSimpleName()).getPermSlot();
        if (this.getOwnerName().equalsIgnoreCase(player.getName())) {
            return true;
        }
        if (this.isFriend(player)) {
            String[] subPerms = perms[1];
            return LowOwnedLand.stringToBool(subPerms[applicablePermSlot]);
        }
        String[] subPerms = perms[0];
        return LowOwnedLand.stringToBool(subPerms[applicablePermSlot]);
    }

    public String permsToString(String[][] perms) {
        String permString = "";
        int i = 0;
        while (i < perms.length) {
            String currPerm = "";
            int ii = 0;
            while (ii < perms[i].length) {
                currPerm = String.valueOf(currPerm) + perms[i][ii];
                ++ii;
            }
            permString = String.valueOf(permString) + Integer.toString(Integer.parseInt(currPerm, 2));
            if (i + 1 < perms.length) {
                permString = String.valueOf(permString) + "|";
            }
            ++i;
        }
        return permString;
    }

    public boolean addFriend(Friend f) {
        if (!this.isFriend(f)) {
            this.friends.add(f);
            return true;
        }
        return false;
    }

    public boolean removeFriend(Friend f) {
        if (this.isFriend(f)) {
            Friend frd = (Friend)Landlord.getInstance().getDatabase().find(Friend.class).where().eq("id", (Object)this.friends.get(this.friends.indexOf(f)).getId()).findUnique();
            this.friends.remove(frd);
            Landlord.getInstance().getDatabase().delete((Object)frd);
            return true;
        }
        return false;
    }

    public boolean isFriend(Friend f) {
        return this.friends.contains(f);
    }

    public boolean isFriend(Player f) {
        return this.isFriend(Friend.friendFromPlayer(f));
    }

    public void delete() {
        chargedLands.remove(new LowChunk(this.worldName, this.x, this.z));
        OwnedLand land = (OwnedLand)Landlord.getInstance().getDatabase().find(OwnedLand.class).where().eq("id", (Object)this.id).findUnique();
        if (land != null) {
            Landlord.getInstance().getDatabase().delete((Object)land);
        }
    }

    public void highlightLand(Player p, Effect e) {
        this.highlightLand(p, e, 5);
    }

    public void highlightLand(Player p, Effect e, int amt) {
        if (!Landlord.getInstance().getConfig().getBoolean("options.particleEffects", true)) {
            return;
        }
        Chunk chunk = this.getChunk();
        ArrayList<Location> edgeBlocks = new ArrayList<Location>();
        int i = 0;
        while (i < 16) {
            int ii = -1;
            while (ii <= 10) {
                edgeBlocks.add(chunk.getBlock(i, (int)p.getLocation().getY() + ii, 15).getLocation());
                edgeBlocks.add(chunk.getBlock(i, (int)p.getLocation().getY() + ii, 0).getLocation());
                edgeBlocks.add(chunk.getBlock(0, (int)p.getLocation().getY() + ii, i).getLocation());
                edgeBlocks.add(chunk.getBlock(15, (int)p.getLocation().getY() + ii, i).getLocation());
                ++ii;
            }
            ++i;
        }
        for (Location edgeBlock : edgeBlocks) {
            edgeBlock.setZ((double)edgeBlock.getBlockZ() + 0.5);
            edgeBlock.setX((double)edgeBlock.getBlockX() + 0.5);
            p.spigot().playEffect(edgeBlock, e, 0, 0, 0.2f, 0.2f, 0.2f, 0.2f, amt, 9);
        }
    }

    public boolean canEveryone(Landflag lf) {
        String[][] perms = this.getLandPerms(false);
        int applicablePermSlot = Landlord.getInstance().getFlagManager().getRegisteredFlags().get(lf.getClass().getSimpleName()).getPermSlot();
        String[] subPerms = perms[0];
        return LowOwnedLand.stringToBool(subPerms[applicablePermSlot]);
    }

    public Chunk getChunk() {
        World world = Bukkit.getServer().getWorld(this.worldName);
        return world.getChunkAt(this.x, this.z);
    }

    public LowChunk getLowChunk() {
        return new LowChunk(this.worldName, this.x, this.z);
    }

    public int getXBlock() {
        return this.getChunk().getBlock(0, 0, 0).getX();
    }

    public int getZBlock() {
        return this.getChunk().getBlock(0, 0, 0).getZ();
    }

    public String getOwnerUsername() {
        if (this.ownerName == null) {
            return "Unknown";
        }
        return this.ownerName;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public void setWorldName(String worldName) {
        this.worldName = worldName;
    }

    public List<Friend> getFriends() {
        return this.friends;
    }

    public void setFriends(List<Friend> friends) {
        this.friends = friends;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public static class LowChunk
    implements Comparable<LowChunk> {
        private String world;
        private int x;
        private int z;

        public LowChunk(String world, int x, int z) {
            this.world = world;
            this.x = x;
            this.z = z;
        }

        public LowChunk(String world) {
            this.world = world;
            this.x = 0;
            this.z = 0;
        }

        public void setXY(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object other) {
            if (other instanceof LowChunk) {
                LowChunk otherChunk = (LowChunk)other;
                if (this.x == otherChunk.x && this.z == otherChunk.z && this.world.equals(otherChunk.world)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int compareTo(LowChunk c) {
            int result = this.x - c.x;
            if (result != 0) {
                return result;
            }
            result = this.z - c.z;
            if (result != 0) {
                return result;
            }
            result = this.world.compareTo(c.world);
            return result;
        }
    }
}

