/*
 * Decompiled with CFR 0.152.
 */
package com.jcdesimp.landlord.landFlags;

import com.jcdesimp.landlord.landManagement.Landflag;
import com.jcdesimp.landlord.persistantData.LowOwnedLand;
import java.util.Arrays;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;

public class HarmAnimals
extends Landflag {
    public HarmAnimals() {
        super("Animaux", "Donne la permission de taper et de tuer les|cochons, moutons, vaches, vaches champignons,|poules, chevaux, loups, et chats.", new ItemStack(Material.LEATHER), "Autorise la maltraitance d'animaux", "peuvent maltraiter les animaux.", "Interdit la maltraitance d'animaux", "ne peuvent pas maltraiter les animaux.");
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void animalDamage(EntityDamageByEntityEvent event) {
        Projectile a;
        EntityType[] safeAnimals = new EntityType[]{EntityType.OCELOT, EntityType.WOLF, EntityType.HORSE, EntityType.COW, EntityType.PIG, EntityType.MUSHROOM_COW, EntityType.SHEEP, EntityType.CHICKEN, EntityType.RABBIT};
        Entity victim = event.getEntity();
        if (!Arrays.asList(safeAnimals).contains(victim.getType())) {
            return;
        }
        Entity attacker = event.getDamager();
        if (attacker.getType() == EntityType.PLAYER) {
            Player p = (Player)attacker;
            LowOwnedLand land = LowOwnedLand.getApplicableLand(victim.getLocation());
            if (land == null) {
                return;
            }
            if (!land.hasPermTo(p, this)) {
                p.sendMessage(ChatColor.RED + "Vous ne pouvez pas maltraiter les animaux de ce terrain.");
                event.setCancelled(true);
            }
        } else if ((attacker.getType() == EntityType.ARROW || attacker.getType() == EntityType.SPLASH_POTION) && (a = (Projectile)attacker).getShooter() instanceof Player) {
            LowOwnedLand land = LowOwnedLand.getApplicableLand(victim.getLocation());
            Player p = (Player)a.getShooter();
            if (land == null) {
                return;
            }
            if (!land.hasPermTo(p, this)) {
                if (a.getType() == EntityType.ARROW) {
                    p.sendMessage(ChatColor.RED + "Vous ne pouvez pas maltraiter les animaux de ce terrain.");
                }
                a.remove();
                event.setCancelled(true);
            }
        }
    }
}

