/*
 * Decompiled with CFR 0.152.
 */
package com.jcdesimp.landlord.commands;

import com.jcdesimp.landlord.Landlord;
import com.jcdesimp.landlord.LandlordCommandExecutor;
import com.jcdesimp.landlord.commands.LandlordCommand;
import com.jcdesimp.landlord.commands.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.util.NumberConversions;

public class Help
implements LandlordCommand {
    private Landlord plugin;
    private ArrayList<LandlordCommand> registeredCommands;

    public Help(Landlord plugin, LandlordCommandExecutor commandHandler) {
        this.plugin = plugin;
        this.registeredCommands = new ArrayList();
    }

    public void addCommand(LandlordCommand lc) {
        this.registeredCommands.add(lc);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args, String label) {
        int pageNumber = 1;
        if (args.length > 1 && Arrays.asList(this.getTriggers()).contains(args[0])) {
            try {
                pageNumber = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(ChatColor.RED + "Le num\u00e9ro de page n'est pas valide.");
                return true;
            }
        }
        String helpHeader = "--|| Landlord v#{version} Cr\u00e9e par #{author} et modifi\u00e9 par #{rudelune} ||--";
        String aliases = "(Aliases: /landlord, land, /ll)";
        String header = ChatColor.DARK_GREEN + helpHeader.replace("#{version}", this.plugin.getDescription().getVersion()).replace("#{author}", ChatColor.BLUE + "Jcdesimp" + ChatColor.DARK_GREEN).replace("#{rudelune}", ChatColor.BLUE + "rudelune" + ChatColor.DARK_GREEN) + '\n' + aliases;
        ArrayList<String> helpList = new ArrayList<String>();
        for (LandlordCommand lc : this.registeredCommands) {
            String currCmd = lc.getHelpText(sender);
            if (currCmd == null) continue;
            helpList.add(currCmd.replace("#{label}", label));
        }
        int numPerPage = 5;
        int numPages = NumberConversions.ceil((double)((double)helpList.size() / 5.0));
        if (pageNumber > numPages) {
            sender.sendMessage(ChatColor.RED + "Le num\u00e9ro de page n'est pas valide.");
            return true;
        }
        String pMsg = header;
        if (pageNumber == numPages) {
            int i = 5 * pageNumber - 5;
            while (i < helpList.size()) {
                pMsg = String.valueOf(pMsg) + '\n' + (String)helpList.get(i);
                ++i;
            }
            pMsg = String.valueOf(pMsg) + ChatColor.DARK_GREEN + "\n------------------------------";
        } else {
            int i = 5 * pageNumber - 5;
            while (i < 5 * pageNumber) {
                pMsg = String.valueOf(pMsg) + '\n' + (String)helpList.get(i);
                ++i;
            }
            pMsg = String.valueOf(pMsg) + ChatColor.DARK_GREEN + "\n--- fa\u00eetes" + ChatColor.YELLOW + " /" + label + " help " + (pageNumber + 1) + ChatColor.DARK_GREEN + " pour voir la page suivante (" + pageNumber + "/" + numPages + ") ---";
        }
        sender.sendMessage(pMsg);
        return true;
    }

    @Override
    public String getHelpText(CommandSender sender) {
        String usage = "/#{label} #{cmd} [page #]";
        String desc = "Affiche l'aide.";
        return Utils.helpString(usage, desc, this.getTriggers()[0].toLowerCase());
    }

    @Override
    public String[] getTriggers() {
        return new String[]{"help", "?"};
    }
}

