/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.zplatform.impl.glowstone.itemstack;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Objects;
import net.glowstone.util.mojangson.Mojangson;
import net.glowstone.util.mojangson.ex.MojangsonParseException;
import net.glowstone.util.nbt.CompoundTag;
import net.glowstone.util.nbt.ListTag;
import net.glowstone.util.nbt.NBTInputStream;
import net.glowstone.util.nbt.NBTOutputStream;
import net.glowstone.util.nbt.NBTReadLimiter;
import net.glowstone.util.nbt.Tag;
import net.glowstone.util.nbt.TagType;
import protocolsupport.zplatform.impl.glowstone.itemstack.GlowStoneNBTTagListWrapper;
import protocolsupport.zplatform.itemstack.NBTTagCompoundWrapper;
import protocolsupport.zplatform.itemstack.NBTTagListWrapper;

public class GlowStoneNBTTagCompoundWrapper
extends NBTTagCompoundWrapper {
    protected final CompoundTag tag;

    protected GlowStoneNBTTagCompoundWrapper(CompoundTag tag) {
        this.tag = tag;
    }

    public CompoundTag unwrap() {
        return this.tag;
    }

    public static GlowStoneNBTTagCompoundWrapper fromJson(String json) {
        try {
            return new GlowStoneNBTTagCompoundWrapper(Mojangson.parseCompound((String)json));
        }
        catch (MojangsonParseException e) {
            throw new RuntimeException("Unable to parse mojangson", e);
        }
    }

    public static GlowStoneNBTTagCompoundWrapper fromStream(InputStream in) throws IOException {
        return new GlowStoneNBTTagCompoundWrapper(new NBTInputStream(in, false).readCompound(new NBTReadLimiter(0x200000L)));
    }

    public static GlowStoneNBTTagCompoundWrapper createEmpty() {
        return new GlowStoneNBTTagCompoundWrapper(new CompoundTag());
    }

    public static GlowStoneNBTTagCompoundWrapper createNull() {
        return new GlowStoneNBTTagCompoundWrapper(null);
    }

    public static GlowStoneNBTTagCompoundWrapper wrap(CompoundTag tag) {
        return new GlowStoneNBTTagCompoundWrapper(tag);
    }

    @Override
    public void writeToStream(OutputStream outputstream) throws IOException {
        new NBTOutputStream(outputstream, false).writeTag((Tag)this.tag);
    }

    @Override
    public boolean isNull() {
        return this.tag == null;
    }

    @Override
    public void remove(String key) {
        this.tag.remove(key);
    }

    @Override
    public Collection<String> getKeys() {
        return this.tag.getValue().keySet();
    }

    @Override
    public boolean hasKeyOfType(String tagname, int type) {
        Tag tagval = (Tag)this.tag.getValue().get(tagname);
        return tagval != null && tagval.getType().getId() == type;
    }

    @Override
    public NBTTagCompoundWrapper getCompound(String key) {
        Tag tagval = (Tag)this.tag.getValue().get(key);
        if (tagval != null && tagval.getType() == TagType.COMPOUND) {
            return GlowStoneNBTTagCompoundWrapper.wrap((CompoundTag)tagval);
        }
        return GlowStoneNBTTagCompoundWrapper.createEmpty();
    }

    @Override
    public void setCompound(String key, NBTTagCompoundWrapper compound) {
        this.tag.putCompound(key, ((GlowStoneNBTTagCompoundWrapper)compound).tag);
    }

    @Override
    public NBTTagListWrapper getList(String key, int type) {
        Tag tagval = (Tag)this.tag.getValue().get(key);
        if (tagval != null && tagval.getType() == TagType.LIST) {
            return new GlowStoneNBTTagListWrapper((ListTag)tagval);
        }
        return GlowStoneNBTTagListWrapper.create();
    }

    @Override
    public void setList(String key, NBTTagListWrapper list) {
        ListTag<Tag<?>> listtag = ((GlowStoneNBTTagListWrapper)list).tag;
        this.tag.putList(key, listtag.getType(), listtag.getValue());
    }

    @Override
    public String getString(String key) {
        Tag tagval = (Tag)this.tag.getValue().get(key);
        if (tagval != null && tagval.getType() == TagType.STRING) {
            return (String)tagval.getValue();
        }
        return "";
    }

    @Override
    public void setString(String key, String value) {
        this.tag.putString(key, value);
    }

    @Override
    public int getNumber(String key) {
        Object rawval;
        Tag tagval = (Tag)this.tag.getValue().get(key);
        if (tagval != null && (rawval = tagval.getValue()) instanceof Number) {
            return ((Number)rawval).intValue();
        }
        return 0;
    }

    @Override
    public void setInt(String key, int i) {
        this.tag.putInt(key, i);
    }

    @Override
    public void setByte(String key, int value) {
        this.tag.putByte(key, value);
    }

    public int hashCode() {
        return this.tag != null ? this.tag.hashCode() : 0;
    }

    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof GlowStoneNBTTagCompoundWrapper)) {
            return false;
        }
        GlowStoneNBTTagCompoundWrapper other = (GlowStoneNBTTagCompoundWrapper)otherObj;
        return Objects.equals(this.tag, other.tag);
    }

    public String toString() {
        return Objects.toString(this.tag);
    }
}

