/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.zplatform.impl.glowstone;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import java.security.KeyPair;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.stream.Collectors;
import net.glowstone.GlowServer;
import net.glowstone.constants.GlowAchievement;
import net.glowstone.constants.GlowStatistic;
import net.glowstone.entity.meta.profile.PlayerProfile;
import net.glowstone.entity.meta.profile.PlayerProperty;
import net.glowstone.io.nbt.NbtSerialization;
import net.glowstone.net.protocol.ProtocolType;
import net.glowstone.util.GlowServerIcon;
import net.glowstone.util.nbt.CompoundTag;
import org.bukkit.Achievement;
import org.bukkit.Bukkit;
import org.bukkit.Statistic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.CachedServerIcon;
import protocolsupport.protocol.pipeline.IPacketPrepender;
import protocolsupport.protocol.pipeline.IPacketSplitter;
import protocolsupport.protocol.utils.authlib.GameProfile;
import protocolsupport.zplatform.PlatformUtils;
import protocolsupport.zplatform.impl.glowstone.itemstack.GlowStoneNBTTagCompoundWrapper;
import protocolsupport.zplatform.impl.glowstone.network.GlowStoneNetworkManagerWrapper;
import protocolsupport.zplatform.impl.glowstone.network.pipeline.GlowStoneFramingHandler;
import protocolsupport.zplatform.itemstack.NBTTagCompoundWrapper;
import protocolsupport.zplatform.network.NetworkManagerWrapper;
import protocolsupport.zplatform.network.NetworkState;

public class GlowStoneMiscUtils
implements PlatformUtils {
    private boolean debug = false;
    private static final Map<String, Statistic> statByName = Arrays.stream(Statistic.values()).filter(stat -> GlowStatistic.getName((Statistic)stat) != null).collect(Collectors.toMap(stat -> GlowStatistic.getName((Statistic)stat), stat -> stat));
    private static final Map<String, Achievement> achByName = Arrays.stream(Achievement.values()).filter(ach -> GlowAchievement.getName((Achievement)ach) != null).collect(Collectors.toMap(ach -> GlowAchievement.getName((Achievement)ach), ach -> ach));

    public static GlowServer getServer() {
        return (GlowServer)Bukkit.getServer();
    }

    public static PlayerProfile toGlowStoneGameProfile(GameProfile profile) {
        return new PlayerProfile(profile.getName(), profile.getUUID(), profile.getProperties().values().stream().map(property -> new PlayerProperty(property.getName(), property.getValue(), property.getSignature())).collect(Collectors.toList()));
    }

    public static ProtocolType netStateToProtocol(NetworkState type) {
        switch (type) {
            case HANDSHAKING: {
                return ProtocolType.HANDSHAKE;
            }
            case PLAY: {
                return ProtocolType.PLAY;
            }
            case LOGIN: {
                return ProtocolType.LOGIN;
            }
            case STATUS: {
                return ProtocolType.STATUS;
            }
        }
        throw new IllegalArgumentException(MessageFormat.format("Unknown state {0}", new Object[]{type}));
    }

    public static NetworkState protocolToNetState(ProtocolType type) {
        switch (type) {
            case HANDSHAKE: {
                return NetworkState.HANDSHAKING;
            }
            case LOGIN: {
                return NetworkState.LOGIN;
            }
            case STATUS: {
                return NetworkState.STATUS;
            }
            case PLAY: {
                return NetworkState.PLAY;
            }
        }
        throw new IllegalArgumentException(MessageFormat.format("Unknown protocol {0}", type));
    }

    @Override
    public ItemStack createItemStackFromNBTTag(NBTTagCompoundWrapper tag) {
        return NbtSerialization.readItem((CompoundTag)((GlowStoneNBTTagCompoundWrapper)tag).unwrap());
    }

    @Override
    public NBTTagCompoundWrapper createNBTTagFromItemStack(ItemStack itemstack) {
        return GlowStoneNBTTagCompoundWrapper.wrap(NbtSerialization.writeItem((ItemStack)itemstack, (int)0));
    }

    @Override
    public String getOutdatedServerMessage() {
        return "Outdated server! I'm running {0}";
    }

    @Override
    public boolean isBungeeEnabled() {
        return GlowStoneMiscUtils.getServer().getProxySupport();
    }

    @Override
    public boolean isDebugging() {
        return this.debug;
    }

    @Override
    public void enableDebug() {
        this.debug = true;
    }

    @Override
    public void disableDebug() {
        this.debug = false;
    }

    @Override
    public int getCompressionThreshold() {
        return GlowStoneMiscUtils.getServer().getCompressionThreshold();
    }

    @Override
    public KeyPair getEncryptionKeyPair() {
        return GlowStoneMiscUtils.getServer().getKeyPair();
    }

    @Override
    public <V> FutureTask<V> callSyncTask(Callable<V> call) {
        FutureTask<V> task = new FutureTask<V>(call);
        Bukkit.getScheduler().scheduleSyncDelayedTask(null, task);
        return task;
    }

    @Override
    public String getModName() {
        return "GlowStone";
    }

    @Override
    public String getVersionName() {
        return "1.11.2";
    }

    @Override
    public Statistic getStatisticByName(String value) {
        return statByName.get(value);
    }

    @Override
    public String getStatisticName(Statistic stat) {
        return GlowStatistic.getName((Statistic)stat);
    }

    @Override
    public Achievement getAchievmentByName(String value) {
        return achByName.get(value);
    }

    @Override
    public String getAchievmentName(Achievement achievement) {
        return GlowAchievement.getName((Achievement)achievement);
    }

    @Override
    public String convertBukkitIconToBase64(CachedServerIcon icon) {
        return ((GlowServerIcon)icon).getData();
    }

    @Override
    public NetworkState getNetworkStateFromChannel(Channel channel) {
        return GlowStoneNetworkManagerWrapper.getFromChannel(channel).getProtocol();
    }

    @Override
    public NetworkManagerWrapper getNetworkManagerFromChannel(Channel channel) {
        return GlowStoneNetworkManagerWrapper.getFromChannel(channel);
    }

    @Override
    public String getReadTimeoutHandlerName() {
        return "readtimeout";
    }

    @Override
    public String getSplitterHandlerName() {
        return "framing";
    }

    @Override
    public String getPrependerHandlerName() {
        return "framing";
    }

    @Override
    public void setFraming(ChannelPipeline pipeline, IPacketSplitter splitter, IPacketPrepender prepender) {
        ((GlowStoneFramingHandler)pipeline.get("framing")).setRealFraming(prepender, splitter);
    }
}

