/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.typeremapper.itemstack.clientbound;

import protocolsupport.api.ProtocolVersion;
import protocolsupport.protocol.typeremapper.itemstack.ItemStackNBTSpecificRemapper;
import protocolsupport.protocol.typeskipper.id.IdSkipper;
import protocolsupport.protocol.typeskipper.id.SkippingTable;
import protocolsupport.zplatform.ServerPlatform;
import protocolsupport.zplatform.itemstack.ItemStackWrapper;
import protocolsupport.zplatform.itemstack.NBTTagCompoundWrapper;
import protocolsupport.zplatform.itemstack.NBTTagListWrapper;

public class EnchantFilterNBTSpecificRemapper
extends ItemStackNBTSpecificRemapper {
    @Override
    public NBTTagCompoundWrapper remapTag(ProtocolVersion version, ItemStackWrapper itemstack, NBTTagCompoundWrapper tag) {
        if (tag.hasKeyOfType("ench", 9)) {
            tag.setList("ench", this.filterEnchantList(version, tag.getList("ench", 10)));
        }
        if (tag.hasKeyOfType("stored-enchants", 9)) {
            tag.setList("stored-enchants", this.filterEnchantList(version, tag.getList("stored-enchants", 10)));
        }
        return tag;
    }

    private NBTTagListWrapper filterEnchantList(ProtocolVersion version, NBTTagListWrapper oldList) {
        SkippingTable.IntSkippingTable enchSkip = (SkippingTable.IntSkippingTable)IdSkipper.ENCHANT.getTable(version);
        NBTTagListWrapper newList = ServerPlatform.get().getWrapperFactory().createEmptyNBTList();
        for (int i = 0; i < oldList.size(); ++i) {
            NBTTagCompoundWrapper enchData = oldList.getCompound(i);
            if (enchSkip.shouldSkip(enchData.getNumber("id") & 0xFFFF)) continue;
            newList.addCompound(enchData);
        }
        return newList;
    }
}

