/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.pipeline.version;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import protocolsupport.api.Connection;
import protocolsupport.protocol.packet.middle.ServerBoundMiddlePacket;
import protocolsupport.protocol.packet.middleimpl.ServerBoundPacketData;
import protocolsupport.protocol.serializer.ProtocolSupportPacketDataSerializer;
import protocolsupport.protocol.storage.NetworkDataCache;
import protocolsupport.protocol.utils.registry.MiddleTransformerRegistry;
import protocolsupport.utils.netty.Allocator;
import protocolsupport.utils.recyclable.RecyclableCollection;

public abstract class AbstractPacketDecoder
extends MessageToMessageDecoder<ByteBuf> {
    protected final MiddleTransformerRegistry<ServerBoundMiddlePacket> registry = new MiddleTransformerRegistry();
    protected final Connection connection;
    protected final NetworkDataCache cache;

    public AbstractPacketDecoder(Connection connection, NetworkDataCache cache) {
        this.connection = connection;
        this.cache = cache;
        this.registry.setCallBack(object -> {
            object.setConnection(this.connection);
            object.setSharedStorage(this.cache);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPackets(RecyclableCollection<ServerBoundPacketData> packets, List<Object> to) {
        try {
            for (ServerBoundPacketData packetdata : packets) {
                ByteBuf receivedata = Allocator.allocateBuffer();
                ProtocolSupportPacketDataSerializer.writeVarInt(receivedata, packetdata.getPacketId());
                receivedata.writeBytes((ByteBuf)packetdata);
                to.add(receivedata);
            }
        }
        finally {
            packets.recycle();
        }
    }
}

