/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.pipeline.initial;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.Future;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.EnumMap;
import java.util.concurrent.TimeUnit;
import protocolsupport.ProtocolSupport;
import protocolsupport.api.ProtocolVersion;
import protocolsupport.protocol.ConnectionImpl;
import protocolsupport.protocol.pipeline.IPipeLineBuilder;
import protocolsupport.protocol.pipeline.initial.ProtocolUtils;
import protocolsupport.protocol.pipeline.initial.SetProtocolTask;
import protocolsupport.protocol.pipeline.version.v_legacy.PipeLineBuilder;
import protocolsupport.protocol.serializer.ProtocolSupportPacketDataSerializer;
import protocolsupport.utils.Utils;
import protocolsupport.utils.netty.ReplayingDecoderBuffer;
import protocolsupport.zplatform.ServerPlatform;

public class InitialPacketDecoder
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final int ping152delay = Utils.getJavaPropertyValue("ping152delay", 100, Utils.Converter.STRING_TO_INT);
    private static final int pingLegacyDelay = Utils.getJavaPropertyValue("pinglegacydelay", 200, Utils.Converter.STRING_TO_INT);
    private static final EnumMap<ProtocolVersion, IPipeLineBuilder> pipelineBuilders = new EnumMap(ProtocolVersion.class);
    protected final ByteBuf receivedData = Unpooled.buffer();
    protected final ReplayingDecoderBuffer replayingBuffer = new ReplayingDecoderBuffer(this.receivedData);
    protected Future<?> responseTask;

    public static void init() {
        ProtocolSupport.logInfo("Assume 1.5.2 ping delay: " + ping152delay);
        ProtocolSupport.logInfo("Assume legacy ping dealy: " + pingLegacyDelay);
    }

    protected void scheduleTask(ChannelHandlerContext ctx, Runnable task, long delay, TimeUnit tu) {
        this.responseTask = ctx.executor().schedule(task, delay, tu);
    }

    protected void cancelTask() {
        if (this.responseTask != null) {
            this.responseTask.cancel(true);
            this.responseTask = null;
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.cancelTask();
        super.channelInactive(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.cancelTask();
        super.handlerRemoved(ctx);
    }

    public void channelRead0(ChannelHandlerContext ctx, ByteBuf buf) {
        if (!buf.isReadable()) {
            return;
        }
        this.receivedData.writeBytes(buf);
        this.receivedData.readerIndex(0);
        this.decode(ctx);
    }

    private void decode(ChannelHandlerContext ctx) {
        this.cancelTask();
        Channel channel = ctx.channel();
        short firstbyte = this.replayingBuffer.readUnsignedByte();
        try {
            ProtocolVersion handshakeversion = null;
            switch (firstbyte) {
                case 254: {
                    if (this.replayingBuffer.readableBytes() == 0) {
                        this.scheduleTask(ctx, new SetProtocolTask(this, channel, ProtocolVersion.MINECRAFT_LEGACY), pingLegacyDelay, TimeUnit.MILLISECONDS);
                        break;
                    }
                    if (this.replayingBuffer.readUnsignedByte() == 1) {
                        if (this.replayingBuffer.readableBytes() == 0) {
                            this.scheduleTask(ctx, new SetProtocolTask(this, channel, ProtocolVersion.MINECRAFT_1_5_2), ping152delay, TimeUnit.MILLISECONDS);
                            break;
                        }
                        if (this.replayingBuffer.readUnsignedByte() == 250 && "MC|PingHost".equals(new String(ProtocolSupportPacketDataSerializer.toArray(this.replayingBuffer.readSlice(this.replayingBuffer.readUnsignedShort() * 2)), StandardCharsets.UTF_16BE))) {
                            this.replayingBuffer.readUnsignedShort();
                            handshakeversion = ProtocolUtils.get16PingVersion(this.replayingBuffer.readUnsignedByte());
                            break;
                        }
                        handshakeversion = InitialPacketDecoder.attemptDecodeNettyHandshake(this.replayingBuffer);
                        break;
                    }
                    handshakeversion = InitialPacketDecoder.attemptDecodeNettyHandshake(this.replayingBuffer);
                    break;
                }
                case 2: {
                    handshakeversion = ProtocolUtils.readOldHandshake(this.replayingBuffer);
                    break;
                }
                default: {
                    handshakeversion = InitialPacketDecoder.attemptDecodeNettyHandshake(this.replayingBuffer);
                }
            }
            if (handshakeversion != null) {
                this.setProtocol(channel, handshakeversion);
            }
        }
        catch (ReplayingDecoderBuffer.EOFSignal eOFSignal) {
            // empty catch block
        }
    }

    protected void setProtocol(Channel channel, ProtocolVersion version) {
        ConnectionImpl connection = ConnectionImpl.getFromChannel(channel);
        if (ServerPlatform.get().getMiscUtils().isDebugging()) {
            ProtocolSupport.logInfo(MessageFormat.format("{0} connected with protocol version {1}", new Object[]{connection.getAddress(), version}));
        }
        connection.setVersion(version);
        channel.pipeline().remove("ps_initial_decoder");
        pipelineBuilders.get((Object)version).buildPipeLine(channel, connection);
        this.receivedData.readerIndex(0);
        channel.pipeline().firstContext().fireChannelRead((Object)this.receivedData);
    }

    private static ProtocolVersion attemptDecodeNettyHandshake(ByteBuf bytebuf) {
        bytebuf.readerIndex(0);
        return ProtocolUtils.readNettyHandshake(bytebuf.readSlice(ProtocolSupportPacketDataSerializer.readVarInt(bytebuf)));
    }

    static {
        pipelineBuilders.put(ProtocolVersion.MINECRAFT_FUTURE, new protocolsupport.protocol.pipeline.version.v_future.PipeLineBuilder());
        protocolsupport.protocol.pipeline.version.v_1_11.PipeLineBuilder builder111 = new protocolsupport.protocol.pipeline.version.v_1_11.PipeLineBuilder();
        pipelineBuilders.put(ProtocolVersion.MINECRAFT_1_11_1, builder111);
        pipelineBuilders.put(ProtocolVersion.MINECRAFT_1_11, builder111);
        pipelineBuilders.put(ProtocolVersion.MINECRAFT_1_10, new protocolsupport.protocol.pipeline.version.v_1_10.PipeLineBuilder());
        pipelineBuilders.put(ProtocolVersion.MINECRAFT_1_9_4, new protocolsupport.protocol.pipeline.version.v_1_9.r2.PipeLineBuilder());
        protocolsupport.protocol.pipeline.version.v_1_9.r1.PipeLineBuilder builder19r1 = new protocolsupport.protocol.pipeline.version.v_1_9.r1.PipeLineBuilder();
        pipelineBuilders.put(ProtocolVersion.MINECRAFT_1_9_2, builder19r1);
        pipelineBuilders.put(ProtocolVersion.MINECRAFT_1_9_1, builder19r1);
        pipelineBuilders.put(ProtocolVersion.MINECRAFT_1_9, builder19r1);
        pipelineBuilders.put(ProtocolVersion.MINECRAFT_1_8, new protocolsupport.protocol.pipeline.version.v_1_8.PipeLineBuilder());
        protocolsupport.protocol.pipeline.version.v_1_7.PipeLineBuilder builder17 = new protocolsupport.protocol.pipeline.version.v_1_7.PipeLineBuilder();
        pipelineBuilders.put(ProtocolVersion.MINECRAFT_1_7_10, builder17);
        pipelineBuilders.put(ProtocolVersion.MINECRAFT_1_7_5, builder17);
        protocolsupport.protocol.pipeline.version.v_1_6.PipeLineBuilder builder16 = new protocolsupport.protocol.pipeline.version.v_1_6.PipeLineBuilder();
        pipelineBuilders.put(ProtocolVersion.MINECRAFT_1_6_4, builder16);
        pipelineBuilders.put(ProtocolVersion.MINECRAFT_1_6_2, builder16);
        pipelineBuilders.put(ProtocolVersion.MINECRAFT_1_6_1, builder16);
        protocolsupport.protocol.pipeline.version.v_1_5.PipeLineBuilder builder15 = new protocolsupport.protocol.pipeline.version.v_1_5.PipeLineBuilder();
        pipelineBuilders.put(ProtocolVersion.MINECRAFT_1_5_2, builder15);
        pipelineBuilders.put(ProtocolVersion.MINECRAFT_1_5_1, builder15);
        pipelineBuilders.put(ProtocolVersion.MINECRAFT_1_4_7, new protocolsupport.protocol.pipeline.version.v_1_4.PipeLineBuilder());
        pipelineBuilders.put(ProtocolVersion.MINECRAFT_LEGACY, new PipeLineBuilder());
    }
}

