/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.pipeline.common;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.timeout.ReadTimeoutException;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.HashSet;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import protocolsupport.api.Connection;
import protocolsupport.api.events.ConnectionCloseEvent;
import protocolsupport.api.events.ConnectionOpenEvent;
import protocolsupport.api.events.PlayerDisconnectEvent;
import protocolsupport.logger.AsyncErrorLogger;
import protocolsupport.protocol.ConnectionImpl;
import protocolsupport.protocol.storage.ProtocolStorage;
import protocolsupport.zplatform.network.NetworkManagerWrapper;

public class LogicHandler
extends ChannelDuplexHandler {
    private static final HashSet<Class<? extends Throwable>> ignoreExceptions = new HashSet();
    private final ConnectionImpl connection;

    public LogicHandler(ConnectionImpl connection) {
        this.connection = connection;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.connection.handlePacketReceive(msg)) {
            super.channelRead(ctx, msg);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (this.connection.handlePacketSend(msg)) {
            super.write(ctx, msg, promise);
        } else {
            promise.setSuccess();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) throws Exception {
        super.exceptionCaught(ctx, e);
        if (!ignoreExceptions.contains(e.getClass())) {
            ConnectionImpl connecion = ConnectionImpl.getFromChannel(ctx.channel());
            AsyncErrorLogger.INSTANCE.log(e, new Object[]{((Connection)connecion).getAddress(), connecion.getVersion()});
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        Bukkit.getPluginManager().callEvent((Event)new ConnectionOpenEvent(this.connection));
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        ConnectionImpl connection = ConnectionImpl.getFromChannel(ctx.channel());
        NetworkManagerWrapper networkmanager = connection.getNetworkManagerWrapper();
        String username = networkmanager.getUserName();
        if (username != null) {
            Bukkit.getPluginManager().callEvent((Event)new PlayerDisconnectEvent((Connection)connection, username));
        }
        Bukkit.getPluginManager().callEvent((Event)new ConnectionCloseEvent(connection));
        ProtocolStorage.removeConnection(networkmanager.getRawAddress());
    }

    static {
        ignoreExceptions.add(ClosedChannelException.class);
        ignoreExceptions.add(ReadTimeoutException.class);
        ignoreExceptions.add(IOException.class);
    }
}

