/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.packet.middle.clientbound.play;

import java.util.UUID;
import protocolsupport.api.chat.ChatAPI;
import protocolsupport.api.events.PlayerPropertiesResolveEvent;
import protocolsupport.protocol.packet.middle.ClientBoundMiddlePacket;
import protocolsupport.protocol.serializer.ProtocolSupportPacketDataSerializer;
import protocolsupport.protocol.storage.NetworkDataCache;

public abstract class MiddlePlayerInfo<T>
extends ClientBoundMiddlePacket<T> {
    protected Action action;
    protected Info[] infos;

    @Override
    public void readFromServerData(ProtocolSupportPacketDataSerializer serializer) {
        this.action = Action.values()[serializer.readVarInt()];
        this.infos = new Info[serializer.readVarInt()];
        for (int i = 0; i < this.infos.length; ++i) {
            Info info = new Info();
            info.uuid = serializer.readUUID();
            switch (this.action) {
                case ADD: {
                    info.username = serializer.readString(16);
                    info.properties = new PlayerPropertiesResolveEvent.ProfileProperty[serializer.readVarInt()];
                    for (int j = 0; j < info.properties.length; ++j) {
                        String name = serializer.readString();
                        String value = serializer.readString();
                        String signature = null;
                        if (serializer.readBoolean()) {
                            signature = serializer.readString();
                        }
                        info.properties[j] = new PlayerPropertiesResolveEvent.ProfileProperty(name, value, signature);
                    }
                    info.gamemode = serializer.readVarInt();
                    info.ping = serializer.readVarInt();
                    if (!serializer.readBoolean()) break;
                    info.displayNameJson = serializer.readString();
                    break;
                }
                case GAMEMODE: {
                    info.gamemode = serializer.readVarInt();
                    break;
                }
                case PING: {
                    info.ping = serializer.readVarInt();
                    break;
                }
                case DISPLAY_NAME: {
                    if (!serializer.readBoolean()) break;
                    info.displayNameJson = serializer.readString();
                    break;
                }
            }
            this.infos[i] = info;
        }
    }

    @Override
    public void handle() {
        block5: for (Info info : this.infos) {
            info.previousinfo = this.cache.getPlayerListEntry(info.uuid);
            if (info.previousinfo != null) {
                info.previousinfo = info.previousinfo.clone();
            }
            switch (this.action) {
                case ADD: {
                    NetworkDataCache.PlayerListEntry entry = new NetworkDataCache.PlayerListEntry(info.username);
                    entry.setDisplayNameJson(info.displayNameJson);
                    for (PlayerPropertiesResolveEvent.ProfileProperty property : info.properties) {
                        entry.getProperties().add(property);
                    }
                    this.cache.addPlayerListEntry(info.uuid, entry);
                    continue block5;
                }
                case DISPLAY_NAME: {
                    NetworkDataCache.PlayerListEntry entry = this.cache.getPlayerListEntry(info.uuid);
                    if (entry == null) continue block5;
                    entry.setDisplayNameJson(info.displayNameJson);
                    continue block5;
                }
                case REMOVE: {
                    this.cache.removePlayerListEntry(info.uuid);
                    continue block5;
                }
            }
        }
    }

    protected static class Info {
        public UUID uuid;
        public NetworkDataCache.PlayerListEntry previousinfo;
        public String username;
        public int ping;
        public int gamemode;
        public String displayNameJson;
        public PlayerPropertiesResolveEvent.ProfileProperty[] properties;

        protected Info() {
        }

        public String getName() {
            return this.displayNameJson == null ? this.username : ChatAPI.fromJSON(this.displayNameJson).toLegacyText();
        }
    }

    protected static enum Action {
        ADD,
        GAMEMODE,
        PING,
        DISPLAY_NAME,
        REMOVE;

    }
}

