/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.packet.middle.clientbound.play;

import java.util.LinkedHashMap;
import java.util.UUID;
import protocolsupport.protocol.packet.middle.clientbound.play.MiddleEntity;
import protocolsupport.protocol.serializer.ProtocolSupportPacketDataSerializer;

public abstract class MiddleEntitySetAttributes<T>
extends MiddleEntity<T> {
    protected final LinkedHashMap<String, Attribute> attributes = new LinkedHashMap();

    @Override
    public void readFromServerData(ProtocolSupportPacketDataSerializer serializer) {
        super.readFromServerData(serializer);
        this.attributes.clear();
        int attributesCount = serializer.readInt();
        for (int i = 0; i < attributesCount; ++i) {
            Attribute attribute = new Attribute();
            attribute.key = serializer.readString(64);
            attribute.value = serializer.readDouble();
            attribute.modifiers = new Modifier[serializer.readVarInt()];
            for (int j = 0; j < attribute.modifiers.length; ++j) {
                Modifier modifier = new Modifier();
                modifier.uuid = serializer.readUUID();
                modifier.amount = serializer.readDouble();
                modifier.operation = serializer.readByte();
                attribute.modifiers[j] = modifier;
            }
            this.attributes.put(attribute.key, attribute);
        }
    }

    @Override
    public void handle() {
        Attribute attr;
        for (Attribute attr2 : this.attributes.values()) {
            if (attr2.value != 0.0) continue;
            attr2.value = 1.0E-8;
        }
        if (this.entityId == this.cache.getSelfPlayerEntityId() && (attr = this.attributes.get("generic.maxHealth")) != null) {
            this.cache.setMaxHealth((float)attr.value);
        }
    }

    protected static class Modifier {
        public UUID uuid;
        public double amount;
        public int operation;

        protected Modifier() {
        }
    }

    protected static class Attribute {
        public String key;
        public double value;
        public Modifier[] modifiers;

        protected Attribute() {
        }
    }
}

