/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.legacyremapper.chunk;

import io.netty.buffer.ByteBuf;
import org.bukkit.Material;

public class BlockStorageReader {
    private static final boolean[] validBlockState = new boolean[65534];
    private final int[] palette;
    private final long[] blockdata;
    private final int bitsPerBlock;
    private final int singleValMask;

    public static void init() {
    }

    public BlockStorageReader(int[] palette, int bitsPerBlock, int datalength) {
        this.palette = palette;
        this.blockdata = new long[datalength];
        this.bitsPerBlock = bitsPerBlock;
        this.singleValMask = (1 << bitsPerBlock) - 1;
    }

    public void readFromStream(ByteBuf stream) {
        for (int i = 0; i < this.blockdata.length; ++i) {
            this.blockdata[i] = stream.readLong();
        }
    }

    public int getBlockState(int blockindex) {
        int blockState = this.palette[this.getPaletteIndex(blockindex)];
        if (blockState > 0 && blockState < validBlockState.length && validBlockState[blockState]) {
            return blockState;
        }
        return 0;
    }

    private int getPaletteIndex(int blockIndex) {
        int bitStartIndex = blockIndex * this.bitsPerBlock;
        int arrStartIndex = bitStartIndex >> 6;
        int arrEndIndex = bitStartIndex + this.bitsPerBlock - 1 >> 6;
        int localStartBitIndex = bitStartIndex & 0x3F;
        if (arrStartIndex == arrEndIndex) {
            return (int)(this.blockdata[arrStartIndex] >>> localStartBitIndex & (long)this.singleValMask);
        }
        return (int)((this.blockdata[arrStartIndex] >>> localStartBitIndex | this.blockdata[arrEndIndex] << 64 - localStartBitIndex) & (long)this.singleValMask);
    }

    static {
        for (Material material : Material.values()) {
            for (int i = 0; i < 16; ++i) {
                BlockStorageReader.validBlockState[material.getId() << 4 | i] = true;
            }
        }
    }
}

